/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.libraries;

import com.intellij.jsf.references.libraries.providers.BooleanPsiReferenceProvider;
import com.intellij.jsf.references.libraries.providers.DoubleReferenceProvider;
import com.intellij.jsf.references.libraries.providers.FloatReferenceProvider;
import com.intellij.jsf.references.libraries.providers.IntegerReferenceProvider;
import com.intellij.jsf.references.libraries.providers.JsfWrappingPathReferenceProvider;
import com.intellij.jsf.references.libraries.providers.JsfWrappingPsiClassReferenceProvider;
import com.intellij.jsf.references.libraries.providers.LongReferenceProvider;
import com.intellij.jsf.references.libraries.providers.MultiVariantsPsiReferenceProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfComponentLibraryReferenceProviderRegistry {
    private final Map<String, Factory<PsiReferenceProvider>> myReferenceProviders = new HashMap<String, Factory<PsiReferenceProvider>>();

    public static JsfComponentLibraryReferenceProviderRegistry getInstance() {
        return (JsfComponentLibraryReferenceProviderRegistry)ServiceManager.getService(JsfComponentLibraryReferenceProviderRegistry.class);
    }

    public JsfComponentLibraryReferenceProviderRegistry() {
        this.initProviders();
    }

    private void initProviders() {
        this.registerReferenceProvider("boolean", (Factory<PsiReferenceProvider>)((Factory)() -> BooleanPsiReferenceProvider.getInstance()));
        this.registerReferenceProvider("integer", (Factory<PsiReferenceProvider>)((Factory)() -> IntegerReferenceProvider.getInstance()));
        this.registerReferenceProvider("float", (Factory<PsiReferenceProvider>)((Factory)() -> FloatReferenceProvider.getInstance()));
        this.registerReferenceProvider("long", (Factory<PsiReferenceProvider>)((Factory)() -> LongReferenceProvider.getInstance()));
        this.registerReferenceProvider("double", (Factory<PsiReferenceProvider>)((Factory)() -> DoubleReferenceProvider.getInstance()));
        this.registerReferenceProvider(MultiVariantsPsiReferenceProvider.getProviderName(), (Factory<PsiReferenceProvider>)((Factory)() -> new MultiVariantsPsiReferenceProvider()));
        this.registerReferenceProvider("styleClass", (Factory<PsiReferenceProvider>)((Factory)() -> CssReferenceProviderUtil.CSS_CLASS_OR_ID_KEY_PROVIDER.getProvider()));
        this.registerReferenceProvider(JsfWrappingPsiClassReferenceProvider.getProviderName(), (Factory<PsiReferenceProvider>)((Factory)() -> new JsfWrappingPsiClassReferenceProvider()));
        this.registerReferenceProvider(JsfWrappingPathReferenceProvider.getProviderName(), (Factory<PsiReferenceProvider>)((Factory)() -> new JsfWrappingPathReferenceProvider()));
    }

    public void registerReferenceProvider(@NotNull String id, Factory<PsiReferenceProvider> provider) {
        if (id == null) {
            JsfComponentLibraryReferenceProviderRegistry.$$$reportNull$$$0(0);
        }
        this.myReferenceProviders.put(id, provider);
    }

    @Nullable
    public PsiReferenceProvider getReferenceProvider(@NotNull String id) {
        Factory<PsiReferenceProvider> factory;
        if (id == null) {
            JsfComponentLibraryReferenceProviderRegistry.$$$reportNull$$$0(1);
        }
        return (factory = this.myReferenceProviders.get(id)) == null ? null : (PsiReferenceProvider)factory.create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "id";
        objectArray2[1] = "com/intellij/jsf/references/libraries/JsfComponentLibraryReferenceProviderRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

