/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterRef {
    static final String PROJECT_LEVEL = "project";
    private final String myReferenceName;

    private NodeJsInterpreterRef(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(0);
        }
        this.myReferenceName = FileUtil.toSystemIndependentName((String)referenceName);
    }

    private NodeJsInterpreterRef(@Nullable NodeJsInterpreter interpreter) {
        this.myReferenceName = interpreter == null ? "" : interpreter.getReferenceName();
    }

    @NotNull
    public String getReferenceName() {
        String string = this.myReferenceName;
        if (string == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isProjectRef() {
        return PROJECT_LEVEL.equals(this.myReferenceName);
    }

    public boolean isConstantRef() {
        return !PROJECT_LEVEL.equals(this.myReferenceName) && !NodeJsLocalInterpreterType.isNodeFromPathRef(this);
    }

    @Nullable
    public NodeJsInterpreter resolve(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(2);
        }
        if (PROJECT_LEVEL.equals(this.myReferenceName)) {
            return NodeJsInterpreterManager.getInstance(project).getInterpreter();
        }
        return this.resolveWithoutAliases();
    }

    @NotNull
    public NodeJsLocalInterpreter resolveAsLocal(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(3);
        }
        NodeJsInterpreter interpreter = this.resolve(project);
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.cast(interpreter);
        if (nodeJsLocalInterpreter == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(4);
        }
        return nodeJsLocalInterpreter;
    }

    @Nullable
    NodeJsInterpreter resolveWithoutAliases() {
        if (this.myReferenceName.isEmpty()) {
            return null;
        }
        boolean remote = NodeJsRemoteInterpreterType.getInstance().isRemoteReference(this);
        NodeJsInterpreterType type = remote ? NodeJsRemoteInterpreterType.getInstance() : NodeJsLocalInterpreterType.getInstance();
        return type.findByReferenceName(this.myReferenceName);
    }

    @NotNull
    public static NodeJsInterpreterRef createProjectRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(PROJECT_LEVEL);
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(5);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public static NodeJsInterpreterRef create(@Nullable String referenceName) {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(StringUtil.notNullize((String)referenceName, (String)PROJECT_LEVEL));
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(6);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public static NodeJsInterpreterRef create(@Nullable NodeJsInterpreter interpreter) {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(interpreter);
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(7);
        }
        return nodeJsInterpreterRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsInterpreterRef ref = (NodeJsInterpreterRef)o;
        return this.myReferenceName.equals(ref.myReferenceName);
    }

    public int hashCode() {
        return this.myReferenceName.hashCode();
    }

    public String toString() {
        return this.myReferenceName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROJECT_LEVEL;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsLocal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectRef";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsLocal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

