/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageManagerUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmManager {
    private static final Logger LOG = Logger.getInstance(NpmManager.class);
    private static final String PACKAGE_MANAGER_PACKAGE_REF = "nodejs_package_manager_path";
    private static final String NPM_PATH_RESET_FOR_DEFAULT_PROJECT = "nodejs_npm_path_reset_for_default_project";
    private final Project myProject;
    private volatile NodePackageRef myPackageManagerPackageRef;

    public NpmManager(@NotNull Project project) {
        if (project == null) {
            NpmManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public static NpmManager getInstance(@NotNull Project project) {
        if (project == null) {
            NpmManager.$$$reportNull$$$0(1);
        }
        NpmManager npmManager = (NpmManager)ServiceManager.getService((Project)project, NpmManager.class);
        if (npmManager == null) {
            NpmManager.$$$reportNull$$$0(2);
        }
        return npmManager;
    }

    public void setPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NpmManager.$$$reportNull$$$0(3);
        }
        if (NodePackageManagerUtil.isProjectPackageManagerPackageRef(packageRef)) {
            LOG.warn("Project package manager cannot be set to itself");
        }
        this.myPackageManagerPackageRef = packageRef;
        String identifier = packageRef.getIdentifier();
        if (StringUtil.isEmpty((String)identifier)) {
            identifier = null;
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(PACKAGE_MANAGER_PACKAGE_REF, identifier);
    }

    @NotNull
    public NodePackageRef getPackageRef() {
        NodePackageRef packageRef = this.myPackageManagerPackageRef;
        if (packageRef == null) {
            NpmManager.resetOnceDefaultProjectNpmPath();
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String value = propertiesComponent.getValue(PACKAGE_MANAGER_PACKAGE_REF);
            if (StringUtil.isEmpty((String)value)) {
                if (this.myProject.isDefault()) {
                    packageRef = NodePackageRef.create(new NodePackage(""));
                } else {
                    packageRef = this.detectPackageRef();
                    if (this.isDetectionTemporary()) {
                        NodePackageRef nodePackageRef = packageRef;
                        if (nodePackageRef == null) {
                            NpmManager.$$$reportNull$$$0(4);
                        }
                        return nodePackageRef;
                    }
                    propertiesComponent.setValue(PACKAGE_MANAGER_PACKAGE_REF, packageRef.getIdentifier());
                }
            } else {
                packageRef = NodePackageManagerUtil.DESCRIPTOR.createPackageRef(value);
            }
            this.myPackageManagerPackageRef = packageRef;
        }
        NodePackageRef nodePackageRef = packageRef;
        if (nodePackageRef == null) {
            NpmManager.$$$reportNull$$$0(5);
        }
        return nodePackageRef;
    }

    private boolean isDetectionTemporary() {
        return NpmPackageProjectGenerator.isGenerating(this.myProject);
    }

    @NotNull
    public NodePackage getPackage() throws ExecutionException {
        NodeJsInterpreter interpreter;
        NodePackageRef ref = this.getPackageRef();
        NodePackage pkg = NodePackageManagerUtil.resolveRef(ref, this.myProject, interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter());
        if (pkg == null) {
            throw new InvalidNpmPackageException(this.myProject, "Cannot find package manager '" + ref.getIdentifier() + "'<p/>Please specify <a href=''>Package Manager</a>.", null);
        }
        NodePackage nodePackage = pkg;
        if (nodePackage == null) {
            NpmManager.$$$reportNull$$$0(6);
        }
        return nodePackage;
    }

    @NotNull
    private NodePackageRef detectPackageRef() {
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null && new File(baseDir.getPath(), "yarn.lock").isFile()) {
            NodePackageRef nodePackageRef = NodePackageRef.create("yarn");
            if (nodePackageRef == null) {
                NpmManager.$$$reportNull$$$0(7);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = NodePackageRef.create("npm");
        if (nodePackageRef == null) {
            NpmManager.$$$reportNull$$$0(8);
        }
        return nodePackageRef;
    }

    public static void resetOnceDefaultProjectNpmPath() {
        PropertiesComponent propertiesComponent;
        boolean reset;
        Project project = ProjectManager.getInstance().getDefaultProject();
        if (!project.isDisposed() && !(reset = (propertiesComponent = PropertiesComponent.getInstance((Project)project)).getBoolean(NPM_PATH_RESET_FOR_DEFAULT_PROJECT, false))) {
            propertiesComponent.setValue(NPM_PATH_RESET_FOR_DEFAULT_PROJECT, true);
            propertiesComponent.unsetValue(PACKAGE_MANAGER_PACKAGE_REF);
        }
    }

    @NotNull
    public String getNpmInstallPresentableText() {
        String string = NpmManager.getNpmCommandPresentableText(NodePackageManagerUtil.isYarnAlikePackageRef(this.getPackageRef()), NpmCommand.INSTALL);
        if (string == null) {
            NpmManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getNpmInstallPresentableText(@NotNull NodePackage pkg) {
        if (pkg == null) {
            NpmManager.$$$reportNull$$$0(10);
        }
        String string = NpmManager.getNpmCommandPresentableText(pkg, NpmCommand.INSTALL);
        if (string == null) {
            NpmManager.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getNpmCommandPresentableText(@NotNull NodePackage npmPkg, @NotNull NpmCommand command) {
        if (npmPkg == null) {
            NpmManager.$$$reportNull$$$0(12);
        }
        if (command == null) {
            NpmManager.$$$reportNull$$$0(13);
        }
        String string = NpmManager.getNpmCommandPresentableText(NodePackageManagerUtil.isYarnAlikePackage(npmPkg), command);
        if (string == null) {
            NpmManager.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String getNpmCommandPresentableText(boolean yarn, @NotNull NpmCommand command) {
        if (command == null) {
            NpmManager.$$$reportNull$$$0(15);
        }
        String string = NpmManager.getNpmPackagePresentableName(yarn) + " " + command.getCliOption(yarn);
        if (string == null) {
            NpmManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String getNpmPackagePresentableName(boolean yarn) {
        String string = yarn ? "yarn" : "npm";
        if (string == null) {
            NpmManager.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageRef";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detectPackageRef";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpmInstallPresentableText";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpmCommandPresentableText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpmPackagePresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPackageRef";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNpmInstallPresentableText";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNpmCommandPresentableText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidNpmPackageException
    extends ExecutionException
    implements HyperlinkListener {
        private final Project myProject;
        private final Runnable myExtraAction;

        public InvalidNpmPackageException(@NotNull Project project, @NotNull String details, @Nullable Runnable extraAction) {
            if (project == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(0);
            }
            if (details == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(1);
            }
            super(details);
            this.myProject = project;
            this.myExtraAction = extraAction;
        }

        public InvalidNpmPackageException(@NotNull InvalidNpmPackageException e, @NotNull Runnable extraAction) {
            if (e == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(2);
            }
            if (extraAction == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(3);
            }
            this(e.myProject, e.getMessage(), extraAction);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event != null && event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                NodeJSSettingsManager.editSettingsAppropriately(this.myProject);
                if (this.myExtraAction != null) {
                    try {
                        NpmManager.getInstance(this.myProject).getPackage();
                        this.myExtraAction.run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "details";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extraAction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/npm/NpmManager$InvalidNpmPackageException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

