/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInstalledPackageQuickFix
implements LocalQuickFix {
    private static final String VERSION_NAME = "version";
    private final VirtualFile myPackageDir;
    private final String myPackageName;

    public OpenInstalledPackageQuickFix(@NotNull VirtualFile packageDir, @NotNull String packageName) {
        if (packageDir == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(1);
        }
        this.myPackageDir = packageDir;
        this.myPackageName = packageName;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = "Navigate to " + this.myPackageName + "/package.json";
        if (string == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Navigate to package.json" == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(3);
        }
        return "Navigate to package.json";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        OpenFileDescriptor desc;
        VirtualFile packageJson;
        if (project == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(5);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile(this.myPackageDir)) != null) {
            JsonLiteral version;
            PsiFile file2 = PsiManager.getInstance((Project)project).findFile(packageJson);
            int offset = -1;
            if (file2 instanceof JsonFile && (version = OpenInstalledPackageQuickFix.findVersionValueElement((JsonFile)file2)) != null) {
                offset = version.getTextOffset() + 1;
            }
            desc = new OpenFileDescriptor(project, packageJson, offset);
        } else {
            desc = new OpenFileDescriptor(project, this.myPackageDir);
        }
        desc.navigate(true);
    }

    @Nullable
    private static JsonLiteral findVersionValueElement(@NotNull JsonFile file2) {
        if (file2 == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(6);
        }
        for (JsonValue root : file2.getAllTopLevelValues()) {
            JsonProperty version;
            JsonObject rootObj = (JsonObject)ObjectUtils.tryCast((Object)root, JsonObject.class);
            if (rootObj == null || (version = rootObj.findProperty(VERSION_NAME)) == null) continue;
            return (JsonLiteral)ObjectUtils.tryCast((Object)version.getValue(), JsonLiteral.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/OpenInstalledPackageQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/OpenInstalledPackageQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findVersionValueElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

