/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Collection<JSQualifiedNamedElement> mySourceElements;
    @NotNull
    private final PsiElement myToModule;
    @NotNull
    private final PsiElement mySourceModule;
    @Nullable
    private final Consumer<Collection<JSQualifiedNamedElement>> myCallback;

    public ES6MoveModuleMembersProcessor(@NotNull Collection<JSQualifiedNamedElement> elements, @NotNull PsiElement toModule, @NotNull PsiElement fromModule, @Nullable Consumer<Collection<JSQualifiedNamedElement>> callbackForResults) {
        if (elements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(0);
        }
        if (toModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(1);
        }
        if (fromModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(2);
        }
        super(fromModule.getProject());
        this.mySourceElements = elements;
        this.mySourceModule = fromModule;
        this.myToModule = toModule;
        this.myCallback = callbackForResults;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(3);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = ES6MoveModuleMembersProcessor.this.mySourceElements.toArray(PsiElement.EMPTY_ARRAY);
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return ES6MoveModuleMembersProcessor.this.getCommandName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(4);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (JSQualifiedNamedElement element : this.mySourceElements) {
            ReferencesSearch.search((PsiElement)element).forEach(reference -> {
                if (!this.isInMovedElement(reference.getElement())) {
                    result2.add(new MoveRenameUsageInfo(reference, (PsiElement)element));
                }
            });
        }
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(6);
        }
        return this.showConflicts(this.getConflicts((UsageInfo[])refUsages.get()), (UsageInfo[])refUsages.get());
    }

    @NotNull
    private MultiMap<PsiElement, String> getConflicts(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(7);
        }
        MultiMap conflicts = new MultiMap();
        this.validateDestinationModuleDeclarations((MultiMap<PsiElement, String>)conflicts);
        for (JSQualifiedNamedElement element : this.mySourceElements) {
            ES6ReferenceExpressionsInfo info = ES6ReferenceExpressionsInfo.getInfo((JSPsiElementBase)element);
            List<String> validations = ES6ReferenceExpressionsInfo.getLocalReferencedElementValidations(info, (JSPsiElementBase)element, (Condition<PsiElement>)((Condition)this::isInMovedElement));
            for (String validation : validations) {
                conflicts.putValue((Object)element, (Object)validation);
            }
        }
        for (UsageInfo usage : usages) {
            PsiElement element;
            PsiElement psiElement = element = usage instanceof MoveRenameUsageInfo ? ((MoveRenameUsageInfo)usage).getReferencedElement() : null;
            if (element == null || ES6ImportHandler.isExportedWithNameOrDefault(element)) continue;
            PsiFile file2 = (PsiFile)ObjectUtils.coalesce((Object)usage.getFile(), (Object)this.mySourceModule.getContainingFile());
            String elementDescription = RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false);
            conflicts.putValue((Object)element, (Object)JSBundle.message((String)"es6.move.module.members.has.local.usage.message", (Object[])new Object[]{elementDescription, file2.getName()}));
        }
        MultiMap multiMap = conflicts;
        if (multiMap == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(8);
        }
        return multiMap;
    }

    private boolean isInMovedElement(@NotNull PsiElement element) {
        if (element == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(9);
        }
        for (PsiElement psiElement : this.mySourceElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(10);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)this.mySourceModule)) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)this.myToModule)) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Set infos = ContainerUtil.map2Set(this.mySourceElements, ES6ReferenceExpressionsInfo::getInfo);
        MultiMap<PsiElement, UsageInfo> elementToUsages = ES6MoveModuleMembersProcessor.splitUsagesByElements(usages);
        Collection<ES6ImportExportDeclaration> importOrExportTargetModule = this.getImportOrExportTargetModuleReferences();
        ArrayList<FormatFixer> postponedFormatters = new ArrayList<FormatFixer>();
        FileHeaderKeeper keeper = new FileHeaderKeeper(this.myToModule);
        keeper.saveStateAndCutHeader();
        List newElements = this.moveElementsAndUpdateUsages(elementToUsages, importOrExportTargetModule, postponedFormatters).stream().map(el -> this.createPointer((JSQualifiedNamedElement)el)).collect(Collectors.toList());
        ES6CreateImportUtil.addRequiredImports(infos, (Condition<PsiElement>)((Condition)this::isInMovedElement), this.myToModule);
        ES6CreateImportUtil.optimizeImports(this.myToModule);
        keeper.restoreHeaderForSavedState();
        this.deleteTargetElements();
        ES6CreateImportUtil.optimizeImports(this.mySourceModule);
        JSRefactoringUtil.format(postponedFormatters);
        if (this.myCallback != null) {
            List result2 = newElements.stream().map(el -> (JSQualifiedNamedElement)el.getElement()).filter(el -> el != null).collect(Collectors.toList());
            this.myCallback.consume(result2);
        }
    }

    @NotNull
    private SmartPsiElementPointer<JSQualifiedNamedElement> createPointer(@NotNull JSQualifiedNamedElement el) {
        if (el == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(11);
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)el);
        if (smartPsiElementPointer == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(12);
        }
        return smartPsiElementPointer;
    }

    private void validateDestinationModuleDeclarations(MultiMap<PsiElement, String> conflicts) {
        for (JSQualifiedNamedElement element : this.mySourceElements) {
            List<PsiElement> elements;
            PsiElement resolved;
            String name;
            JSElement destinationModuleDefaultExport = ES6PsiUtil.findDefaultExport(this.myToModule);
            if (element.isExportedWithDefault() && destinationModuleDefaultExport != null) {
                conflicts.putValue((Object)destinationModuleDefaultExport, (Object)JSBundle.message((String)"es6.move.module.members.destination.contains.default.export", (Object[])new Object[0]));
            }
            if (StringUtil.isEmpty((String)(name = element.getName())) || (resolved = JSStubBasedPsiTreeUtil.resolveLocally(name, this.myToModule, false)) == null || element.equals(resolved) || (resolved instanceof ES6ImportExportSpecifier ? (elements = JSResolveResult.toElements(((ES6ImportExportSpecifier)resolved).multiResolve(false))).contains(element) : resolved instanceof ES6ImportExportDeclarationPart && this.isFromPartEqualsSource((ES6ImportExportDeclarationPart)resolved))) continue;
            conflicts.putValue((Object)resolved, (Object)("Destination module contains a symbol with name \"" + name + "\""));
        }
    }

    private boolean isFromPartEqualsSource(@NotNull ES6ImportExportDeclarationPart importPart) {
        Collection elements;
        ES6ImportExportDeclaration declaration;
        ES6FromClause clause;
        if (importPart == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(13);
        }
        ES6FromClause eS6FromClause = clause = (declaration = importPart.getDeclaration()) == null ? null : declaration.getFromClause();
        return clause != null && (elements = clause.resolveReferencedElements()).contains(this.mySourceModule);
    }

    private List<JSQualifiedNamedElement> moveElementsAndUpdateUsages(@NotNull MultiMap<PsiElement, UsageInfo> elementToUsages, @NotNull Collection<ES6ImportExportDeclaration> importOrExportTargetModule, @NotNull List<FormatFixer> postponedFormatters) {
        if (elementToUsages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(14);
        }
        if (importOrExportTargetModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(15);
        }
        if (postponedFormatters == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(16);
        }
        ArrayList newElements = ContainerUtil.newArrayList();
        PsiElement anchor = this.getInsertionAnchor(elementToUsages.values());
        for (JSQualifiedNamedElement member : this.mySourceElements) {
            RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)member);
            Collection elementUsages = elementToUsages.get((Object)member);
            JSQualifiedNamedElement newMember = this.moveElement(member, importOrExportTargetModule, elementUsages, postponedFormatters, anchor);
            if (newMember != null) {
                newElements.add(newMember);
                anchor = ES6MoveModuleMembersProcessor.getPsiElementToMove(newMember);
            }
            elementListener.elementMoved((PsiElement)(newMember == null ? member : newMember));
        }
        return newElements;
    }

    @Nullable
    private PsiElement getInsertionAnchor(@NotNull Collection<? extends UsageInfo> elementUsages) {
        if (elementUsages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(17);
        }
        PsiFile myToFile = this.myToModule.getContainingFile();
        List usagesStatements = elementUsages.stream().map(el -> {
            PsiFile file2 = el.getFile();
            if (!myToFile.isEquivalentTo((PsiElement)file2)) {
                return null;
            }
            PsiReference reference = el.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement element = reference.getElement();
            if (element == null || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding) {
                return null;
            }
            PsiElement parent = element;
            boolean matched = false;
            while (parent != null) {
                PsiElement nextParent = parent.getParent();
                if (this.myToModule.isEquivalentTo(nextParent)) {
                    matched = true;
                    break;
                }
                parent = nextParent;
            }
            return matched ? parent : null;
        }).filter(el -> el != null).sorted((el, el2) -> Comparing.compare((int)el.getTextRange().getStartOffset(), (int)el2.getTextRange().getStartOffset())).collect(Collectors.toList());
        PsiElement[] children = this.myToModule.getChildren();
        if (usagesStatements.isEmpty()) {
            for (int i = children.length - 1; i >= 0; --i) {
                PsiElement child = children[i];
                if (!(child instanceof JSSourceElement)) continue;
                return child;
            }
        } else {
            PsiElement element = (PsiElement)usagesStatements.get(0);
            PsiElement prev = element.getPrevSibling();
            if (prev != null) {
                PsiElement candidate = element;
                PsiElement newCandidate = JSRefactoringUtil.skipWhitespaces(element, false);
                while (newCandidate instanceof PsiComment) {
                    candidate = newCandidate;
                    if ((newCandidate = newCandidate.getPrevSibling()) == null) continue;
                    newCandidate = JSRefactoringUtil.skipWhitespaces(newCandidate, false);
                }
                return candidate.getPrevSibling();
            }
            return element.getPrevSibling();
        }
        return null;
    }

    private void deleteTargetElements() {
        for (JSQualifiedNamedElement member : this.mySourceElements) {
            JSRefactoringUtil.deleteWithNoPostponedFormatting(ES6MoveModuleMembersProcessor.getPsiElementToMove(member));
        }
    }

    private JSQualifiedNamedElement moveElement(@NotNull JSQualifiedNamedElement oldMember, @NotNull Collection<ES6ImportExportDeclaration> importOrExportTargetModule, @NotNull Collection<UsageInfo> elementUsages, @NotNull List<FormatFixer> postponedFormatters, @Nullable PsiElement anchor) {
        if (oldMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(18);
        }
        if (importOrExportTargetModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(19);
        }
        if (elementUsages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(20);
        }
        if (postponedFormatters == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(21);
        }
        PsiElement psiElementToMove = ES6MoveModuleMembersProcessor.getPsiElementToMove(oldMember);
        PsiElement newElement = JSChangeUtil.doDoAddAfter(this.myToModule, psiElementToMove, anchor);
        postponedFormatters.add(FormatFixer.create(newElement, FormatFixer.Mode.Reformat));
        JSRefactoringUtil.handleDocCommentAndFormat(newElement, postponedFormatters);
        JSQualifiedNamedElement newMember = ES6ModuleMemberInfo.getMember(newElement);
        if (newMember == null) {
            return null;
        }
        ArrayList toRemoveElements = ContainerUtil.newArrayList();
        HashMap updatedModules = ContainerUtil.newHashMap();
        for (UsageInfo usage : elementUsages) {
            this.updateUsage(usage, newMember, toRemoveElements, updatedModules);
        }
        if (newMember.isExportedWithDefault()) {
            this.updateForDefaultExportedMember(importOrExportTargetModule, oldMember, newMember);
        }
        ES6MoveModuleMembersProcessor.updateExportAllDeclarations(importOrExportTargetModule, newMember);
        for (PsiElement element : toRemoveElements) {
            ES6MoveModuleMembersProcessor.deletePsiElement(element);
        }
        for (PsiElement module : updatedModules.keySet()) {
            ES6CreateImportUtil.optimizeImports(module);
        }
        return newMember;
    }

    private static void updateExportAllDeclarations(@NotNull Collection<ES6ImportExportDeclaration> importOrExportTargetModule, @NotNull JSQualifiedNamedElement newMember) {
        boolean isDefault;
        if (importOrExportTargetModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(22);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(23);
        }
        if (isDefault = newMember.isExportedWithDefault()) {
            return;
        }
        for (ES6ImportExportDeclaration declaration : importOrExportTargetModule) {
            String newName;
            if (!(declaration instanceof ES6ExportDeclaration) || !((ES6ExportDeclaration)declaration).isExportAll() || (newName = newMember.getName()) == null) continue;
            ES6CreateImportUtil.insertExport(newMember, ES6ImportPsiUtil.ImportExportType.SPECIFIER, newName, newName, (PsiElement)declaration);
        }
    }

    private void updateForDefaultExportedMember(@NotNull Collection<ES6ImportExportDeclaration> importOrExportTargetModule, @NotNull JSQualifiedNamedElement oldMember, @NotNull JSQualifiedNamedElement newMember) {
        if (importOrExportTargetModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(24);
        }
        if (oldMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(25);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(26);
        }
        for (ES6ImportExportDeclaration declaration : importOrExportTargetModule) {
            String name;
            ES6ImportExportDeclarationPart defaultElement;
            ES6FromClause clause = declaration.getFromClause();
            if (clause == null || (defaultElement = ES6MoveModuleMembersProcessor.getDefault(declaration)) == null) continue;
            PsiElement declarationModule = ES6PsiUtil.findExternalModule((PsiElement)declaration);
            boolean fromDestinationModule = this.myToModule.isEquivalentTo(declarationModule);
            if (fromDestinationModule) {
                name = oldMember.getName();
                if (name == null || !name.equals(defaultElement.getDeclaredName())) {
                    ReferencesSearch.search((PsiElement)defaultElement, (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.myToModule.getContainingFile())).forEach(el -> {
                        if (newMember == null) {
                            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(59);
                        }
                        el.bindToElement((PsiElement)newMember);
                    });
                }
                ES6MoveModuleMembersProcessor.deletePsiElement((PsiElement)defaultElement);
                return;
            }
            if (ES6MoveModuleMembersProcessor.isSingleElementImportExportDeclaration(declaration)) {
                this.rebindFromClause(clause, this.mySourceModule);
                continue;
            }
            name = defaultElement.getDeclaredName();
            if (name == null) continue;
            if (declaration instanceof ES6ImportDeclaration) {
                ES6CreateImportUtil.insertImport((PsiElement)declaration, newMember, name);
            } else if (declaration instanceof ES6ExportDeclaration) {
                ES6ImportPsiUtil.ImportExportType importExportType = defaultElement instanceof ES6ImportedBinding ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
                ES6CreateImportUtil.insertExport(newMember, importExportType, name, "default", (PsiElement)declaration);
            }
            ES6MoveModuleMembersProcessor.deletePsiElement((PsiElement)defaultElement);
        }
    }

    private static boolean isSingleElementImportExportDeclaration(@NotNull ES6ImportExportDeclaration importExportDeclaration) {
        if (importExportDeclaration == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(27);
        }
        if (importExportDeclaration instanceof ES6ImportDeclaration) {
            ES6ImportDeclaration declaration = (ES6ImportDeclaration)importExportDeclaration;
            ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
            ES6ImportedBinding[] bindings = declaration.getImportedBindings();
            return specifiers.length == 0 && bindings.length == 1 || specifiers.length == 1 && bindings.length == 0;
        }
        if (importExportDeclaration instanceof ES6ExportDeclaration) {
            ES6ExportDeclaration declaration = (ES6ExportDeclaration)importExportDeclaration;
            ES6ExportSpecifier[] specifiers = declaration.getExportSpecifiers();
            ES6ExportedDefaultBinding binding = declaration.getExportedDefaultBinding();
            return binding != null && specifiers.length == 0 || binding == null && specifiers.length == 1;
        }
        return false;
    }

    private static ES6ImportExportDeclarationPart getDefault(@NotNull ES6ImportExportDeclaration importExportDeclaration) {
        if (importExportDeclaration == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(28);
        }
        if (importExportDeclaration instanceof ES6ImportDeclaration) {
            ES6ImportedBinding[] bindings;
            ES6ImportDeclaration declaration = (ES6ImportDeclaration)importExportDeclaration;
            for (ES6ImportedBinding binding : bindings = declaration.getImportedBindings()) {
                if (binding.isNamespaceImport()) continue;
                return binding;
            }
            return ES6MoveModuleMembersProcessor.getDefaultSpecifier((ES6ImportExportSpecifier[])declaration.getImportSpecifiers());
        }
        if (importExportDeclaration instanceof ES6ExportDeclaration) {
            ES6ExportDeclaration declaration = (ES6ExportDeclaration)importExportDeclaration;
            boolean all = declaration.isExportAll();
            if (all) {
                return null;
            }
            ES6ExportedDefaultBinding binding = declaration.getExportedDefaultBinding();
            if (binding != null) {
                return binding;
            }
            return ES6MoveModuleMembersProcessor.getDefaultSpecifier((ES6ImportExportSpecifier[])declaration.getExportSpecifiers());
        }
        return null;
    }

    @Nullable
    private static ES6ImportExportDeclarationPart getDefaultSpecifier(@NotNull ES6ImportExportSpecifier[] specifiers) {
        if (specifiers == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(29);
        }
        for (ES6ImportExportSpecifier specifier : specifiers) {
            String name = specifier.getReferenceName();
            if (!"default".equals(name)) continue;
            return specifier;
        }
        return null;
    }

    private void rebindFromClause(@NotNull ES6FromClause clause, @NotNull PsiElement refModule) {
        PsiReference[] references;
        if (clause == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(30);
        }
        if (refModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(31);
        }
        for (PsiReference reference : references = clause.getReferences()) {
            if (!reference.isReferenceTo(refModule)) continue;
            reference.bindToElement(this.myToModule);
            break;
        }
    }

    private void updateUsage(@NotNull UsageInfo usage, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements, @NotNull Map<PsiElement, String> updatedModules) {
        PsiReference reference;
        if (usage == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(32);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(33);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(34);
        }
        if (updatedModules == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(35);
        }
        if ((reference = usage.getReference()) instanceof JSReferenceExpression) {
            this.updateReferenceExpressionUsage((JSReferenceExpression)reference, newMember, toRemoveElements, updatedModules);
        } else if (reference instanceof ES6ImportSpecifier) {
            this.updateImportSpecifier((ES6ImportSpecifier)reference, newMember, toRemoveElements);
        } else if (reference instanceof ES6ExportSpecifier) {
            this.updateExportSpecifier((ES6ExportSpecifier)reference, newMember, toRemoveElements);
        }
    }

    private void updateExportSpecifier(@NotNull ES6ExportSpecifier specifier, JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements) {
        ES6ExportDeclaration declaration;
        if (specifier == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(36);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(37);
        }
        if (this.skipDeclaration((ES6ImportExportDeclaration)(declaration = specifier.getDeclaration()))) {
            return;
        }
        String name = specifier.getDeclaredName();
        if (name == null) {
            return;
        }
        PsiElement declarationModule = ES6PsiUtil.findExternalModule((PsiElement)declaration);
        if (declaration.getFromClause() == null) {
            if (this.mySourceModule.isEquivalentTo(declarationModule)) {
                ES6CreateImportUtil.insertExportName(ES6ImportPsiUtil.ImportExportType.SPECIFIER, name, newMember.getName(), this.getDestinationPlace());
                toRemoveElements.add((PsiElement)specifier);
            }
            return;
        }
        boolean fromDestinationModule = this.myToModule.isEquivalentTo(declarationModule);
        if (fromDestinationModule) {
            toRemoveElements.add((PsiElement)specifier);
            return;
        }
        if (ES6MoveModuleMembersProcessor.isSingleElementImportExportDeclaration((ES6ImportExportDeclaration)declaration)) {
            this.rebindImportExportDeclaration((ES6ImportExportDeclaration)declaration);
        } else {
            ES6CreateImportUtil.insertExport(newMember, ES6ImportPsiUtil.ImportExportType.SPECIFIER, name, newMember.getName(), (PsiElement)declaration);
            toRemoveElements.add((PsiElement)specifier);
        }
    }

    @NotNull
    private PsiElement getDestinationPlace() {
        PsiElement psiElement = (PsiElement)ObjectUtils.coalesce((Object)this.myToModule.getFirstChild(), (Object)this.myToModule);
        if (psiElement == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(38);
        }
        return psiElement;
    }

    private void updateImportSpecifier(@NotNull ES6ImportSpecifier specifier, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements) {
        ES6ImportDeclaration declaration;
        if (specifier == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(39);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(40);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(41);
        }
        if (this.skipDeclaration((ES6ImportExportDeclaration)(declaration = specifier.getDeclaration()))) {
            return;
        }
        boolean fromDestinationModule = this.myToModule.isEquivalentTo(ES6PsiUtil.findExternalModule((PsiElement)declaration));
        if (fromDestinationModule) {
            toRemoveElements.add((PsiElement)specifier);
            return;
        }
        if (ES6MoveModuleMembersProcessor.isSingleElementImportExportDeclaration((ES6ImportExportDeclaration)declaration)) {
            this.rebindImportExportDeclaration((ES6ImportExportDeclaration)declaration);
        } else {
            ES6CreateImportUtil.insertImport((PsiElement)declaration, newMember, StringUtil.notNullize((String)newMember.getName()));
            toRemoveElements.add((PsiElement)specifier);
        }
    }

    private boolean skipDeclaration(@Nullable ES6ImportExportDeclaration declaration) {
        if (declaration == null) {
            return true;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause == null) {
            return false;
        }
        Collection elements = clause.resolveReferencedElements();
        return elements.size() != 0 && !elements.contains(this.mySourceModule);
    }

    private void rebindImportExportDeclaration(@NotNull ES6ImportExportDeclaration declaration) {
        ES6FromClause clause;
        if (declaration == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(42);
        }
        if ((clause = declaration.getFromClause()) == null) {
            return;
        }
        this.rebindFromClause(clause, this.mySourceModule);
    }

    private static void deletePsiElement(@NotNull PsiElement element) {
        if (element == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(43);
        }
        JSRefactoringUtil.deleteWithNoPostponedFormatting(element);
    }

    private void updateQualifiedReferenceExpressionUsage(@NotNull JSReferenceExpression reference, @NotNull JSQualifiedNamedElement newMember, @NotNull Map<PsiElement, String> updatedModules) {
        boolean hasImportFromPrevUsage;
        ResolveResult[] results;
        List<PsiElement> elements;
        PsiElement module;
        if (reference == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(44);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(45);
        }
        if (updatedModules == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(46);
        }
        if ((module = ES6PsiUtil.findExternalModule((PsiElement)reference)) == null) {
            ES6MoveModuleMembersProcessor.throwErrorUpdateUsage((PsiElement)reference);
        }
        if ((elements = JSResolveResult.toElements(results = reference.multiResolve(false))).isEmpty()) {
            return;
        }
        for (PsiElement element : elements) {
            if (this.isInMovedElement(element)) continue;
            ES6MoveModuleMembersProcessor.throwErrorUpdateUsage((PsiElement)reference);
        }
        String name = newMember.getName();
        if (name == null) {
            ES6MoveModuleMembersProcessor.throwErrorUpdateUsage((PsiElement)reference);
        }
        boolean isDestinationModule = this.myToModule.isEquivalentTo(module);
        String updatedName = updatedModules.get(module);
        boolean bl = hasImportFromPrevUsage = updatedName != null;
        if (!isDestinationModule) {
            if (updatedName == null) {
                PsiElement element = JSStubBasedPsiTreeUtil.resolveLocally(name, module, false);
                if (element != null) {
                    name = JSNameSuggestionsUtil.ensureUniqueVariableName(name, module, ContainerUtil.newArrayList((Object[])new String[]{name}), false);
                }
            } else {
                name = updatedName;
            }
        }
        JSReferenceExpression newElement = JSChangeUtil.createExpressionPsiWithContext(name, module, JSReferenceExpression.class);
        JSExpression newExpression = reference.replace((JSExpression)newElement);
        if (!isDestinationModule && !hasImportFromPrevUsage) {
            ES6CreateImportUtil.insertImport((PsiElement)newExpression, newMember, name);
            updatedModules.put(module, name);
        }
    }

    private static void throwErrorUpdateUsage(@NotNull PsiElement reference) {
        if (reference == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(47);
        }
        throw new IncorrectOperationException("Cannot update usage " + reference.getText() + " from " + reference.getContainingFile().getVirtualFile().getPath());
    }

    private void updateReferenceExpressionUsage(@NotNull JSReferenceExpression reference, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements, @NotNull Map<PsiElement, String> updatedModules) {
        if (reference == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(48);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(49);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(50);
        }
        if (updatedModules == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(51);
        }
        if (reference.getQualifier() != null) {
            this.updateQualifiedReferenceExpressionUsage(reference, newMember, updatedModules);
            return;
        }
        PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)reference);
        if (module == null) {
            module = reference.getContainingFile();
        }
        if (this.mySourceModule.isEquivalentTo(module)) {
            String name = newMember.getName();
            if (name == null) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (parent instanceof ES6ExportDefaultAssignment) {
                ES6CreateImportUtil.insertExportName(ES6ImportPsiUtil.ImportExportType.DEFAULT, name, name, this.getDestinationPlace());
                toRemoveElements.add(parent);
            } else {
                ES6CreateImportUtil.insertImport(this.mySourceModule.getFirstChild(), newMember, name);
            }
        }
    }

    @NotNull
    private static PsiElement getPsiElementToMove(@NotNull JSQualifiedNamedElement element) {
        PsiElement parent;
        if (element == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(52);
        }
        if ((parent = element.getParent()) instanceof ES6ExportDefaultAssignment || parent instanceof JSVarStatement) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                ES6MoveModuleMembersProcessor.$$$reportNull$$$0(53);
            }
            return psiElement;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = element;
        if (jSQualifiedNamedElement == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(54);
        }
        return jSQualifiedNamedElement;
    }

    @NotNull
    private Collection<ES6ImportExportDeclaration> getImportOrExportTargetModuleReferences() {
        ArrayList result2 = ContainerUtil.newArrayList();
        ReferencesSearch.search((PsiElement)this.mySourceModule).forEach(el -> {
            PsiElement parent;
            PsiElement element = el.getElement();
            if (element instanceof ES6FromClause && (parent = element.getParent()) instanceof ES6ImportExportDeclaration) {
                result2.add((ES6ImportExportDeclaration)parent);
            }
            return true;
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @NotNull
    private static MultiMap<PsiElement, UsageInfo> splitUsagesByElements(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(56);
        }
        MultiMap result2 = MultiMap.create();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            result2.putValue((Object)((MoveRenameUsageInfo)usage).getReferencedElement(), (Object)usage);
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(57);
        }
        return multiMap;
    }

    @NotNull
    protected String getCommandName() {
        String string = JSBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]);
        if (string == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(58);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 38: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 38: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModule";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 38: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 9: 
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPart";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToUsages";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importOrExportTargetModule";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postponedFormatters";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementUsages";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMember";
                break;
            }
            case 23: 
            case 26: 
            case 33: 
            case 40: 
            case 45: 
            case 49: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMember";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importExportDeclaration";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refModule";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 34: 
            case 37: 
            case 41: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemoveElements";
                break;
            }
            case 35: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedModules";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 44: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflicts";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationPlace";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementToMove";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportOrExportTargetModuleReferences";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "splitUsagesByElements";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 38: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConflicts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInMovedElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFromPartEqualsSource";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moveElementsAndUpdateUsages";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInsertionAnchor";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moveElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateExportAllDeclarations";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateForDefaultExportedMember";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSingleElementImportExportDeclaration";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSpecifier";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "rebindFromClause";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateUsage";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updateExportSpecifier";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "updateImportSpecifier";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "rebindImportExportDeclaration";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "deletePsiElement";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "updateQualifiedReferenceExpressionUsage";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "throwErrorUpdateUsage";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "updateReferenceExpressionUsage";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementToMove";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "splitUsagesByElements";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateForDefaultExportedMember$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 38: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

