/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileReferencesUtil {
    private static volatile JSFileReferencesUtil INSTANCE = new JSFileReferencesUtil();
    private static final Key<ParameterizedCachedValue<Collection<PsiElement>, PsiElement>> CACHE_KEY = Key.create((String)"TypeScript.External.Module.Resolve");
    private static final ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement> CACHED_VALUE_PROVIDER = e -> CachedValueProvider.Result.create(JSFileReferencesUtil.getModulesWithAugmentations(e), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    private static final Key<ParameterizedCachedValue<Collection<PsiElement>, PsiElement>> CACHE_LIBRARY_MODULES_KEY = Key.create((String)"Library.External.Module.Resolve");
    private static final ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement> CACHED_LIBRARY_MODULES_VALUE_PROVIDER = new ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement>(){

        public CachedValueProvider.Result<Collection<PsiElement>> compute(PsiElement param) {
            Collection elements = JSFileReferencesUtil.getMainModules(param);
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)param.getProject()).getFileIndex();
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)param);
            ArrayList deps = ContainerUtil.newArrayListWithCapacity((int)(elements.size() + 2));
            deps.add(file2);
            deps.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            boolean allResolveResultsFromLibrary = true;
            for (PsiElement element : elements) {
                VirtualFile curr;
                if (element instanceof JSFile && (curr = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && (index.isInLibrary(curr) || index.isExcluded(curr))) {
                    deps.add(curr);
                    continue;
                }
                allResolveResultsFromLibrary = false;
                break;
            }
            if (allResolveResultsFromLibrary) {
                return CachedValueProvider.Result.create((Object)elements, (Object[])deps.toArray());
            }
            return CachedValueProvider.Result.create((Object)elements, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    private static final Key<ParameterizedCachedValue<Map<String, CachedValue<Collection<PsiElement>>>, PsiFile>> FILE_MAP_KEY = Key.create((String)"js.file.references.map");
    private static final ParameterizedCachedValueProvider<Map<String, CachedValue<Collection<PsiElement>>>, PsiFile> FILE_MAP_PROVIDER = new ParameterizedCachedValueProvider<Map<String, CachedValue<Collection<PsiElement>>>, PsiFile>(){

        @NotNull
        public CachedValueProvider.Result<Map<String, CachedValue<Collection<PsiElement>>>> compute(PsiFile param) {
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)ContainerUtil.newHashMap(), (Object[])new Object[]{param});
            if (result2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$2", "compute"));
        }
    };

    public static void setInstance(@NotNull JSFileReferencesUtil util) {
        if (util == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(0);
        }
        INSTANCE = util;
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement moduleReference) {
        if (moduleReference == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(1);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)moduleReference.getProject()).getParameterizedCachedValue((UserDataHolder)moduleReference, CACHE_KEY, CACHED_VALUE_PROVIDER, false, (Object)moduleReference);
        if (collection == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReference(@NotNull PsiFile scope, @NotNull String refText) {
        Map cache;
        CachedValue value;
        if (scope == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(3);
        }
        if (refText == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(4);
        }
        if ((value = (CachedValue)(cache = (Map)CachedValuesManager.getManager((Project)scope.getProject()).getParameterizedCachedValue((UserDataHolder)scope, FILE_MAP_KEY, FILE_MAP_PROVIDER, false, (Object)scope)).get(refText)) == null) {
            value = new PsiCachedValueImpl(scope.getManager(), () -> {
                if (scope == null) {
                    JSFileReferencesUtil.$$$reportNull$$$0(47);
                }
                if (refText == null) {
                    JSFileReferencesUtil.$$$reportNull$$$0(48);
                }
                Collection<PsiElement> elements = INSTANCE.calculateMainModules((PsiElement)scope, refText);
                return CachedValueProvider.Result.create(elements, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
            cache.put(refText, value);
        }
        Collection collection = (Collection)value.getValue();
        if (collection == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public static String getReferenceModuleText(@NotNull PsiElement element) {
        JSType exportsInnerAlias;
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(6);
        }
        if (element instanceof JSLiteralExpression) {
            return element.getText();
        }
        if (element instanceof ES6FromClause) {
            return ((ES6FromClause)element).getReferenceText();
        }
        if (element instanceof TypeScriptExternalModuleReference) {
            return ((TypeScriptExternalModuleReference)element).getReferenceText();
        }
        if (element instanceof TypeScriptModule) {
            return ((TypeScriptModule)element).getName();
        }
        if (element instanceof JSFile && (exportsInnerAlias = ((JSFile)element).getExportsInnerAlias()) instanceof JSRequireCallExpressionType) {
            return ((JSRequireCallExpressionType)exportsInnerAlias).getReferencedModule();
        }
        return null;
    }

    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String text, @Nullable PsiReferenceProvider provider2) {
        if (host == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(7);
        }
        if (text == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(8);
        }
        return JSModuleReferenceContributor.getReferences(JSStringUtil.unquoteStringLiteralValue(text, false), host, offset, provider2, false);
    }

    private static Collection<PsiElement> getModulesWithAugmentations(@NotNull PsiElement moduleRef) {
        Collection<PsiElement> modules;
        String referenceText;
        if (moduleRef == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(9);
        }
        if ((referenceText = JSFileReferencesUtil.getReferenceModuleText(moduleRef)) == null) {
            return Collections.emptyList();
        }
        Collection<PsiElement> collection = modules = JSFileReferencesUtil.isLibraryElement(moduleRef) ? JSFileReferencesUtil.getMainModulesFromCache(moduleRef) : JSFileReferencesUtil.getMainModules(moduleRef);
        if (moduleRef instanceof TypeScriptModule && ((TypeScriptModule)moduleRef).isAugmentation() || modules.isEmpty()) {
            return modules;
        }
        return JSFileReferencesUtil.mergeWithAugmentations(moduleRef, modules);
    }

    private static boolean isLibraryElement(@NotNull PsiElement context) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(10);
        }
        if (DumbService.isDumb((Project)context.getProject())) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)context);
        return file2 != null && index.isInLibrary(file2);
    }

    private static Collection<PsiElement> getMainModulesFromCache(@NotNull PsiElement moduleRef) {
        if (moduleRef == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(11);
        }
        return (Collection)CachedValuesManager.getManager((Project)moduleRef.getProject()).getParameterizedCachedValue((UserDataHolder)moduleRef, CACHE_LIBRARY_MODULES_KEY, CACHED_LIBRARY_MODULES_VALUE_PROVIDER, false, (Object)moduleRef);
    }

    private static Collection<PsiElement> getMainModules(@NotNull PsiElement context) {
        String text;
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmpty((String)(text = JSFileReferencesUtil.getReferenceModuleText(context)))) {
            return ContainerUtil.emptyList();
        }
        return INSTANCE.calculateMainModules(context, text);
    }

    @NotNull
    protected Collection<PsiElement> calculateMainModules(@NotNull PsiElement context, @NotNull String quotedString) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(13);
        }
        if (quotedString == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(14);
        }
        Collection<PsiElement> collection = JSFileReferencesUtil.getMostPriorityModules(context, JSStringUtil.unquoteStringLiteralValue(quotedString, false), false);
        if (collection == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> getMostPriorityModules(@NotNull PsiElement context, @NotNull PsiReference[] references) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(16);
        }
        if (references == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(17);
        }
        THashSet results = new THashSet();
        int maxWeight = Integer.MIN_VALUE;
        for (PsiReference reference : references) {
            Collection<PsiElement> currentResults;
            int weight = JSFileReferencesUtil.getReferenceWeight(reference);
            if (maxWeight > weight && results.size() > 0 || (currentResults = JSModuleReferenceContributor.resolveModuleReference(reference)).size() == 0) continue;
            String[] extensions = JSFileReferencesUtil.getExtensions(context);
            for (PsiElement result2 : currentResults) {
                PsiElement current = JSFileReferencesUtil.getModuleForPsiElement(extensions, result2);
                if (current == null || !JSFileReferencesUtil.isValidModule(context, current)) continue;
                if (weight > maxWeight) {
                    results.clear();
                    maxWeight = weight;
                }
                results.add(current);
            }
        }
        THashSet tHashSet = results;
        if (tHashSet == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(18);
        }
        return tHashSet;
    }

    @NotNull
    public static Collection<PsiElement> getMostPriorityModules(@NotNull PsiElement context, @NotNull String path, boolean isCommonJS) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(19);
        }
        if (path == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(20);
        }
        THashSet results = new THashSet();
        String[] extensions = JSFileReferencesUtil.getExtensions(context);
        THashSet invalidResults = new THashSet();
        int maxWeight = Integer.MIN_VALUE;
        for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])JSModuleReferenceContributor.EP_NAME.getExtensions()) {
            if (!contributor.isApplicable(context)) continue;
            Collection<PsiElement> elements = contributor.resolveReferences(context, path, isCommonJS);
            int weight = contributor.getDefaultWeight();
            if (elements.isEmpty() || weight < maxWeight) continue;
            for (PsiElement result2 : elements) {
                PsiElement current = JSFileReferencesUtil.getModuleForPsiElement(extensions, result2);
                if (current == null) continue;
                boolean isValid = JSFileReferencesUtil.isValidModule(context, current);
                if (isValid) {
                    if (weight > maxWeight) {
                        results.clear();
                        maxWeight = weight;
                    }
                    results.add(current);
                    continue;
                }
                invalidResults.add(current);
            }
        }
        THashSet tHashSet = results.isEmpty() ? invalidResults : results;
        if (tHashSet == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(21);
        }
        return tHashSet;
    }

    @NotNull
    private static String[] getExtensions(@NotNull PsiElement context) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(22);
        }
        String[] stringArray = DialectDetector.isTypeScript(context) ? TypeScriptUtil.TYPESCRIPT_EXTENSIONS : JSFileReference.IMPLICIT_EXTENSIONS;
        if (stringArray == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    @Nullable
    public static PsiElement getModuleForPsiElement(@NotNull String[] extensions, @NotNull PsiElement result2) {
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(24);
        }
        if (result2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(25);
        }
        PsiElement current = null;
        if (result2 instanceof PsiFileSystemItem && ((PsiFileSystemItem)result2).isDirectory()) {
            PsiFile file2 = JSFileReferencesUtil.findIndexFile(extensions, (PsiFileSystemItem)result2);
            if (file2 != null) {
                current = file2;
            }
        } else {
            current = JSFileReferencesUtil.findModule(result2);
        }
        return current;
    }

    private static boolean isValidModule(@NotNull PsiElement context, @NotNull PsiElement module) {
        if (context == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(26);
        }
        if (module == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(27);
        }
        if (DialectDetector.isTypeScript(context) && module instanceof TypeScriptModule) {
            return TypeScriptConfigService.Provider.isAccessible(context, module);
        }
        return true;
    }

    private static int getReferenceWeight(@NotNull PsiReference reference) {
        if (reference == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(28);
        }
        if (reference instanceof JSModuleBaseReference) {
            return ((JSModuleBaseReference)reference).getWeight();
        }
        return 0;
    }

    private static PsiElement findModule(PsiElement result2) {
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            PsiElement processed = handler.findModule(result2);
            if (processed == null) continue;
            return processed;
        }
        return result2;
    }

    public static PsiFile findIndexFile(@NotNull String[] extensions, @NotNull PsiFileSystemItem result2) {
        VirtualFile virtualFile;
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(29);
        }
        if (result2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(30);
        }
        if ((virtualFile = result2.getVirtualFile()) != null) {
            for (String ext : extensions) {
                VirtualFile child = virtualFile.findChild("index" + ext);
                if (child == null) continue;
                return result2.getManager().findFile(child);
            }
        }
        return null;
    }

    @NotNull
    private static Collection<PsiElement> mergeWithAugmentations(PsiElement context, Collection<PsiElement> modules) {
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(context, modules);
        if (augmentations.isEmpty()) {
            Collection<PsiElement> collection = modules;
            if (collection == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(31);
            }
            return collection;
        }
        ArrayList result2 = ContainerUtil.newArrayList(modules);
        result2.addAll(augmentations);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    public static PsiReference[] calcImportExportFromClauseReferences(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider2) {
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(33);
        }
        return INSTANCE.calcImportExportFromClauseReferencesImpl(element, provider2);
    }

    @NotNull
    protected PsiReference[] calcImportExportFromClauseReferencesImpl(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider2) {
        Pair<String, PsiElement> pair;
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(34);
        }
        if ((pair = JSPsiImplUtils.getChildStringLiteralWithText(element)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(35);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement literalExpression = (PsiElement)pair.second;
        String quotedText = (String)pair.first;
        PsiReference[] psiReferenceArray = JSFileReferencesUtil.createImportExportFromClauseReferences(element, literalExpression.getStartOffsetInParent() + 1, quotedText, provider2);
        if (psiReferenceArray == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(36);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static String getShortestPathInContexts(@Nullable VirtualFile dstVFile, @NotNull Collection<VirtualFile> contexts, boolean skipParent) {
        if (contexts == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(37);
        }
        if (dstVFile == null || contexts.size() == 0) {
            return null;
        }
        String path = null;
        String parentDirPath = null;
        for (VirtualFile contextFile : contexts) {
            String candidate;
            if (!VfsUtilCore.isAncestor((VirtualFile)contextFile, (VirtualFile)dstVFile, (boolean)true) || StringUtil.isEmpty((String)(candidate = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)contextFile, (char)'/')))) continue;
            if (skipParent && contextFile.equals(dstVFile.getParent())) {
                parentDirPath = candidate;
                continue;
            }
            path = path == null || path.length() > candidate.length() ? candidate : path;
        }
        return path == null ? parentDirPath : path;
    }

    public static boolean startWithLocalPrefix(@NotNull String text) {
        if (text == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(38);
        }
        return text.startsWith("./") || text.startsWith("../");
    }

    @NotNull
    public static String getNodeModuleName(@NotNull String text) {
        String path;
        if (text == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(39);
        }
        if (JSFileReferencesUtil.startWithLocalPrefix(path = JSStringUtil.unquoteStringLiteralValue(text.trim(), false))) {
            String string = path;
            if (string == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        String[] strings = path.split("/");
        if (strings.length > 1) {
            if (strings[0].startsWith("@")) {
                String string = strings[0] + "/" + strings[1];
                if (string == null) {
                    JSFileReferencesUtil.$$$reportNull$$$0(41);
                }
                return string;
            }
            String string = strings[0];
            if (string == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(42);
            }
            return string;
        }
        String string = strings.length == 0 ? "" : strings[0];
        if (string == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public static PsiReferenceProvider getSimpleReferencesPathProvider(final @NotNull String[] extensions) {
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(44);
        }
        PsiReferenceProvider psiReferenceProvider = new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (element instanceof JsonStringLiteral) {
                    VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
                    boolean isCaseSensitive = file2 == null ? SystemInfo.isFileSystemCaseSensitive : file2.getFileSystem().isCaseSensitive();
                    String value = ((JsonStringLiteral)element).getValue();
                    FileReference[] fileReferenceArray = new FileReferenceSet(value, element, 1, null, isCaseSensitive){

                        protected boolean isSoft() {
                            return true;
                        }

                        public FileReference createFileReference(TextRange range, int index, String text) {
                            return new JSFileReference(text, index, range, this, extensions){

                                @Override
                                protected boolean isAllowFolders() {
                                    return true;
                                }

                                @Override
                                protected String[] getImplicitExtensions() {
                                    return extensions;
                                }
                            };
                        }
                    }.getAllReferences();
                    if (fileReferenceArray == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    3.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$3";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (psiReferenceProvider == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(45);
        }
        return psiReferenceProvider;
    }

    public static boolean isAcceptableNodeModulesPackageName(@NotNull String moduleName) {
        if (moduleName == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(46);
        }
        if (JSFileReferencesUtil.startWithLocalPrefix(moduleName)) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)moduleName)) {
            return false;
        }
        boolean haveNamePartInWord = false;
        for (int i = 0; i < moduleName.length(); ++i) {
            char ch = moduleName.charAt(i);
            if (ch == '@' && i > 0) {
                return false;
            }
            boolean namePart = Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '@';
            haveNamePartInWord |= namePart;
            if (namePart || ch == '.' || ch == '/') continue;
            return false;
        }
        return haveNamePartInWord;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "util";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReference";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil";
                break;
            }
            case 3: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refText";
                break;
            }
            case 6: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 8: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedString";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: 
            case 29: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReferences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReference";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMainModules";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostPriorityModules";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWithAugmentations";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImportExportFromClauseReferencesImpl";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModuleName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleReferencesPathProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReferences";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceModuleText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createImportExportFromClauseReferences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getModulesWithAugmentations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMainModulesFromCache";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMainModules";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateMainModules";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMostPriorityModules";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForPsiElement";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isValidModule";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceWeight";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findIndexFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "calcImportExportFromClauseReferences";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "calcImportExportFromClauseReferencesImpl";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getShortestPathInContexts";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "startWithLocalPrefix";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModuleName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleReferencesPathProvider";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNodeModulesPackageName";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveModuleReference$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

