/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlerBase;
import com.intellij.lang.javascript.macro.JSSuggestVariableNameMacro;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSKeywordInsertHandlers {
    public static final InsertHandler<LookupElement> STATEMENT_WITH_PARENS_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        @Nullable
        protected Template getTemplate() {
            return STATEMENT_WITH_PARENS_TEMPLATE;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.LPAR;
            if (iElementType == null) {
                1.$$$reportNull$$$0(0);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordInsertHandlers$1", "getElementType"));
        }
    };
    public static final InsertHandler<LookupElement> TS_REQUIRE_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        @Nullable
        protected Template getTemplate() {
            return REQUIRE_ARG_TEMPLATE;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.LPAR;
            if (iElementType == null) {
                2.$$$reportNull$$$0(0);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordInsertHandlers$2", "getElementType"));
        }
    };
    public static final InsertHandler<LookupElement> STATEMENT_WITH_BLOCK_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        @Nullable
        protected Template getTemplate() {
            return ENTITY_WITH_BLOCK_TEMPLATE;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.LBRACE;
            if (iElementType == null) {
                3.$$$reportNull$$$0(0);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordInsertHandlers$3", "getElementType"));
        }
    };
    public static final InsertHandler<LookupElement> CATCH_BLOCK_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        @Nullable
        protected Template getTemplate() {
            return CATCH_BLOCK_TEMPLATE;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.LBRACE;
            if (iElementType == null) {
                4.$$$reportNull$$$0(0);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordInsertHandlers$4", "getElementType"));
        }
    };
    public static final InsertHandler<LookupElement> INTERFACE_KEYWORD_INSERT_HANDLER = new NamedTypeInsertHandler(){

        @Override
        @NotNull
        protected String getKeywordText() {
            if ("interface" == null) {
                5.$$$reportNull$$$0(0);
            }
            return "interface";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordInsertHandlers$5", "getKeywordText"));
        }
    };
    public static final InsertHandler<LookupElement> ENUM_KEYWORD_INSERT_HANDLER = new NamedTypeInsertHandler(){

        @Override
        @NotNull
        protected String getKeywordText() {
            if ("enum" == null) {
                6.$$$reportNull$$$0(0);
            }
            return "enum";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordInsertHandlers$6", "getKeywordText"));
        }
    };
    public static final InsertHandler<LookupElement> FUNCTION_KEYWORD_INSERT_HANDLER = new JSKeywordInsertHandlerBase(){

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file2, PsiElement at) {
            Template template = null;
            if (at != null && at.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD) {
                if (!7.isFollowedByIdentifierOrReferenceName(at)) {
                    PsiElement parent = at.getParent();
                    if (parent instanceof JSFunction && !(at.getNextSibling() instanceof JSParameterList)) {
                        if (parent instanceof JSFunctionExpression) {
                            template = FUNCTION_EXPRESSION_TEMPLATE;
                        } else if (DialectDetector.isJavaScriptFamily((PsiElement)file2)) {
                            template = DialectDetector.isTypeScript((PsiElement)file2) && JSPsiImplUtils.hasModifier((JSAttributeListOwner)((JSFunction)parent), JSAttributeList.ModifierType.DECLARE) ? FUNCTION_TEMPLATE_NO_BODY : FUNCTION_TEMPLATE;
                        } else {
                            7.insertWhitespaceIfNeeded(at, context);
                        }
                    }
                } else {
                    7.insertWhitespaceIfNeeded(at, context);
                }
            }
            if (template == null && 7.isKeywordWithIdentifierAppended(at, "function")) {
                7.insertWhitespace(context);
            }
            return template;
        }
    };
    public static final InsertHandler<LookupElement> CLASS_KEYWORD_INSERT_HANDLER = new JSKeywordInsertHandlerBase(){

        private boolean isLBrace(PsiElement element) {
            if (!(element instanceof LeafPsiElement)) {
                return false;
            }
            return ((LeafPsiElement)element).getElementType() == JSTokenTypes.LBRACE;
        }

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file2, PsiElement at) {
            Template template = null;
            if (at != null && at.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
                if (!8.isFollowedByIdentifierOrReferenceName(at)) {
                    PsiElement parent = at.getParent();
                    if ((parent instanceof JSClass || parent instanceof JSFile || parent instanceof TypeScriptModule) && !this.isLBrace(PsiTreeUtil.skipWhitespacesForward((PsiElement)at))) {
                        if (parent instanceof JSClassExpression) {
                            template = ENTITY_WITH_BLOCK_TEMPLATE;
                        } else if (DialectDetector.isJavaScriptFamily((PsiElement)file2)) {
                            template = NAMED_TYPE_TEMPLATE;
                        } else {
                            8.insertWhitespaceIfNeeded(at, context);
                        }
                    }
                } else {
                    8.insertWhitespaceIfNeeded(at, context);
                }
            }
            if (template == null && 8.isKeywordWithIdentifierAppended(at, "class")) {
                8.insertWhitespace(context);
            }
            return template;
        }
    };
    private static final Template STATEMENT_WITH_PARENS_TEMPLATE = new TemplateImpl("", " ($ARG$) $END$", "");
    private static final Template REQUIRE_ARG_TEMPLATE = new TemplateImpl("", "(\"$ARG$\");\n$END$", "");
    private static final Template ENTITY_WITH_BLOCK_TEMPLATE = new TemplateImpl("", " {\n  $END$\n}", "");
    private static final Template CATCH_BLOCK_TEMPLATE = new TemplateImpl("", " $BINDING$ {\n  $END$\n}", "");
    private static final Template FUNCTION_TEMPLATE = new TemplateImpl("", " $NAME$($PARAMS$) {\n  $END$\n}", "");
    private static final Template FUNCTION_TEMPLATE_NO_BODY = new TemplateImpl("", " $NAME$($PARAMS$);", "");
    private static final Template FUNCTION_EXPRESSION_TEMPLATE = new TemplateImpl("", "($PARAMS$) {\n  $END$\n}", "");
    private static final Template NAMED_TYPE_TEMPLATE = new TemplateImpl("", " $NAME$ {\n  $END$\n}", "");

    static {
        FUNCTION_TEMPLATE.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        FUNCTION_TEMPLATE.addVariable("PARAMS", (Expression)new EmptyNode(), true);
        FUNCTION_TEMPLATE.setToReformat(true);
        FUNCTION_TEMPLATE_NO_BODY.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        FUNCTION_TEMPLATE_NO_BODY.addVariable("PARAMS", (Expression)new EmptyNode(), true);
        FUNCTION_TEMPLATE_NO_BODY.setToReformat(true);
        FUNCTION_EXPRESSION_TEMPLATE.addVariable("PARAMS", (Expression)new EmptyNode(), true);
        FUNCTION_EXPRESSION_TEMPLATE.setToReformat(true);
        STATEMENT_WITH_PARENS_TEMPLATE.addVariable("ARG", (Expression)new EmptyNode(), true);
        STATEMENT_WITH_PARENS_TEMPLATE.setToReformat(true);
        STATEMENT_WITH_PARENS_TEMPLATE.addVariable("ARG", (Expression)new EmptyNode(), true);
        STATEMENT_WITH_PARENS_TEMPLATE.setToReformat(true);
        REQUIRE_ARG_TEMPLATE.addVariable("ARG", (Expression)new MacroCallNode((Macro)new CompleteMacro()), true);
        REQUIRE_ARG_TEMPLATE.setToReformat(true);
        ENTITY_WITH_BLOCK_TEMPLATE.setToReformat(true);
        NAMED_TYPE_TEMPLATE.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        NAMED_TYPE_TEMPLATE.setToReformat(true);
        CATCH_BLOCK_TEMPLATE.addVariable("BINDING", (Expression)new ConstantNode("(e)"), true);
        CATCH_BLOCK_TEMPLATE.setToReformat(true);
    }

    private static class NamedTypeInsertHandler
    extends JSWithFollowingElementInsertHandler {
        private NamedTypeInsertHandler() {
        }

        @Override
        @Nullable
        protected Template getTemplate() {
            return NAMED_TYPE_TEMPLATE;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.IDENTIFIER;
            if (iElementType == null) {
                NamedTypeInsertHandler.$$$reportNull$$$0(0);
            }
            return iElementType;
        }

        @Override
        protected boolean stopBeforeIdentifier() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordInsertHandlers$NamedTypeInsertHandler", "getElementType"));
        }
    }

    private static abstract class JSWithFollowingElementInsertHandler
    extends JSKeywordInsertHandlerBase {
        private JSWithFollowingElementInsertHandler() {
        }

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file2, PsiElement at) {
            ASTNode node;
            Template template = null;
            ASTNode aSTNode = node = at == null ? null : at.getNode();
            if (node instanceof LeafPsiElement) {
                if (this.stopBeforeIdentifier() && JSWithFollowingElementInsertHandler.isFollowedByIdentifierOrReferenceName(at)) {
                    JSWithFollowingElementInsertHandler.insertWhitespaceIfNeeded(at, context);
                } else {
                    String keywordText;
                    PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)at);
                    if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == this.getElementType()) {
                        context.getEditor().getCaretModel().moveToOffset(((LeafPsiElement)element).getStartOffset() + 1);
                        return null;
                    }
                    if (this.stopBeforeIdentifier() && node.getElementType() == JSTokenTypes.IDENTIFIER && (keywordText = this.getKeywordText()) != null && JSWithFollowingElementInsertHandler.isKeywordWithIdentifierAppended(at, keywordText)) {
                        JSWithFollowingElementInsertHandler.insertWhitespace(context);
                        return null;
                    }
                    template = this.getTemplate();
                }
            }
            return template;
        }

        @Nullable
        protected abstract Template getTemplate();

        @NotNull
        protected abstract IElementType getElementType();

        protected boolean stopBeforeIdentifier() {
            return false;
        }

        @Nullable
        protected String getKeywordText() {
            return null;
        }
    }
}

