/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.markdown4j.Markdown4jProcessor;

public class JSMarkdownUtil {
    private static final Pattern TAG_START_OR_CLOSE_PATTERN = Pattern.compile("(<)/?(\\w+)[> ]");
    private static final Pattern SPLIT_BY_LINE_PATTERN = Pattern.compile("\n|\r|\r\n");
    private static final String HTML_CODE_START = "<code>";
    private static final String HTML_CODE_END = "</code>";
    private static final String FENCED_CODE_BLOCK = "```";
    private static final String INLINE_CODE_BLOCK = "``";
    private static final Map<String, String> HTML_DOC_SUBSTITUTIONS = new HashMap();
    public static final String BR_TAG_AFTER_MARKDOWN_PROCESSING = "<br  />";
    private static final Set<String> ACCEPTABLE_TAGS;

    private JSMarkdownUtil() {
    }

    @Nullable
    public static String toHtml(@NotNull String markdownText) {
        if (markdownText == null) {
            JSMarkdownUtil.$$$reportNull$$$0(0);
        }
        return JSMarkdownUtil.toHtml(markdownText, false, true);
    }

    @Nullable
    public static String toHtml(@NotNull String markdownText, boolean convertNewLinesToBr, boolean convertTagCodeBlocks) {
        if (markdownText == null) {
            JSMarkdownUtil.$$$reportNull$$$0(1);
        }
        String[] lines = SPLIT_BY_LINE_PATTERN.split(markdownText);
        ArrayList processedLines = ContainerUtil.newArrayListWithCapacity((int)lines.length);
        boolean isInCode = false;
        for (String line : lines) {
            String processedLine = StringUtil.trimTrailing((String)line);
            int count = StringUtil.getOccurrenceCount((String)(processedLine = StringUtil.trimStart((String)processedLine, (String)" ")), (String)FENCED_CODE_BLOCK);
            if (count > 0) {
                isInCode = count % 2 == 0 ? isInCode : !isInCode;
            } else if (convertTagCodeBlocks) {
                if (isInCode) {
                    if (processedLine.startsWith(HTML_CODE_END)) {
                        processedLines.add(FENCED_CODE_BLOCK);
                        processedLine = StringUtil.trimStart((String)processedLine, (String)HTML_CODE_END);
                        isInCode = false;
                    }
                } else {
                    boolean codeStart = false;
                    if (processedLine.endsWith(HTML_CODE_START)) {
                        codeStart = true;
                        processedLine = StringUtil.trimEnd((String)processedLine, (String)HTML_CODE_START);
                    }
                    processedLine = processedLine.replace("<pre>", FENCED_CODE_BLOCK).replace("</pre>", FENCED_CODE_BLOCK).replace(HTML_CODE_START, INLINE_CODE_BLOCK).replace(HTML_CODE_END, INLINE_CODE_BLOCK);
                    if (codeStart) {
                        processedLines.add(processedLine);
                        processedLine = FENCED_CODE_BLOCK;
                        isInCode = true;
                    }
                }
            } else {
                List<TextRange> ranges = JSMarkdownUtil.getInlineCodeBlocks(processedLine);
                processedLine = isInCode ? processedLine : JSMarkdownUtil.replaceProhibitedTags(StringUtil.trimLeading((String)processedLine), ranges);
            }
            processedLines.add(processedLine);
        }
        String normalizedMarkdown = StringUtil.join((Collection)processedLines, (String)"\n");
        String html = JSMarkdownUtil.convert(normalizedMarkdown);
        return JSMarkdownUtil.adjustHtml(html, convertNewLinesToBr);
    }

    private static List<TextRange> getInlineCodeBlocks(@NotNull String processingLine) {
        int startQuote;
        if (processingLine == null) {
            JSMarkdownUtil.$$$reportNull$$$0(2);
        }
        int next = 0;
        ArrayList ranges = ContainerUtil.newArrayList();
        int length = processingLine.length();
        while (next >= 0 && next < length && (startQuote = processingLine.indexOf(96, next)) >= 0 && length > startQuote + 1) {
            int endQuote;
            int offset;
            char nextChar = processingLine.charAt(startQuote + 1);
            int n = offset = nextChar == '`' ? 2 : 1;
            if (length <= startQuote + offset || (endQuote = processingLine.indexOf(96, startQuote + offset)) <= 0) break;
            ranges.add(new TextRange(startQuote, endQuote));
            next = endQuote + offset;
        }
        return ranges;
    }

    @Nullable
    private static String convert(@NotNull String text) {
        if (text == null) {
            JSMarkdownUtil.$$$reportNull$$$0(3);
        }
        try {
            return new Markdown4jProcessor().process(text);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String replaceProhibitedTags(@NotNull String line) {
        if (line == null) {
            JSMarkdownUtil.$$$reportNull$$$0(4);
        }
        return JSMarkdownUtil.replaceProhibitedTags(line, ContainerUtil.emptyList());
    }

    @NotNull
    private static String replaceProhibitedTags(@NotNull String line, @NotNull List<TextRange> skipRanges) {
        TIntArrayList list;
        if (line == null) {
            JSMarkdownUtil.$$$reportNull$$$0(5);
        }
        if (skipRanges == null) {
            JSMarkdownUtil.$$$reportNull$$$0(6);
        }
        if ((list = JSMarkdownUtil.collectProhibitedTagOffsets(line, skipRanges)).isEmpty()) {
            String string = line;
            if (string == null) {
                JSMarkdownUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = JSMarkdownUtil.escapeTagsStart(line, list);
        if (string == null) {
            JSMarkdownUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String escapeTagsStart(@NotNull String line, @NotNull TIntArrayList orderedOffsetList) {
        if (line == null) {
            JSMarkdownUtil.$$$reportNull$$$0(9);
        }
        if (orderedOffsetList == null) {
            JSMarkdownUtil.$$$reportNull$$$0(10);
        }
        StringBuilder builder = new StringBuilder(line);
        orderedOffsetList.forEachDescending(el -> {
            builder.replace(el, el + 1, "&lt;");
            return true;
        });
        String string = builder.toString();
        if (string == null) {
            JSMarkdownUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static TIntArrayList collectProhibitedTagOffsets(@NotNull String line, @NotNull List<TextRange> skipRanges) {
        if (line == null) {
            JSMarkdownUtil.$$$reportNull$$$0(12);
        }
        if (skipRanges == null) {
            JSMarkdownUtil.$$$reportNull$$$0(13);
        }
        Matcher matcher = TAG_START_OR_CLOSE_PATTERN.matcher(line);
        TIntArrayList list = new TIntArrayList();
        block0: while (matcher.find()) {
            String tagName = matcher.group(2);
            if (ACCEPTABLE_TAGS.contains(StringUtil.toLowerCase((String)tagName))) continue;
            int startOfTag = matcher.start(2);
            for (TextRange range : skipRanges) {
                if (!range.contains(startOfTag)) continue;
                continue block0;
            }
            list.add(matcher.start(1));
        }
        TIntArrayList tIntArrayList = list;
        if (tIntArrayList == null) {
            JSMarkdownUtil.$$$reportNull$$$0(14);
        }
        return tIntArrayList;
    }

    @Nullable
    public static String adjustHtml(@Nullable String html, boolean convertNewLinesToBr) {
        if (html == null) {
            return null;
        }
        String str = html;
        for (Map.Entry<String, String> entry : HTML_DOC_SUBSTITUTIONS.entrySet()) {
            str = str.replace(entry.getKey(), entry.getValue());
        }
        if (!convertNewLinesToBr) {
            str = str.replace(BR_TAG_AFTER_MARKDOWN_PROCESSING, "");
        }
        return str.trim();
    }

    static {
        HTML_DOC_SUBSTITUTIONS.put("<pre><code>", "<pre>");
        HTML_DOC_SUBSTITUTIONS.put("</code></pre>", "</pre>");
        HTML_DOC_SUBSTITUTIONS.put("<em>", "<i>");
        HTML_DOC_SUBSTITUTIONS.put("</em>", "</i>");
        HTML_DOC_SUBSTITUTIONS.put("<strong>", "<b>");
        HTML_DOC_SUBSTITUTIONS.put("</strong>", "</b>");
        HTML_DOC_SUBSTITUTIONS.put(": //", "://");
        ACCEPTABLE_TAGS = ContainerUtil.immutableSet((Object[])new String[]{"p", "i", "code", "ul", "h1", "h2", "h3", "h4", "h5", "h6", "li", "blockquote", "b", "a", "tt", "tt", "pre", "tr", "th", "td", "table"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markdownText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingLine";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipRanges";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSMarkdownUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedOffsetList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSMarkdownUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceProhibitedTags";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTagsStart";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProhibitedTagOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInlineCodeBlocks";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceProhibitedTags";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "escapeTagsStart";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectProhibitedTagOffsets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

