/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleIndex;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptUtil {
    public static final FileType[] TYPESCRIPT_FILE_TYPES_ARRAY = new FileType[]{TypeScriptFileType.INSTANCE, TypeScriptJSXFileType.INSTANCE};
    public static final Collection<FileType> TYPESCRIPT_FILE_TYPES = ContainerUtil.newArrayList((Object[])TYPESCRIPT_FILE_TYPES_ARRAY);
    public static final String TYPESCRIPT_FILE_EXTENSION = ".ts";
    public static final String TYPESCRIPT_JSX_FILE_EXTENSION = ".tsx";
    public static final String[] TYPESCRIPT_EXTENSIONS_WITHOUT_DTS = new String[]{".ts", ".tsx"};
    public static final String TYPESCRIPT_DECLARATIONS_FILE_EXTENSION = ".d.ts";
    public static final String VUE_FILE_EXTENSION = ".vue";
    public static final String[] TYPESCRIPT_EXTENSIONS = new String[]{".d.ts", ".ts", ".tsx"};
    public static final String LIB_PREFIX = "lib.";
    public static final String[] TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS = new String[]{".d.ts"};
    public static final String COMPILER_DIRECTORY_NAME = "jsLanguageServicesImpl";
    public static final Function<PsiElement, TypeScriptInterface> TYPESCRIPT_INTERFACE_FILTER = element -> element instanceof TypeScriptInterface ? (TypeScriptInterface)element : null;
    public static final String TYPINGS = "typings";
    public static final String TYPES = "types";

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> resolveConstructorFunctions(@NotNull TypeScriptClass clazz, @NotNull PsiElement methodExpression) {
        if (clazz == null) {
            TypeScriptUtil.$$$reportNull$$$0(0);
        }
        if (methodExpression == null) {
            TypeScriptUtil.$$$reportNull$$$0(1);
        }
        THashSet visitedClasses = new THashSet();
        ArrayDeque<TypeScriptClass> classQueue = new ArrayDeque<TypeScriptClass>();
        PsiElement parent = methodExpression.getParent();
        if (!(methodExpression instanceof JSNewExpression) && !(parent instanceof JSNewExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            TypeScriptClass currentClass;
            JSClass rawClass = (JSClass)classQueue.poll();
            if (!(rawClass instanceof TypeScriptClass) || !visitedClasses.add((currentClass = (TypeScriptClass)rawClass).getQualifiedName())) continue;
            TypeScriptFunction[] constructors = currentClass.getConstructors();
            if (constructors.length > 0) {
                Collection collection = Arrays.stream(constructors).map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
                if (collection == null) {
                    TypeScriptUtil.$$$reportNull$$$0(3);
                }
                return collection;
            }
            Collection indirectConstructors = currentClass.getIndirectSuperConstructors();
            if (!indirectConstructors.isEmpty()) {
                Collection collection = indirectConstructors.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
                if (collection == null) {
                    TypeScriptUtil.$$$reportNull$$$0(4);
                }
                return collection;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public static VirtualFile findFileByReferencePath(@NotNull PsiFile file2, @NotNull String referencePath, @NotNull Project project) {
        ConcurrentMap refPathToVirtualFile;
        Object value;
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(6);
        }
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(8);
        }
        if ((value = (refPathToVirtualFile = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            if (file2 == null) {
                TypeScriptUtil.$$$reportNull$$$0(93);
            }
            ConcurrentMap result2 = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{file2, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        })).get(referencePath)) == null) {
            VirtualFile result2 = TypeScriptUtil.calcFileByReferencePath(file2.getProject(), file2.getVirtualFile(), referencePath);
            refPathToVirtualFile.put(referencePath, result2 == null ? ObjectUtils.NULL : result2);
            return result2;
        }
        return TypeScriptUtil.getValue(value);
    }

    @Nullable
    private static VirtualFile getValue(@NotNull Object object) {
        if (object == null) {
            TypeScriptUtil.$$$reportNull$$$0(9);
        }
        if (object instanceof VirtualFile) {
            return (VirtualFile)object;
        }
        return null;
    }

    @Nullable
    public static VirtualFile calcFileByReferencePath(Project project, @Nullable VirtualFile virtualFile, @NotNull String referencePath) {
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile result2 = null;
        referencePath = referencePath.replace('\\', '/');
        VirtualFile dir = virtualFile.getParent();
        if (referencePath.startsWith(".")) {
            if (dir != null) {
                result2 = TypeScriptUtil.getFileByRelativePath(referencePath, dir);
            }
        } else {
            VirtualFile contentRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(virtualFile, true);
            VirtualFile imported = TypeScriptUtil.findForContentRoot(referencePath, contentRootForFile, dir);
            if (imported == null) {
                for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                    if (!contentRoot.equals(contentRootForFile) && (imported = TypeScriptUtil.findForContentRoot(referencePath, contentRoot, contentRoot)) != null) break;
                }
            }
            result2 = imported;
        }
        return result2;
    }

    @Nullable
    private static VirtualFile findForContentRoot(@NotNull String referencePath, VirtualFile contentRoot, VirtualFile startFrom) {
        VirtualFile contentRootParent;
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(11);
        }
        VirtualFile imported = null;
        VirtualFile virtualFile = contentRootParent = contentRoot != null ? contentRoot.getParent() : null;
        while (imported == null && startFrom != null && startFrom.isInLocalFileSystem()) {
            imported = TypeScriptUtil.getFileByRelativePath(referencePath, startFrom);
            if (contentRootParent != null && startFrom.equals(contentRootParent)) break;
            startFrom = startFrom.getParent();
        }
        return imported;
    }

    private static VirtualFile getFileByRelativePath(@NotNull String referencePath, VirtualFile currentParent) {
        VirtualFile imported;
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(12);
        }
        if ((imported = currentParent.findFileByRelativePath(referencePath)) == null || imported.isDirectory()) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_DECLARATIONS_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_JSX_FILE_EXTENSION);
        }
        return imported;
    }

    @NotNull
    public static ResolveResult[] findExternalModule(@NotNull PsiFile refFile, @NotNull String unquotedEscapedModuleName) {
        if (refFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(13);
        }
        if (unquotedEscapedModuleName == null) {
            TypeScriptUtil.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String quotedModuleName = StringUtil.wrapWithDoubleQuote((String)JSStringUtil.unescapeStringLiteralValue(unquotedEscapedModuleName));
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)refFile);
        Collection<JSQualifiedNamedElement> modules = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(quotedModuleName, scope);
        if (!modules.isEmpty()) {
            ArrayList result2 = ContainerUtil.newArrayList();
            for (JSNamedElement jSNamedElement : modules) {
                if (!(jSNamedElement instanceof TypeScriptModule) || ((TypeScriptModule)jSNamedElement).isAugmentation()) continue;
                result2.add(new JSResolveResult((PsiElement)jSNamedElement));
            }
            if (!ContainerUtil.isEmpty((Collection)result2)) {
                ResolveResult[] resolveResultArray = result2.toArray(ResolveResult.EMPTY_ARRAY);
                if (resolveResultArray == null) {
                    TypeScriptUtil.$$$reportNull$$$0(15);
                }
                return resolveResultArray;
            }
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            TypeScriptUtil.$$$reportNull$$$0(16);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static ResolveResult[] findPatternBasedExternalModule(@NotNull PsiFile refFile, @NotNull String unquotedEscapedModuleName, @NotNull Project project) {
        if (refFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(17);
        }
        if (unquotedEscapedModuleName == null) {
            TypeScriptUtil.$$$reportNull$$$0(18);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String unquotedModuleName = JSStringUtil.unescapeStringLiteralValue(unquotedEscapedModuleName);
        Collection<TypeScriptModule> patternExternalModules = TypeScriptUtil.getAllPatternExternalModules(project, (PsiElement)refFile);
        List patterns = patternExternalModules.stream().map(module -> JSPathMappingsUtil.createPatternForString(StringUtil.unquoteString((String)module.getName()))).collect(Collectors.toList());
        Pair path = JSPathMappingsUtil.findMaxElementByPaths(unquotedModuleName, patterns);
        if (path != null && path.getFirst() != null) {
            ArrayList resultPatternModules = ContainerUtil.newArrayList();
            String pattern = StringUtil.wrapWithDoubleQuote((String)((JSModulePattern)path.getFirst()).getPattern());
            for (TypeScriptModule module2 : patternExternalModules) {
                if (!pattern.equals(module2.getName())) continue;
                resultPatternModules.add(new JSResolveResult((PsiElement)module2));
            }
            return resultPatternModules.toArray(ResolveResult.EMPTY_ARRAY);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static Collection<TypeScriptModule> getAllRegularExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(20);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"reg", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner), TypeScriptModule.class);
    }

    @NotNull
    private static GlobalSearchScope createScopeWithFilterByNodeModules(@NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(21);
        }
        GlobalSearchScope globalSearchScope = TypeScriptUtil.createFilterByNodeModuleScope(JSResolveUtil.getResolveScope(owner), owner);
        if (globalSearchScope == null) {
            TypeScriptUtil.$$$reportNull$$$0(22);
        }
        return globalSearchScope;
    }

    public static Collection<TypeScriptModule> getAllPatternExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(23);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"pat", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner), TypeScriptModule.class);
    }

    public static Collection<TypeScriptModule> getAllAugmentationModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(24);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"aug", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner), TypeScriptModule.class);
    }

    @Contract(value="!null -> !null", pure=true)
    public static String unifyModuleName(@Nullable String quotedEscapedLiteralModuleName) {
        if (quotedEscapedLiteralModuleName == null) {
            return null;
        }
        return StringUtil.wrapWithDoubleQuote((String)JSStringUtil.unquoteAndUnescapeStringLiteralValue(quotedEscapedLiteralModuleName));
    }

    @NotNull
    public static Collection<JSClass<?>> getNonStrictParents(@NotNull JSClass<?> clazz, boolean includeInterfaces) {
        if (clazz == null) {
            TypeScriptUtil.$$$reportNull$$$0(25);
        }
        final ArrayList result2 = new ArrayList();
        JSClassUtils.processClassesInHierarchy(clazz, includeInterfaces, new JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                result2.add(aClass);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<JSClass> resolveAliasesToClass(@NotNull JSClass[] classes, boolean includeInterfaces) {
        if (classes == null) {
            TypeScriptUtil.$$$reportNull$$$0(27);
        }
        if (classes.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptUtil.$$$reportNull$$$0(28);
            }
            return list;
        }
        if (!includeInterfaces) {
            List list = ContainerUtil.newSmartList((Object[])classes);
            if (list == null) {
                TypeScriptUtil.$$$reportNull$$$0(29);
            }
            return list;
        }
        List result2 = ContainerUtil.newSmartList();
        for (JSClass currentClass : classes) {
            if (currentClass instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)currentClass, result2, null);
                continue;
            }
            result2.add(currentClass);
        }
        List list = result2;
        if (list == null) {
            TypeScriptUtil.$$$reportNull$$$0(30);
        }
        return list;
    }

    public static void resolveNameToClassesOverAliases(@Nullable String name, @NotNull PsiElement context, @NotNull Collection<JSClass> resultCollection, Collection<JSClass> visitedAliases) {
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(31);
        }
        if (resultCollection == null) {
            TypeScriptUtil.$$$reportNull$$$0(32);
        }
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveTypeName(name, context);
        for (PsiElement psiElement : result2.getElements()) {
            if (!(psiElement instanceof JSClass)) continue;
            if (psiElement instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)psiElement, resultCollection, visitedAliases);
                continue;
            }
            resultCollection.add((JSClass)psiElement);
        }
    }

    public static void resolveAliasToClass(@NotNull TypeScriptTypeAlias alias, @NotNull Collection<JSClass> resultCollection, @Nullable Collection<JSClass> visitedAliases) {
        JSTypeDeclaration declaration;
        if (alias == null) {
            TypeScriptUtil.$$$reportNull$$$0(33);
        }
        if (resultCollection == null) {
            TypeScriptUtil.$$$reportNull$$$0(34);
        }
        if ((declaration = alias.getTypeDeclaration()) instanceof TypeScriptSingleType) {
            if (visitedAliases == null) {
                visitedAliases = ContainerUtil.newHashSet();
            }
            if (!visitedAliases.add(alias)) {
                return;
            }
            TypeScriptSingleType singleType = (TypeScriptSingleType)declaration;
            TypeScriptUtil.resolveNameToClassesOverAliases(singleType.getQualifiedTypeName(), (PsiElement)alias, resultCollection, visitedAliases);
        } else {
            resultCollection.add((JSClass)alias);
        }
    }

    @NotNull
    public static Iterable<JSNamedElement> getNamedMembers(@NotNull JSClass<?> aClass) {
        if (aClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(35);
        }
        Iterable members = aClass.getMembers();
        ArrayList<JSNamedElement> namedElements = new ArrayList<JSNamedElement>();
        for (JSElement member : members) {
            if (!(member instanceof JSNamedElement)) continue;
            namedElements.add((JSNamedElement)member);
        }
        ArrayList<JSNamedElement> arrayList = namedElements;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyGenericsToType(@NotNull JSType typeInParentClass, @Nullable JSClass surroundClass, @Nullable JSClass parentClass) {
        if (typeInParentClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(37);
        }
        if (parentClass != null && surroundClass != null && DialectDetector.isTypeScript((PsiElement)surroundClass)) {
            JSType jSType = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(surroundClass, (List<JSType>)ContainerUtil.emptyList(), parentClass, typeInParentClass);
            if (jSType == null) {
                TypeScriptUtil.$$$reportNull$$$0(38);
            }
            return jSType;
        }
        JSType jSType = typeInParentClass;
        if (jSType == null) {
            TypeScriptUtil.$$$reportNull$$$0(39);
        }
        return jSType;
    }

    @NotNull
    public static String buildParameterTypeListStringWithApplyingGenerics(TypeScriptFunction function, @Nullable PsiElement surroundClass) {
        TypeScriptTypeParameterList list;
        JSClass classOfContext = JSResolveUtil.getClassOfContext((PsiElement)function);
        if (classOfContext != null && (list = function.getTypeParameterList()) != null) {
            String join = StringUtil.join((Object[])list.getTypeParameters(), parameter -> {
                if (parameter.getTypeConstraint() != null) {
                    JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)parameter.getTypeConstraint());
                    if (surroundClass instanceof JSClass && JSTypeUtils.hasGenericParameter(type)) {
                        type = TypeScriptUtil.applyGenericsToType(type, (JSClass)surroundClass, classOfContext);
                    }
                    return parameter.getName() + " extends " + type.getTypeText(JSType.TypeTextFormat.CODE);
                }
                return parameter.getName();
            }, (String)", ");
            String string = StringUtil.isEmpty((String)join) ? "" : "<" + join + ">";
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        if ("" == null) {
            TypeScriptUtil.$$$reportNull$$$0(41);
        }
        return "";
    }

    @NotNull
    public static Map<JSElement, JSClass> getUnimplementedMembers(final @NotNull JSClass jsClass, final boolean includeOptional) {
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(42);
        }
        final ArrayList implementedInterfaces = new ArrayList();
        final HashMap typeSubstitutors = ContainerUtil.newHashMap();
        JSClassUtils.processClassesInHierarchy(jsClass, true, new JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((includeOptional || fromImplements || TypeScriptPsiUtil.isAbstractElement(aClass)) && aClass != jsClass) {
                    implementedInterfaces.add(aClass);
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)jsClass);
        LinkedHashMap<Pair, JSClass> membersToImplement = new LinkedHashMap<Pair, JSClass>();
        for (JSClass implementedInterface : implementedInterfaces) {
            ArrayList<Pair> implementedMembers = new ArrayList<Pair>();
            if (implementedInterface instanceof TypeScriptInterface) {
                TypeScriptObjectType body = ((TypeScriptInterface)implementedInterface).getBody();
                if (body == null) continue;
                for (TypeScriptTypeMember typeMember : body.getTypeMembers()) {
                    JSRecordType.TypeMember interfaceTypeMember = TypeScriptTypeMemberParser.buildTypeMember(typeMember);
                    if (interfaceTypeMember == null) continue;
                    implementedMembers.add(Pair.create((Object)interfaceTypeMember, (Object)typeMember));
                }
            } else if (implementedInterface instanceof TypeScriptClass) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)implementedInterface, true);
                for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(implementedInterface)) {
                    JSRecordType.TypeMember member = TypeScriptTypeMemberParser.buildTypeMemberFromClassMember(implementedInterface, (JSElement)classMember, false, typeSource, (JSTypeSubstitutor)typeSubstitutors.get(implementedInterface));
                    if (member == null) continue;
                    implementedMembers.add(Pair.create((Object)member, (Object)classMember));
                }
            }
            JSRecordType classType = TypeScriptTypeParser.buildTypeFromClass(jsClass, false, true, TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)jsClass), false);
            classType = (JSRecordType)classType.transformTypeHierarchy(type -> {
                if (jsClass == null) {
                    TypeScriptUtil.$$$reportNull$$$0(92);
                }
                return TypeScriptUtil.replaceThisType(type, jsClass, source);
            });
            JSRecordTypeImpl objectType = null;
            ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
            for (Pair implementedMember : implementedMembers) {
                boolean memberIsAlreadyAdded = false;
                for (Pair member : membersToImplement.keySet()) {
                    if (member == null || !((JSRecordType.TypeMember)member.first).isEquivalentTo((JSRecordType.TypeMember)implementedMember.first, true)) continue;
                    memberIsAlreadyAdded = true;
                    break;
                }
                if (memberIsAlreadyAdded) continue;
                typeMembers.clear();
                typeMembers.add(includeOptional ? TypeScriptUtil.overrideOptionalFlagForTypeMember((JSRecordType.TypeMember)implementedMember.first) : (JSRecordType.TypeMember)implementedMember.first);
                JSRecordTypeImpl type2 = new JSRecordTypeImpl(source, typeMembers);
                type2 = type2.transformTypeHierarchy(type1 -> {
                    if (jsClass == null) {
                        TypeScriptUtil.$$$reportNull$$$0(91);
                    }
                    return TypeScriptUtil.replaceThisType(type1, jsClass, source);
                });
                ProcessingContext context = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)jsClass);
                context.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)true);
                if (type2.isDirectlyAssignableType((JSType)classType, context)) continue;
                if (objectType == null) {
                    List<JSClass> objectClasses = TypeScriptClassResolver.getInstance().findObjectClasses(jsClass);
                    for (JSClass objectClass : objectClasses) {
                        JSRecordType currentObjectType = TypeScriptTypeParser.buildTypeFromClass(objectClass, false, false, false, false);
                        if (objectType == null) {
                            objectType = currentObjectType;
                            continue;
                        }
                        List objectTypeMembers = ContainerUtil.concat((List)objectType.getTypeMembers(), (List)currentObjectType.getTypeMembers());
                        objectType = new JSRecordTypeImpl(objectType.getSource(), objectTypeMembers);
                    }
                    if (objectType == null) {
                        objectType = new JSRecordTypeImpl(source, Collections.emptyList());
                    }
                }
                if (type2.isDirectlyAssignableType(objectType, context)) continue;
                membersToImplement.put(implementedMember, implementedInterface);
            }
        }
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (Map.Entry entry : membersToImplement.entrySet()) {
            result2.put(((Pair)entry.getKey()).second, entry.getValue());
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            TypeScriptUtil.$$$reportNull$$$0(43);
        }
        return linkedHashMap;
    }

    private static JSType replaceThisType(JSType type, JSClass jsClass, JSTypeSource source) {
        String name;
        if (type instanceof TypeScriptGenericThisTypeImpl && (name = jsClass.getQualifiedName()) != null) {
            return new TypeScriptGenericThisTypeImpl(type.getSource(), JSNamedType.createType(name, source, JSTypeContext.INSTANCE));
        }
        return type;
    }

    private static JSRecordType.TypeMember overrideOptionalFlagForTypeMember(JSRecordType.TypeMember member) {
        JSRecordType.PropertySignature propertySignature;
        if (member instanceof JSRecordType.PropertySignature && (propertySignature = (JSRecordType.PropertySignature)member).isOptional()) {
            return new JSRecordTypeImpl.PropertySignatureImpl(propertySignature.getMemberName(), propertySignature.getType(), false, propertySignature.getMemberSource());
        }
        return member;
    }

    public static boolean isTypeScriptMethod(PsiElement element) {
        return element instanceof JSFunction && !(element instanceof TypeScriptCallSignature);
    }

    public static boolean isTypeScriptProperty(PsiElement element) {
        return element instanceof TypeScriptPropertySignature || element instanceof JSVariable;
    }

    public static JSType setCallEnvironmentIfGenericParameterType(JSType type) {
        if (type instanceof JSGenericParameterImpl) {
            return JSGenericParameterImpl.cloneWithEnvironment((JSGenericParameterImpl)type, true);
        }
        return type;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            TypeScriptUtil.$$$reportNull$$$0(44);
        }
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(45);
        }
        JSType type = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(context), JSContext.INSTANCE);
        String string = TypeScriptUtil.getShortestTypeNameInContext(type, context);
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull JSType type, @Nullable PsiElement context) {
        if (type == null) {
            TypeScriptUtil.$$$reportNull$$$0(47);
        }
        if (!((type = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(type))) instanceof JSNamedType) || context == null || type instanceof JSPrimitiveType) {
            String string = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(48);
            }
            return string;
        }
        String text = type.getResolvedTypeText();
        String string = TypeScriptUtil.getShortestTypeNameInContextForQualifiedName(context, text);
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    public static String getShortestTypeNameInContextForQualifiedName(@NotNull PsiElement context, @NotNull String startQName) {
        JSQualifiedNameImpl name;
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(50);
        }
        if (startQName == null) {
            TypeScriptUtil.$$$reportNull$$$0(51);
        }
        if ((name = JSQualifiedNameImpl.fromQualifiedName(startQName)).getParent() == null) {
            String string = startQName;
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(52);
            }
            return string;
        }
        String result2 = null;
        String qName = null;
        for (JSQualifiedNameImpl current = name; current != null && (StringUtil.isEmpty(result2) || !StringUtil.equals((CharSequence)startQName, result2)); current = current.getParent()) {
            String currentName = StringUtil.unquoteString((String)current.getName());
            qName = qName == null ? currentName : currentName + "." + qName;
            result2 = TypeScriptImportHandler.getInstance().getQualifiedNameResolvedType(qName, context);
        }
        if (result2 != null && StringUtil.equals((CharSequence)startQName, result2)) {
            String string = qName;
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(53);
            }
            return string;
        }
        String string = startQName;
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    public static boolean hasAmbientExternalModuleInQName(@Nullable String value) {
        return value != null && (value.contains("'") || value.contains("\""));
    }

    @NotNull
    public static JSType getBaseTypeOfEnumLiteralType(@NotNull JSResolvableType type) {
        String text;
        JSQualifiedNameImpl name;
        JSQualifiedName parent;
        if (type == null) {
            TypeScriptUtil.$$$reportNull$$$0(55);
        }
        if ((parent = (name = JSQualifiedNameImpl.fromQualifiedName(text = type.getResolvedTypeText())).getParent()) != null) {
            String qualifiedName = parent.getQualifiedName();
            JSType jSType = JSNamedType.createType(qualifiedName, type.getSource(), JSTypeContext.INSTANCE);
            if (jSType == null) {
                TypeScriptUtil.$$$reportNull$$$0(56);
            }
            return jSType;
        }
        JSResolvableType jSResolvableType = type;
        if (jSResolvableType == null) {
            TypeScriptUtil.$$$reportNull$$$0(57);
        }
        return jSResolvableType;
    }

    @NotNull
    public static File getTypeScriptExternalFolderFile() {
        File file2 = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "external");
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(58);
        }
        return file2;
    }

    @NotNull
    public static File getTypeScriptCompilerFolderFile() throws RuntimeException {
        File file2;
        block7: {
            String jarPath;
            block5: {
                File file3;
                block6: {
                    try {
                        jarPath = PathUtil.getJarPathForClass(TypeScriptUtil.class);
                        if (jarPath.endsWith(".jar")) break block5;
                        URL resource = TypeScriptUtil.class.getClassLoader().getResource(COMPILER_DIRECTORY_NAME);
                        if (resource == null) {
                            throw new RuntimeException("Cannot find file compiler implementation");
                        }
                        file3 = new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
                        if (file3 != null) break block6;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    TypeScriptUtil.$$$reportNull$$$0(59);
                }
                return file3;
            }
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            file2 = new File(pluginBaseDir, COMPILER_DIRECTORY_NAME);
            if (file2 != null) break block7;
            TypeScriptUtil.$$$reportNull$$$0(60);
        }
        return file2;
    }

    public static boolean resolveIsStrict(@NotNull JSReferenceExpression node) {
        JSType jsType;
        JSExpression qualifier;
        if (node == null) {
            TypeScriptUtil.$$$reportNull$$$0(61);
        }
        if ((qualifier = node.getQualifier()) instanceof JSThisExpression && JSContextResolver.findContextElement((JSThisExpression)qualifier) instanceof JSClass || qualifier instanceof JSSuperExpression || qualifier == null) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((JSReferenceExpression)qualifier).multiResolve(false)) {
                PsiElement resolve = result2.getElement();
                if (!(resolve instanceof TypeScriptModule) && !(resolve instanceof TypeScriptImportStatement) && !(resolve instanceof ES6ImportedBinding) && !(resolve instanceof ES6ImportSpecifierAlias) && !(resolve instanceof JSFile)) continue;
                return true;
            }
        }
        return TypeScriptUtil.isStrictType(jsType = JSResolveUtil.getExpressionJSType(qualifier));
    }

    public static ProblemHighlightType getProblemHighlightTypeForType(@Nullable JSType type) {
        if (TypeScriptUtil.isStrictType(type)) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    public static boolean isStrictType(JSType jsType) {
        return jsType != null && jsType.getSource().isStrict() && !JSTypeUtils.hasAnyType(jsType) && !(jsType instanceof JSNullType);
    }

    public static boolean isUnderNodeModules(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(62);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(63);
        }
        return JSLibraryUtil.isProbableLibraryFile(file2, project);
    }

    public static boolean isDefinitionFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(64);
        }
        return TypeScriptUtil.isDefinitionFile(file2.getNameSequence());
    }

    public static boolean isDefinitionFile(@NotNull CharSequence fileName) {
        int dtslength;
        int length;
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(65);
        }
        if ((length = fileName.length()) <= (dtslength = TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.length())) {
            return false;
        }
        for (int i = 0; i < dtslength; ++i) {
            char ch = fileName.charAt(i + length - dtslength);
            if ('A' <= ch && ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            if (ch == TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static JSRecordType getFunctionTypeMembers(@Nullable PsiElement source) {
        if (source == null || !DialectDetector.isTypeScript(source)) {
            return null;
        }
        return TypeScriptUtil.getTypeMembers(source, "Function");
    }

    private static JSRecordType getTypeMembers(@NotNull PsiElement source, @NotNull String className) {
        if (source == null) {
            TypeScriptUtil.$$$reportNull$$$0(66);
        }
        if (className == null) {
            TypeScriptUtil.$$$reportNull$$$0(67);
        }
        ArrayList members = ContainerUtil.newArrayList();
        JSElement context = ES6PsiUtil.getNonStrictExportScope(source);
        if (context == null) {
            context = source;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(className, (PsiElement)context);
        for (PsiElement psiElement : elements) {
            JSElement container = ES6PsiUtil.getExportScope(psiElement);
            if (!(psiElement instanceof JSClass) || container == null || ES6PsiUtil.isExternalModule((PsiElement)container) || TypeScriptModuleAccessibilityChecker.INSTANCE.check((PsiElement)context, psiElement) != null) continue;
            JSRecordType current = TypeScriptTypeParser.buildTypeFromClass((JSClass)psiElement, false);
            members.addAll(current.getTypeMembers());
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)context, true), members);
    }

    @NotNull
    public static GlobalSearchScope createFilterByNodeModuleScope(@NotNull GlobalSearchScope scope, @NotNull PsiElement context) {
        VirtualFile contextFile;
        if (scope == null) {
            TypeScriptUtil.$$$reportNull$$$0(68);
        }
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(69);
        }
        final VirtualFile nodeModules = (contextFile = PsiUtilCore.getVirtualFile((PsiElement)context)) == null ? null : JSLibraryUtil.findUpClosestNodeModulesResolveRoot(contextFile);
        Object object = nodeModules == null ? scope : new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                VirtualFile currentLibrary = JSLibraryUtil.findAncestorLibraryDir(file2, "node_modules");
                return currentLibrary == null || currentLibrary.equals(nodeModules);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$3", "contains"));
            }
        };
        if (object == null) {
            TypeScriptUtil.$$$reportNull$$$0(70);
        }
        return object;
    }

    @Nullable
    public static JSRecordType getTypeAliasRecordTypeForSubstitutor(@NotNull TypeScriptTypeAlias alias, @Nullable JSTypeSubstitutor substitutor) {
        JSType typeToProcess;
        if (alias == null) {
            TypeScriptUtil.$$$reportNull$$$0(71);
        }
        typeToProcess = (typeToProcess = alias.getParsedTypeDeclaration()) != null && substitutor != null ? JSTypeUtils.applyGenericArguments(typeToProcess, (Map<String, JSType>)substitutor) : null;
        return typeToProcess == null ? null : typeToProcess.asRecordType();
    }

    public static boolean isDefinitionFile(@NotNull PsiFile file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(72);
        }
        return (virtualFile = file2.getVirtualFile()) != null && TypeScriptUtil.isDefinitionFile(virtualFile);
    }

    public static List<VirtualFile> getLibFiles(@NotNull Condition<String> includeCondition, boolean includeInvalid) {
        if (includeCondition == null) {
            TypeScriptUtil.$$$reportNull$$$0(73);
        }
        File externalDirectory = TypeScriptUtil.getTypeScriptExternalFolderFile();
        return TypeScriptUtil.getLibFiles(externalDirectory, includeCondition, includeInvalid);
    }

    @NotNull
    public static List<VirtualFile> getLibFiles(@NotNull File libFolder, @NotNull Condition<String> includeCondition, boolean includeInvalid) {
        if (libFolder == null) {
            TypeScriptUtil.$$$reportNull$$$0(74);
        }
        if (includeCondition == null) {
            TypeScriptUtil.$$$reportNull$$$0(75);
        }
        if (!libFolder.exists() || !libFolder.isDirectory()) {
            Logger.getInstance(TypeScriptUtil.class).error("Cannot find external directory, the installation is possibly broken.");
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptUtil.$$$reportNull$$$0(76);
            }
            return list;
        }
        File[] files = libFolder.listFiles();
        if (files == null) {
            Logger.getInstance(TypeScriptUtil.class).error("Cannot find files in the external directory, the installation is possibly broken.");
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptUtil.$$$reportNull$$$0(77);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)files.length);
        for (File file2 : files) {
            String name;
            if (file2.isDirectory() || !(name = file2.getName()).startsWith(LIB_PREFIX) || !TypeScriptUtil.isDefinitionFile(name) || !includeCondition.value((Object)name)) continue;
            ContainerUtil.addIfNotNull((Collection)result2, (Object)JSLibraryUtil.findFileByIO(file2, includeInvalid));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(78);
        }
        return arrayList;
    }

    @NotNull
    public static String getFileNameWithoutExtension(@NotNull String name) {
        String extension;
        if (name == null) {
            TypeScriptUtil.$$$reportNull$$$0(79);
        }
        if ((extension = JSFileReference.findExtension(name, TYPESCRIPT_EXTENSIONS)) != null) {
            String string = TypeScriptUtil.getNameWithoutExtension(name, extension);
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(80);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(81);
        }
        return string;
    }

    public static String getNameWithoutExtension(@NotNull String name, @NotNull String extension) {
        if (name == null) {
            TypeScriptUtil.$$$reportNull$$$0(82);
        }
        if (extension == null) {
            TypeScriptUtil.$$$reportNull$$$0(83);
        }
        return name.substring(0, name.length() - extension.length());
    }

    @Contract(value="null -> false")
    public static boolean typeCanHaveExplicitCallSignatures(@Nullable JSType type) {
        if (type instanceof JSTypeImpl) {
            JSResolvedTypeInfo resolvedInfo = ((JSTypeImpl)type).resolveType();
            return resolvedInfo != null && resolvedInfo.isInterface();
        }
        if (type instanceof JSSimpleRecordTypeImpl) {
            return type.getSource().getSourceElement() instanceof TypeScriptObjectType;
        }
        return false;
    }

    public static boolean isES6LibName(@NotNull String libraryName) {
        if (libraryName == null) {
            TypeScriptUtil.$$$reportNull$$$0(84);
        }
        if ((libraryName = StringUtil.toLowerCase((String)libraryName)).startsWith("esnext")) {
            return true;
        }
        if (!libraryName.startsWith("es")) {
            return false;
        }
        int indexOfEnd = libraryName.indexOf(".");
        if (indexOfEnd == -1) {
            indexOfEnd = libraryName.length();
        }
        try {
            String index = libraryName.substring(2, indexOfEnd);
            int parsedValue = Integer.parseInt(index);
            if (index.length() == 1 && parsedValue >= 6) {
                return true;
            }
            if (index.length() == 4 && parsedValue >= 2015) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptUtil.class).debug((Throwable)e);
        }
        return false;
    }

    @NotNull
    public static String getLibraryName(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(85);
        }
        int end = fileName.length() - TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.length();
        int start = LIB_PREFIX.length();
        String string = "lib.d.ts".equals(fileName) ? fileName : fileName.substring(start, end);
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(86);
        }
        return string;
    }

    @NotNull
    public static JSType getConstructedType(@NotNull JSType type, @Nullable JSExpression context) {
        ES6ReferenceListImpl.ClassExpressionResolve constructorSignatureType;
        if (type == null) {
            TypeScriptUtil.$$$reportNull$$$0(87);
        }
        if (!(constructorSignatureType = ES6ReferenceListImpl.getConstructorSignatureType(type, (PsiElement)context)).hasError() && constructorSignatureType.types != null && constructorSignatureType.types.size() > 0) {
            ArrayList types = ContainerUtil.newArrayListWithCapacity((int)constructorSignatureType.types.size());
            for (JSType cType : constructorSignatureType.types) {
                JSType retType;
                if (!(cType instanceof TypeScriptJSFunctionTypeImpl) || (retType = ((TypeScriptJSFunctionTypeImpl)cType).getReturnType()) == null) continue;
                types.add(retType);
            }
            if (types.size() == 1) {
                JSType jSType = (JSType)types.get(0);
                if (jSType == null) {
                    TypeScriptUtil.$$$reportNull$$$0(88);
                }
                return jSType;
            }
            if (types.size() > 0) {
                JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)context, true), types);
                if (jSCompositeTypeImpl == null) {
                    TypeScriptUtil.$$$reportNull$$$0(89);
                }
                return jSCompositeTypeImpl;
            }
        }
        JSNamespace jSNamespace = ((JSTypeImpl)type).copyWithJSContext(JSContext.INSTANCE);
        if (jSNamespace == null) {
            TypeScriptUtil.$$$reportNull$$$0(90);
        }
        return jSNamespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 70: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 70: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 70: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil";
                break;
            }
            case 6: 
            case 62: 
            case 64: 
            case 72: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencePath";
                break;
            }
            case 8: 
            case 19: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFile";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedModuleName";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 31: 
            case 45: 
            case 50: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultCollection";
                break;
            }
            case 33: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInParentClass";
                break;
            }
            case 42: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 44: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 47: 
            case 55: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startQName";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 65: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeCondition";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFolder";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorFunctions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalModule";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeWithFilterByNodeModules";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonStrictParents";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAliasesToClass";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedMembers";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "applyGenericsToType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterTypeListStringWithApplyingGenerics";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnimplementedMembers";
                break;
            }
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortestTypeNameInContext";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortestTypeNameInContextForQualifiedName";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseTypeOfEnumLiteralType";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptExternalFolderFile";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptCompilerFolderFile";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilterByNodeModuleScope";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibFiles";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameWithoutExtension";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorFunctions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 70: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileByReferencePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcFileByReferencePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findForContentRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileByRelativePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findPatternBasedExternalModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAllRegularExternalModules";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createScopeWithFilterByNodeModules";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllPatternExternalModules";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllAugmentationModules";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParents";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveAliasesToClass";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameToClassesOverAliases";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveAliasToClass";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNamedMembers";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "applyGenericsToType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getUnimplementedMembers";
                break;
            }
            case 44: 
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getShortestTypeNameInContext";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getShortestTypeNameInContextForQualifiedName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getBaseTypeOfEnumLiteralType";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsStrict";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isUnderNodeModules";
                break;
            }
            case 64: 
            case 65: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isDefinitionFile";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMembers";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createFilterByNodeModuleScope";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAliasRecordTypeForSubstitutor";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getLibFiles";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getFileNameWithoutExtension";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isES6LibName";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getConstructedType";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getUnimplementedMembers$5";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getUnimplementedMembers$4";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFileByReferencePath$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 70: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface JSClassHierarchyProcessor {
        public boolean process(@NotNull JSClass<?> var1, @NotNull JSTypeSubstitutor var2, boolean var3);
    }
}

