/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.MarkerPsiElementPointer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportUtils {
    @NonNls
    private static final String CDATA = "<![CDATA[";
    @NonNls
    private static final String CDATA_END = "]]>";
    private static final Logger LOG = Logger.getInstance((String)ImportUtils.class.getName());
    private static final Function<PsiElement, Boolean> ourFilter = psiElement -> psiElement instanceof PsiComment || psiElement instanceof JSImportStatement;

    @Nullable
    public static PsiElement findLBrace(JSElement holder) {
        for (PsiElement child = holder.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() != JSTokenTypes.LBRACE) continue;
            return child;
        }
        return null;
    }

    private static PsiElement specifyInsertionPlace(PsiElement insertBefore, String fqn) {
        JSImportStatement earlyImport = ImportUtils.findEarlyImport(insertBefore);
        if (earlyImport == null) {
            return insertBefore;
        }
        JSImportStatement result2 = earlyImport;
        while (ImportUtils.compareImports(fqn, earlyImport.getImportText()) > 0) {
            PsiElement nextSibling = earlyImport.getNextSibling();
            if (nextSibling instanceof JSImportStatement) {
                result2 = earlyImport = (JSImportStatement)nextSibling;
                continue;
            }
            if (nextSibling instanceof PsiWhiteSpace && nextSibling.getNextSibling() instanceof JSImportStatement) {
                earlyImport = (JSImportStatement)nextSibling.getNextSibling();
                result2 = nextSibling;
                continue;
            }
            return nextSibling;
        }
        return result2;
    }

    public static void doImport(@NotNull PsiElement subject, @NotNull String fqn, boolean qualifyReferenceIfNeeded) {
        if (subject == null) {
            ImportUtils.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            ImportUtils.$$$reportNull$$$0(1);
        }
        assert (fqn.contains(".")) : "Qualified name belongs to default package: " + fqn;
        PsiElement context = subject.getContainingFile().getContext();
        if (context != null && context.getContainingFile() instanceof XmlFile) {
            MarkerPsiElementPointer p = new MarkerPsiElementPointer(PsiUtilCore.getOriginalElement((PsiElement)subject, subject.getClass()));
            XmlBackedJSClassImpl.syncInjectedFiles((XmlFile)context.getContainingFile());
            if (!subject.isValid()) {
                subject = p.getElement();
            }
        }
        Project project = subject.getProject();
        try {
            FormatFixer fixer;
            ResolveResult[] referencedName;
            Pair<? extends PsiElement, String> qualifiedElement = JSResolveUtil.getElementThatShouldBeQualified(subject, fqn);
            if (qualifiedElement != null) {
                if (!FileModificationService.getInstance().prepareFileForWrite(subject.getContainingFile())) {
                    return;
                }
                ((PsiElement)qualifiedElement.first).replace(JSChangeUtil.createExpressionFromText(project, (String)qualifiedElement.second).getPsi());
                return;
            }
            JSReferenceExpression reference = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)subject, (Class[])new Class[]{JSReferenceExpression.class});
            if (qualifyReferenceIfNeeded && reference != null && reference.getQualifier() == null && (referencedName = reference.getReferencedName()) != null && JSResolveUtil.shortReferenceIsAmbiguousOrUnequal((String)referencedName, (PsiElement)reference, fqn, null)) {
                subject = reference.replace(JSChangeUtil.createExpressionFromText(project, fqn).getPsi());
                reference = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)subject, (Class[])new Class[]{JSReferenceExpression.class});
            }
            if (reference != null) {
                if (fqn.equals(JSImportHandlingUtil.resolveTypeName(reference.getReferencedName(), (PsiElement)reference))) {
                    return;
                }
                for (ResolveResult resolveResult : reference.multiResolve(false)) {
                    if (!(resolveResult instanceof JSResolveResult) || !(resolveResult.getElement() instanceof JSQualifiedNamedElement) || !fqn.equals(((JSQualifiedNamedElement)resolveResult.getElement()).getQualifiedName()) || ((JSResolveResult)resolveResult).getActionScriptImport() == null) continue;
                    return;
                }
            }
            if ((fixer = ImportUtils.insertImportStatements(subject, Collections.singletonList(fqn))) != null) {
                fixer.fixFormat();
            }
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    @Nullable
    public static FormatFixer insertImportStatements(PsiElement place, Collection<String> fqns) {
        String suffix;
        String prefix;
        int offset;
        if (fqns.isEmpty()) {
            return null;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(place.getContainingFile())) {
            return null;
        }
        JSElement holderComputed = ImportUtils.computeImportHolder(place);
        if (holderComputed == null) {
            return null;
        }
        PsiFile file2 = holderComputed.getContainingFile();
        Project project = file2.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(place);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        place = pointer.getElement();
        if (place == null || !place.isValid()) {
            return null;
        }
        holderComputed = ImportUtils.computeImportHolder(place);
        if (holderComputed == null) {
            return null;
        }
        String textToInsert = ImportUtils.createImportBlock(file2, fqns);
        Pair insertionPlace = ImportUtils.getImportInsertionPlace(holderComputed);
        if (insertionPlace == null) {
            offset = 0;
            prefix = "\n";
            suffix = "";
        } else {
            if (!((Boolean)insertionPlace.second).booleanValue() && ((PsiElement)insertionPlace.first).getNextSibling() != null) {
                insertionPlace = Pair.create((Object)((PsiElement)insertionPlace.first).getNextSibling(), (Object)true);
            }
            if (((Boolean)insertionPlace.second).booleanValue()) {
                PsiElement insertBefore;
                PsiElement psiElement = insertBefore = fqns.size() == 1 ? ImportUtils.specifyInsertionPlace((PsiElement)insertionPlace.first, fqns.iterator().next()) : (PsiElement)insertionPlace.first;
                if (insertBefore != null) {
                    offset = insertBefore.getTextRange().getStartOffset();
                    prefix = insertBefore.getPrevSibling() == null && file2.getContext() == null || insertBefore.getPrevSibling() instanceof PsiWhiteSpace ? "" : "\n";
                    suffix = insertBefore instanceof PsiWhiteSpace ? "" : " ";
                } else {
                    offset = file2.getTextLength();
                    prefix = "\n";
                    suffix = "";
                }
            } else if (((PsiElement)insertionPlace.first).getNextSibling() == null && ImportUtils.hasCDATA((PsiElement)insertionPlace.first) && ImportUtils.hasCDATAEnd((PsiElement)insertionPlace.first)) {
                offset = ((PsiElement)insertionPlace.first).getTextRange().getStartOffset() + ((PsiElement)insertionPlace.first).getText().indexOf(CDATA_END);
                prefix = "\n";
                suffix = "";
            } else {
                offset = ((PsiElement)insertionPlace.first).getTextRange().getEndOffset();
                prefix = "";
                suffix = "";
            }
        }
        textToInsert = prefix + textToInsert + suffix;
        document.insertString(offset, (CharSequence)textToInsert);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        return FormatFixer.create(file2, TextRange.from((int)offset, (int)textToInsert.length()), FormatFixer.Mode.Reformat);
    }

    private static JSElement computeImportHolder(PsiElement place) {
        Computable<JSElement> importHolder = ImportUtils.getImportHolder(place, false, JSPackageStatement.class, JSFile.class);
        if (importHolder == null) {
            return null;
        }
        JSElement holderComputed = (JSElement)importHolder.compute();
        return holderComputed;
    }

    private static JSElement getAnonymousEventHandlerBody(JSFile injectedFile) {
        JSFunctionExpression functionExpression;
        JSParenthesizedExpression parenthesizedExpression;
        JSCallExpression callExpression;
        JSExpressionStatement expressionStatement;
        if (injectedFile.getFirstChild() instanceof JSExpressionStatement && (expressionStatement = (JSExpressionStatement)injectedFile.getFirstChild()).getExpression() instanceof JSCallExpression && (callExpression = (JSCallExpression)expressionStatement.getExpression()).getMethodExpression() instanceof JSParenthesizedExpression && (parenthesizedExpression = (JSParenthesizedExpression)callExpression.getMethodExpression()).getInnerExpression() instanceof JSFunctionExpression && (functionExpression = (JSFunctionExpression)parenthesizedExpression.getInnerExpression()).getBody().length > 0) {
            return functionExpression.getBody()[0];
        }
        assert (false) : "Couldn't find anonymous event handler body: " + injectedFile;
        return null;
    }

    private static int compareImports(String qname1, String qname2) {
        return Comparing.compare((Comparable)((Object)qname1), (Comparable)((Object)qname2));
    }

    @Nullable
    public static Pair<PsiElement, Boolean> getImportInsertionPlace(JSElement holder) {
        boolean before;
        PsiElement insertionPlace;
        if (holder.getFirstChild() == null) {
            return null;
        }
        if (holder instanceof JSPackageStatement) {
            insertionPlace = ImportUtils.findLBrace(holder);
            assert (insertionPlace != null) : "LBrace not found";
            before = false;
        } else if (holder instanceof JSFunction) {
            JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)holder, JSBlockStatement.class);
            assert (block != null) : "Function block not found";
            insertionPlace = ImportUtils.findLBrace((JSElement)block);
            before = false;
        } else if (holder instanceof JSBlockStatement) {
            insertionPlace = ImportUtils.findLBrace(holder);
            before = false;
        } else if (ActionScriptResolveUtil.isAnonymousEventHandlerTag((JSFile)holder)) {
            insertionPlace = ImportUtils.findLBrace(holder = ImportUtils.getAnonymousEventHandlerBody((JSFile)holder));
            if (ImportUtils.hasCDATA(insertionPlace.getNextSibling())) {
                insertionPlace = insertionPlace.getNextSibling();
            }
            before = false;
        } else {
            JSPackageStatement aPackage = (JSPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)holder, JSPackageStatement.class);
            if (aPackage != null) {
                insertionPlace = aPackage;
                before = false;
            } else {
                insertionPlace = holder.getFirstChild();
                before = !ImportUtils.hasCDATA(insertionPlace);
            }
        }
        return Pair.create((Object)insertionPlace, (Object)before);
    }

    private static boolean hasCDATA(@Nullable PsiElement element) {
        return element instanceof PsiWhiteSpace && element.getText().contains(CDATA);
    }

    private static boolean hasCDATAEnd(@Nullable PsiElement element) {
        return element instanceof PsiWhiteSpace && element.getText().contains(CDATA_END);
    }

    @SafeVarargs
    @Nullable
    public static Computable<JSElement> getImportHolder(@NotNull PsiElement origin, boolean allowConditionalCompilationBlock, Class<? extends JSElement> ... classes) {
        if (origin == null) {
            ImportUtils.$$$reportNull$$$0(2);
        }
        if (classes == null) {
            ImportUtils.$$$reportNull$$$0(3);
        }
        if (origin instanceof XmlBackedJSClassImpl) {
            return new XmlBackedClassImportHolder((XmlBackedJSClassImpl)origin);
        }
        JSElement importHolder = ImportUtils.getNonStrictParentOfTypeOrConditionalCompilationBlock(origin, allowConditionalCompilationBlock, classes);
        if (importHolder instanceof JSFunctionExpression && (ActionScriptResolveUtil.isAnonymousEventHandlerTag((JSFile)importHolder.getContainingFile()) || ActionScriptResolveUtil.isAnonymousEventHandlerAttribute((JSFile)importHolder.getContainingFile()))) {
            JSElement jSElement = importHolder = ArrayUtil.contains(JSFile.class, (Object[])classes) ? (JSElement)importHolder.getContainingFile() : null;
        }
        if (importHolder instanceof JSFile && ActionScriptResolveUtil.isAnonymousEventHandlerAttribute((JSFile)importHolder)) {
            XmlBackedJSClass jsClass = JSResolveUtil.getXmlBackedClass((JSFile)importHolder);
            assert (jsClass != null);
            return new XmlBackedClassImportHolder((XmlBackedJSClassImpl)jsClass);
        }
        return importHolder != null ? new Wrapper(importHolder) : null;
    }

    @SafeVarargs
    @Nullable
    private static <T extends PsiElement> T getNonStrictParentOfTypeOrConditionalCompilationBlock(@NotNull PsiElement element, boolean allowBlock, Class<? extends T> ... classes) {
        if (element == null) {
            ImportUtils.$$$reportNull$$$0(4);
        }
        if (classes == null) {
            ImportUtils.$$$reportNull$$$0(5);
        }
        for (PsiElement run2 = element; run2 != null; run2 = run2.getParent()) {
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(run2)) continue;
                return (T)run2;
            }
            if (allowBlock && ImportUtils.isConditionalCompilationBlock(run2)) {
                return (T)run2;
            }
            if (run2 instanceof PsiFile) break;
        }
        return null;
    }

    private static boolean isConditionalCompilationBlock(PsiElement element) {
        if (!(element instanceof JSBlockStatement)) {
            return false;
        }
        JSAttributeList attributeList = (JSAttributeList)PsiTreeUtil.getChildOfType((PsiElement)element, JSAttributeList.class);
        return attributeList != null && attributeList.getConditionalCompileVariableReference() != null;
    }

    public static String createImportBlock(PsiFile file2, Collection<String> fqns) {
        ArrayList<String> sorted = new ArrayList<String>(fqns);
        Collections.sort(sorted, ImportUtils::compareImports);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)file2);
        if (semicolon.isEmpty()) {
            semicolon = " ";
        }
        StringBuilder s = new StringBuilder();
        for (String fqn : sorted) {
            LOG.assertTrue(fqn.contains("."));
            s.append("import ").append(fqn).append(semicolon);
        }
        return s.toString();
    }

    @Nullable
    public static JSImportStatement findEarlyImport(@Nullable PsiElement startFrom) {
        for (PsiElement element = startFrom; element != null; element = element.getNextSibling()) {
            if (element instanceof JSImportStatement) {
                return (JSImportStatement)element;
            }
            if (element instanceof JSClass || element instanceof JSStatement || element instanceof JSFunction) break;
        }
        return null;
    }

    public static Pair<String, PsiElement> importAndShortenReference(String resolvedTypeName, PsiElement context, boolean allowImport, boolean allowShorten) {
        ResolveResult[] results;
        if (context != null && !DialectDetector.isActionScript(context)) {
            return Pair.create((Object)resolvedTypeName, (Object)context);
        }
        if (resolvedTypeName == null || resolvedTypeName.indexOf(46) == -1) {
            if (resolvedTypeName != null) {
                ImportUtils.ensureUseNamespacePresentIfNeeded(null, resolvedTypeName, resolvedTypeName, context);
            }
            return Pair.create((Object)resolvedTypeName, (Object)context);
        }
        assert (context.isValid());
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(resolvedTypeName);
        if (signature != null) {
            resolvedTypeName = signature.elementType;
            Pair<String, PsiElement> genericType = ImportUtils.importAndShortenReference(signature.genericType, context, allowImport, allowShorten);
            context = (PsiElement)genericType.second;
            signature = new JSResolveUtil.GenericSignature(signature.elementType, (String)genericType.first);
        }
        String shortTypeName = JSResolveUtil.getShortTypeName(resolvedTypeName, false);
        MarkerPsiElementPointer p = new MarkerPsiElementPointer(PsiUtilCore.getOriginalElement((PsiElement)context, context.getClass()));
        if (context.getContainingFile().getContext() != null) {
            XmlBackedJSClassImpl.syncInjectedFiles((XmlFile)context.getContainingFile().getContext().getContainingFile());
            if (context.isValid()) {
                p = new MarkerPsiElementPointer(PsiUtilCore.getOriginalElement((PsiElement)context, context.getClass()));
            } else {
                context = p.getElement();
            }
        }
        if ((results = JSReferenceExpressionImpl.resolveUnqualified(shortTypeName, context, Boolean.TRUE)).length == 0) {
            if (allowImport && resolvedTypeName.indexOf(46) != -1) {
                ImportUtils.doImport(context, resolvedTypeName, false);
                context = p.getElement();
            }
            ImportUtils.ensureUseNamespacePresentIfNeeded(null, shortTypeName, resolvedTypeName, context);
            return Pair.create((Object)JSResolveUtil.GenericSignature.build(allowShorten ? shortTypeName : resolvedTypeName, signature), (Object)context);
        }
        if (results.length == 1 && results[0].getElement() instanceof JSQualifiedNamedElement && resolvedTypeName.equals(((JSQualifiedNamedElement)results[0].getElement()).getQualifiedName())) {
            ImportUtils.ensureUseNamespacePresentIfNeeded(results[0], shortTypeName, resolvedTypeName, context);
            return Pair.create((Object)JSResolveUtil.GenericSignature.build(allowShorten ? shortTypeName : resolvedTypeName, signature), (Object)context);
        }
        if (allowImport) {
            boolean needImport = resolvedTypeName.indexOf(46) != -1;
            for (ResolveResult result2 : results) {
                if (!(result2.getElement() instanceof JSQualifiedNamedElement) || !resolvedTypeName.equals(((JSQualifiedNamedElement)result2.getElement()).getQualifiedName())) continue;
                needImport = false;
                break;
            }
            if (needImport) {
                ImportUtils.doImport(context, resolvedTypeName, false);
                context = p.getElement();
            }
        }
        ImportUtils.ensureUseNamespacePresentIfNeeded(null, shortTypeName, resolvedTypeName, context);
        return Pair.create((Object)JSResolveUtil.GenericSignature.build(resolvedTypeName, signature), (Object)context);
    }

    public static void insertUseNamespaceIfNeeded(String qName, PsiElement context) {
        ImportUtils.ensureUseNamespacePresentIfNeeded(null, JSResolveUtil.getShortTypeName(qName, true), qName, context);
    }

    private static void ensureUseNamespacePresentIfNeeded(ResolveResult r, final String shortTypeName, String qName, PsiElement context) {
        ResolveResult[] resolveResults;
        Object elt = r == null ? (shortTypeName.equals(qName) ? ((resolveResults = JSReferenceExpressionImpl.resolveUnqualified(shortTypeName, context, Boolean.TRUE)).length == 1 ? resolveResults[0].getElement() : null) : JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(qName, context)) : r.getElement();
        if (elt instanceof JSNamespaceDeclaration || ImportUtils.isNativeConst(elt)) {
            Computable<JSElement> importHolder = ImportUtils.getImportHolder(context, false, JSPackageStatement.class, JSFile.class);
            final Ref hasUseNamespace = new Ref();
            if (importHolder != null) {
                Pair<PsiElement, Boolean> insertionPlaceInfo;
                ((JSElement)importHolder.compute()).accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                    public void visitJSUseNamespaceDirective(JSUseNamespaceDirective useNamespaceDirective) {
                        super.visitJSUseNamespaceDirective(useNamespaceDirective);
                        JSReferenceExpression namespaceReference = useNamespaceDirective.getNamespaceReference();
                        if (namespaceReference != null && namespaceReference.getText().equals(shortTypeName)) {
                            hasUseNamespace.set((Object)Boolean.TRUE);
                        }
                    }
                });
                if (hasUseNamespace.get() == null && (insertionPlaceInfo = ImportUtils.getImportInsertionPlace((JSElement)importHolder.compute())) != null) {
                    PsiElement insertionPlace = JSFormatUtil.findInsertionPlaceStartingFrom((PsiElement)insertionPlaceInfo.first, true, ourFilter);
                    Project project = context.getProject();
                    String s = "use namespace " + shortTypeName + JSCodeStyleSettings.getSemicolon((PsiElement)context.getContainingFile());
                    ASTNode statementFromText = JSChangeUtil.createStatementFromText(project, s, JavaScriptSupportLoader.ECMA_SCRIPT_L4);
                    PsiElement psiElement = insertionPlace.getParent().addBefore(statementFromText.getPsi(), insertionPlace);
                    CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(psiElement.getParent().getNode(), psiElement.getNode());
                }
            }
        }
    }

    private static boolean isNativeConst(@Nullable PsiElement elt) {
        if (!(elt instanceof JSVariable) || elt instanceof JSParameter || !((JSVariable)elt).isConst()) {
            return false;
        }
        if (!elt.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            return false;
        }
        PsiElement parent = elt.getParent();
        return parent instanceof JSVarStatement && PsiTreeUtil.getDeepestFirst((PsiElement)parent).getNode().getElementType() == JSTokenTypes.NATIVE_KEYWORD;
    }

    public static void importTypeIfNeeded(@NotNull PsiElement contextElement, String typeName, boolean optimizeImports) {
        if (contextElement == null) {
            ImportUtils.$$$reportNull$$$0(6);
        }
        if (!DialectDetector.isActionScript(contextElement)) {
            return;
        }
        String currentPackage = JSResolveUtil.getPackageNameFromPlace(contextElement);
        if (typeName != null && typeName.contains(".") && JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)typeName), currentPackage)) {
            ImportUtils.doImport(contextElement, typeName, true);
            if (optimizeImports) {
                new ECMAScriptImportOptimizer().processFile(contextElement.getContainingFile()).run();
            }
        }
    }

    public static boolean needsImport(@NotNull JSQualifiedNamedElement contextElement, @Nullable String referencedPackageName) {
        String qName;
        if (contextElement == null) {
            ImportUtils.$$$reportNull$$$0(7);
        }
        if ((qName = contextElement.getQualifiedName()) == null) {
            return false;
        }
        String contextPackageName = StringUtil.getPackageName((String)qName);
        return StringUtil.isNotEmpty((String)referencedPackageName) && JSPsiImplUtils.differentPackageName(contextPackageName, referencedPackageName);
    }

    public static boolean needsImport(@Nullable String contextPackage, @NotNull JSQualifiedNamedElement referencedElement) {
        String qName;
        if (referencedElement == null) {
            ImportUtils.$$$reportNull$$$0(8);
        }
        if ((qName = referencedElement.getQualifiedName()) == null) {
            return false;
        }
        String referencedPackageName = StringUtil.getPackageName((String)qName);
        return !referencedPackageName.isEmpty() && JSPsiImplUtils.differentPackageName(contextPackage, referencedPackageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/ImportUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doImport";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportHolder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNonStrictParentOfTypeOrConditionalCompilationBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "importTypeIfNeeded";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "needsImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class XmlBackedClassImportHolder
    implements Computable<JSElement> {
        @NotNull
        private final XmlBackedJSClassImpl myClass;

        XmlBackedClassImportHolder(@NotNull XmlBackedJSClassImpl aClass) {
            if (aClass == null) {
                XmlBackedClassImportHolder.$$$reportNull$$$0(0);
            }
            this.myClass = aClass;
        }

        public JSElement compute() {
            try {
                return this.myClass.createOrGetFirstScriptTag();
            }
            catch (IncorrectOperationException ex) {
                LOG.error((Throwable)ex);
                return null;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XmlBackedClassImportHolder that = (XmlBackedClassImportHolder)o;
            return ((Object)((Object)this.myClass)).equals((Object)that.myClass);
        }

        public int hashCode() {
            return ((Object)((Object)this.myClass)).hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/flex/ImportUtils$XmlBackedClassImportHolder", "<init>"));
        }
    }

    private static class Wrapper
    implements Computable<JSElement> {
        @NotNull
        private final JSElement myElement;

        public Wrapper(@NotNull JSElement element) {
            if (element == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        public JSElement compute() {
            return this.myElement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Wrapper that = (Wrapper)o;
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        public String toString() {
            return "Wrapper [" + this.myElement + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/ImportUtils$Wrapper", "<init>"));
        }
    }
}

