/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigImpl;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigServiceImpl
implements FlowJSConfigService {
    public static final Logger LOGGER = Logger.getInstance(FlowJSServerService.class);
    @NotNull
    private final Project myProject;
    private static final Function<PsiFile, FlowJSConfig> MAP_TO_CONFIG = FlowJSConfigImpl::getConfig;
    @NotNull
    private final CachedValue<Collection<FlowJSConfig>> myConfigs;
    private final CachedValue<ConcurrentMap<VirtualFile, Collection<FlowJSConfig>>> myConfigsOfFile;

    public FlowJSConfigServiceImpl(@NotNull Project project) {
        if (project == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        CachedValueProvider configsProvider = () -> (CachedValueProvider.Result)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CachedValueProvider.Result<Collection<FlowJSConfig>>>(){

            public CachedValueProvider.Result<Collection<FlowJSConfig>> compute() {
                Object[] files = FilenameIndex.getFilesByName((Project)FlowJSConfigServiceImpl.this.myProject, (String)".flowconfig", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)FlowJSConfigServiceImpl.this.myProject));
                FileIndexFacade fileIndexFacade = FileIndexFacade.getInstance((Project)FlowJSConfigServiceImpl.this.myProject);
                HashSet configFiles = ContainerUtil.newHashSet();
                if (fileIndexFacade != null) {
                    for (Object file2 : files) {
                        if (!fileIndexFacade.isInContent(file2.getVirtualFile())) continue;
                        configFiles.add(file2);
                    }
                }
                files = configFiles.toArray(PsiFile.EMPTY_ARRAY);
                List configs = ContainerUtil.mapNotNull((Object[])files, (Function)MAP_TO_CONFIG);
                ArrayList depends = ContainerUtil.newArrayList((Object[])files);
                depends.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
                return CachedValueProvider.Result.create((Object)configs, (Collection)depends);
            }
        });
        this.myConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(configsProvider, false);
        this.myConfigsOfFile = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    @Override
    @NotNull
    public Collection<FlowJSConfig> getConfigOfFile(@NotNull VirtualFile file2) {
        ConcurrentMap fileConfigsIncludeCache;
        if (file2 == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(1);
        }
        if ((fileConfigsIncludeCache = (ConcurrentMap)this.myConfigsOfFile.getValue()).containsKey(file2)) {
            Collection collection = (Collection)fileConfigsIncludeCache.get(file2);
            if (collection == null) {
                FlowJSConfigServiceImpl.$$$reportNull$$$0(2);
            }
            return collection;
        }
        Collection<FlowJSConfig> configOfFile = this.getConfigOfFileImpl(file2);
        fileConfigsIncludeCache.put(file2, configOfFile);
        Collection<FlowJSConfig> collection = configOfFile;
        if (collection == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    private Collection<FlowJSConfig> getConfigOfFileImpl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(4);
        }
        Collection<FlowJSConfig> allConfigs = this.getConfigFiles();
        ArrayList configOfFile = ContainerUtil.newArrayList();
        allConfigs.forEach(config2 -> {
            if (file2 == null) {
                FlowJSConfigServiceImpl.$$$reportNull$$$0(11);
            }
            if (config2.isFileIncluded(file2) && !config2.isFileIgnored(file2)) {
                configOfFile.add(config2);
            }
        });
        ArrayList arrayList = configOfFile;
        if (arrayList == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public Collection<FlowJSConfig> getConfigFiles() {
        Collection value = (Collection)this.myConfigs.getValue();
        Collection collection = value == null ? ContainerUtil.emptyList() : value;
        if (collection == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    @Nullable
    public FlowJSConfig getNearestConfig(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(7);
        }
        Collection<FlowJSConfig> configCollection = this.getConfigOfFile(file2);
        return FlowJSConfigServiceImpl.getNearestConfig(configCollection, file2);
    }

    @Nullable
    private static FlowJSConfig getNearestConfig(@NotNull Collection<FlowJSConfig> configCollection, @NotNull VirtualFile file2) {
        if (configCollection == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            FlowJSConfigServiceImpl.$$$reportNull$$$0(9);
        }
        Optional<FlowJSConfig> nearestConfig = configCollection.stream().min(Comparator.comparingInt(config2 -> {
            String relativePath;
            if (file2 == null) {
                FlowJSConfigServiceImpl.$$$reportNull$$$0(10);
            }
            if ((relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)config2.getConfigDirectory())) == null) {
                return Integer.MAX_VALUE;
            }
            return StringUtil.countChars((CharSequence)relativePath, (char)'/');
        }));
        return nearestConfig.orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigOfFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigOfFileImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConfigOfFile";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigOfFileImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNearestConfig";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNearestConfig$3";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigOfFileImpl$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

