/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptStatementParser;
import com.intellij.lang.javascript.flow.psi.FlowJSParser;
import com.intellij.lang.javascript.flow.psi.FlowJSPsiTypeParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.psi.tree.IElementType;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class FlowJSStatementParser
extends ES6StatementParser<FlowJSParser> {
    private static final JSModifiersStructure DECLARE_CLASS_MEMBER_MODIFIERS = new JSOrderedModifiersStructure(new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.PLUS, JSTokenTypes.MINUS), new JSOneOfModifiersStructure(JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.SHARP));
    private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START = builder -> {
        IElementType type = builder.getTokenType();
        return type == JSTokenTypes.LBRACKET || JSKeywordSets.PROPERTY_NAMES.contains(type);
    };
    private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE = new JSOrderedModifiersStructure(new JSOneOfModifiersStructure(JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PUBLIC_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.PLUS, JSTokenTypes.MINUS), new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.MULT), new JSModifiersStructureLeaf(JSTokenTypes.SHARP));

    public FlowJSStatementParser(FlowJSParser parser) {
        super(parser);
    }

    @Override
    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            FlowJSStatementParser.$$$reportNull$$$0(0);
        }
        TypeScriptStatementParser.parseInterface(clazz, this, (ES6Parser)this.myJavaScriptParser, this.builder);
    }

    @Override
    protected void doParseStatement(boolean canHaveClasses) {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.TYPE_KEYWORD && this.isIdentifierToken(this.builder.lookAhead(1)) || firstToken == JSTokenTypes.OPAQUE_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.TYPE_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseTypeAlias(marker, firstToken);
            return;
        }
        super.doParseStatement(canHaveClasses);
    }

    @Override
    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.TYPE_KEYWORD || firstToken == JSTokenTypes.OPAQUE_KEYWORD) {
            this.parseTypeAlias(marker, firstToken);
            return true;
        }
        return false;
    }

    private void parseTypeAlias(@NotNull PsiBuilder.Marker marker, @NotNull IElementType firstToken) {
        if (marker == null) {
            FlowJSStatementParser.$$$reportNull$$$0(1);
        }
        if (firstToken == null) {
            FlowJSStatementParser.$$$reportNull$$$0(2);
        }
        if (firstToken == JSTokenTypes.OPAQUE_KEYWORD) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.TYPE_KEYWORD) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type", (Object[])new Object[0]));
                marker.done(JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS);
                return;
            }
        }
        this.builder.putUserData(FlowJSPsiTypeParser.OPAQUE_TYPE_KEY, (Object)(firstToken == JSTokenTypes.OPAQUE_KEYWORD ? 1 : 0));
        TypeScriptStatementParser.parseTypeAlias(marker, this.builder, (ES6Parser)this.myJavaScriptParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDeclareModule() {
        PsiBuilder.Marker module = this.builder.mark();
        PsiBuilder.Marker attrList = this.builder.mark();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD);
        this.builder.advanceLexer();
        attrList.done(((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).getAttributeListElementType());
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.MODULE_KEYWORD);
        this.builder.advanceLexer();
        if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            ((FlowJSParser)this.myJavaScriptParser).buildTokenElement((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
        } else if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        } else {
            if (this.builder.getTokenType() == JSTokenTypes.DOT && this.builder.lookAhead(1) == JSTokenTypes.IDENTIFIER) {
                this.builder.advanceLexer();
                if (!"exports".equals(this.builder.getTokenText())) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.exports", (Object[])new Object[0]));
                }
                this.builder.advanceLexer();
                FlowJSStatementParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
                ((FlowJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseType();
                module.done(JSStubElementTypes.TYPESCRIPT_MODULE);
                module.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                return;
            }
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            module.drop();
            return;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
            module.drop();
            return;
        }
        this.builder.advanceLexer();
        String methodsMustBeEmpty = (String)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
        Boolean forcedType = (Boolean)this.builder.getUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY);
        try {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)"a");
            this.builder.putUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY, (Object)Boolean.TRUE);
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
                    module.drop();
                    return;
                }
                if (this.builder.getTokenType() != JSTokenTypes.DECLARE_KEYWORD && this.builder.getTokenType() != JSTokenTypes.IMPORT_KEYWORD) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.declare", (Object[])new Object[0]));
                }
                this.parseSourceElement();
            }
            this.builder.advanceLexer();
        }
        finally {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodsMustBeEmpty);
            this.builder.putUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY, (Object)forcedType);
        }
        module.done(JSStubElementTypes.TYPESCRIPT_MODULE);
        module.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseSourceElement() {
        if (this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD) {
            String functionType = (String)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
            try {
                this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)"a");
                if (this.builder.lookAhead(1) == JSTokenTypes.MODULE_KEYWORD) {
                    this.parseDeclareModule();
                    this.checkForSemicolon();
                    return;
                }
                if (this.builder.lookAhead(1) == JSTokenTypes.EXPORT_KEYWORD && !EXPORTABLE_ELEMENTS_KEYWORDS.contains(this.builder.lookAhead(2)) && this.builder.lookAhead(2) != JSTokenTypes.INTERFACE_KEYWORD) {
                    PsiBuilder.Marker attrList = this.builder.mark();
                    this.builder.advanceLexer();
                    attrList.done(((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).getAttributeListElementType());
                    PsiBuilder.Marker marker = attrList.precede();
                    if (this.builder.lookAhead(1) == JSTokenTypes.DEFAULT_KEYWORD && this.builder.lookAhead(2) != JSTokenTypes.FUNCTION_KEYWORD && this.builder.lookAhead(2) != JSTokenTypes.CLASS_KEYWORD) {
                        this.builder.advanceLexer();
                        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DEFAULT_KEYWORD);
                        this.builder.advanceLexer();
                        ((FlowJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseType();
                        this.forceCheckForSemicolon();
                        marker.done((IElementType)ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
                        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                    } else {
                        this.tryParseES6ExportStatement(marker);
                    }
                    return;
                }
            }
            finally {
                this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)functionType);
            }
        }
        super.parseSourceElement();
    }

    @Override
    protected void parseClassMember() {
        if (this.builder.getUserData(FunctionParser.methodsEmptinessKey) == "a") {
            PsiBuilder.Marker classMember = this.builder.mark();
            boolean lexerAdvanced = ((FlowJSParser)this.myJavaScriptParser).parseModifiers(DECLARE_CLASS_MEMBER_MODIFIERS, true, IS_MEMBER_NAME_START);
            IElementType memberStart = this.builder.getTokenType();
            if (memberStart == JSTokenTypes.LBRACKET) {
                TypeScriptPsiTypeParser.parseIndexSignatureNoMarker(classMember, this.builder, (ES6Parser)this.myJavaScriptParser, false, false);
                this.forceCheckForSemicolon();
                return;
            }
            if (JSKeywordSets.PROPERTY_NAMES.contains(memberStart)) {
                this.builder.advanceLexer();
                lexerAdvanced = true;
                ((FlowJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseInterfaceSimplePropertyOrFunction(classMember);
            } else if (memberStart == JSTokenTypes.LPAR || memberStart == JSTokenTypes.LT) {
                lexerAdvanced = ((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).parseParameterList(false);
                lexerAdvanced |= ((FlowJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).tryParseType();
                classMember.done(JSStubElementTypes.CALL_SIGNATURE);
            } else {
                classMember.drop();
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.declaration", (Object[])new Object[0]));
            }
            if (!lexerAdvanced) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                this.forceCheckForSemicolon();
            }
            return;
        }
        super.parseClassMember();
    }

    @Override
    protected boolean parseClassMemberModifiers() {
        return ((FlowJSParser)this.myJavaScriptParser).parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE, false, IS_MEMBER_NAME_START);
    }

    @Override
    protected boolean parseES6ImportClause() {
        IElementType secondToken;
        IElementType firstToken = this.builder.getTokenType();
        if ((firstToken == JSTokenTypes.TYPE_KEYWORD || firstToken == JSTokenTypes.TYPEOF_KEYWORD) && ((secondToken = this.builder.lookAhead(1)) == JSTokenTypes.FROM_KEYWORD ? this.builder.lookAhead(2) != JSTokenTypes.STRING_LITERAL : secondToken == JSTokenTypes.MULT || secondToken == JSTokenTypes.LBRACE || this.isIdentifierToken(secondToken))) {
            this.builder.advanceLexer();
        }
        return super.parseES6ImportClause();
    }

    @Override
    protected boolean tryParseES6ExportStatement() {
        IElementType secondToken;
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.TYPE_KEYWORD && ((secondToken = this.builder.lookAhead(2)) == JSTokenTypes.MULT || secondToken == JSTokenTypes.LBRACE)) {
            PsiBuilder.Marker exportDeclaration = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            this.parseES6ExportDeclarationBody(exportDeclaration);
            return true;
        }
        return super.tryParseES6ExportStatement();
    }

    @Override
    protected void parseReferencesList() {
        super.parseReferencesList();
        if (this.builder.getTokenType() == JSTokenTypes.MIXINS_KEYWORD) {
            this.parseReferenceList(this.getClassExtendListElementType());
        }
    }

    @Override
    protected boolean parseES6ImportOrExportSpecifier(boolean isImport, @NotNull PsiBuilder.Marker marker) {
        IElementType tokenType;
        if (marker == null) {
            FlowJSStatementParser.$$$reportNull$$$0(3);
        }
        if (((tokenType = this.builder.getTokenType()) == JSTokenTypes.TYPE_KEYWORD || tokenType == JSTokenTypes.TYPEOF_KEYWORD) && this.isIdentifierToken(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        return super.parseES6ImportOrExportSpecifier(isImport, marker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstToken";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flow/psi/FlowJSStatementParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseInterfaceNoMarker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseTypeAlias";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseES6ImportOrExportSpecifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

