/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.CommenterForm;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.PresentableEnumCellRenderer;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public abstract class JSGeneratedCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myPanel;
    protected JTextField myFieldPrefixTextField;
    protected JTextField myPropertyPrefixTextField;
    protected JPanel myNamingConventionsPane;
    protected JBCheckBox myUsePublicModifierJBCheckBox;
    private JComboBox<JSCodeStyleSettings.JSFileNameStyle> myFilenameStyleBox;
    private JPanel myCodeCommentingPanel;
    private CommenterForm myCommenterForm;
    private boolean myInsideUpdate = false;

    public JSGeneratedCodeStylePanel(Language language, CodeStyleSettings settings, boolean showVisibilityModifiers) {
        super(language, null, settings);
        this.$$$setupUI$$$();
        this.addPanelToWatch(this.myPanel);
        DocumentAdapter adapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!JSGeneratedCodeStylePanel.this.myInsideUpdate) {
                    JSGeneratedCodeStylePanel.this.somethingChanged();
                }
            }
        };
        ActionListener anotherAdapter = e -> {
            if (!this.myInsideUpdate) {
                this.somethingChanged();
            }
        };
        this.myFieldPrefixTextField.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myPropertyPrefixTextField.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myFilenameStyleBox.setModel(new DefaultComboBoxModel<JSCodeStyleSettings.JSFileNameStyle>(JSCodeStyleSettings.JSFileNameStyle.values()));
        this.myFilenameStyleBox.setRenderer((ListCellRenderer<JSCodeStyleSettings.JSFileNameStyle>)((Object)new PresentableEnumCellRenderer()));
        this.myFilenameStyleBox.addActionListener(anotherAdapter);
        this.myUsePublicModifierJBCheckBox.setVisible(showVisibilityModifiers);
        this.myNamingConventionsPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"javascript.formatting.options.panel.naming.conventions", (Object[])new Object[0]), (boolean)true));
    }

    private void createUIComponents() {
        this.myCommenterForm = new CommenterForm(this.getDefaultLanguage());
        this.myCodeCommentingPanel = this.myCommenterForm.getCommenterPanel();
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(this.getFileType())).getEditorHighlighter(ProjectUtil.guessCurrentProject((JComponent)this.getPanel()), this.getFileType(), null, scheme);
    }

    protected int getRightMargin() {
        return 60;
    }

    protected String getTabTitle() {
        return ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]);
    }

    @NotNull
    protected abstract FileType getFileType();

    protected String getPreviewText() {
        return "";
    }

    public void apply(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        jsCodeStyleSettings.FIELD_PREFIX = this.myFieldPrefixTextField.getText();
        jsCodeStyleSettings.PROPERTY_PREFIX = this.myPropertyPrefixTextField.getText();
        jsCodeStyleSettings.FILE_NAME_STYLE = (JSCodeStyleSettings.JSFileNameStyle)this.myFilenameStyleBox.getSelectedItem();
        jsCodeStyleSettings.USE_PUBLIC_MODIFIER = this.myUsePublicModifierJBCheckBox.isSelected();
        this.myCommenterForm.apply(settings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        return !jsCodeStyleSettings.FIELD_PREFIX.equals(this.myFieldPrefixTextField.getText()) || !jsCodeStyleSettings.PROPERTY_PREFIX.equals(this.myPropertyPrefixTextField.getText()) || !jsCodeStyleSettings.FILE_NAME_STYLE.equals(this.myFilenameStyleBox.getSelectedItem()) || jsCodeStyleSettings.USE_PUBLIC_MODIFIER != this.myUsePublicModifierJBCheckBox.isSelected() || this.myCommenterForm.isModified(settings);
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        try {
            this.myInsideUpdate = true;
            JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
            this.myFieldPrefixTextField.setText(jsCodeStyleSettings.FIELD_PREFIX);
            this.myPropertyPrefixTextField.setText(jsCodeStyleSettings.PROPERTY_PREFIX);
            this.myFilenameStyleBox.setSelectedItem(jsCodeStyleSettings.FILE_NAME_STYLE);
            this.myUsePublicModifierJBCheckBox.setSelected(jsCodeStyleSettings.USE_PUBLIC_MODIFIER);
            this.myCommenterForm.reset(settings);
        }
        finally {
            this.myInsideUpdate = false;
        }
    }

    private JSCodeStyleSettings getCustomJSSettings(CodeStyleSettings settings) {
        return (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.getDefaultLanguage()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 10, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10), "", 0, 0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 1, 1, 0, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), null, 0, 0, null, null));
        this.myNamingConventionsPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Naming conventions", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("codestyle.ui.field.prefix"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFieldPrefixTextField = jTextField2 = new JTextField();
        jTextField2.setColumns(20);
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("codestyle.ui.property.prefix"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPropertyPrefixTextField = jTextField = new JTextField();
        jTextField.setColumns(20);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("codestyle.ui.file.name.style"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myFilenameStyleBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myUsePublicModifierJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.generated.use.public.modifier"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = this.myCodeCommentingPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

