/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSIndentOptionsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final String FLOW_CATEGORY_NAME = JSBundle.message((String)"js.spaces.in.flow.category", (Object[])new Object[0]);
    public static final int[] ALIGN_OBJECT_PROPERTIES_VALUES = new int[]{0, 2, 1};
    public static final String[] ALIGN_OBJECT_PROPERTIES_OPTIONS = new String[]{JSBundle.message((String)"js.align.properties.none", (Object[])new Object[0]), JSBundle.message((String)"js.align.properties.on.colon", (Object[])new Object[0]), JSBundle.message((String)"js.align.properties.on.value", (Object[])new Object[0])};
    public static final int[] ALIGN_VAR_STATEMENT_VALUES = new int[]{0, 1, 2};
    public static final String[] ALIGN_VAR_STATEMENT_OPTIONS = new String[]{JSBundle.message((String)"js.code.style.do.not.align.var.statement", (Object[])new Object[0]), JSBundle.message((String)"js.code.style.align.var.statements", (Object[])new Object[0]), JSBundle.message((String)"js.code.style.align.var.statements.and.assignments", (Object[])new Object[0])};
    public static final String[] STANDARD_SPACING_OPTIONS = new String[]{"SPACE_AFTER_COLON", "SPACE_AFTER_COMMA", "SPACE_AFTER_QUEST", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_BEFORE_CATCH_LBRACE", "SPACE_BEFORE_COLON", "SPACE_BEFORE_COMMA", "SPACE_BEFORE_ELSE_LBRACE", "SPACE_BEFORE_FINALLY_LBRACE", "SPACE_BEFORE_FOR_LBRACE", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_BEFORE_IF_LBRACE", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_LBRACE", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_BEFORE_QUEST", "SPACE_BEFORE_SEMICOLON", "SPACE_BEFORE_SWITCH_LBRACE", "SPACE_BEFORE_SWITCH_PARENTHESES", "SPACE_BEFORE_TRY_LBRACE", "SPACE_BEFORE_TYPE", "SPACE_BEFORE_WHILE_LBRACE", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_WITHIN_CATCH_PARENTHESES", "SPACE_WITHIN_FOR_PARENTHESES", "SPACE_WITHIN_IF_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_SWITCH_PARENTHESES", "SPACE_WITHIN_WHILE_PARENTHESES", "SPACE_WITHIN_PARENTHESES", "SPACE_WITHIN_BRACKETS", "SPACE_BEFORE_CATCH_PARENTHESES", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_AROUND_UNARY_OPERATOR", "SPACE_BEFORE_DO_LBRACE", "SPACE_BEFORE_WHILE_KEYWORD", "SPACE_BEFORE_ELSE_KEYWORD", "SPACE_BEFORE_CATCH_KEYWORD", "SPACE_BEFORE_FINALLY_KEYWORD"};
    public static final String[] STANDARD_BLANK_LINES_OPTIONS = new String[]{"KEEP_BLANK_LINES_IN_CODE", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_AROUND_CLASS"};
    public static final String[] STANDARD_WRAPPING_OPTIONS = new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT", "KEEP_SIMPLE_BLOCKS_IN_ONE_LINE", "KEEP_SIMPLE_METHODS_IN_ONE_LINE", "BRACE_STYLE", "METHOD_BRACE_STYLE", "METHOD_PARAMETERS_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_PARAMETERS", "CALL_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "METHOD_CALL_CHAIN_WRAP", "ALIGN_MULTILINE_CHAINED_METHODS", "PREFER_PARAMETERS_WRAP", "IF_BRACE_FORCE", "ELSE_ON_NEW_LINE", "FOR_STATEMENT_WRAP", "ALIGN_MULTILINE_FOR", "FOR_STATEMENT_LPAREN_ON_NEXT_LINE", "FOR_STATEMENT_RPAREN_ON_NEXT_LINE", "FOR_BRACE_FORCE", "WHILE_BRACE_FORCE", "DOWHILE_BRACE_FORCE", "WHILE_ON_NEW_LINE", "INDENT_CASE_FROM_SWITCH", "CATCH_ON_NEW_LINE", "BINARY_OPERATION_WRAP", "BINARY_OPERATION_SIGN_ON_NEXT_LINE", "ALIGN_MULTILINE_BINARY_OPERATION", "PARENTHESES_EXPRESSION_LPAREN_WRAP", "PARENTHESES_EXPRESSION_RPAREN_WRAP", "ASSIGNMENT_WRAP", "PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE", "ALIGN_MULTILINE_TERNARY_OPERATION", "TERNARY_OPERATION_WRAP", "TERNARY_OPERATION_SIGNS_ON_NEXT_LINE", "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", "ARRAY_INITIALIZER_WRAP", "ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", "SPECIAL_ELSE_IF_TREATMENT", "FINALLY_ON_NEW_LINE", "WRAP_COMMENTS", "EXTENDS_LIST_WRAP", "ALIGN_MULTILINE_EXTENDS_LIST", "EXTENDS_KEYWORD_WRAP", "CLASS_BRACE_STYLE"};
    public static final String GENERAL_CODE_SAMPLE = "import {Component} from 'react'\n\nfunction foo(){\n  ct(a,b)\n\n\n  c0=c0+1\n   if (c0 >= 2)cl0.left=-100\n  TC=TC+1\n  if (Fm >= Fl){Fm=Fl}\n  while (TC != Bl){Bo+=1;x++}\n  if (Bo >= 1){\n   x=x-5\n   if (x >= 0){\n    if (s!=\"C\") return\n   }\n   if (x == 0){\n    if (x <= 0){\n     if (s!=\"C\"){\n      x=1\n     }else{\n      x=10\n     }\n    }\n   }\n   x=0\n   for (x1=0; x1<10; x1++) if (EX[x1] >= -50){x=1}\n   if (x == 0) B(\"a\",\"b\")\n  }\n}";
    public static final String WRAPPING_CODE_SAMPLE = "class Foo extends BarComponent, BazService, QuuxProvider {\n}\n\nimport {Component} from 'react'\nimport {Rx} from 'rxjs/Observable'\n\nimport {property1, property2, property3} from './myModule.js'\n\nfunction buzz() { return 0; }\nvar x = 1, y = 2, foregroundColor = 'transparent', highlightColor = 'lime', font = 'Arial';\n/*\n Multiline\n   C-style\n     Comment\n */\nvar myLink  = {img: \"btn.gif\"},\n    local   = true,\n    initial = -1;\nwidth = 400\nheight = 300\n\nvar foo = {\n    numbers:['one', 'two', 'three', 'four', 'five', 'six'],\n    data : {a:{id: 123, type: \"String\", isAvailable: true},\nb:{id: 456, type:\"Int\"}},\n// fBar : function (x,y);\n    fOne:function(a, b, c, d, e, f, g, h) {\n        var x = a + b + c + d + e + f + g + h;\n        fTwo(a, b, c, fThree(d, e, f, g, h));\n        var z = a == 'Some string' ? 'yes' : 'no';\n        z = a == 10 ? 'yes' : 'no';\n        var colors = ['red', 'green', 'blue', 'black', 'white', 'gray'];\n        for (j = 0; j < 2; j ++) i = a;        for (var i = 0; i < colors.length; i++)\n             var colorString = this.numbers[i];\n    },\n\n chainedCallSample: function(a,b,c,d,e,f) {\n        chainRoot.firstCall(a,b,c,d,e,f,g).secondCall(a,b,c,d).thirdCall(a,b,c,d).fourthCall().q(a).r(a,b).s();\n        chainRoot.x().y()\n        .z();     },\n callArgumentsSample: function () {\n    this.fTwo(\"one\", \"two\", \"three\", \"four\");\n    this.fThree({\n      strA: 'a',\n      strB: 'b',\n      strC: 'c',\n      strD: 'd'\n    }, 'strE');\n    [1, 2, 3].reduce(function (previousValue, currentValue) {\n      return previousValue + currentValue;\n    }, 10);\n  },\n    /**\n     * Function JSDoc. Long lines can be wrapped with 'Comments'/'Wrap at right margin' option\n     * @param {string} a Parameter A description.\n     * @param {string} b Parameter B description. Can extend beyond the right margin.\n     */\n    fTwo:function(a, b, c, d) {\n        foo(a, b, c, d); // Line comment which can be wrapped if long.\n        if (true)\n            return c;\n        if (a == 'one' && (b == 'two' || c == 'three')) {\n            return a + b + c + d;\n        } else return strD;\n        if (a == 'one') {\n            return 1;\n        }\n        else if(a == 'two') {\n            return 2;\n        }\n        var number = -10;\n        while (x < 0) {\n            number = number + 1;\n        }\n        do {\n            number = number + 1;\n        } while (number < 10);\n        return d;\n    },\n\n    fThree:function({strA, strB, strC, strD}, strE) {\n        var number = prompt(\"Enter a number:\", 0);\n        switch (number) {\n            case 0 :\n                alert(\"Zero\");\n                break;\n            case 1:\n                alert(\"One\");\n                break;\n        }\n        try {\n            a[2]= 10;\n        }\n        catch(e) {\n            alert(\"Failure: \" + e.message);\n        }\n        return strA + strB + strC + strD + strE;\n    }\n};";
    public static final String BLANK_LINES_CODE_SAMPLE = "/**\n * This is a sample file\n */\nimport {Component} from 'React'\nimport {add, subtract} from 'utils';\nclass Foo {\n    field1 = 1;\n    field2 = 2;\n    foo() {\n        console.log('foo')\n    }\n    static bar() {\n        function hello(n) {\n            console.log('hello ' + n)\n        }\n        var x = 1;\n\n\n        while (x < 10) {\n            hello(x)\n        }\n    }\n}";
    private static final String ES6_SPACING_CODE_SAMPLE = "import {Component} from 'react'\nexport class Greeter extends Component {\n    constructor(message) {\n        super();\n        this.greeting = message;\n    }\n\n    greetFrom(...names) {\n        return (<div className=\"greeting\">\n            Hello, { this.greeting } from\n            { names.map(name => <Name>{ name }</Name>) }\n        </div>);\n    }\n\n    greetNTimes({ name, times }) {\n        let greeting = this.greetFrom(name);\n        for (let i = 0; i < times; i++) {\n            console.log(greeting)\n        }\n    }\n}\n\nnew Greeter(\"foo\").greetNTimes({name:\"Webstorm\", times:3})\nfunction *fibonacci(current = 1, next = 1) {\n    yield current;\n    yield *fibonacci(next, current + next);\n}\n\nlet [first, second, ...rest] = take(fibonacci(), 10)\n";
    public static final String SIMPLE_SPACING_CODE_SAMPLE = "function foo(x,y,z) {\n    var i = 0;\n    var x = {0:\"zero\",1:\"one\"};\n    var a = [0,1,2];\n    var foo = function () {}\n    var asyncFoo = async (x, y, z) => { }\n    var v = x.map( s => s.length );\n    if (!i > 10) {\n        for (var j = 0; j < 10; j++) {\n            switch (j) {\n                case 0:\n                    value = \"zero\";\n                    break;\n                case 1:\n                    value = \"one\";\n                    break;\n            }\n            var c = j > 5 ? \"GT 5\" : \"LE 5\";\n        }\n    } else {\n        var j = 0;\n        try {\n            while (j < 10) {\n                if (i == j || j > 5) {\n                    a[j] = i + j * 12;\n                }\n                i = (j << 2) & 4;\n                j++;\n            }\n            do {\n                j--;\n            } while (j > 0)\n        } catch (e) {\n            alert(\"Failure: \" + e.message);\n        } finally {\n            reset(a,i);\n        }\n    }\n}";
    public static final String INDENTS_CODE_SAMPLE = "foo(\n        \"demo\",\n        {\n            title:\"Demo\",\n            width:100\n        },\n        function() {\n            object.firstCall({\n            a:'a',\n            b:'b'})\n            .secondCall();\n        }\n);";

    @NotNull
    public Language getLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return javascriptLanguage;
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (Language)JavaScriptSupportLoader.JSX_HARMONY, (CharSequence)text, false, false);
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        switch (settingsType) {
            case WRAPPING_AND_BRACES_SETTINGS: {
                return WRAPPING_CODE_SAMPLE;
            }
            case BLANK_LINES_SETTINGS: {
                return BLANK_LINES_CODE_SAMPLE;
            }
            case SPACING_SETTINGS: {
                return "import {Component} from 'react'\nexport class Greeter extends Component {\n    constructor(message) {\n        super();\n        this.greeting = message;\n    }\n\n    greetFrom(...names) {\n        return (<div className=\"greeting\">\n            Hello, { this.greeting } from\n            { names.map(name => <Name>{ name }</Name>) }\n        </div>);\n    }\n\n    greetNTimes({ name, times }) {\n        let greeting = this.greetFrom(name);\n        for (let i = 0; i < times; i++) {\n            console.log(greeting)\n        }\n    }\n}\n\nnew Greeter(\"foo\").greetNTimes({name:\"Webstorm\", times:3})\nfunction *fibonacci(current = 1, next = 1) {\n    yield current;\n    yield *fibonacci(next, current + next);\n}\n\nlet [first, second, ...rest] = take(fibonacci(), 10)\n\nfunction foo(x,y,z) {\n    var i = 0;\n    var x = {0:\"zero\",1:\"one\"};\n    var a = [0,1,2];\n    var foo = function () {}\n    var asyncFoo = async (x, y, z) => { }\n    var v = x.map( s => s.length );\n    if (!i > 10) {\n        for (var j = 0; j < 10; j++) {\n            switch (j) {\n                case 0:\n                    value = \"zero\";\n                    break;\n                case 1:\n                    value = \"one\";\n                    break;\n            }\n            var c = j > 5 ? \"GT 5\" : \"LE 5\";\n        }\n    } else {\n        var j = 0;\n        try {\n            while (j < 10) {\n                if (i == j || j > 5) {\n                    a[j] = i + j * 12;\n                }\n                i = (j << 2) & 4;\n                j++;\n            }\n            do {\n                j--;\n            } while (j > 0)\n        } catch (e) {\n            alert(\"Failure: \" + e.message);\n        } finally {\n            reset(a,i);\n        }\n    }\n}";
            }
            case INDENT_SETTINGS: {
                return INDENTS_CODE_SAMPLE;
            }
        }
        return GENERAL_CODE_SAMPLE;
    }

    public DisplayPriority getDisplayPriority() {
        return PlatformUtils.isWebStorm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(STANDARD_SPACING_OPTIONS);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_PROPERTY_COLON", JSBundle.message((String)"space.before.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_AFTER_PROPERTY_COLON", JSBundle.message((String)"space.after.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_AFTER_DOTS_IN_REST_PARAMETER", JSBundle.message((String)"space.after.dots.in.rest.parameter", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_GENERATOR_MULT", JSBundle.message((String)"space.before.generator.mult", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_AFTER_GENERATOR_MULT", JSBundle.message((String)"space.after.generator.mult", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_FUNCTION_LEFT_PARENTH", JSBundle.message((String)"space.before.function.left.parenth", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACES_WITHIN_OBJECT_LITERAL_BRACES", JSBundle.message((String)"spaces.within.object.literal.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACES_WITHIN_IMPORTS", JSBundle.message((String)"spaces.within.import.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_CLASS_LBRACE", JSBundle.message((String)"space.before.class.lbrace", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_LEFT_BRACE, new Object[0]);
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_CALL_PARENTHESES", JSBundle.message((String)"js.function.call.parentheses", (Object[])new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_PARENTHESES", JSBundle.message((String)"js.function.declaration.parentheses", (Object[])new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_CALL_PARENTHESES", JSBundle.message((String)"js.function.call.parentheses", (Object[])new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_PARENTHESES", JSBundle.message((String)"js.function.declaration.parentheses", (Object[])new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_LBRACE", JSBundle.message((String)"js.space.before.function.left.brace", (Object[])new Object[0]));
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_TYPE_COLON", JSBundle.message((String)"space.before.type.colon", (Object[])new Object[0]), FLOW_CATEGORY_NAME, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_AFTER_TYPE_COLON", JSBundle.message((String)"space.after.type.colon", (Object[])new Object[0]), FLOW_CATEGORY_NAME, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACES_WITHIN_OBJECT_TYPE_BRACES", JSBundle.message((String)"spaces.within.object.type.braces", (Object[])new Object[0]), FLOW_CATEGORY_NAME, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACES_WITHIN_UNION_TYPES", JSBundle.message((String)"js.wrap.settings.union.and.intersection.types", (Object[])new Object[0]), FLOW_CATEGORY_NAME, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_AROUND_ARROW_FUNCTION_OPERATOR", JSBundle.message((String)"spaces.arrow.function", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_ASYNC_ARROW_LPAREN", JSBundle.message((String)"spaces.async.arrow.function", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACES_WITHIN_INTERPOLATION_EXPRESSIONS", JSBundle.message((String)"spaces.within.interpolation.expressions", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(STANDARD_BLANK_LINES_OPTIONS);
            consumer.renameStandardOption("BLANK_LINES_AROUND_METHOD", JSBundle.message((String)"js.blank.lines.around.method", (Object[])new Object[0]));
            consumer.showCustomOption(JSCodeStyleSettings.class, "BLANK_LINES_AROUND_FUNCTION", JSBundle.message((String)"js.blank.lines.around.function", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BLANK_LINES, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(STANDARD_WRAPPING_OPTIONS);
            consumer.renameStandardOption("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.after.left.bracket", (Object[])new Object[0]));
            consumer.renameStandardOption("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.before.right.bracket", (Object[])new Object[0]));
            consumer.renameStandardOption("METHOD_BRACE_STYLE", JSBundle.message((String)"js.function.brace.style", (Object[])new Object[0]));
            consumer.showCustomOption(JSCodeStyleSettings.class, "FUNCTION_EXPRESSION_BRACE_STYLE", JSBundle.message((String)"js.function.expression.brace.style", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "METHOD_BRACE_STYLE", new Object[]{CodeStyleSettingsCustomizable.BRACE_PLACEMENT_OPTIONS, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES});
            consumer.renameStandardOption("METHOD_PARAMETERS_WRAP", JSBundle.message((String)"js.function.parameters.wrap", (Object[])new Object[0]));
            consumer.renameStandardOption("CALL_PARAMETERS_WRAP", JSBundle.message((String)"js.function.call.wrap", (Object[])new Object[0]));
            consumer.renameStandardOption("EXTENDS_LIST_WRAP", JSBundle.message((String)"js.extends.list.wrap", (Object[])new Object[0]));
            consumer.renameStandardOption("ALIGN_MULTILINE_EXTENDS_LIST", JSBundle.message((String)"js.align.multiline.extends.list", (Object[])new Object[0]));
            consumer.renameStandardOption("EXTENDS_KEYWORD_WRAP", JSBundle.message((String)"js.extends.keyword.wrap", (Object[])new Object[0]));
            consumer.showCustomOption(JSCodeStyleSettings.class, "REFORMAT_C_STYLE_COMMENTS", JSBundle.message((String)"js.format.cstyle.comments", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_COMMENTS, new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "OBJECT_LITERAL_WRAP", JSBundle.message((String)"js.code.style.object.literals.category.name", (Object[])new Object[0]), null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JSCodeStyleSettings.class, "ALIGN_OBJECT_PROPERTIES", JSBundle.message((String)"js.code.style.align.caption", (Object[])new Object[0]), JSBundle.message((String)"js.code.style.object.literals.category.name", (Object[])new Object[0]), new Object[]{ALIGN_OBJECT_PROPERTIES_OPTIONS, ALIGN_OBJECT_PROPERTIES_VALUES});
            consumer.showCustomOption(JSCodeStyleSettings.class, "VAR_DECLARATION_WRAP", JSBundle.message((String)"js.wrap.settings.var.group.name", (Object[])new Object[0]), null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JSCodeStyleSettings.class, "ALIGN_VAR_STATEMENTS", JSBundle.message((String)"js.code.style.align.caption", (Object[])new Object[0]), JSBundle.message((String)"js.wrap.settings.var.group.name", (Object[])new Object[0]), new Object[]{ALIGN_VAR_STATEMENT_OPTIONS, ALIGN_VAR_STATEMENT_VALUES});
            consumer.showCustomOption(JSCodeStyleSettings.class, "IMPORTS_WRAP", JSBundle.message((String)"js.wrap.settings.import", (Object[])new Object[0]), null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JSCodeStyleSettings.class, "ALIGN_IMPORTS", JSBundle.message((String)"js.code.style.align.from.clause.caption", (Object[])new Object[0]), JSBundle.message((String)"js.wrap.settings.import", (Object[])new Object[0]), new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "CHAINED_CALL_DOT_ON_NEW_LINE", JSBundle.message((String)"js.chained.call.dot.on.next.line", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_CALL_CHAIN, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN"});
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_ADD_SPACE"});
        }
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        return JSLanguageCodeStyleSettingsProvider.getDefaultSettings(this.getLanguage());
    }

    @NotNull
    public static CommonCodeStyleSettings getDefaultSettings(Language language) {
        CommonCodeStyleSettings commonCodeStyleSettings = new CommonCodeStyleSettings(language);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonCodeStyleSettings.initIndentOptions();
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        commonCodeStyleSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonCodeStyleSettings.LINE_COMMENT_ADD_SPACE = true;
        CommonCodeStyleSettings commonCodeStyleSettings2 = commonCodeStyleSettings;
        if (commonCodeStyleSettings2 == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return commonCodeStyleSettings2;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new JSIndentOptionsEditor(null);
    }

    public int getRightMargin(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return 40;
        }
        return super.getRightMargin(settingsType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSLanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

