/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.commonjs;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSDocModulesIndex;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonJSUtil {
    public static boolean calculateIsRequireCall(@NotNull JSCallExpression callExpression) {
        JSReferenceExpression methodExpression;
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(0);
        }
        return (methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) != null && callExpression.getArguments().length == 1 && methodExpression.getQualifier() == null && "require".equals(methodExpression.getReferenceName());
    }

    @Nullable
    public static String getRequireCallModulePath(@NotNull JSCallExpression call) {
        if (call == null) {
            CommonJSUtil.$$$reportNull$$$0(1);
        }
        assert (call.isRequireCall());
        JSExpression[] arguments = call.getArguments();
        assert (arguments.length == 1);
        JSExpression argument = arguments[0];
        if (!(argument instanceof JSLiteralExpression) || !((JSLiteralExpression)argument).isQuotedLiteral()) {
            return null;
        }
        return StringUtil.unquoteString((String)argument.getText());
    }

    @Nullable
    public static String getNodeJsRedirectPath(PsiFile mainModule) {
        if (!(mainModule instanceof JSFileImpl)) {
            return null;
        }
        StubElement stub = ((JSFileImpl)mainModule).getStub();
        JSAssignmentExpression candidate = null;
        if (stub != null) {
            PsiElement[] assignments = stub.getChildrenByType(JSStubElementTypes.ASSIGNMENT_EXPRESSION, PsiElement.ARRAY_FACTORY);
            if (assignments.length == 1 && assignments[0] instanceof JSAssignmentExpression) {
                candidate = (JSAssignmentExpression)assignments[0];
            }
        } else {
            JSExpression expression;
            JSExpressionStatement[] exprStatements = (JSExpressionStatement[])((JSFileImpl)mainModule).findChildrenByClass(JSExpressionStatement.class);
            if (exprStatements.length == 1 && (expression = exprStatements[0].getExpression()) instanceof JSAssignmentExpression) {
                candidate = (JSAssignmentExpression)expression;
            }
        }
        if (candidate == null) {
            return null;
        }
        JSDefinitionExpression definitionExpression = candidate.getDefinitionExpression();
        if (definitionExpression == null || !"module.exports".equals(definitionExpression.getQualifiedName())) {
            return null;
        }
        JSType exportsType = ((JSFileImpl)mainModule).getExportsInnerAlias();
        if (!(exportsType instanceof JSRequireCallExpressionType)) {
            return null;
        }
        return ((JSRequireCallExpressionType)exportsType).getReferencedModule();
    }

    @NotNull
    public static Collection<PsiFile> resolveJSDocCommentModules(@NotNull JSType type) {
        if (type == null) {
            CommonJSUtil.$$$reportNull$$$0(2);
        }
        if (!(type instanceof JSTypeImpl)) {
            List<PsiFile> list = Collections.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiFile file2 = type.getSource().getScope();
        if (file2 == null) {
            List<PsiFile> list = Collections.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        String typeText = type.getTypeText(JSType.TypeTextFormat.SIMPLE);
        if (!typeText.startsWith("module:")) {
            List<PsiFile> list = Collections.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        String moduleNameWithoutPrefix = typeText.substring("module:".length());
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file2);
        SmartHashSet files = new SmartHashSet();
        StubIndex.getInstance().processElements(JSDocModulesIndex.KEY, (Object)moduleNameWithoutPrefix, file2.getProject(), scope, JSDocComment.class, arg_0 -> CommonJSUtil.lambda$resolveJSDocCommentModules$0((Collection)files, arg_0));
        SmartHashSet smartHashSet = files;
        if (smartHashSet == null) {
            CommonJSUtil.$$$reportNull$$$0(6);
        }
        return smartHashSet;
    }

    public static Collection<JSFile> resolveReferencedElements(@NotNull PsiElement context, @NotNull String path) {
        if (context == null) {
            CommonJSUtil.$$$reportNull$$$0(7);
        }
        if (path == null) {
            CommonJSUtil.$$$reportNull$$$0(8);
        }
        return JSFileReferencesUtil.getMostPriorityModules(context, path, true).stream().filter(el -> el instanceof JSFile).map(el -> (JSFile)el).collect(Collectors.toList());
    }

    public static boolean isExportNamespace(@Nullable JSNamespace namespace) {
        if (namespace == null) {
            return false;
        }
        JSQualifiedName qName = namespace.getQualifiedName();
        return qName != null && "exports".equals(qName.getName()) && (qName.getParent() == null || "module".equals(qName.getParent().getName()) && qName.getParent().getParent() == null);
    }

    @NotNull
    public static Collection<PsiElement> findReferencedModulesIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(9);
        }
        if (!callExpression.isRequireCall()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CommonJSUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression) {
            PsiReference[] references = arguments[arguments.length - 1].getReferences();
            Collection<PsiElement> collection = JSFileReferencesUtil.getMostPriorityModules((PsiElement)callExpression, references);
            if (collection == null) {
                CommonJSUtil.$$$reportNull$$$0(11);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            CommonJSUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public static PsiElement findReferencedModuleIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(13);
        }
        return (PsiElement)ContainerUtil.getFirstItem(CommonJSUtil.findReferencedModulesIfRequireCall(callExpression));
    }

    private static /* synthetic */ boolean lambda$resolveJSDocCommentModules$0(Collection files, JSDocComment element) {
        files.add(element.getContainingFile());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveJSDocCommentModules";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModulesIfRequireCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateIsRequireCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRequireCallModulePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveJSDocCommentModules";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModulesIfRequireCall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModuleIfRequireCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

