/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class JSMethodToImplement {
    private final boolean myIsAbstractMethod;
    private final boolean myIsGetAccessor;
    private final boolean myIsSetAccessor;
    private final String myBaseClassName;
    private final String myParameterList;
    private final JSType myReturnType;
    private final String myName;
    private final SmartPsiElementPointer<JSPsiElementBase> myElementPointer;

    public boolean isAbstractMethod() {
        return this.myIsAbstractMethod;
    }

    public String getBaseClassName() {
        return this.myBaseClassName;
    }

    public String getParameterList() {
        return this.myParameterList;
    }

    public JSType getReturnType() {
        return this.myReturnType;
    }

    public String getName() {
        return this.myName;
    }

    public JSPsiElementBase getElement() {
        return (JSPsiElementBase)this.myElementPointer.getElement();
    }

    public boolean isGetAccessor() {
        return this.myIsGetAccessor;
    }

    public boolean isSetAccessor() {
        return this.myIsSetAccessor;
    }

    public JSMethodToImplement(JSPsiElementBase member, boolean isAbstractMethod, String baseClassName) {
        this.myIsAbstractMethod = isAbstractMethod;
        this.myBaseClassName = baseClassName;
        this.myParameterList = JSMethodToImplement.buildParameterList(member);
        this.myReturnType = JSMethodToImplement.getReturnType(member);
        this.myName = member.getName();
        this.myElementPointer = SmartPointerManager.createPointer((PsiElement)member);
        this.myIsGetAccessor = member instanceof JSFunctionItem && ((JSFunctionItem)member).isGetProperty();
        this.myIsSetAccessor = member instanceof JSFunctionItem && ((JSFunctionItem)member).isSetProperty();
    }

    private static String buildParameterList(JSPsiElementBase member) {
        JSFunctionItem function = JSPsiImplUtils.getPossibleFunctionItem((PsiElement)member);
        StringBuilder builder = new StringBuilder("(");
        if (function != null) {
            builder.append(Arrays.stream(function.getParameters()).map(p -> p.getName()).reduce((p1, p2) -> p1 + ", " + p2).orElse(""));
        }
        builder.append(")");
        return builder.toString();
    }

    @Nullable
    private static JSType getReturnType(JSPsiElementBase member) {
        return member instanceof JSFunctionItem ? ((JSFunctionItem)member).getReturnType() : null;
    }
}

