/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSSymbolPresentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.fixes.ChangeJSDocTypeFix;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSCheckFunctionSignaturesInspection
extends JSInspection {
    public static final String SHORT_NAME = JSCheckFunctionSignaturesInspection.calcShortNameFromClass(JSCheckFunctionSignaturesInspection.class);
    public boolean myCheckGuessedTypes;

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.validate.signature.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JSBundle.message((String)"js.check.function.signature.guess.optionality", (Object[])new Object[0]), JSBundle.message((String)"js.check.function.signature.guess.optionality.hint", (Object[])new Object[0]), "myCheckGuessedTypes");
    }

    protected boolean isAllowedToCheckCallExpression(JSCallExpression node) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)node);
        return dialect == null || !dialect.isTypeScript && dialect != DialectOptionHolder.FLOW;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSCallExpression(JSCallExpression node) {
                block9: {
                    PsiElement arrayInitializingType;
                    JSExpression methodExpression;
                    block8: {
                        JSFunctionItem function;
                        if (!JSCheckFunctionSignaturesInspection.this.isAllowedToCheckCallExpression(node)) {
                            return;
                        }
                        methodExpression = node.getMethodExpression();
                        if (methodExpression instanceof JSParenthesizedExpression) {
                            methodExpression = JSUtils.unparenthesize(methodExpression);
                        }
                        if (!(methodExpression instanceof JSReferenceExpression) && !(methodExpression instanceof JSSuperExpression)) break block8;
                        PsiReference reference = methodExpression.getReference();
                        if (reference == null) {
                            return;
                        }
                        PsiElement resolve = reference.resolve();
                        if (resolve == null || !resolve.isValid()) break block9;
                        boolean checkFunction = true;
                        if (!JSCheckFunctionSignaturesInspection.this.myCheckGuessedTypes && (function = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)methodExpression)) instanceof JSFunction && !JSPsiImplUtils.signatureIsExplicitlyDeclared(function)) {
                            checkFunction = false;
                        }
                        if (!checkFunction) break block9;
                        this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, resolve);
                        break block9;
                    }
                    if (methodExpression instanceof JSFunctionExpression && (JSCheckFunctionSignaturesInspection.this.myCheckGuessedTypes || JSPsiImplUtils.signatureIsExplicitlyDeclared((JSFunctionItem)((JSFunctionExpression)methodExpression)))) {
                        this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, (PsiElement)methodExpression);
                    } else if (methodExpression instanceof JSArrayLiteralExpression && node instanceof JSNewExpression && (arrayInitializingType = ((JSNewExpression)node).getArrayInitializingType()) != null) {
                        String typeName = JSImportHandlingUtil.resolveTypeName(arrayInitializingType.getText(), (PsiElement)node);
                        for (JSExpression expr : ((JSArrayLiteralExpression)methodExpression).getExpressions()) {
                            if (expr == null) continue;
                            JSCheckFunctionSignaturesInspection.getTypeChecker((PsiElement)expr, holder).checkExpressionIsAssignableToType(expr, typeName, "javascript.vector.literal.element.type.mismatch", null, true);
                        }
                    }
                }
            }

            @NotNull
            private JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull PsiElement context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSFunctionSignatureChecker jSFunctionSignatureChecker = JSAnalysisHandlersFactory.forElement(context).getFunctionSignatureChecker(holder);
                if (jSFunctionSignatureChecker == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jSFunctionSignatureChecker;
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.checkSignatureMatchesOverridden((JSFunction)node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                this.checkSignatureMatchesOverridden(node);
            }

            private void checkSignatureMatchesOverridden(JSFunction function) {
                if (!DialectDetector.isJavaScript((PsiElement)function)) {
                    return;
                }
                Collection<JSPsiElementBase> members = JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)function, true);
                if (members.isEmpty()) {
                    return;
                }
                JSParameterListElement[] parameters = function.getParameters();
                if (members.size() == 1) {
                    JSFunctionItem overridden = JSPsiImplUtils.calculatePossibleFunction((PsiElement)members.iterator().next());
                    if (overridden == null) {
                        return;
                    }
                    this.checkCompatibleSignature(function, parameters, overridden, true);
                } else {
                    for (JSPsiElementBase member : members) {
                        JSFunctionItem overridden = JSPsiImplUtils.calculatePossibleFunction((PsiElement)member);
                        if (overridden == null || !this.checkCompatibleSignature(function, parameters, overridden, false)) continue;
                        return;
                    }
                    PsiElement nameIdentifier = function.getNameIdentifier();
                    holder.registerProblem((PsiElement)(nameIdentifier != null ? nameIdentifier : function), JSBundle.message((String)"javascript.validation.message.function.override.incompatible.signature.generic", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private boolean checkCompatibleSignature(JSFunction function, JSParameterListElement[] parameters, JSFunctionItem overridden, boolean reportProblems) {
                PsiFile file2 = overridden.getContainingFile();
                if (file2 instanceof JSFile && ((JSFile)file2).isPredefined()) {
                    return true;
                }
                if (!JSPsiImplUtils.signatureIsExplicitlyDeclared(overridden)) {
                    return true;
                }
                ProcessingContext context = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)overridden);
                JSParameterItem[] overriddenParameters = overridden.getParameters();
                if (overriddenParameters.length != parameters.length) {
                    String expectedSignature = JSSymbolPresentationUtils.buildFunctionSignaturePresentation(overridden);
                    if (reportProblems) {
                        holder.registerProblem((PsiElement)function.getParameterList(), JSBundle.message((String)"javascript.validation.message.function.override.incompatible.signature", (Object[])new Object[]{expectedSignature}), new LocalQuickFix[0]);
                    }
                    return false;
                }
                boolean result2 = true;
                for (int i = 0; i < parameters.length; ++i) {
                    JSParameterListElement source;
                    JSType type = parameters[i].getType();
                    JSType overriddenType = overriddenParameters[i].getType();
                    if (type == null || JSTypeUtils.areTypesCompatible(type, overriddenType, context, (PsiElement)function)) continue;
                    if (reportProblems && (source = parameters[i]) instanceof JSNamedElement) {
                        this.registerTypeMismatchProblem((JSNamedElement)source, overriddenType, "javascript.validation.message.function.method.invalid.overridden.parameter.type");
                    }
                    result2 = false;
                }
                JSType overriddenReturnType = overridden.getReturnType();
                JSType returnType = function.getReturnType();
                if (overriddenReturnType != null && returnType != null && !overriddenReturnType.isDirectlyAssignableType(returnType, context)) {
                    if (reportProblems) {
                        this.registerTypeMismatchProblem((JSNamedElement)function, overriddenReturnType, "javascript.validation.message.function.method.invalid.overridden.parameter.type");
                    }
                    result2 = false;
                }
                return result2;
            }

            private void registerTypeMismatchProblem(@NotNull JSNamedElement typedElement, @Nullable JSType overriddenType, @NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String key) {
                LocalQuickFix[] localQuickFixArray;
                if (typedElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (key == null) {
                    1.$$$reportNull$$$0(3);
                }
                String typeText = overriddenType != null ? overriddenType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
                String message = JSBundle.message((String)key, (Object[])new Object[]{typeText});
                PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)typedElement);
                if (comment != null && overriddenType != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new ChangeJSDocTypeFix(typedElement, (PsiElement)comment, overriddenType);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                PsiElement nameIdentifier = typedElement.getNameIdentifier();
                holder.registerProblem((PsiElement)(nameIdentifier != null ? nameIdentifier : typedElement), message, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typedElement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionSignatureChecker";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getFunctionSignatureChecker";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "registerTypeMismatchProblem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (jSElementVisitor == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    @NotNull
    private static JSTypeChecker getTypeChecker(PsiElement context, ProblemsHolder holder) {
        JSTypeChecker jSTypeChecker = JSAnalysisHandlersFactory.forElement(context).getTypeChecker(holder);
        if (jSTypeChecker == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(3);
        }
        return jSTypeChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeChecker";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

