/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalDeclarationsCache;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSUnusedGlobalDeclarationsWorker
implements JSUnusedGlobalDeclarationsCache {
    private final ZipperUpdater myUpdater;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Runnable myRunnable;
    private final Object myLock;
    private final Map<VirtualFile, DelegateFuture<Set<PsiElement>>> myFutureMap;
    private boolean myUpdateAll;
    private final ExecutorService myService;

    public JSUnusedGlobalDeclarationsWorker(@NotNull Project project) {
        if (project == null) {
            JSUnusedGlobalDeclarationsWorker.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myFutureMap = new HashMap<VirtualFile, DelegateFuture<Set<PsiElement>>>();
        this.myUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        this.myProject = project;
        this.myService = new ThreadPoolExecutor(0, Math.min(2, Runtime.getRuntime().availableProcessors()), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "JS unused declarations pool"));
        Disposer.register((Disposable)project, () -> this.myService.shutdownNow());
        this.myRunnable = this.createExecutor();
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        Object object = this.myLock;
        synchronized (object) {
            this.myUpdateAll = true;
        }
        if (Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            this.myUpdater.queue(this.myRunnable);
        }
    }

    @Override
    public void restartFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSUnusedGlobalDeclarationsWorker.$$$reportNull$$$0(1);
        }
        this.getUnusedDeclarationsFuture(file2);
        if (Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            this.myUpdater.queue(this.myRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileIsNotInterestingAnyMore(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSUnusedGlobalDeclarationsWorker.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myFutureMap.remove(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Set<PsiElement>> getUnusedDeclarationsFuture(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSUnusedGlobalDeclarationsWorker.$$$reportNull$$$0(3);
        }
        file2 = file2 instanceof VirtualFileWindow ? ((VirtualFileWindow)file2).getDelegate() : file2;
        Object object = this.myLock;
        synchronized (object) {
            DelegateFuture<Set<Object>> future = this.myFutureMap.get(file2);
            if (future == null) {
                future = new DelegateFuture();
                this.myFutureMap.put(file2, future);
            }
            return future;
        }
    }

    private Runnable createExecutor() {
        return () -> {
            Object object = this.myLock;
            synchronized (object) {
                ArrayList<VirtualFile> toProcess = new ArrayList<VirtualFile>();
                if (this.myUpdateAll) {
                    VirtualFile[] files = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
                    toProcess.addAll(Arrays.asList(files));
                }
                this.myFutureMap.forEach((file2, future) -> toProcess.add((VirtualFile)file2));
                this.myUpdateAll = false;
                List futures = toProcess.stream().map(file2 -> this.myService.submit(() -> this.calculateForFile((VirtualFile)file2))).collect(Collectors.toList());
                for (int i = 0; i < toProcess.size(); ++i) {
                    VirtualFile file3 = (VirtualFile)toProcess.get(i);
                    DelegateFuture<Set<Object>> delegateFuture = this.myFutureMap.get(file3);
                    if (delegateFuture == null) {
                        delegateFuture = new DelegateFuture();
                        this.myFutureMap.put(file3, delegateFuture);
                    }
                    delegateFuture.setFuture((Future)futures.get(i));
                }
            }
        };
    }

    private Set<PsiElement> calculateForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSUnusedGlobalDeclarationsWorker.$$$reportNull$$$0(4);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        return (Set)ReadAction.compute(() -> {
            if (file2 == null) {
                JSUnusedGlobalDeclarationsWorker.$$$reportNull$$$0(5);
            }
            if (this.myProject.isDisposed()) {
                return Collections.emptySet();
            }
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myFutureMap.containsKey(file2) || !file2.isValid()) {
                    return Collections.emptySet();
                }
            }
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null || !psiFile.isValid()) {
                return Collections.emptySet();
            }
            InspectionProfileImpl currentProfile = InspectionProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
            String shortName = InspectionProfileEntry.getShortName((String)JSUnusedGlobalSymbolsInspection.class.getSimpleName());
            InspectionToolWrapper tool = currentProfile.getInspectionTool(shortName, this.myProject);
            HighlightDisplayKey displayKey = HighlightDisplayKey.find((String)shortName);
            if (!currentProfile.isToolEnabled(displayKey, (PsiElement)psiFile)) {
                return Collections.emptySet();
            }
            JSUnusedGlobalSymbolsInspection inspection = (JSUnusedGlobalSymbolsInspection)tool.getTool();
            HashSet set = new HashSet();
            JSUnusedGlobalSymbolsInspection.MyJSElementVisitor visitor = new JSUnusedGlobalSymbolsInspection.MyJSElementVisitor(psiFile, (Consumer<PsiElement>)((Consumer)element -> set.add(element)), inspection.myReportUnusedDefinitions, inspection.myReportUnusedProperties);
            new MyVisitor(visitor).visitFile(psiFile);
            return set;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalDeclarationsWorker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "restartFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileIsNotInterestingAnyMore";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnusedDeclarationsFuture";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$calculateForFile$7";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DelegateFuture<T>
    implements Future<T> {
        private final Object myMonitor = new Object();
        private volatile Future<T> myFuture;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFuture(@NotNull Future<T> future) {
            if (future == null) {
                DelegateFuture.$$$reportNull$$$0(0);
            }
            Object object = this.myMonitor;
            synchronized (object) {
                this.myFuture = future;
                if (this.myFuture != null) {
                    this.myMonitor.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Object object = this.myMonitor;
            synchronized (object) {
                this.myMonitor.notifyAll();
            }
            if (this.myFuture != null) {
                return this.myFuture.cancel(mayInterruptIfRunning);
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.myFuture != null && this.myFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.myFuture != null && this.myFuture.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException, ExecutionException {
            Object object = this.myMonitor;
            synchronized (object) {
                while (this.myFuture == null) {
                    this.myMonitor.wait(100L);
                }
            }
            return this.myFuture.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public T get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            void unit;
            if (timeUnit == null) {
                DelegateFuture.$$$reportNull$$$0(1);
            }
            long start = System.currentTimeMillis();
            Object object = this.myMonitor;
            synchronized (object) {
                while (this.myFuture == null && System.currentTimeMillis() < start + unit.toMillis(timeout)) {
                    this.myMonitor.wait(100L);
                }
            }
            return this.myFuture.get(unit.toMillis(timeout) - (System.currentTimeMillis() - start), TimeUnit.MILLISECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalDeclarationsWorker$DelegateFuture";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFuture";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyVisitor
    extends JSRecursiveElementVisitor {
        @NotNull
        private final JSUnusedGlobalSymbolsInspection.MyJSElementVisitor myVisitor;

        private MyVisitor(@NotNull JSUnusedGlobalSymbolsInspection.MyJSElementVisitor visitor) {
            if (visitor == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myVisitor = visitor;
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.myVisitor.visitJSFunctionExpression(node);
            super.visitJSFunctionExpression(node);
        }

        public void visitJSProperty(JSProperty node) {
            this.myVisitor.visitJSProperty(node);
            super.visitJSProperty(node);
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            this.myVisitor.visitJSReferenceExpression(node);
            super.visitJSReferenceExpression(node);
        }

        public void visitJSDefinitionExpression(JSDefinitionExpression node) {
            this.myVisitor.visitJSDefinitionExpression(node);
            super.visitJSDefinitionExpression(node);
        }

        public void visitJSVariable(JSVariable node) {
            this.myVisitor.visitJSVariable(node);
            super.visitJSVariable(node);
        }

        public void visitJSFunctionDeclaration(JSFunction node) {
            this.myVisitor.visitJSFunctionDeclaration(node);
            super.visitJSFunctionDeclaration(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/inspections/JSUnusedGlobalDeclarationsWorker$MyVisitor", "<init>"));
        }
    }
}

