/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFileNameMismatchIntentionBase
extends JavaScriptIntention {
    @Nullable
    protected String myName = null;
    @Nullable
    protected String myFileName = null;
    @Nullable
    protected String myEntityDesc = null;
    @Nullable
    protected String myEntityName = null;

    @Nullable
    protected static JSClass findClass(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element instanceof JSReferenceExpression) {
            parent = element;
        } else {
            if (PsiUtilCore.getElementType((PsiElement)element) != JSTokenTypes.IDENTIFIER) {
                return null;
            }
            parent = element.getParent();
            if (!(parent instanceof JSReferenceExpression)) {
                return null;
            }
        }
        PsiElement parentParent = parent.getParent();
        return !(parentParent instanceof JSClass) ? null : (JSClass)parentParent;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSClass jsClass;
        if (project == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(2);
        }
        if (!JSFileNameMismatchIntentionBase.isTopLevelDeclaration(jsClass = JSFileNameMismatchIntentionBase.findClass(element)) || JSNameSuggestionsUtil.matchesFileNameByCodeStyle((JSNamedElement)jsClass)) {
            return false;
        }
        this.myName = jsClass.getName();
        if (this.myName == null) {
            return false;
        }
        this.myFileName = JSNameSuggestionsUtil.fileNameFromElementName((JSNamedElement)jsClass, this.myName);
        if (this.myFileName == null) {
            return false;
        }
        this.myEntityDesc = JSFormatUtil.formatEntityDescription((PsiElement)jsClass, this.myName);
        this.myEntityName = JSFormatUtil.formatEntityDescription((PsiElement)jsClass, null);
        return true;
    }

    @Contract(value="null -> false")
    private static boolean isTopLevelDeclaration(@Nullable JSClass jsClass) {
        if (jsClass == null) {
            return false;
        }
        PsiElement parent = jsClass.getParent();
        if (parent instanceof JSFile) {
            return true;
        }
        return parent instanceof ES6ExportDefaultAssignment && parent.getParent() instanceof JSFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/JSFileNameMismatchIntentionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

