/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintSuppressionUtil {
    private static final Pattern LINE_SUPPRESSION_PATTERN = Pattern.compile("//\\s*eslint-disable-next-line\\s*(\\S*)\\s*");
    private static final Pattern FILE_SUPPRESSION_PATTERN = Pattern.compile("/\\*\\s*eslint-disable\\s*(\\S+)\\s*\\*/");

    private EslintSuppressionUtil() {
    }

    public static SuppressQuickFix[] getBatchSuppressActions(@Nullable HighlightDisplayKey displayKey, @Nullable PsiElement element) {
        if (displayKey == null) {
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        Class<? extends JSSuppressionHolder> holderClass = JSInspectionSuppressor.getHolderClass(element);
        return new SuppressQuickFix[]{new SuppressForFileByCommentFix(displayKey, holderClass), new SuppressForLineByCommentFix(displayKey, holderClass)};
    }

    @NotNull
    public static List<IntentionAction> getSuppressionsForError(@NotNull JSLinterErrorBase error, boolean isOnTheFly) {
        String code;
        if (error == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(0);
        }
        JSLinterError linterError = error instanceof JSLinterError ? (JSLinterError)error : null;
        ArrayList list = ContainerUtil.newArrayList();
        String string = code = linterError != null ? linterError.getCode() : null;
        if (linterError == null || StringUtil.isEmpty((String)code)) {
            ArrayList arrayList = list;
            if (arrayList == null) {
                EslintSuppressionUtil.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        if (isOnTheFly) {
            list.add(new SuppressForLineIntentionAction(code, linterError.getLine()));
        }
        list.add(new SuppressForFileIntentionAction(code, linterError.getLine()));
        ArrayList arrayList = list;
        if (arrayList == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void insertFileSuppressionComment(@NotNull Project project, @NotNull PsiElement rootElement, @Nullable String ruleCode) {
        Matcher matcher;
        if (project == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(3);
        }
        if (rootElement == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(4);
        }
        String existingSuppressions = null;
        PsiComment suppressionComment = EslintSuppressionUtil.findFileSuppressionComment(rootElement);
        if (suppressionComment != null && (matcher = FILE_SUPPRESSION_PATTERN.matcher(suppressionComment.getText())).matches()) {
            existingSuppressions = matcher.group(1);
        }
        String rules = EslintSuppressionUtil.getRulesText(existingSuppressions, ruleCode);
        String commentText = String.format("/* eslint-disable%s */\n\n", !StringUtil.isEmpty((String)rules) ? ' ' + rules : "");
        ASTNode newComment = JSChangeUtil.createJSTreeFromText(project, commentText, DialectDetector.languageDialectOfElement(rootElement));
        if (newComment == null) {
            return;
        }
        if (suppressionComment != null) {
            suppressionComment.replace(newComment.getPsi());
        } else {
            rootElement.addBefore(newComment.getPsi(), rootElement.getFirstChild());
            boolean isScriptBlockInHtml = rootElement instanceof JSEmbeddedContent;
            if (isScriptBlockInHtml) {
                rootElement.addBefore(JSChangeUtil.createJSTreeFromText(project, "\n").getPsi(), rootElement.getFirstChild());
            }
        }
    }

    private static void insertLineSuppressionComment(@NotNull Project project, @NotNull Document document, @NotNull PsiElement rootElement, int lineNumber, @Nullable String ruleCode) {
        Matcher matcher;
        int previousLineEnd;
        int previousLineStart;
        if (project == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(5);
        }
        if (document == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(6);
        }
        if (rootElement == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(7);
        }
        String existingSuppressions = null;
        PsiElement existingComment = null;
        if (lineNumber > 0 && (existingComment = EslintSuppressionUtil.findLineCommentInRange(rootElement, previousLineStart = document.getLineStartOffset(lineNumber - 1), previousLineEnd = document.getLineEndOffset(lineNumber - 1))) != null && (matcher = LINE_SUPPRESSION_PATTERN.matcher(existingComment.getText())).matches()) {
            existingSuppressions = matcher.group(1);
        }
        String rules = EslintSuppressionUtil.getRulesText(existingSuppressions, ruleCode);
        String comment = String.format("//%seslint-disable-next-line%s\n", JSCodeStyleSettings.getLineCommentPrefix(rootElement), !StringUtil.isEmpty((String)rules) ? ' ' + rules : "");
        if (existingComment != null) {
            ASTNode newComment = JSChangeUtil.createJSTreeFromText(project, comment, DialectDetector.languageDialectOfElement(rootElement));
            if (newComment == null) {
                return;
            }
            existingComment.replace(newComment.getPsi());
        } else {
            int insertionOffset = document.getLineStartOffset(lineNumber);
            int rootElementStartOffset = rootElement.getNode().getStartOffset();
            if (rootElementStartOffset > insertionOffset) {
                insertionOffset = rootElementStartOffset;
                comment = "\n" + comment.trim();
            }
            document.insertString(insertionOffset, (CharSequence)comment);
        }
    }

    @Nullable
    private static PsiElement findLineCommentInRange(@NotNull PsiElement file2, int lineStart, int lineEnd) {
        if (file2 == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(8);
        }
        return EslintSuppressionUtil.findIntersectingLeaf(file2, lineStart, lineEnd, (Condition<PsiElement>)((Condition)element -> {
            PsiComment comment = element instanceof PsiComment ? (PsiComment)element : null;
            return comment != null && comment.getTokenType() == JSTokenTypes.END_OF_LINE_COMMENT && comment.getText().contains("eslint-disable-next-line");
        }));
    }

    @Nullable
    private static PsiElement findIntersectingLeaf(@NotNull PsiElement rootElement, int start, int end, @NotNull Condition<PsiElement> condition) {
        if (rootElement == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(9);
        }
        if (condition == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(10);
        }
        PsiElement element = rootElement.getContainingFile().getViewProvider().findElementAt(start);
        while (element != null) {
            if (element.getTextRange().intersects(start, end) && condition.value((Object)element)) {
                return element;
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return null;
    }

    @Nullable
    private static PsiElement getRootJsElement(PsiFile file2, int lineNumber) {
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        PsiElement jsElement = EslintSuppressionUtil.findIntersectingLeaf((PsiElement)file2, lineStartOffset, lineEndOffset, (Condition<PsiElement>)((Condition)leaf -> EslintSuppressionUtil.getRootJSElement(leaf) != null));
        return EslintSuppressionUtil.getRootJSElement(jsElement);
    }

    @Nullable
    private static PsiComment findFileSuppressionComment(@NotNull PsiElement rootElement) {
        if (rootElement == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(11);
        }
        Ref commentRef = new Ref();
        PsiTreeUtil.processElements((PsiElement)rootElement, element -> {
            if (rootElement == null) {
                EslintSuppressionUtil.$$$reportNull$$$0(15);
            }
            if (element != rootElement && !(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace)) {
                return false;
            }
            if (element instanceof PsiComment && element.getNode().getElementType() == JSTokenTypes.C_STYLE_COMMENT && element.getText().contains("eslint-disable")) {
                commentRef.set((Object)((PsiComment)element));
                return false;
            }
            return true;
        });
        return (PsiComment)commentRef.get();
    }

    @NotNull
    private static String getRulesText(@Nullable String existingSuppressions, @Nullable String ruleCode) {
        if (StringUtil.isEmpty((String)ruleCode)) {
            if ("" == null) {
                EslintSuppressionUtil.$$$reportNull$$$0(12);
            }
            return "";
        }
        if (!StringUtil.isEmpty((String)existingSuppressions)) {
            String string = existingSuppressions + "," + ruleCode;
            if (string == null) {
                EslintSuppressionUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = ruleCode;
        if (string == null) {
            EslintSuppressionUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    @Contract(value="null -> null")
    private static JSElement getRootJSElement(@Nullable PsiElement element) {
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class});
    }

    private static String getSuppressForLineDescription(@Nullable String code) {
        return String.format("Suppress %s for current line", EslintSuppressionUtil.getRuleDescription(code));
    }

    private static String getSuppressForFileDescription(String ruleCode) {
        return String.format("Suppress %s for current file", EslintSuppressionUtil.getRuleDescription(ruleCode));
    }

    private static String getRuleDescription(@Nullable String code) {
        return StringUtil.isEmpty((String)code) ? "all ESLint rules" : String.format("rule '%s'", code);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionsForError";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionsForError";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertFileSuppressionComment";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertLineSuppressionComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLineCommentInRange";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findIntersectingLeaf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileSuppressionComment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFileSuppressionComment$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SuppressForFileIntentionAction
    extends BaseIntentionAction {
        @NotNull
        private final String myRuleCode;
        private final int myLine;

        public SuppressForFileIntentionAction(@NotNull String code, int line) {
            if (code == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(0);
            }
            this.myRuleCode = code;
            this.myLine = line;
        }

        @NotNull
        public String getText() {
            String string = EslintSuppressionUtil.getSuppressForFileDescription(this.myRuleCode);
            if (string == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Suppress for current file" == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(2);
            }
            return "Suppress for current file";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(3);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            PsiElement rootElement;
            if (project == null) {
                SuppressForFileIntentionAction.$$$reportNull$$$0(4);
            }
            if ((rootElement = EslintSuppressionUtil.getRootJsElement(file2, this.myLine)) == null) {
                return;
            }
            EslintSuppressionUtil.insertFileSuppressionComment(project, rootElement, this.myRuleCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileIntentionAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileIntentionAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SuppressForLineIntentionAction
    extends BaseIntentionAction {
        @NotNull
        private final String myRuleCode;
        private final int myLineNumber;

        public SuppressForLineIntentionAction(@NotNull String myRuleCode, int lineNumber) {
            if (myRuleCode == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(0);
            }
            this.myRuleCode = myRuleCode;
            this.myLineNumber = lineNumber;
        }

        @NotNull
        public String getText() {
            String string = EslintSuppressionUtil.getSuppressForLineDescription(this.myRuleCode);
            if (string == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Suppress for current line" == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(2);
            }
            return "Suppress for current line";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(3);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project == null) {
                SuppressForLineIntentionAction.$$$reportNull$$$0(4);
            }
            Document document = ((Editor)ObjectUtils.assertNotNull((Object)editor)).getDocument();
            PsiElement rootJsElement = EslintSuppressionUtil.getRootJsElement(file2, this.myLineNumber);
            if (rootJsElement == null) {
                return;
            }
            EslintSuppressionUtil.insertLineSuppressionComment(project, document, rootJsElement, this.myLineNumber, this.myRuleCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myRuleCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineIntentionAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineIntentionAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SuppressForLineByCommentFix
    extends SuppressByCommentFix {
        public SuppressForLineByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends PsiElement> suppressionHolderClass) {
            if (key == null) {
                SuppressForLineByCommentFix.$$$reportNull$$$0(0);
            }
            if (suppressionHolderClass == null) {
                SuppressForLineByCommentFix.$$$reportNull$$$0(1);
            }
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress all rules for current line" == null) {
                SuppressForLineByCommentFix.$$$reportNull$$$0(2);
            }
            return "Suppress all rules for current line";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) {
            Document document;
            if (project == null) {
                SuppressForLineByCommentFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                SuppressForLineByCommentFix.$$$reportNull$$$0(4);
            }
            if (container == null) {
                SuppressForLineByCommentFix.$$$reportNull$$$0(5);
            }
            if ((document = JSLinterUtil.getDocumentForElement(element)) == null) {
                return;
            }
            EslintSuppressionUtil.insertLineSuppressionComment(project, document, element, document.getLineNumber(element.getTextOffset()), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suppressionHolderClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineByCommentFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineByCommentFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createSuppression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SuppressForFileByCommentFix
    extends SuppressByCommentFix {
        public SuppressForFileByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends PsiElement> suppressionHolderClass) {
            if (key == null) {
                SuppressForFileByCommentFix.$$$reportNull$$$0(0);
            }
            if (suppressionHolderClass == null) {
                SuppressForFileByCommentFix.$$$reportNull$$$0(1);
            }
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress all rules for file" == null) {
                SuppressForFileByCommentFix.$$$reportNull$$$0(2);
            }
            return "Suppress all rules for file";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) {
            JSElement rootElement;
            if (project == null) {
                SuppressForFileByCommentFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                SuppressForFileByCommentFix.$$$reportNull$$$0(4);
            }
            if (container == null) {
                SuppressForFileByCommentFix.$$$reportNull$$$0(5);
            }
            if ((rootElement = EslintSuppressionUtil.getRootJSElement(element)) != null) {
                EslintSuppressionUtil.insertFileSuppressionComment(project, (PsiElement)rootElement, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suppressionHolderClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileByCommentFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileByCommentFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createSuppression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

