/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.google.common.base.Supplier;
import com.google.common.io.CharStreams;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.jslint.JSLintConfigurable;
import com.intellij.lang.javascript.linter.jslint.JSLintConfiguration;
import com.intellij.lang.javascript.linter.jslint.JSLintInspection;
import com.intellij.lang.javascript.linter.jslint.JSLintOption;
import com.intellij.lang.javascript.linter.jslint.JSLintOptionsState;
import com.intellij.lang.javascript.linter.jslint.JSLintState;
import com.intellij.lang.javascript.linter.rhino.FunctionWithScope;
import com.intellij.lang.javascript.linter.rhino.RhinoFunctionManager;
import com.intellij.lang.javascript.linter.rhino.RhinoUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSLintExternalAnnotator
extends JSLinterExternalAnnotator<JSLintState> {
    private static final Logger LOG = Logger.getInstance(JSLintExternalAnnotator.class);
    private static final JSLintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new JSLintExternalAnnotator(false);
    public static final RhinoFunctionManager JSLINT_FUNCTION_MANAGER = new RhinoFunctionManager(new Supplier<String>(){

        public String get() {
            String fileName = "jslint.js";
            InputStream inputStream = this.getClass().getResourceAsStream(fileName);
            if (inputStream == null) {
                throw new RuntimeException("Resource " + fileName + " is not found!");
            }
            InputStreamReader reader = new InputStreamReader(inputStream);
            try {
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Can't read " + fileName + "!", e);
            }
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
    }, "jslint", null);

    @NotNull
    public static JSLintExternalAnnotator getInstanceForBatchInspection() {
        JSLintExternalAnnotator jSLintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (jSLintExternalAnnotator == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(0);
        }
        return jSLintExternalAnnotator;
    }

    public JSLintExternalAnnotator() {
        this(true);
    }

    public JSLintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<JSLintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(1);
        }
        JSLintConfigurable jSLintConfigurable = new JSLintConfigurable(project);
        if (jSLintConfigurable == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(2);
        }
        return jSLintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<JSLintState>> getConfigurationClass() {
        return JSLintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return JSLintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(3);
        }
        return file2 instanceof JSFile && JSUtils.isJavaScriptFile(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSLinterAnnotationResult<JSLintState> annotate(@NotNull JSLinterInput<JSLintState> collectedInfo) {
        if (collectedInfo == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(4);
        }
        Context cx = Context.enter();
        try {
            block11: {
                Object result2;
                block9: {
                    block10: {
                        FunctionWithScope functionWithScope = JSLINT_FUNCTION_MANAGER.getFunctionWithScope();
                        Function function = functionWithScope.getFunction();
                        Scriptable scope = functionWithScope.getScope();
                        JSLintState state = collectedInfo.getState();
                        JSLintOptionsState optionsState = state.getOptionsState();
                        NativeObject optionsNativeObject = JSLintExternalAnnotator.convertOptionsToNativeObject(optionsState);
                        String globals = StringUtil.notNullize((String)((String)ObjectUtils.tryCast((Object)optionsState.getValue(JSLintOption.GLOBALS), String.class)));
                        NativeArray globalsNativeArray = JSLinterUtil.convertPredefStrToNativeArray(globals, scope);
                        Object[] args = new Object[]{collectedInfo.getFileContent(), optionsNativeObject, globalsNativeArray};
                        result2 = function.call(cx, scope, scope, args);
                        if (!(result2 instanceof NativeObject)) break block9;
                        NativeObject resultObj = (NativeObject)result2;
                        Object warnings = resultObj.get("warnings", scope);
                        if (!(warnings instanceof NativeArray)) break block10;
                        List<JSLinterError> errors = JSLintExternalAnnotator.convertErrors((NativeArray)warnings);
                        JSLinterAnnotationResult<JSLintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(collectedInfo, errors, null);
                        Context.exit();
                        return jSLinterAnnotationResult;
                    }
                    JSLinterAnnotationResult<JSLintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(collectedInfo, Collections.emptyList(), null);
                    Context.exit();
                    return jSLinterAnnotationResult;
                }
                try {
                    LOG.warn("jslint unexpectedly returned " + (result2 != null ? result2.getClass() : null));
                }
                catch (JavaScriptException e) {
                    if (JSLintExternalAnnotator.tryPrintStack(e.getValue())) break block11;
                    LOG.warn((Throwable)e);
                }
            }
            JSLinterAnnotationResult<JSLintState> jSLinterAnnotationResult = null;
            return jSLinterAnnotationResult;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Context.exit();
        }
    }

    @NotNull
    private static List<JSLinterError> convertErrors(@NotNull NativeArray errorsNativeArray) {
        if (errorsNativeArray == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(5);
        }
        ArrayList errors = ContainerUtil.newArrayListWithCapacity((int)errorsNativeArray.size());
        for (Object errorObj : errorsNativeArray) {
            if (errorObj instanceof NativeObject) {
                JSLinterError error = JSLintExternalAnnotator.toLinterError((NativeObject)errorObj);
                if (error == null) continue;
                errors.add(error);
                continue;
            }
            JSLintExternalAnnotator.tryPrintStack(errorObj);
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean tryPrintStack(@Nullable Object errorObj) {
        if (errorObj instanceof ScriptableObject && "NativeError".equals(errorObj.getClass().getSimpleName())) {
            ScriptableObject nativeError = (ScriptableObject)errorObj;
            LOG.warn("Failed to run jslint: " + RhinoUtil.getStringKey(nativeError, "message") + "\n" + RhinoUtil.getStringKey(nativeError, "stack"));
            return true;
        }
        LOG.warn("Unexpected error of type " + (errorObj != null ? errorObj.getClass() : null));
        return false;
    }

    @Nullable
    private static JSLinterError toLinterError(@NotNull NativeObject nativeError) {
        if (nativeError == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(7);
        }
        int line = JSLintExternalAnnotator.toInt(nativeError.get((Object)"line"));
        int character = JSLintExternalAnnotator.toInt(nativeError.get((Object)"column"));
        if (line < 0 || character < 0) {
            return null;
        }
        String reason = RhinoUtil.getStringKey((ScriptableObject)nativeError, "message");
        if (reason != null) {
            return new JSLinterError(line + 1, character + 1, reason, null);
        }
        return null;
    }

    private static int toInt(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return -1;
    }

    @NotNull
    private static NativeObject convertOptionsToNativeObject(@NotNull JSLintOptionsState optionsState) {
        if (optionsState == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(8);
        }
        NativeObject object = new NativeObject();
        for (JSLintOption option : optionsState.getOptions()) {
            Object value = optionsState.getValue(option);
            if (option == JSLintOption.GLOBALS || value == null) continue;
            if (!(value instanceof Boolean || value instanceof String || value instanceof Number)) {
                throw new RuntimeException();
            }
            Object nativeObj = value;
            object.defineProperty(option.getOptionName(), nativeObj, 1);
        }
        NativeObject nativeObject = object;
        if (nativeObject == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(9);
        }
        return nativeObject;
    }

    @Override
    public void apply(@NotNull PsiFile file2, JSLinterAnnotationResult<JSLintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            JSLintExternalAnnotator.$$$reportNull$$$0(11);
        }
        if (annotationResult == null) {
            return;
        }
        new JSLinterAnnotationsBuilder<JSLintState>(file2, annotationResult, holder, JSLintInspection.getHighlightDisplayKey(), new JSLintConfigurable(file2.getProject()), "JSLint: ", this.getInspectionClass(), new JSLinterStandardFixes()).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsNativeArray";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeError";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsState";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceForBatchInspection";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jslint/JSLintExternalAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsConfigurable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertErrors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertOptionsToNativeObject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertErrors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toLinterError";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertOptionsToNativeObject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

