/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeNameValuePairImpl;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.JSParameterListStub;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import gnu.trove.TIntStack;
import org.jetbrains.annotations.NotNull;

public class FunctionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    public static final Key<String> methodsEmptinessKey = Key.create((String)"methodsEmptinessKey");
    public static final String METHODS_EMPTINESS_ALWAYS = "a";
    public static final String METHODS_EMPTINESS_POSSIBLY = "p";
    public static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY = Key.create((String)"js.generator.Function");
    public static final Key<Boolean> HAD_GET_SET = Key.create((String)"js.getsetParser");

    protected FunctionParser(T parser) {
        super(parser);
    }

    public boolean parseFunctionExpression() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD;
    }

    public void parseFunctionDeclaration() {
        String prevMethodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        try {
            PsiBuilder.Marker mark = this.builder.mark();
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
        this.parseAttributesList();
    }

    public boolean parseFunctionNoMarker(Context context, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            FunctionParser.$$$reportNull$$$0(0);
        }
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD && context != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSTokenTypes.MULT && this.isJSorTS()) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        boolean wasGenerator = this.isGeneratorContext();
        this.setIsGenerator(isGeneratorContext);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]));
            parsedWithoutErrors = false;
        }
        parsedWithoutErrors &= this.parseParameterList(context == Context.EXPRESSION || context == Context.PROPERTY);
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        String methodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        if (methodEmptiness == null) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
        } else if (METHODS_EMPTINESS_ALWAYS.equals(methodEmptiness)) {
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                String key = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? "javascript.ambient.declaration.should.have.no.body" : "interface.function.declaration.should.have.no.body";
                parsedWithoutErrors = false;
                this.builder.error(JSBundle.message((String)key, (Object[])new Object[0]));
            }
        } else if (METHODS_EMPTINESS_POSSIBLY.equals(methodEmptiness)) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            } else if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            }
        }
        functionMarker.done(context == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.setIsGenerator(wasGenerator);
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, Context context) {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        if ((dialect == null || dialect.getOptionHolder().hasFeature(JSLanguageFeature.E4X)) && this.parseGetSetAndNameAfterFunctionKeyword(context)) {
            return true;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(this.isIdentifierToken(tokenType) || functionKeywordWasOmitted && JSKeywordSets.PROPERTY_NAMES.contains(tokenType))) {
            return context == Context.EXPRESSION;
        }
        this.parseFunctionIdentifier();
        return true;
    }

    protected boolean parseGetSetAndNameAfterFunctionKeyword(Context context) {
        IElementType firstToken = this.builder.getTokenType();
        if (JSTokenTypes.GET_SET.contains(firstToken) && context != Context.EXPRESSION) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (JSKeywordSets.PROPERTY_NAMES.contains(lookAhead)) {
                this.builder.advanceLexer();
            } else if (context == Context.PROPERTY && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(lookAhead)) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parsePropertyName();
                return true;
            }
        }
        return false;
    }

    public void parseFunctionIdentifier() {
        this.builder.advanceLexer();
    }

    public IElementType getFunctionDeclarationElementType() {
        return JSStubElementTypes.FUNCTION_DECLARATION;
    }

    public boolean parseAttributesList() {
        PsiBuilder.Marker mark = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.EXPORT_KEYWORD || type == JSTokenTypes.GET_KEYWORD || type == JSTokenTypes.SET_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark.done(this.getAttributeListElementType());
        return true;
    }

    public JSStubElementType<JSAttributeListStub, JSAttributeList> getAttributeListElementType() {
        return JSStubElementTypes.ATTRIBUTE_LIST;
    }

    public void parseES7Decorators() {
        if (this.hasSupportDecorators()) {
            PsiBuilder.Marker attribute = this.builder.mark();
            this.builder.advanceLexer();
            Object expressionParser = this.myJavaScriptParser.getExpressionParser();
            ((ExpressionParser)expressionParser).parseLeftHandSideExpression(false);
            attribute.done(JSStubElementTypes.ES6_DECORATOR);
        } else {
            this.builder.advanceLexer();
        }
    }

    public boolean tryParseES7Decorators() {
        boolean hadAnnotation = false;
        if (this.hasSupportDecorators()) {
            while (this.builder.getTokenType() == JSTokenTypes.AT) {
                this.parseES7Decorators();
                hadAnnotation = true;
            }
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    public void parseAttributeBody() {
        boolean haveLParen = FunctionParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        while (haveLParen) {
            boolean hasName = JSAttributeNameValuePairImpl.IDENTIFIER_TOKENS_SET.contains(this.builder.getTokenType());
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifer.or.value", (Object[])new Object[0]));
                break;
            }
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RPAR) break;
            PsiBuilder.Marker attributeNameValuePair = this.builder.mark();
            this.builder.advanceLexer();
            if (hasName && this.builder.getTokenType() != JSTokenTypes.COMMA && this.builder.getTokenType() != JSTokenTypes.RPAR) {
                FunctionParser.checkMatches(this.builder, JSTokenTypes.EQ, "javascript.parser.message.expected.equal");
                IElementType type = this.builder.getTokenType();
                if (type != JSTokenTypes.COMMA && type != JSTokenTypes.RBRACKET && type != JSTokenTypes.RPAR) {
                    if (type == JSTokenTypes.IDENTIFIER) {
                        PsiBuilder.Marker ident = this.builder.mark();
                        this.builder.advanceLexer();
                        IElementType nextTokenType = this.builder.getTokenType();
                        ident.rollbackTo();
                        if (!JSTokenTypes.STRING_LITERALS.contains(nextTokenType)) {
                            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseSimpleExpression();
                        } else {
                            this.builder.advanceLexer();
                        }
                    } else {
                        this.builder.advanceLexer();
                    }
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.value", (Object[])new Object[0]));
                }
            }
            if (attributeNameValuePair != null) {
                attributeNameValuePair.done(JSStubElementTypes.ATTRIBUTE_NAME_VALUE_PAIR);
            }
            if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
            this.builder.advanceLexer();
            if (!this.builder.eof()) continue;
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
            return;
        }
        if (haveLParen) {
            FunctionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        } else {
            this.builder.advanceLexer();
        }
    }

    public boolean parseParameterList(boolean funExpr) {
        if (!((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeParameterList()) {
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]));
            if (!funExpr) {
                PsiBuilder.Marker parameterList = this.builder.mark();
                parameterList.done(this.getParameterListElementType());
            }
            return false;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasErrors = false;
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && this.allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                hasErrors = true;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            }
            hasErrors |= !this.parseSingleParameter(parameter);
        }
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(this.getParameterListElementType());
        if (first) {
            return true;
        }
        return !hasErrors;
    }

    protected boolean parseSingleParameter(PsiBuilder.Marker parameter) {
        ParseResult result2 = this.doParseSingleParameter();
        if (result2.acceptResult) {
            parameter.done(result2.elementType);
        } else {
            parameter.drop();
        }
        return !result2.hasCriticalErrors;
    }

    protected ParseResult doParseSingleParameter() {
        boolean acceptResult;
        IElementType tokenType;
        boolean hasCriticalErrors = false;
        boolean hasOtherErrors = false;
        IElementType elementType = this.getParameterType();
        boolean allowPropertyNameAsIdentifier = this.parseParameterAttributeList();
        if (this.isParameterName(allowPropertyNameAsIdentifier, tokenType = this.builder.getTokenType())) {
            this.builder.advanceLexer();
            this.parseParameterOptionalMark();
            if (!this.tryParseArrowFunctionParameterType()) {
                hasOtherErrors = true;
            }
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                PsiBuilder.Marker m = null;
                if (!this.hasParameterInitializers()) {
                    m = this.builder.mark();
                }
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true);
                if (m != null) {
                    m.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                    hasCriticalErrors = true;
                }
            }
            acceptResult = true;
        } else if (this.willParseDestructuringAssignment()) {
            elementType = ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElementNoMarker((IElementType)this.getParameterType(), true, true);
            acceptResult = true;
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.formal.parameter.name", (Object[])new Object[0]));
            hasCriticalErrors = true;
            if (this.hasParameterInitializers() && this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true);
            } else {
                ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            }
            acceptResult = false;
        }
        return new ParseResult(hasCriticalErrors, hasOtherErrors, acceptResult, elementType);
    }

    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType);
    }

    protected boolean allowLastCommaInParameterAndArgumentList() {
        return false;
    }

    protected boolean tryParseArrowFunctionParameterType() {
        boolean looksLikeParameterList = this.builder.getTokenType() == JSTokenTypes.COLON;
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        return looksLikeParameterList;
    }

    public JSStubElementType<JSParameterStub, JSParameter> getParameterType() {
        return JSStubElementTypes.FORMAL_PARAMETER;
    }

    public void parseParameterOptionalMark() {
    }

    protected boolean willParseDestructuringAssignment() {
        return !this.isECMAL4() && FunctionParser.willParseDestructuringAssignment(this.builder.getTokenType());
    }

    private static boolean willParseDestructuringAssignment(IElementType tokenType) {
        return tokenType == JSTokenTypes.LBRACKET || tokenType == JSTokenTypes.LBRACE;
    }

    protected boolean hasParameterInitializers() {
        return false;
    }

    protected boolean parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.tryParseES7Decorators();
            mark.done(this.getAttributeListElementType());
        }
        return false;
    }

    public boolean parseArrowFunction() {
        return this.parseArrowFunctionWithoutModifiers(this.builder.mark());
    }

    protected boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        IElementType firstToken;
        if (arrowFunction == null) {
            FunctionParser.$$$reportNull$$$0(1);
        }
        if (this.isIdentifierToken(firstToken = this.builder.getTokenType()) && JSTokenTypes.ARROWS.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker parameterList = this.builder.mark();
            PsiBuilder.Marker parameter = this.builder.mark();
            this.builder.advanceLexer();
            parameter.done(this.getParameterType());
            parameterList.done(this.getParameterListElementType());
            parameterList.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            if (!this.isArrowFunctionWithParentheses()) {
                arrowFunction.rollbackTo();
                return false;
            }
            this.parseParameterList(true);
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType();
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSTokenTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseBlockOrFunctionBody(StatementParser.BlockType.ARROW_FUNCTION_BODY);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.eqgt", (Object[])new Object[0]));
        }
        arrowFunction.done(this.getFunctionExpressionElementType());
        arrowFunction.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    private boolean isArrowFunctionWithParentheses() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            this.builder.advanceLexer();
            int balance = 1;
            while (!this.builder.eof()) {
                IElementType tokenType = this.builder.getTokenType();
                if (tokenType == JSTokenTypes.LT) {
                    ++balance;
                } else if (tokenType == JSTokenTypes.GT) {
                    --balance;
                }
                this.builder.advanceLexer();
                if (balance != 0) continue;
                break;
            }
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            marker.rollbackTo();
            return false;
        }
        IElementType next = this.builder.lookAhead(1);
        if (!(!this.isJSorTS() && !this.isECMAL4() || this.isParameterName(true, next) || next == JSTokenTypes.RPAR || next == JSTokenTypes.DOT_DOT_DOT || !this.isECMAL4() && FunctionParser.willParseDestructuringAssignment(next))) {
            marker.rollbackTo();
            return false;
        }
        TIntStack braceBalance = new TIntStack();
        boolean seenQuestion = false;
        boolean isEmpty = false;
        while (!this.builder.eof()) {
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.LPAR) {
                if (braceBalance.size() == 0 && this.builder.lookAhead(1) == JSTokenTypes.RPAR) {
                    isEmpty = true;
                }
                braceBalance.push(1);
            } else if (tokenType == JSTokenTypes.RPAR) {
                if (braceBalance.size() == 0 || braceBalance.pop() != 1) {
                    marker.rollbackTo();
                    return false;
                }
                if (braceBalance.size() == 0) {
                    this.builder.advanceLexer();
                    break;
                }
            } else if (tokenType == JSTokenTypes.LBRACE) {
                braceBalance.push(2);
            } else if (tokenType == JSTokenTypes.RBRACE) {
                if (braceBalance.size() == 0 || braceBalance.pop() != 2) {
                    marker.rollbackTo();
                    return false;
                }
            } else if (tokenType == JSTokenTypes.LBRACKET) {
                braceBalance.push(3);
            } else if (tokenType == JSTokenTypes.RBRACKET) {
                if (braceBalance.size() == 0 || braceBalance.pop() != 3) {
                    marker.rollbackTo();
                    return false;
                }
            } else if (tokenType == JSTokenTypes.QUEST) {
                if (braceBalance.size() == 1 && braceBalance.peek() == 1) {
                    if (this.builder.lookAhead(1) == JSTokenTypes.COLON) {
                        marker.rollbackTo();
                        return true;
                    }
                    seenQuestion = true;
                }
            } else if (tokenType == JSTokenTypes.COLON) {
                if (braceBalance.size() == 1 && braceBalance.peek() == 1) {
                    if (seenQuestion) {
                        marker.rollbackTo();
                        return false;
                    }
                    if (!this.supportsColonTypeCast()) {
                        marker.rollbackTo();
                        return true;
                    }
                }
            } else if (tokenType == JSTokenTypes.COMMA && braceBalance.size() == 1 && braceBalance.peek() == 1) {
                if (this.builder.lookAhead(1) == JSTokenTypes.EQ) {
                    marker.rollbackTo();
                    return true;
                }
                seenQuestion = false;
            }
            this.builder.advanceLexer();
        }
        if (isEmpty && this.builder.getTokenType() == JSTokenTypes.COLON) {
            marker.rollbackTo();
            return true;
        }
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType();
        boolean result2 = JSTokenTypes.ARROWS.contains(this.builder.getTokenType());
        marker.rollbackTo();
        return result2;
    }

    protected boolean supportsColonTypeCast() {
        return false;
    }

    public JSStubElementType<JSParameterListStub, JSParameterList> getParameterListElementType() {
        return JSStubElementTypes.PARAMETER_LIST;
    }

    protected IElementType getFunctionExpressionElementType() {
        return JSStubElementTypes.FUNCTION_EXPRESSION;
    }

    public boolean isAsyncContext() {
        return Boolean.TRUE.equals(this.builder.getUserData(ASYNC_METHOD_KEY));
    }

    public void setIsGenerator(boolean isGenerator) {
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).hasGeneratorsSupport()) {
            return;
        }
        this.builder.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }

    public boolean isGeneratorContext() {
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).hasGeneratorsSupport()) {
            return false;
        }
        return Boolean.TRUE.equals(this.builder.getUserData(IS_GENERATOR_FUNCTION_KEY));
    }

    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        boolean lexerAdvanced = ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterList(false);
        lexerAdvanced |= ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/parsing/FunctionParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseFunctionNoMarker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseArrowFunctionWithoutModifiers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class ParseResult {
        public final boolean hasCriticalErrors;
        public final boolean hasOtherErrors;
        public final boolean acceptResult;
        public final IElementType elementType;

        public ParseResult(boolean hasCriticalErrors, boolean hasOtherErrors, boolean acceptResult, IElementType elementType) {
            this.hasCriticalErrors = hasCriticalErrors;
            this.acceptResult = acceptResult;
            this.elementType = elementType;
            this.hasOtherErrors = hasOtherErrors;
        }
    }

    public static enum Context {
        EXPRESSION,
        SOURCE_ELEMENT,
        PROPERTY;

    }
}

