/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNumberLiteralTypeImpl
extends JSNumberType
implements JSPrimitiveLiteralType<Double> {
    private final double myLiteral;
    private final boolean myCanBeWidened;
    @Nullable
    private final String myValueAsString;

    /*
     * WARNING - void declaration
     */
    public JSNumberLiteralTypeImpl(double literal, boolean canBeWidened, @NotNull JSTypeSource source, @Nullable String string) {
        void valueAsString;
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myCanBeWidened = canBeWidened;
        this.myValueAsString = valueAsString;
    }

    @NotNull
    public String getValueAsString() {
        String string = this.myValueAsString != null ? this.myValueAsString : Double.toString(this.myLiteral);
        if (string == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public Double getLiteral() {
        return this.myLiteral;
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String stringVal;
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Number" == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(2);
            }
            return "Number";
        }
        String string = stringVal = this.myValueAsString != null ? this.myValueAsString : Double.toString(this.myLiteral);
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            String string2 = this.isTypeScript() && (!this.canBeWidened() || format != JSType.TypeTextFormat.CODE) ? stringVal : "number";
            if (string2 == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(3);
            }
            return string2;
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string3 = stringVal + (!this.myCanBeWidened ? "!" : "");
            if (string3 == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(4);
            }
            return string3;
        }
        String string4 = "Number(" + stringVal + ")";
        if (string4 == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        return string4;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        if (elementType instanceof JSNumberLiteralTypeImpl && this.getSource().isStrict() && !this.myCanBeWidened) {
            return this.myLiteral == ((JSNumberLiteralTypeImpl)elementType).myLiteral;
        }
        if (!this.myCanBeWidened && elementType instanceof JSNumberType) {
            return false;
        }
        if (!this.myCanBeWidened && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType != null && resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                Double numericValue = value.getNumericValue();
                return numericValue != null && numericValue == this.myLiteral;
            }
            if (resolvedType != null && resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        return type instanceof JSNumberLiteralTypeImpl && this.myLiteral == ((JSNumberLiteralTypeImpl)type).myLiteral;
    }

    @Override
    @NotNull
    public JSType asPrimitiveType() {
        JSType jSType = JSNamedType.createType("number", this.getSource(), this.getTypeContext());
        if (jSType == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSNumberLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(this.getLiteral(), this.myCanBeWidened, source, this.myValueAsString);
        if (jSNumberLiteralTypeImpl == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        return jSNumberLiteralTypeImpl;
    }

    @Override
    public boolean canBeWidened() {
        return this.myCanBeWidened;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithCanBeWidened(boolean canBeWidened) {
        JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(this.myLiteral, canBeWidened, this.getSource(), this.myValueAsString);
        if (jSNumberLiteralTypeImpl == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return jSNumberLiteralTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asPrimitiveType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithCanBeWidened";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

