/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeCache {
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, JSRecordType> myCache = ContainerUtil.createConcurrentWeakMap();

    @NotNull
    public JSRecordType buildRecordType(@NotNull JSType type, @NotNull PsiElement context) {
        JSResolvedTypeId id;
        JSRecordType recordType;
        if (type == null) {
            JSRecordTypeCache.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSRecordTypeCache.$$$reportNull$$$0(1);
        }
        if ((recordType = (JSRecordType)this.myCache.get(id = type.getResolvedTypeId())) != null) {
            JSRecordType jSRecordType = recordType;
            if (jSRecordType == null) {
                JSRecordTypeCache.$$$reportNull$$$0(2);
            }
            return jSRecordType;
        }
        JSRecordType result2 = JSRecordTypeCache.buildRecordTypeNoCache(type, context);
        if (result2 == null) {
            Object object = type.isJavaScript() ? JSTypeCastUtil.NO_RECORD_TYPE : new JSRecordTypeImpl(type.getSource(), ContainerUtil.emptyList());
            if (object == null) {
                JSRecordTypeCache.$$$reportNull$$$0(3);
            }
            return object;
        }
        JSRecordType newResult = this.myCache.putIfAbsent(id, result2);
        JSRecordType jSRecordType = newResult == null ? result2 : newResult;
        if (jSRecordType == null) {
            JSRecordTypeCache.$$$reportNull$$$0(4);
        }
        return jSRecordType;
    }

    @Nullable
    private static JSRecordType buildRecordTypeNoCache(@NotNull JSType type, @NotNull PsiElement element) {
        if (type == null) {
            JSRecordTypeCache.$$$reportNull$$$0(5);
        }
        if (element == null) {
            JSRecordTypeCache.$$$reportNull$$$0(6);
        }
        Object id = JSRecordTypeCache.getIdForPreventingRecursion(type);
        return (JSRecordType)RecursionManager.doPreventingRecursion((Object)id, (boolean)false, () -> {
            if (type == null) {
                JSRecordTypeCache.$$$reportNull$$$0(13);
            }
            if (element == null) {
                JSRecordTypeCache.$$$reportNull$$$0(14);
            }
            JSType substitute = type.substitute();
            ProgressManager.checkCanceled();
            if (substitute != type) {
                return substitute.asRecordType();
            }
            Collection<? extends PsiElement> resolvedElements = JSRecordTypeCache.resolveElementsForRecordType(type, element);
            if (type.isJavaScript() && (resolvedElements.isEmpty() || type instanceof JSObjectType)) {
                return JSTypeCastUtil.NO_RECORD_TYPE;
            }
            return TypeScriptTypeParser.buildResolvedType(resolvedElements, type);
        });
    }

    @NotNull
    private static Object getIdForPreventingRecursion(@NotNull JSType type) {
        if (type == null) {
            JSRecordTypeCache.$$$reportNull$$$0(7);
        }
        if (type instanceof JSGenericTypeImpl) {
            Pair pair = Pair.create((Object)((JSGenericTypeImpl)type).getType().getResolvedTypeId(), type.getClass());
            if (pair == null) {
                JSRecordTypeCache.$$$reportNull$$$0(8);
            }
            return pair;
        }
        JSResolvedTypeId jSResolvedTypeId = type.getResolvedTypeId();
        if (jSResolvedTypeId == null) {
            JSRecordTypeCache.$$$reportNull$$$0(9);
        }
        return jSResolvedTypeId;
    }

    @NotNull
    private static Collection<? extends PsiElement> resolveElementsForRecordType(@NotNull JSType type, @NotNull PsiElement element) {
        if (type == null) {
            JSRecordTypeCache.$$$reportNull$$$0(10);
        }
        if (element == null) {
            JSRecordTypeCache.$$$reportNull$$$0(11);
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, element);
        if (collection == null) {
            JSRecordTypeCache.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeCache";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeCache";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForPreventingRecursion";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsForRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeNoCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIdForPreventingRecursion";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsForRecordType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildRecordTypeNoCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

