/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSRecordTypeCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeComparingCacheService {
    @NotNull
    private final CachedValue<JSTypeComparingCache> myCachedContext;
    private final CachedValue<JSTypeComparingCache> mySubtypingCachedContext;
    private final CachedValue<JSRecordTypeCache> myRecordTypesCache;

    @NotNull
    private JSTypeComparingCache getComparingCache() {
        JSTypeComparingCache jSTypeComparingCache = (JSTypeComparingCache)this.myCachedContext.getValue();
        if (jSTypeComparingCache == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(0);
        }
        return jSTypeComparingCache;
    }

    @NotNull
    private JSTypeComparingCache getSubtypingComparingCache() {
        JSTypeComparingCache jSTypeComparingCache = (JSTypeComparingCache)this.mySubtypingCachedContext.getValue();
        if (jSTypeComparingCache == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(1);
        }
        return jSTypeComparingCache;
    }

    public JSTypeComparingCacheService(@NotNull Project project) {
        if (project == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(2);
        }
        this.myCachedContext = JSTypeComparingCacheService.buildCache(project);
        this.mySubtypingCachedContext = JSTypeComparingCacheService.buildCache(project);
        this.myRecordTypesCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)new JSRecordTypeCache(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
    }

    @NotNull
    private static CachedValue<JSTypeComparingCache> buildCache(@NotNull Project project) {
        if (project == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(3);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            if (project == null) {
                JSTypeComparingCacheService.$$$reportNull$$$0(16);
            }
            return CachedValueProvider.Result.create((Object)new JSTypeComparingCache(project), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }, false);
        if (cachedValue == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(4);
        }
        return cachedValue;
    }

    @Nullable
    public static JSTypeComparingCache getComparingCache(@NotNull Project project, boolean subtyping) {
        if (project == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(5);
        }
        if (DumbService.isDumb((Project)project) || project.isDefault()) {
            return null;
        }
        JSTypeComparingCacheService service = (JSTypeComparingCacheService)ServiceManager.getService((Project)project, JSTypeComparingCacheService.class);
        return service == null ? null : (subtyping ? service.getSubtypingComparingCache() : service.getComparingCache());
    }

    @NotNull
    public JSRecordTypeCache getRecordTypesCache() {
        JSRecordTypeCache jSRecordTypeCache = (JSRecordTypeCache)this.myRecordTypesCache.getValue();
        if (jSRecordTypeCache == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(6);
        }
        return jSRecordTypeCache;
    }

    @NotNull
    public static JSRecordType buildRecordType(@NotNull JSType type) {
        PsiElement element;
        if (type == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(7);
        }
        if ((element = type.getSource().getSourceElement()) == null || !element.isValid()) {
            JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(ContainerUtil.emptyList(), type);
            if (jSRecordType == null) {
                JSTypeComparingCacheService.$$$reportNull$$$0(8);
            }
            return jSRecordType;
        }
        Project project = element.getProject();
        if (DumbService.isDumb((Project)project) || project.isDefault()) {
            JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(ContainerUtil.emptyList(), type);
            if (jSRecordType == null) {
                JSTypeComparingCacheService.$$$reportNull$$$0(9);
            }
            return jSRecordType;
        }
        JSTypeComparingCacheService service = (JSTypeComparingCacheService)ServiceManager.getService((Project)project, JSTypeComparingCacheService.class);
        if (service == null) {
            JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(ContainerUtil.emptyList(), type);
            if (jSRecordType == null) {
                JSTypeComparingCacheService.$$$reportNull$$$0(10);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = service.getRecordTypesCache().buildRecordType(type, element);
        if (jSRecordType == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(11);
        }
        return jSRecordType;
    }

    @NotNull
    public static ProcessingContext getProcessingContextWithCache(@Nullable PsiElement element) {
        ProcessingContext processingContext = JSTypeComparingCacheService.getProcessingContextWithCache(element, false);
        if (processingContext == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(12);
        }
        return processingContext;
    }

    @NotNull
    private static ProcessingContext getProcessingContextWithCache(@Nullable PsiElement element, boolean subTyping) {
        ProcessingContext processingContext = new ProcessingContext();
        if (element == null || !element.isValid()) {
            ProcessingContext processingContext2 = processingContext;
            if (processingContext2 == null) {
                JSTypeComparingCacheService.$$$reportNull$$$0(13);
            }
            return processingContext2;
        }
        JSTypeComparingCache cache = JSTypeComparingCacheService.getComparingCache(element.getProject(), subTyping);
        if (cache != null) {
            processingContext.put(JSTypeComparingCache.TYPE_COMPARATOR, (Object)cache);
        }
        ProcessingContext processingContext3 = processingContext;
        if (processingContext3 == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(14);
        }
        return processingContext3;
    }

    public static ProcessingContext getSubtypingProcessingContext(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeComparingCacheService.$$$reportNull$$$0(15);
        }
        ProcessingContext context = JSTypeComparingCacheService.getProcessingContextWithCache(element, true);
        context.put(JSTypeComparingCache.SUBTYPING_CONTEXT, (Object)true);
        return context;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCacheService";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparingCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubtypingComparingCache";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCacheService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordTypesCache";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordType";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingContextWithCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildCache";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getComparingCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSubtypingProcessingContext";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildCache$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

