/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptLiteralBasedPropertyElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSMappedTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptMappedJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSTypeWithIncompleteSubstitution {
    private final boolean myReadonly;
    private final boolean myMinusReadonly;
    private final boolean myOptional;
    private final boolean myMinusOptional;
    @Nullable
    private final String myParameterName;
    @NotNull
    private final JSType myParameterType;
    @NotNull
    private final JSType myResultType;
    private static final Key<CachedValue<JSType>> completenessTrue = new Key("TSMAPPED.TRUE");
    private static final Key<CachedValue<JSType>> completenessFalse = new Key("TSMAPPED.FALSE");
    private static final int MAX_SOURCE_DEPTH = 10;

    public TypeScriptMappedJSTypeImpl(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, boolean isMinusReadonly, boolean isMinusOptional, @Nullable String parameterName, @NotNull JSType parameterType, @NotNull JSType resultType) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (resultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myReadonly = isReadonly;
        this.myMinusReadonly = isMinusReadonly;
        this.myOptional = isOptional;
        this.myMinusOptional = isMinusOptional;
        this.myParameterName = parameterName;
        this.myParameterType = parameterType;
        this.myResultType = resultType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean isSerialized = format == JSType.TypeTextFormat.SERIALIZED;
        StringBuilder builder = new StringBuilder();
        if (isSerialized) {
            builder.append("#mapped");
        }
        builder.append("{");
        boolean readonly = this.isReadonly();
        boolean minusReadonly = this.isMinusReadonly();
        if (readonly || minusReadonly) {
            builder.append(isSerialized ? (readonly ? "r" : "R") : (minusReadonly ? "-readonly " : "readonly "));
        }
        builder.append("[");
        String name = this.getParameterName();
        builder.append(name == null ? "MapParameter" : name);
        builder.append(isSerialized ? "+" : " in ");
        builder.append(this.getParameterType().getTypeText(format));
        builder.append("]");
        boolean optional = this.isOptional();
        boolean minusOptional = this.isMinusOptional();
        if (optional || minusOptional) {
            builder.append(optional ? "?" : (isSerialized ? "!" : "-?"));
        }
        builder.append(this.getTypeSeparator(format, ":"));
        builder.append(this.getResultType().getTypeText(format));
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.getParameterType().resolvedHashCode(), this.getResultType().resolvedHashCode());
    }

    @Override
    @NotNull
    protected TypeScriptMappedJSTypeImpl copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(4);
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(this.getSource(), this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), this.myParameterName, JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform), JSTypeUtils.transformTypeHierarchySafe(this.getResultType(), childTransform));
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(5);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(6);
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(source, this.myReadonly, this.myOptional, this.myMinusReadonly, this.myMinusOptional, this.myParameterName, this.myParameterType, this.myResultType);
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(7);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        String name;
        JSType substitute;
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(8);
        }
        if ((substitute = this.substitute()) != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        JSType paramType = this.getParameterType();
        if (JSTypeCastUtil.isTypeOperatorLikeType(paramType) && (name = this.getParameterName()) != null && this.getResultType().isDirectlyAssignableType((JSType)new TypeScriptIndexedAccessJSTypeImpl(elementType, JSNamedType.createType(name, this.getSource(), JSTypeContext.INSTANCE), this.getSource()), processingContext)) {
            if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && paramType instanceof JSGenericParameterImpl) {
                paramType.isDirectlyAssignableType((JSType)new TypeScriptTypeOperatorJSTypeImpl(elementType, this.getSource()), processingContext);
            }
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.substituteWithPreventingRecursion(false);
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @NotNull
    public JSType substituteCompletely() {
        JSType jSType = this.substituteWithPreventingRecursion(true);
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @NotNull
    public JSType substituteWithPreventingRecursion(boolean complete) {
        JSType type = (JSType)RecursionManager.doPreventingRecursion((Object)this.getResolvedTypeId(), (boolean)false, () -> this.substituteImpl(complete));
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = type == null ? this : type;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(11);
        }
        return typeScriptMappedJSTypeImpl;
    }

    private JSType substituteImpl(boolean complete) {
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        if (element != null && element.isValid()) {
            CachedValuesManager manager = CachedValuesManager.getManager((Project)element.getProject());
            return (JSType)manager.getCachedValue((UserDataHolder)this, complete ? completenessTrue : completenessFalse, () -> CachedValueProvider.Result.create((Object)this.substituteInternal(complete), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
        }
        return this.substituteInternal(complete);
    }

    private boolean hasGenericParameterExceptOwn(JSType type) {
        String name = this.getParameterName();
        return JSTypeUtils.hasTypes(type, true, (Condition<JSType>)((Condition)t -> t instanceof JSGenericParameterImpl && (name == null || !TypeScriptMappedJSTypeImpl.isParameter(name, t))));
    }

    @NotNull
    private JSType substituteInternal(boolean complete) {
        JSType parameterType = this.getParameterType();
        JSType originalResultType = this.getResultType();
        if (!complete && (JSTypeUtils.hasGenericParameter(parameterType) || this.hasGenericParameterExceptOwn(originalResultType))) {
            TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
            if (typeScriptMappedJSTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(12);
            }
            return typeScriptMappedJSTypeImpl;
        }
        JSType type = JSTypeUtils.getValuableType(parameterType);
        Collection<String> strings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(type);
        String name = this.getParameterName();
        if (strings.isEmpty() || name == null) {
            JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isStrict());
            if (jSAnyType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(13);
            }
            return jSAnyType;
        }
        JSType resultType = JSTypeUtils.getValuableType(originalResultType, false);
        boolean hasOptionalKeyword = this.isOptional();
        boolean hasMinusOptionalKeyword = this.isMinusOptional();
        List result2 = ContainerUtil.newSmartList();
        JSRecordType originalType = TypeScriptMappedJSTypeImpl.getOriginalType(type);
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isParameter(name, ((TypeScriptIndexedAccessJSTypeImpl)resultType).getParameterType())) {
            TypeScriptIndexedAccessJSTypeImpl accessJSType = (TypeScriptIndexedAccessJSTypeImpl)resultType;
            JSRecordType ownerRecordType = accessJSType.getOwner().asRecordType();
            HashSet<String> propertyNames = new HashSet<String>(strings);
            for (JSRecordType.TypeMember member : ownerRecordType.getTypeMembers()) {
                JSRecordType.PropertySignature propertySignature;
                String memberName;
                if (!(member instanceof JSRecordType.PropertySignature) || !propertyNames.contains(memberName = (propertySignature = (JSRecordType.PropertySignature)member).getMemberName())) continue;
                JSRecordType.MemberSource source = this.computeCommonMemberSource(type, originalType, propertySignature, memberName);
                result2.add(new JSRecordTypeImpl.PropertySignatureImpl(memberName, propertySignature.getType(), !hasMinusOptionalKeyword && (hasOptionalKeyword || propertySignature.isOptional()), source));
            }
        } else {
            JSType keyBase = type instanceof TypeScriptTypeOperatorJSTypeImpl ? ((TypeScriptTypeOperatorJSTypeImpl)type).getReferencedType() : null;
            for (String string : strings) {
                JSType propertyType = JSTypeUtils.transformTypeHierarchySafe(originalResultType, (Function<JSType, JSType>)((Function)el -> {
                    if (TypeScriptMappedJSTypeImpl.isParameter(name, el)) {
                        return keyBase != null ? new JSTypeKeyTypeImpl(string, keyBase, el.getSource()) : new JSStringLiteralTypeImpl(string, false, el.getSource());
                    }
                    return el;
                }));
                propertyType = JSTypeUtils.getValuableType(propertyType, true);
                JSRecordType.MemberSource source = this.computeCommonMemberSource(type, originalType, null, string);
                PsiElement sourceSingleElement = source.getSingleElement();
                boolean propIsOptional = hasOptionalKeyword;
                if (sourceSingleElement instanceof JSRecordType.PropertySignature) {
                    propIsOptional |= ((JSRecordType.PropertySignature)sourceSingleElement).isOptional();
                }
                result2.add(new JSRecordTypeImpl.PropertySignatureImpl(string, propertyType, propIsOptional, source));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), result2);
        if (jSRecordTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(14);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    private static List<JSType> collectReferencedTypes(@Nullable JSType type, boolean expandTypeof) {
        JSType typedef;
        JSResolvedTypeInfo resolvedTypeInfo;
        if (type instanceof TypeScriptTypeOperatorJSTypeImpl) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((TypeScriptTypeOperatorJSTypeImpl)type).getReferencedType());
            if (list == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            ArrayList types = ContainerUtil.newArrayList();
            for (JSType part : ((JSUnionOrIntersectionType)type).getTypes()) {
                types.addAll(TypeScriptMappedJSTypeImpl.collectReferencedTypes(part, expandTypeof));
            }
            ArrayList arrayList = types;
            if (arrayList == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        if (expandTypeof && type instanceof JSTypeofTypeImpl) {
            List<JSType> list = TypeScriptMappedJSTypeImpl.collectReferencedTypes(((JSTypeofTypeImpl)type).evaluateType(), false);
            if (list == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (expandTypeof && type instanceof JSResolvableType && (resolvedTypeInfo = ((JSResolvableType)type).resolveType()) != null && (typedef = resolvedTypeInfo.getTypedef()) != null) {
            List<JSType> list = TypeScriptMappedJSTypeImpl.collectReferencedTypes(typedef, false);
            if (list == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(18);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    private static JSRecordType getOriginalType(@Nullable JSType type) {
        List<JSType> types = TypeScriptMappedJSTypeImpl.collectReferencedTypes(type, true);
        if (types.size() == 0) {
            return null;
        }
        if (types.size() == 1) {
            return types.get(0).asRecordType();
        }
        assert (type != null);
        return new JSCompositeTypeImpl(type.getSource(), types).asRecordType();
    }

    @NotNull
    private JSRecordType.MemberSource computeCommonMemberSource(JSType type, @Nullable JSRecordType originalType, @Nullable JSRecordType.PropertySignature propertySignature, String memberName) {
        JSRecordType.MemberSource originalSignatureSource;
        JSRecordType.PropertySignature originalSignature;
        JSRecordType.MemberSource source;
        JSRecordType.MemberSource memberSource = source = propertySignature == null ? JSRecordMemberSourceFactory.createEmptySource() : propertySignature.getMemberSource().copyWithKind(this.getMemberSourceKind());
        if (originalType != null && (originalSignature = originalType.findPropertySignature(memberName)) != null && !(originalSignatureSource = originalSignature.getMemberSource()).isEmpty()) {
            source = source.isEmpty() ? originalSignatureSource.copyWithKind(this.getMemberSourceKind()) : JSRecordMemberSourceFactory.createSource(ContainerUtil.concat((List)source.getAllSourceElements(), (List)originalSignatureSource.getAllSourceElements()), this.getMemberSourceKind());
        }
        HashSet sourceElements = ContainerUtil.newHashSet();
        TypeScriptMappedJSTypeImpl.addExtraSourceElements(type, memberName, sourceElements, 0);
        if (!source.isEmpty()) {
            sourceElements.addAll(source.getAllSourceElements());
        }
        JSRecordType.MemberSource memberSource2 = JSRecordMemberSourceFactory.createSource(ContainerUtil.newArrayList((Iterable)sourceElements), this.getMemberSourceKind());
        if (memberSource2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(20);
        }
        return memberSource2;
    }

    @NotNull
    private JSRecordType.MemberSourceKind getMemberSourceKind() {
        JSRecordType.MemberSourceKind memberSourceKind = JSRecordType.MemberSourceKind.getMappedKind((boolean)this.isOptional(), (boolean)this.isMinusOptional(), (boolean)this.isReadonly(), (boolean)this.isMinusReadonly());
        if (memberSourceKind == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(21);
        }
        return memberSourceKind;
    }

    private static void addExtraSourceElements(@Nullable JSType type, String memberName, @NotNull Set<PsiElement> sourceElements, int depth) {
        JSExpression expression;
        PsiElement element;
        JSType referencedType;
        JSRecordType recordType;
        JSRecordType.PropertySignature signature;
        Object typeInfo;
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(22);
        }
        if (depth > 10) {
            return;
        }
        if (type instanceof JSTypeImpl && (typeInfo = ((JSTypeImpl)type).resolveType()) != null && typeInfo.getDeclarationOfType(TypeScriptTypeAlias.class) != null) {
            TypeScriptMappedJSTypeImpl.addSourceElementsFromAliasedType(memberName, sourceElements, typeInfo.getTypedef());
            return;
        }
        if ((type = TypeScriptTypeRelations.expandTypeRecursive(type)) instanceof JSUnionOrIntersectionType) {
            for (JSType part : JSCompositeTypeBaseImpl.flattenTypes(((JSUnionOrIntersectionType)type).getTypes().stream(), type.getClass())) {
                TypeScriptMappedJSTypeImpl.addExtraSourceElements(part, memberName, sourceElements, depth + 1);
            }
        }
        if (type instanceof JSTypeKeyTypeImpl && (signature = (recordType = (referencedType = ((JSTypeKeyTypeImpl)type).getReferencedType()).asRecordType()).findPropertySignature(memberName)) != null) {
            sourceElements.addAll(signature.getMemberSource().getAllSourceElements());
        }
        if (type instanceof JSTaggedLiteralKeyTypeImpl && memberName.equals(((JSTaggedLiteralKeyTypeImpl)type).getLiteral()) && (element = type.getSource().getSourceElement()) instanceof TypeScriptStringLiteralType && (expression = ((TypeScriptStringLiteralType)element).getExpression()) != null) {
            sourceElements.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(((JSTaggedLiteralKeyTypeImpl)type).myUnquotedValue, (PsiElement)expression));
        }
    }

    private static void addSourceElementsFromAliasedType(String memberName, Set<PsiElement> sourceElements, JSType typedef) {
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
            if (t instanceof JSStringLiteralTypeImpl && Objects.equals(((JSStringLiteralTypeImpl)t).getLiteral(), memberName)) {
                PsiElement element = t.getSource().getSourceElement();
                if (element instanceof TypeScriptLiteralType) {
                    JSExpression expression = ((TypeScriptLiteralType)element).getExpression();
                    if (expression != null) {
                        sourceElements.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(memberName, (PsiElement)expression));
                    }
                } else if ((element instanceof JSField || element instanceof JSProperty) && t instanceof JSTypeKeyTypeImpl) {
                    sourceElements.add(element);
                }
            }
            return true;
        }), typedef, false, true, true);
    }

    private static boolean isParameter(@NotNull String name, @NotNull JSType el) {
        if (name == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(23);
        }
        if (el == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(24);
        }
        return el instanceof JSMappedTypeGenericParameterImpl && name.equals(el.getTypeText(JSType.TypeTextFormat.SIMPLE));
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    public boolean isMinusReadonly() {
        return this.myMinusReadonly;
    }

    public boolean isMinusOptional() {
        return this.myMinusOptional;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(25);
        }
        if (type instanceof TypeScriptMappedJSTypeImpl) {
            TypeScriptMappedJSTypeImpl mappedType = (TypeScriptMappedJSTypeImpl)type;
            return this.isReadonly() == mappedType.isReadonly() && this.isMinusReadonly() == mappedType.isMinusReadonly() && this.isOptional() == mappedType.isOptional() && this.isMinusOptional() == mappedType.isMinusOptional() && this.getParameterType().isEquivalentTo(mappedType.getParameterType(), context, allowResolve) && this.getResultType().isEquivalentTo(mappedType.getResultType(), context, allowResolve);
        }
        return false;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(26);
        }
        return jSType;
    }

    @NotNull
    public JSType getResultType() {
        JSType jSType = this.myResultType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(27);
        }
        return jSType;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @Nullable
    public String getParameterName() {
        return this.myParameterName;
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myResultType.accept(visitor);
        this.myParameterType.accept(visitor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElements";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteWithPreventingRecursion";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteInternal";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencedTypes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommonMemberSource";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSourceKind";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addExtraSourceElements";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isParameter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

