/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.DefaultTypeProvider;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMethodDescriptor
implements MethodDescriptor<JSParameterInfo, String> {
    protected final JSFunction myMethod;
    protected final boolean myForceConstructor;

    public JSMethodDescriptor(JSFunction method, boolean forceConstructor) {
        this.myMethod = method;
        this.myForceConstructor = forceConstructor;
    }

    public String getName() {
        return StringUtil.notNullize((String)this.myMethod.getName());
    }

    public List<JSParameterInfo> getParameters() {
        return JSMethodDescriptor.getParameters(this.myMethod);
    }

    public String getReturnType() {
        JSType returnType = this.myMethod.getReturnType();
        return StringUtil.notNullize((String)(returnType != null ? returnType.getResolvedTypeText() : null));
    }

    public static List<JSParameterInfo> getParameters(JSFunction method) {
        return JSMethodDescriptor.getParameters(method, DefaultTypeProvider.INSTANCE);
    }

    public int getParametersCount() {
        return this.myMethod.getParameterList().getParameters().length;
    }

    public String getVisibility() {
        if (!this.isActionScript()) {
            return JSAttributeList.AccessType.PACKAGE_LOCAL.name();
        }
        return this.getVisibilityImpl(JSAttributeList.AccessType.PACKAGE_LOCAL);
    }

    protected final String getVisibilityImpl(JSAttributeList.AccessType defaultAccessType) {
        JSAttributeList.AccessType accessType;
        Object element = this.myMethod instanceof JSFunctionExpression && this.myMethod.getParent() instanceof JSVariable ? (JSVariable)this.myMethod.getParent() : this.myMethod;
        JSAttributeList attributeList = element.getAttributeList();
        JSAttributeList.AccessType accessType2 = accessType = attributeList != null ? attributeList.getAccessType() : defaultAccessType;
        if (!this.canChangeVisibility() && JSUtils.getMemberContainingClass((PsiElement)element) != null && accessType != JSAttributeList.AccessType.PUBLIC) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        } else if (JSResolveUtil.isConstructorFunction((PsiElement)element) && accessType != JSAttributeList.AccessType.PUBLIC && accessType != JSAttributeList.AccessType.PACKAGE_LOCAL) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        }
        return accessType.name();
    }

    public List<JSAttributeList.AccessType> getPossibleVisibility() {
        if (this.myMethod.isConstructor()) {
            return ContainerUtil.newArrayList((Object[])new JSAttributeList.AccessType[]{JSAttributeList.AccessType.PUBLIC, JSAttributeList.AccessType.PACKAGE_LOCAL});
        }
        return ContainerUtil.newArrayList((Object[])new JSAttributeList.AccessType[]{JSAttributeList.AccessType.PRIVATE, JSAttributeList.AccessType.PACKAGE_LOCAL, JSAttributeList.AccessType.PROTECTED, JSAttributeList.AccessType.PUBLIC});
    }

    public boolean isConstructor() {
        return this.myForceConstructor || this.myMethod.isConstructor();
    }

    public JSFunction getMethod() {
        return this.myMethod;
    }

    public boolean canChangeVisibility() {
        if (!this.isActionScript()) {
            return false;
        }
        return this.canChangeVisibilityImpl();
    }

    public boolean resolveTypes() {
        return this.isActionScript();
    }

    protected final boolean canChangeVisibilityImpl() {
        JSFunction element = this.myMethod instanceof JSFunctionExpression ? this.myMethod.getParent() : this.myMethod;
        JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)element);
        return clazz != null && !clazz.isInterface();
    }

    public boolean canChangeParameters() {
        return !this.myMethod.isGetProperty();
    }

    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        if (this.isConstructor() || !this.isActionScript()) {
            return MethodDescriptor.ReadWriteOption.None;
        }
        if (this.myMethod.isSetProperty()) {
            return MethodDescriptor.ReadWriteOption.Read;
        }
        return MethodDescriptor.ReadWriteOption.ReadWrite;
    }

    boolean isActionScript() {
        return DialectDetector.isActionScript((PsiElement)this.myMethod);
    }

    boolean isTypeScript() {
        return DialectDetector.isTypeScript((PsiElement)this.myMethod);
    }

    boolean isEcmaScript6() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this.myMethod);
        return holder != null && holder.isECMA6;
    }

    @Nullable
    DialectOptionHolder dialect() {
        return DialectDetector.dialectOfElement((PsiElement)this.myMethod);
    }

    boolean canHaveOptional() {
        return !this.isActionScript() && !this.isEcmaScript6();
    }

    boolean canHaveType() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this.myMethod);
        return holder != null && holder.hasFeature(JSLanguageFeature.TYPES);
    }

    boolean canHaveInitializers() {
        return this.isActionScript() || this.isEcmaScript6();
    }

    String getFunctionNameWithKeyword(String methodName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getFunctionPrefix());
        if (this.getMethod().isGetProperty()) {
            buffer.append(" get");
        } else if (this.getMethod().isSetProperty()) {
            buffer.append(" set");
        }
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        if (StringUtil.isNotEmpty((String)methodName)) {
            buffer.append(methodName);
        }
        return buffer.toString();
    }

    protected String getFunctionPrefix() {
        return JSClassUtils.isES6ClassImplementation((PsiElement)this.myMethod) && this.isClassMember() ? "" : "function";
    }

    @Nullable
    JSLanguageDialect getFileLanguage() {
        return DialectDetector.languageDialectOfElement((PsiElement)this.myMethod);
    }

    public boolean canChangeName() {
        if (this.myMethod instanceof JSFunctionExpression) {
            PsiElement parent = this.myMethod.getParent();
            return parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSProperty || parent instanceof ES6ExportDefaultAssignment && this.myMethod.getName() != null;
        }
        return !this.isConstructor();
    }

    protected boolean isClassMember() {
        PsiElement classMember = this.getContainingClassMember();
        return JSUtils.getMemberContainingClass(classMember) != null;
    }

    private PsiElement getContainingClassMember() {
        return this.myMethod instanceof JSFunctionExpression ? this.myMethod.getParent() : this.myMethod;
    }

    @NotNull
    public static List<JSParameterInfo> getParameters(JSFunction method, Function<JSParameterListElement, String> typeProvider) {
        ArrayList<JSParameterInfo> result2 = new ArrayList<JSParameterInfo>();
        JSParameterListElement[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            JSParameterListElement parameter = parameters[i];
            JSParameterInfo info = JSParameterInfo.build(parameter, i);
            info.setDefaultValue("");
            info.setTypeText((String)typeProvider.fun((Object)parameter));
            result2.add(info);
        }
        ArrayList<JSParameterInfo> arrayList = result2;
        if (arrayList == null) {
            JSMethodDescriptor.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/changeSignature/JSMethodDescriptor", "getParameters"));
    }
}

