/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableTypeBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfo
implements ParameterInfo {
    public static final JSParameterInfo[] EMPTY_ARRAY = new JSParameterInfo[0];
    public static final ArrayFactory<JSParameterInfo> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new JSParameterInfo[count];
    private int myOldIndex;
    private String myTypeText = "";
    private String myDefaultValue = "";
    private String myInitializer = "";
    private String myModifiers = "";
    private String myDeclarationText = "";
    private boolean myIsDestructuring;
    private boolean myIsOptional;
    @Nullable
    private DialectOptionHolder myDialect;

    public static JSParameterInfo build(@NotNull JSParameterListElement parameterListElement, int index) {
        JSExpression initializerExpr;
        if (parameterListElement == null) {
            JSParameterInfo.$$$reportNull$$$0(0);
        }
        String initializer = (initializerExpr = parameterListElement.getInitializer()) == null ? null : initializerExpr.getText();
        JSType type = parameterListElement.getType();
        String typeText = type == null || type instanceof JSEvaluableTypeBase ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        JSParameter jsParameter = (JSParameter)ObjectUtils.tryCast((Object)parameterListElement, JSParameter.class);
        String modifiers = jsParameter != null && jsParameter.getAttributeList() != null ? jsParameter.getAttributeList().getText() : "";
        JSParameterInfo result2 = new JSParameterInfo(JSParameterInfo.buildDeclarationText(parameterListElement), typeText, initializer, null, index, parameterListElement.isOptional());
        result2.myModifiers = modifiers;
        result2.myIsDestructuring = parameterListElement instanceof JSDestructuringParameter;
        result2.myDialect = DialectDetector.dialectOfElement((PsiElement)parameterListElement);
        return result2;
    }

    private static String buildDeclarationText(@NotNull JSParameterListElement parameterListElement) {
        if (parameterListElement == null) {
            JSParameterInfo.$$$reportNull$$$0(1);
        }
        if (!DialectDetector.isActionScript((PsiElement)parameterListElement) && parameterListElement.isRest()) {
            return "..." + parameterListElement.getName();
        }
        if (parameterListElement instanceof TypeScriptParameterImpl && ((TypeScriptParameterImpl)parameterListElement).isDeclaredOptional()) {
            return parameterListElement.getName() + "?";
        }
        return parameterListElement.getName();
    }

    public JSParameterInfo(String declarationText, String type, String initializer, String defaultValue, int oldIndex, boolean optional, @Nullable DialectOptionHolder dialect) {
        this(declarationText, type, initializer, defaultValue, oldIndex);
        this.myIsOptional = optional;
        this.myDialect = dialect;
    }

    public JSParameterInfo(String declarationText, String type, String initializer, String defaultValue, int oldIndex, boolean optional) {
        this(declarationText, type, initializer, defaultValue, oldIndex);
        this.myIsOptional = optional;
    }

    public JSParameterInfo(String declarationText, String type, String initializer, String defaultValue, int oldIndex) {
        this.myDeclarationText = declarationText;
        this.myInitializer = initializer;
        this.myOldIndex = oldIndex;
        this.myTypeText = type;
        this.myDefaultValue = defaultValue;
    }

    public String getDeclarationText() {
        return this.myDeclarationText;
    }

    public void setDeclarationText(String value) {
        this.myDeclarationText = value;
    }

    public String getName() {
        return this.getDeclarationText();
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public String getTypeText() {
        return "null".equals(this.myTypeText) ? "*" : this.myTypeText;
    }

    public String getModifiersText() {
        return this.myModifiers;
    }

    public void setTypeText(String type) {
        this.myTypeText = type;
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    public String getInitializer() {
        return this.myInitializer;
    }

    public void setInitializer(String initializer) {
        this.myInitializer = initializer;
    }

    public boolean isOptional() {
        return this.myIsOptional;
    }

    public void setOptional(boolean optional) {
        this.myIsOptional = optional;
    }

    public void setOldIndex(int oldIndex) {
        this.myOldIndex = oldIndex;
    }

    public boolean isDestructuringParameter() {
        return this.myIsDestructuring;
    }

    public boolean isRest() {
        return StringUtil.equals((CharSequence)this.myTypeText, (CharSequence)"...") || StringUtil.startsWith((CharSequence)this.myDeclarationText, (CharSequence)"...");
    }

    @Nullable
    public DialectOptionHolder getDialect() {
        return this.myDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "parameterListElement";
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDeclarationText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

