/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.ui.newclass.CreateFlashClassWizard;
import com.intellij.lang.javascript.ui.newclass.CustomVariablesStep;
import com.intellij.lang.javascript.ui.newclass.MainStep;
import com.intellij.lang.javascript.ui.newclass.WizardModel;
import com.intellij.lang.javascript.validation.fixes.AddConstructorAndSuperInvocationFix;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateClassIntentionWithCallback;
import com.intellij.lang.javascript.validation.fixes.CreateClassParameters;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptCreateClassOrInterfaceFix
extends FixAndIntentionAction
implements CreateClassIntentionWithCallback {
    @NonNls
    public static final String ACTION_SCRIPT_CLASS_TEMPLATE_NAME = "ActionScript Class";
    @NonNls
    public static final String ACTION_SCRIPT_CLASS_WITH_SUPERS_TEMPLATE_NAME = "ActionScript Class with Supers";
    @NonNls
    public static final String ACTION_SCRIPT_INTERFACE_TEMPLATE_NAME = "ActionScript Interface";
    private static final Logger LOG = Logger.getInstance((String)ActionScriptCreateClassOrInterfaceFix.class.getName());
    @NonNls
    public static final String ACCESS_MODIFIER_PROPERTY = "Access_modifier";
    @NonNls
    public static final String SUPERCLASS = "Superclass";
    @NonNls
    public static final String SUPER_INTERFACES = "SuperInterfaces";
    public static final Collection<String> ACTIONSCRIPT_TEMPLATES_EXTENSIONS = Arrays.asList("as", "js2", "es");
    private static String ourPreviousClassTemplateName;
    private static String ourPreviousInterfaceTemplateName;
    protected String myClassNameToCreate;
    protected final PsiElement myContext;
    protected String myPackageName;
    private final boolean myIsInterface;
    @Nullable
    private final JSClass myBaseClassifier;
    private final boolean myAddImportForCreatedClass;
    private final boolean myIdentifierIsValid;
    private Consumer<String> myCreatedClassFqnConsumer;
    @Nullable
    private final JSArgumentList myConstructorArguments;
    private final boolean myIsClassNameEditable;

    public ActionScriptCreateClassOrInterfaceFix(JSReferenceExpression context, boolean isInterface, @Nullable JSArgumentList constructorArguments, @Nullable JSType expectedType) {
        this.myIsClassNameEditable = false;
        this.myConstructorArguments = constructorArguments;
        this.myClassNameToCreate = context.getReferencedName();
        this.myBaseClassifier = ActionScriptCreateClassOrInterfaceFix.getBaseClassifier(expectedType);
        this.myContext = context;
        this.myIsInterface = isInterface;
        this.myAddImportForCreatedClass = true;
        this.myIdentifierIsValid = this.myClassNameToCreate != null && ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE)).isIdentifier(this.myClassNameToCreate, null);
    }

    public ActionScriptCreateClassOrInterfaceFix(String fqn, @Nullable String baseClassFqn, PsiElement context) {
        this.myClassNameToCreate = StringUtil.getShortName((String)fqn);
        this.myPackageName = StringUtil.getPackageName((String)fqn);
        this.myBaseClassifier = ActionScriptCreateClassOrInterfaceFix.getBaseClassifier(baseClassFqn, context);
        this.myContext = context;
        this.myIsInterface = false;
        this.myAddImportForCreatedClass = false;
        this.myIdentifierIsValid = this.myClassNameToCreate != null && ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE)).isIdentifier(this.myClassNameToCreate, null);
        this.myConstructorArguments = null;
        this.myIsClassNameEditable = true;
        this.registerElementRefForFix(context, null);
    }

    public ActionScriptCreateClassOrInterfaceFix(PsiDirectory dir) {
        this.myClassNameToCreate = null;
        this.myIsClassNameEditable = true;
        this.myPackageName = DirectoryIndex.getInstance((Project)dir.getProject()).getPackageName(dir.getVirtualFile());
        LOG.assertTrue(this.myPackageName != null, (Object)("No package for file " + dir.getVirtualFile().getPath()));
        this.myBaseClassifier = null;
        this.myContext = dir;
        this.myIsInterface = false;
        this.myAddImportForCreatedClass = false;
        this.myIdentifierIsValid = true;
        this.myConstructorArguments = null;
    }

    @Nullable
    private static JSClass getBaseClassifier(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        String typeString = type.getResolvedTypeText();
        if (ArrayUtil.contains((String)typeString, (String[])JSCommonTypeNames.ALL)) {
            return null;
        }
        return ActionScriptCreateClassOrInterfaceFix.getBaseClassifier(typeString, (PsiElement)type.getSource().getScope());
    }

    private static JSClass getBaseClassifier(@Nullable String fqn, PsiElement context) {
        if (fqn == null || context == null) {
            return null;
        }
        PsiElement clazz = JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(fqn, context);
        return clazz instanceof JSClass ? (JSClass)clazz : null;
    }

    @NotNull
    public String getName() {
        String key = this.myIsInterface ? "javascript.create.interface.intention.name" : "javascript.create.class.intention.name";
        String string = JSBundle.message((String)key, (Object[])new Object[]{this.myClassNameToCreate});
        if (string == null) {
            ActionScriptCreateClassOrInterfaceFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file2, Editor editor) {
        this.execute();
    }

    public void execute() {
        Map<String, Object> templateAttributes;
        Collection<String> interfacesFqns;
        String superClassFqn;
        PsiDirectory targetDirectory;
        String templateName;
        if (this.myPackageName == null) {
            PsiFile contextFile = this.getTopLevelContextFile();
            assert (this.myContext instanceof JSReferenceExpression);
            JSExpression qualifier = ((JSReferenceExpression)this.myContext).getQualifier();
            this.myPackageName = qualifier != null ? qualifier.getText() : JSResolveUtil.getExpectedPackageNameFromFile(contextFile.getVirtualFile(), this.myContext.getProject());
        }
        String defaultTemplateName = ActionScriptCreateClassOrInterfaceFix.getTemplateName(this.myIsInterface, this.myBaseClassifier != null, ourPreviousInterfaceTemplateName, ourPreviousClassTemplateName, this.myContext.getProject());
        if (this.myIsInterface) {
            templateName = ourPreviousInterfaceTemplateName == null ? defaultTemplateName : ourPreviousInterfaceTemplateName;
        } else {
            String string = templateName = ourPreviousClassTemplateName == null || this.myBaseClassifier != null ? defaultTemplateName : ourPreviousClassTemplateName;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            CreateClassParameters params = this.createDialog(templateName);
            if (params == null) {
                return;
            }
            this.myPackageName = params.getPackageName();
            templateName = params.getTemplateName();
            targetDirectory = params.getTargetDirectory();
            superClassFqn = params.getSuperclassFqn();
            interfacesFqns = params.getInterfacesFqns();
            this.myClassNameToCreate = params.getClassName();
            templateAttributes = new HashMap<String, String>(params.getTemplateAttributes());
            if (this.myIsInterface) {
                ourPreviousInterfaceTemplateName = templateName;
            } else {
                ourPreviousClassTemplateName = templateName;
            }
        } else {
            if (StringUtil.isEmpty((String)this.myPackageName)) {
                this.myPackageName = "foo";
            }
            templateName = this.getTemplateForTest(this.myIsInterface);
            templateAttributes = ActionScriptCreateClassOrInterfaceFix.fillAttributes(this.myBaseClassifier == null || this.myBaseClassifier.isInterface() ? null : this.myBaseClassifier, this.myBaseClassifier != null && this.myBaseClassifier.isInterface() ? Collections.singletonList(this.myBaseClassifier.getQualifiedName()) : Collections.emptyList());
            targetDirectory = (PsiDirectory)WriteAction.compute(() -> ActionScriptCreateClassOrInterfaceFix.findOrCreateDirectory(this.myPackageName, (PsiElement)this.getTopLevelContextFile()));
            superClassFqn = this.myBaseClassifier == null || this.myBaseClassifier.isInterface() ? null : this.myBaseClassifier.getQualifiedName();
            interfacesFqns = this.myBaseClassifier != null && this.myBaseClassifier.isInterface() ? Collections.singletonList(this.myBaseClassifier.getQualifiedName()) : Collections.emptyList();
        }
        JSClass jsClass = ActionScriptCreateClassOrInterfaceFix.createClass(templateName, this.myClassNameToCreate, this.myPackageName, ActionScriptCreateClassOrInterfaceFix.calcClass(superClassFqn, this.myContext), interfacesFqns, targetDirectory, this.getName(), this.myConstructorArguments == null, templateAttributes, (Consumer<JSClass>)((Consumer)jsClass1 -> {
            if (this.myAddImportForCreatedClass) {
                String contextPackage = JSResolveUtil.findPackageStatementQualifier(this.myContext);
                if (StringUtil.isNotEmpty((String)this.myPackageName) && !this.myPackageName.equals(contextPackage)) {
                    ImportUtils.doImport(this.myContext, StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassNameToCreate), true);
                }
            }
            if (this.myCreatedClassFqnConsumer != null) {
                this.myCreatedClassFqnConsumer.consume((Object)StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassNameToCreate));
            }
        }));
        if (jsClass != null) {
            this.postProcess(jsClass, superClassFqn);
        }
    }

    @Nullable
    public static JSClass calcClass(@Nullable String superClassFqn, PsiElement context) {
        if (superClassFqn != null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            GlobalSearchScope superClassScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.projectScope((Project)context.getProject());
            PsiElement byQName = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(superClassFqn, superClassScope);
            return byQName instanceof JSClass ? (JSClass)byQName : null;
        }
        return null;
    }

    protected String getTemplateForTest(boolean isInterface) {
        return ActionScriptCreateClassOrInterfaceFix.getTemplateName(this.myIsInterface, true, ourPreviousInterfaceTemplateName, ourPreviousClassTemplateName, this.myContext.getProject());
    }

    protected void postProcess(@NotNull JSClass jsClass, String superClassFqn) {
        if (jsClass == null) {
            ActionScriptCreateClassOrInterfaceFix.$$$reportNull$$$0(1);
        }
        if (!this.fixConstructor(jsClass, this.myConstructorArguments, this.myContext)) {
            jsClass.navigate(true);
        }
    }

    @Nullable
    protected CreateClassParameters createDialog(String templateName) {
        String title = JSBundle.message((String)(this.myIsInterface ? "new.actionscript.interface.dialog.title" : "new.actionscript.class.dialog.title"), (Object[])new Object[0]);
        return ActionScriptCreateClassOrInterfaceFix.createAndShow(templateName, this.myContext, this.myClassNameToCreate, this.myIsClassNameEditable, this.myPackageName, this.myBaseClassifier, title, (Computable<List<FileTemplate>>)((Computable)() -> this.computeApplicableTemplates()));
    }

    @Nullable
    public static CreateClassParameters createAndShow(String templateName, PsiElement context, String classNameToCreate, boolean classNameEditable, String packageName, JSClass baseClassifier, String title, Computable<List<FileTemplate>> templatesProvider) {
        WizardModel model = new WizardModel(context, true);
        MainStep mainStep = new MainStep(model, context.getProject(), classNameToCreate, classNameEditable, packageName, baseClassifier, baseClassifier == null, templateName, context, JSBundle.message((String)"choose.super.class.title", (Object[])new Object[0]), templatesProvider);
        CustomVariablesStep customVariablesStep = new CustomVariablesStep(model);
        CreateFlashClassWizard w = new CreateFlashClassWizard(title, context.getProject(), model, "New_ActionScript_Class_dialog", mainStep, customVariablesStep);
        w.show();
        if (w.getExitCode() != 0) {
            return null;
        }
        return model;
    }

    protected List<FileTemplate> computeApplicableTemplates() {
        return ActionScriptCreateClassOrInterfaceFix.getApplicableTemplates(ACTIONSCRIPT_TEMPLATES_EXTENSIONS, this.myContext.getProject());
    }

    private PsiFile getTopLevelContextFile() {
        PsiFile contextFile = this.myContext.getContainingFile();
        PsiElement context = contextFile.getContext();
        if (context != null) {
            contextFile = context.getContainingFile();
        }
        return contextFile;
    }

    protected boolean fixConstructor(@NotNull JSClass jsClass, JSArgumentList argumentList, PsiElement psiElement) {
        if (jsClass == null) {
            ActionScriptCreateClassOrInterfaceFix.$$$reportNull$$$0(2);
        }
        if (argumentList == null || argumentList.getArguments().length == 0) {
            return false;
        }
        Set toImport = ContainerUtil.map2SetNotNull(Arrays.asList(argumentList.getArguments()), argument -> {
            String type;
            if (jsClass == null) {
                ActionScriptCreateClassOrInterfaceFix.$$$reportNull$$$0(5);
            }
            return StringUtil.isNotEmpty((String)(type = JSResolveUtil.getQualifiedExpressionType(argument, argument.getContainingFile()))) && ImportUtils.needsImport((JSQualifiedNamedElement)jsClass, StringUtil.getPackageName((String)type)) ? type : null;
        });
        PsiFile jsClassContainingFile = jsClass.getContainingFile();
        Project project = jsClass.getProject();
        JSFunction constructor = jsClass.getConstructor();
        if (constructor != null) {
            ASTNode rpar;
            if (constructor.getParameterList().getParameters().length > 0) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    JSFunction func = (JSFunction)JSChangeUtil.createJSTreeFromText(constructor.getProject(), "function foo() {}", JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
                    constructor.getParameterList().replace((PsiElement)func.getParameterList());
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                    documentManager.doPostponedOperationsAndUnblockDocument(documentManager.getDocument(jsClassContainingFile));
                });
            }
            if ((rpar = constructor.getParameterList().getNode().findChildByType(JSTokenTypes.RPAR)) == null) {
                return false;
            }
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            JSReferenceExpression referenceExpression = (JSReferenceExpression)this.myContext;
            CreateJSFunctionIntentionAction.addParameters(template, argumentList, (PsiElement)referenceExpression, jsClassContainingFile);
            Editor editor = BaseCreateFix.getEditor(project, jsClassContainingFile);
            if (editor == null) {
                return false;
            }
            BaseCreateFix.navigate(project, editor, rpar.getTextRange().getStartOffset(), jsClassContainingFile.getVirtualFile());
            templateManager.startTemplate(editor, template);
        } else {
            final ASTNode lbrace = jsClass.getNode().findChildByType(JSTokenTypes.LBRACE);
            if (lbrace == null) {
                return false;
            }
            new CreateJSFunctionIntentionAction(jsClass.getName(), true, false){

                @Override
                @NotNull
                protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement1) {
                    Pair pair = Pair.create((Object)((JSReferenceExpression)ActionScriptCreateClassOrInterfaceFix.this.myContext), (Object)lbrace.getPsi());
                    if (pair == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return pair;
                }

                @Override
                protected void appendFunctionBody(Template template, JSReferenceExpression refExpr, PsiFile file2) {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateClassOrInterfaceFix$1", "calculateAnchors"));
                }
            }.applyFix(project, psiElement, jsClassContainingFile, null);
        }
        if (!toImport.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                FormatFixer fixer;
                if (jsClass == null) {
                    ActionScriptCreateClassOrInterfaceFix.$$$reportNull$$$0(4);
                }
                if ((fixer = ImportUtils.insertImportStatements((PsiElement)jsClass, toImport)) != null) {
                    fixer.fixFormat();
                }
            });
        }
        return true;
    }

    public static JSClass createClass(String templateName, String className, String packageName, @Nullable JSClass superClass, Collection<String> superInterfaces, PsiDirectory targetDirectory, String errorTitle, boolean fixSuperCall, Map<String, Object> templateAttributes, Consumer<JSClass> postProcessRunnable) {
        IncorrectOperationException error = null;
        JSClass result2 = null;
        try {
            result2 = (JSClass)WriteAction.compute(() -> {
                Map<String, Object> additionalTemplateProperties = ActionScriptCreateClassOrInterfaceFix.fillAttributes(superClass, superInterfaces);
                additionalTemplateProperties.putAll(templateAttributes);
                PsiElement createdFile = ActionScriptCreateClassOrInterfaceFix.doCreateClass(className, packageName, targetDirectory, templateName, additionalTemplateProperties);
                JSClass createdClass = createdFile instanceof JSFile ? JSPsiImplUtils.findClass((JSFile)createdFile) : XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)createdFile);
                ArrayList<String> toImport = new ArrayList<String>();
                if (createdClass != null && !(createdClass instanceof XmlBackedJSClass) && superClass != null) {
                    JSFunction superConstructor;
                    String superClassPackage = StringUtil.getPackageName((String)superClass.getQualifiedName());
                    if (!StringUtil.isEmpty((String)superClassPackage) && !superClassPackage.equals(packageName)) {
                        toImport.add(superClass.getQualifiedName());
                    }
                    if (fixSuperCall && (superConstructor = superClass.getConstructor()) != null && superConstructor.getParameterList().getParameters().length > 0) {
                        String text = AddConstructorAndSuperInvocationFix.getConstructorText(createdClass, superConstructor, toImport);
                        PsiElement newConstructor = JSChangeUtil.createJSTreeFromText(createdClass.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
                        if (newConstructor != null) {
                            JSFunction constructor = createdClass.getConstructor();
                            if (constructor != null) {
                                constructor.replace(newConstructor);
                            } else {
                                createdClass.add(newConstructor);
                            }
                        }
                    }
                }
                if (createdClass != null && !(createdClass instanceof XmlBackedJSClass)) {
                    for (String superInterface : superInterfaces) {
                        String aPackage = StringUtil.getPackageName((String)superInterface);
                        if (StringUtil.isEmpty((String)aPackage) || aPackage.equals(packageName)) continue;
                        toImport.add(superInterface);
                    }
                    if (!toImport.isEmpty()) {
                        ImportUtils.insertImportStatements((PsiElement)createdClass, toImport);
                    }
                    new ECMAScriptImportOptimizer().processFile(createdClass.getContainingFile()).run();
                }
                postProcessRunnable.consume((Object)createdClass);
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)targetDirectory.getProject());
                documentManager.doPostponedOperationsAndUnblockDocument(documentManager.getDocument((PsiFile)createdFile));
                return createdClass;
            });
        }
        catch (IncorrectOperationException e) {
            error = e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        if (error != null) {
            String message = error.getCause() instanceof IOException ? error.getCause().getMessage() : error.getMessage();
            ApplicationUtil.showDialogAfterWriteAction(() -> Messages.showErrorDialog((Project)targetDirectory.getProject(), (String)message, (String)errorTitle));
        }
        return result2;
    }

    private static Map<String, Object> fillAttributes(JSClass superClass, Collection<String> superInterfaces) {
        HashMap<String, Object> additionalTemplateProperties = new HashMap<String, Object>();
        if (superClass != null) {
            additionalTemplateProperties.put(SUPERCLASS, superClass.getQualifiedName());
        }
        if (!superInterfaces.isEmpty()) {
            additionalTemplateProperties.put(SUPER_INTERFACES, superInterfaces);
        }
        return additionalTemplateProperties;
    }

    @Override
    public void setCreatedClassFqnConsumer(Consumer<String> consumer) {
        this.myCreatedClassFqnConsumer = consumer;
    }

    public static PsiDirectory findOrCreateDirectory(String packageName, PsiElement context) {
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        VirtualFile base = ModuleRootManager.getInstance((Module)module).getSourceRoots()[0];
        VirtualFile relativeFile = VfsUtil.findRelativeFile((String)packageName, (VirtualFile)base);
        if (relativeFile == null) {
            relativeFile = base;
            StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
            while (tokenizer.hasMoreTokens()) {
                String nextNameSegment = tokenizer.nextToken();
                VirtualFile next = relativeFile.findChild(nextNameSegment);
                if (next == null) {
                    try {
                        next = relativeFile.createChildDirectory(ActionScriptCreateClassOrInterfaceFix.class, nextNameSegment);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                relativeFile = next;
            }
        }
        assert (relativeFile != null);
        return context.getManager().findDirectory(relativeFile);
    }

    public static String getClassText(String className, String packageName, boolean isInterface, String accessModifier, Project project) throws IOException {
        final Map<String, Object> props = ActionScriptCreateClassOrInterfaceFix.createProperties(className, packageName, accessModifier);
        final FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate(ActionScriptCreateClassOrInterfaceFix.getTemplateName(isInterface, false, ourPreviousInterfaceTemplateName, ourPreviousClassTemplateName, project));
        String mergedText = (String)ClassLoaderUtil.runWithClassLoader((ClassLoader)ActionScriptCreateClassOrInterfaceFix.class.getClassLoader(), (ThrowableComputable)new ThrowableComputable<String, IOException>(){

            public String compute() throws IOException {
                return template.getText(props);
            }
        });
        return StringUtil.convertLineSeparators((String)mergedText);
    }

    public static Map<String, Object> createProperties(String className, String packageName, String accessModifier) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        FileTemplateUtil.putAll(props, (Properties)FileTemplateManager.getDefaultInstance().getDefaultProperties());
        props.put("NAME", className);
        props.put("PACKAGE_NAME", packageName);
        props.put(ACCESS_MODIFIER_PROPERTY, accessModifier);
        return props;
    }

    private static String getTemplateName(boolean isInterface, boolean hasSuperClassifier, @Nullable String interfaceDefault, @Nullable String classDefault, Project project) {
        FileTemplate t;
        if (isInterface) {
            if (interfaceDefault != null && FileTemplateManager.getInstance((Project)project).getTemplate(interfaceDefault) != null) {
                return interfaceDefault;
            }
            return ACTION_SCRIPT_INTERFACE_TEMPLATE_NAME;
        }
        if (classDefault != null && (t = FileTemplateManager.getInstance((Project)project).getTemplate(classDefault)) != null && !(t instanceof BundledFileTemplate)) {
            return classDefault;
        }
        return hasSuperClassifier ? ACTION_SCRIPT_CLASS_WITH_SUPERS_TEMPLATE_NAME : ACTION_SCRIPT_CLASS_TEMPLATE_NAME;
    }

    private static PsiElement createClass(String className, String packageName, PsiDirectory directory, String templateName) throws Exception {
        return ActionScriptCreateClassOrInterfaceFix.doCreateClass(className, packageName, directory, templateName, null);
    }

    public static void createClass(String className, String packageName, PsiDirectory directory, boolean isInterface) throws Exception {
        ActionScriptCreateClassOrInterfaceFix.createClass(className, packageName, directory, ActionScriptCreateClassOrInterfaceFix.getTemplateName(isInterface, false, ourPreviousInterfaceTemplateName, ourPreviousClassTemplateName, directory.getProject()));
    }

    private static PsiElement doCreateClass(String className, String packageName, final PsiDirectory directory, final String templateName, @Nullable Map<String, Object> additionalTemplateProperties) throws Exception {
        Map<String, Object> props = ActionScriptCreateClassOrInterfaceFix.createProperties(className, packageName, JSFormatUtil.formatVisibility(JSAttributeList.AccessType.PUBLIC));
        if (additionalTemplateProperties != null) {
            props.putAll(additionalTemplateProperties);
        }
        FileTemplate template = (FileTemplate)ClassLoaderUtil.runWithClassLoader((ClassLoader)ActionScriptCreateClassOrInterfaceFix.class.getClassLoader(), (ThrowableComputable)new ThrowableComputable<FileTemplate, IOException>(){

            public FileTemplate compute() throws IOException {
                return FileTemplateManager.getInstance((Project)directory.getProject()).getInternalTemplate(templateName);
            }
        });
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)className, props, (PsiDirectory)directory, (ClassLoader)ActionScriptCreateClassOrInterfaceFix.class.getClassLoader());
    }

    @Override
    public boolean isAvailable(@NotNull Project project, PsiElement element, Editor editor, PsiFile file2) {
        if (project == null) {
            ActionScriptCreateClassOrInterfaceFix.$$$reportNull$$$0(3);
        }
        if (!DialectDetector.isActionScript((PsiElement)file2)) {
            return false;
        }
        if (!this.myIdentifierIsValid) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        return module != null && ModuleRootManager.getInstance((Module)module).getSourceRoots().length > 0;
    }

    public static Icon getTemplateIcon(FileTemplate t) {
        if (ACTION_SCRIPT_CLASS_TEMPLATE_NAME.equals(t.getName()) || ACTION_SCRIPT_CLASS_WITH_SUPERS_TEMPLATE_NAME.equals(t.getName())) {
            return JSIconProvider.AS_INSTANCE.getClassIcon();
        }
        if (ACTION_SCRIPT_INTERFACE_TEMPLATE_NAME.equals(t.getName())) {
            return JSIconProvider.AS_INSTANCE.getInterfaceIcon();
        }
        return FileTypeManager.getInstance().getFileTypeByExtension(t.getExtension()).getIcon();
    }

    public static String getTemplateShortName(String templateName) {
        if (ACTION_SCRIPT_CLASS_TEMPLATE_NAME.equals(templateName)) {
            return JSBundle.message((String)"class.template.title", (Object[])new Object[0]);
        }
        if (ACTION_SCRIPT_CLASS_WITH_SUPERS_TEMPLATE_NAME.equals(templateName)) {
            return JSBundle.message((String)"class.with.supers.template.title", (Object[])new Object[0]);
        }
        if (ACTION_SCRIPT_INTERFACE_TEMPLATE_NAME.equals(templateName)) {
            return JSBundle.message((String)"interface.template.title", (Object[])new Object[0]);
        }
        return templateName;
    }

    public static List<FileTemplate> getApplicableTemplates(Collection<String> extensions, Project project) {
        SmartList applicableTemplates = new SmartList();
        Condition filter = fileTemplate -> extensions.contains(fileTemplate.getExtension());
        applicableTemplates.addAll(ContainerUtil.findAll((Object[])FileTemplateManager.getInstance((Project)project).getInternalTemplates(), (Condition)filter));
        applicableTemplates.addAll(ContainerUtil.findAll((Object[])FileTemplateManager.getInstance((Project)project).getAllTemplates(), (Condition)filter));
        return applicableTemplates;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateClassOrInterfaceFix";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ActionScriptCreateClassOrInterfaceFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fixConstructor$5";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fixConstructor$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

