/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TypeScriptCompiler", storages={@Storage(value="typescript-compiler.xml")})
public class TypeScriptCompilerSettings
implements PersistentStateComponent<CompilerSettings> {
    public static final String[] CONFIG_PARAMS = new String[]{"-p", "--p", "--project", "-project"};
    public static final String DEFAULT_SCOPE = "Project Files";
    private final Project myProject;
    public static final String[] TYPESCRIPT_SERVICE_FILES = new String[]{"tsserver.js", "tsserverlibrary.js"};
    private CompilerSettings myState = new CompilerSettings();

    public static TypeScriptCompilerSettings getSettings(Project project) {
        return (TypeScriptCompilerSettings)ServiceManager.getService((Project)project, TypeScriptCompilerSettings.class);
    }

    public TypeScriptCompilerSettings(Project project) {
        this.myProject = project;
    }

    @Nullable
    public CompilerSettings getState() {
        return this.myState;
    }

    public void loadState(@NotNull CompilerSettings state) {
        if (state == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    public boolean isUseServiceParameterInfo() {
        return this.myState.useServiceParameterInfo;
    }

    public boolean isUseServiceCompletion() {
        return this.myState.useServiceCompletion;
    }

    public boolean isUseSingleInferredProject() {
        return this.myState.useSingleInferredProject;
    }

    public String getDefaultServiceOptions() {
        return this.myState.typeScriptCompilerParams;
    }

    public void setDefaultServiceOptions(@Nullable String typeScriptCompilerParams) {
        this.myState.typeScriptCompilerParams = StringUtil.nullize((String)typeScriptCompilerParams, (boolean)true);
    }

    public void setTypeScriptServiceDirectory(@Nullable String path) {
        this.myState.typeScriptServiceDirectory = PathMacroManager.getInstance((ComponentManager)this.myProject).expandPath(StringUtil.nullize((String)path, (boolean)true));
    }

    public boolean isShowAllProjectErrors() {
        return this.myState.showAllErrors;
    }

    public void setShowAllProjectErrors(boolean value) {
        this.myState.showAllErrors = value;
    }

    public boolean useDeprecatedSettings() {
        if (this.myState.isCompilerEnabled) {
            return !this.myState.useConfig;
        }
        return this.myState.useDeprecatedSettings;
    }

    @Nullable
    public String getTypeScriptServiceDirectory() {
        return PathMacroManager.getInstance((ComponentManager)this.myProject).expandPath(this.myState.typeScriptServiceDirectory);
    }

    public TypeScriptCompilerVersionType getVersionType() {
        return this.myState.versionType;
    }

    public void setVersionType(TypeScriptCompilerVersionType type) {
        this.myState.versionType = type;
    }

    @Nullable
    public String getNodeInterpreter() {
        return this.myState.nodeInterpreterTextField;
    }

    public void setNodeInterpreter(String nodeInterpreterTextField) {
        this.myState.nodeInterpreterTextField = StringUtil.nullize((String)nodeInterpreterTextField, (boolean)true);
    }

    @NotNull
    public String getScopeName() {
        String scopeName = this.myState.scopeName;
        String string = scopeName == null ? DEFAULT_SCOPE : scopeName;
        if (string == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setScopeName(@NotNull String scopeName) {
        if (scopeName == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(2);
        }
        this.myState.scopeName = scopeName;
    }

    @NotNull
    public String getDefaultTypeScriptServiceDirectory() {
        String string = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile().getAbsolutePath(), "external").getAbsolutePath();
        if (string == null) {
            TypeScriptCompilerSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean useServiceForProjectsWithoutConfig() {
        if (this.myState.isCompilerEnabled) {
            return true;
        }
        return this.myState.enableServiceForProjectsWithoutConfig;
    }

    public boolean isRecompileOnChanges() {
        if (this.myState.isCompilerEnabled && this.myState.trackFileSystemChanges) {
            return true;
        }
        return this.myState.recompileOnChanges;
    }

    public boolean useService() {
        if (this.myState.isCompilerEnabled) {
            return true;
        }
        return this.myState.useService;
    }

    public void setRecompileOnChanges(boolean result2) {
        this.myState.recompileOnChanges = result2;
        if (this.myState.isCompilerEnabled) {
            this.myState.enableServiceForProjectsWithoutConfig = true;
            this.myState.useDeprecatedSettings = !this.myState.useConfig;
            this.resetDeprecatedSettingsToDefault();
        }
    }

    public void setUseServiceForProjectsWithoutConfig(boolean result2) {
        this.myState.enableServiceForProjectsWithoutConfig = result2;
        if (this.myState.isCompilerEnabled) {
            this.myState.recompileOnChanges = this.myState.trackFileSystemChanges;
            this.myState.useDeprecatedSettings = !this.myState.useConfig;
            this.myState.useService = this.myState.useService || this.myState.enableServiceForProjectsWithoutConfig;
            this.resetDeprecatedSettingsToDefault();
        }
    }

    public void setUseConfig(boolean value) {
        this.myState.useConfig = value;
    }

    public void setUseDeprecatedSettings(boolean result2) {
        this.myState.useDeprecatedSettings = result2;
        if (this.myState.isCompilerEnabled) {
            this.myState.enableServiceForProjectsWithoutConfig = true;
            this.myState.recompileOnChanges = this.myState.trackFileSystemChanges;
            this.resetDeprecatedSettingsToDefault();
        }
    }

    public void setUseService(boolean useService) {
        this.myState.useService = useService;
        if (this.myState.isCompilerEnabled) {
            this.myState.enableServiceForProjectsWithoutConfig = true;
            this.myState.recompileOnChanges = this.myState.trackFileSystemChanges;
            this.myState.useDeprecatedSettings = !this.myState.useConfig;
            this.resetDeprecatedSettingsToDefault();
        }
    }

    public void resetDeprecatedSettingsToDefault() {
        this.myState.isCompilerEnabled = false;
        this.myState.useConfig = false;
        this.myState.trackFileSystemChanges = true;
    }

    public static String getOSDependTypeScriptServicesPathByDirectory(String path) {
        String normalizePath = StringUtil.trimEnd((String)FileUtil.normalize((String)path), (String)"/");
        return FileUtil.toSystemDependentName((String)normalizePath);
    }

    public static boolean acceptFileType(FileType type) {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type);
    }

    @Deprecated
    public boolean isGenerateSourceMap() {
        return this.myState.generateSourceMap;
    }

    @Deprecated
    public void setGenerateSourceMap(boolean generateSourceMap) {
        this.myState.generateSourceMap = generateSourceMap;
    }

    @Deprecated
    public boolean isHasOutDirectory() {
        return this.myState.hasOutDirectory;
    }

    @Deprecated
    public void setHasOutDirectory(boolean pHasOutPath) {
        this.myState.hasOutDirectory = pHasOutPath;
    }

    @Deprecated
    public String getOutDirectory() {
        return this.myState.outDirectory;
    }

    @Deprecated
    public void setOutDirectory(String outDirectory) {
        this.myState.outDirectory = StringUtil.nullize((String)outDirectory, (boolean)true);
    }

    @Deprecated
    @Nullable
    public String getMainFilePath() {
        return this.myState.mainFilePath;
    }

    @Deprecated
    public void setMainFilePath(String mainFilePath) {
        this.myState.mainFilePath = StringUtil.nullize((String)mainFilePath, (boolean)true);
    }

    @Deprecated
    public boolean isUseMainFile() {
        return this.myState.useMainFile;
    }

    @Deprecated
    public void setUseMainFile(boolean useMainFile) {
        this.myState.useMainFile = useMainFile;
    }

    public boolean useMainFile() {
        return this.useDeprecatedSettings() && this.isUseMainFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeScriptServiceDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setScopeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CompilerSettings {
        @Deprecated
        public boolean isCompilerEnabled = false;
        @Deprecated
        public boolean trackFileSystemChanges = true;
        @Deprecated
        public boolean useConfig = false;
        public boolean enableServiceForProjectsWithoutConfig = false;
        public boolean recompileOnChanges = false;
        public boolean useDeprecatedSettings = false;
        public String typeScriptServiceDirectory = null;
        public String typeScriptCompilerParams = null;
        public String nodeInterpreterTextField = null;
        public String scopeName = "Project Files";
        public boolean generateSourceMap = true;
        public boolean hasOutDirectory = false;
        public String outDirectory = "$FileDir$";
        public String mainFilePath = null;
        public boolean useMainFile = false;
        public boolean showAllErrors = false;
        public boolean useSingleInferredProject = true;
        public boolean useService = true;
        public boolean useServiceCompletion = true;
        public boolean useServiceParameterInfo = true;
        public TypeScriptCompilerVersionType versionType = TypeScriptCompilerVersionType.EMBEDDED_OR_DETECTED;

        CompilerSettings() {
        }
    }

    public static enum TypeScriptCompilerVersionType {
        EMBEDDED_OR_DETECTED,
        EMBEDDED,
        SERVICE_DIRECTORY;

    }
}

