/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.ES6CompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlers;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompletionKeywordsContributor
extends ES6CompletionKeywordsContributor {
    public static final String[] PRIMITIVE_TYPES = new String[]{"string", "boolean", "number", "void", "never", "symbol", "undefined", "null", "object", "any"};
    public static final String[] TYPE_PREFIXES = new String[]{"typeof", "keyof"};
    private static final String[] PRIMITIVE_TYPES_FOR_INDEXER = new String[]{"string", "number"};
    private static final String[] TYPE_PREFIXES_FOR_INDEXER = new String[0];

    @Override
    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        PsiElement grandParentParent;
        ASTNode currentNode;
        ASTNode prev;
        JSFunction function;
        JSClass classOfContext;
        PsiElement parent = context.getParent();
        if (parent instanceof TypeScriptPropertySignature && (classOfContext = JSResolveUtil.getClassOfContext(parent)) != null && classOfContext.isInterface()) {
            JSAttributeList list = ((TypeScriptPropertySignature)parent).getAttributeList();
            if (list == null || !list.hasModifier(JSAttributeList.ModifierType.READONLY)) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "readonly", "new");
            }
            return false;
        }
        if (!super.process(consumer, context)) {
            return false;
        }
        boolean isTsIndexer = TypeScriptPsiUtil.isTsIndexerType(parent);
        if (TypeScriptCompletionKeywordsContributor.addPredefinedTypesInTypeContext(parent, consumer, isTsIndexer ? PRIMITIVE_TYPES_FOR_INDEXER : PRIMITIVE_TYPES, isTsIndexer ? TYPE_PREFIXES_FOR_INDEXER : TYPE_PREFIXES) || parent instanceof TypeScriptImportStatement) {
            return false;
        }
        if (parent instanceof JSParameter && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class)) != null && function.isConstructor() && (prev = TreeUtil.prevLeaf((ASTNode)(currentNode = context.getNode()))) != null) {
            IElementType type;
            ASTNode newPrev;
            if (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(prev.getElementType()) && (newPrev = TreeUtil.skipElementsBack((ASTNode)prev, (TokenSet)JSTokenTypes.COMMENTS_AND_WHITESPACES)) != null) {
                prev = newPrev;
            }
            if ((type = prev.getElementType()) == JSTokenTypes.COMMA || type == JSTokenTypes.LPAR) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "private", "public", "protected", "readonly");
                return false;
            }
        }
        PsiElement grandParent = parent.getParent();
        boolean grandParentParentIsModule = false;
        if (grandParent instanceof JSExpressionStatement || grandParent instanceof JSAttributeList) {
            if (grandParent instanceof JSExpressionStatement) {
                PsiElement prev2;
                grandParentParent = grandParent.getParent();
                if (grandParentParent instanceof PsiFile || grandParentParent instanceof TypeScriptModule) {
                    grandParentParentIsModule = true;
                    consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "class", "enum", "interface", "declare", "abstract", "async", "export", "type", "module", "namespace", "import");
                }
                if ((prev2 = JSPsiImplUtils.findPrevCodeElement(grandParent)) instanceof TypeScriptClass && prev2.getNode().findChildByType(JSTokenTypes.LBRACE) == null || prev2 instanceof TypeScriptInterface && ((TypeScriptInterface)prev2).getBody() == null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends");
                    if (prev2 instanceof TypeScriptClass) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "implements");
                    }
                    return false;
                }
            }
            if (grandParentParentIsModule) {
                consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "function", "let", "const", "var");
            } else {
                consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "public", "private", "protected", "function", "let", "const", "var");
            }
            return !TypeScriptPsiUtil.isAmbientDeclaration(grandParent.getParent());
        }
        if (grandParent instanceof TypeScriptImportStatement && parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "require");
            return false;
        }
        if (grandParent instanceof JSVarStatement) {
            grandParentParent = grandParent.getParent();
            if (grandParentParent instanceof TypeScriptClass) {
                TypeScriptCompletionKeywordsContributor.appendKeywordsForClassMember(consumer, (JSVarStatement)grandParent, (TypeScriptClass)grandParentParent);
                return false;
            }
            if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property) {
                return false;
            }
            if (grandParent instanceof JSBinaryExpression || grandParent instanceof TypeScriptTypeParameterList) {
                consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "extends");
            }
        } else {
            if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property) {
                return false;
            }
            if (grandParent instanceof JSBinaryExpression || grandParent instanceof TypeScriptTypeParameterList) {
                consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "extends");
            }
        }
        return true;
    }

    private static void appendKeywordsForClassMember(@NotNull KeywordCompletionConsumer consumer, @NotNull JSVarStatement grandParent, @NotNull TypeScriptClass grandParentParent) {
        JSAttributeList.AccessType accessType;
        if (consumer == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(0);
        }
        if (grandParent == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(1);
        }
        if (grandParentParent == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(2);
        }
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "readonly", "async", "get", "set");
        JSAttributeList attributeList = grandParent.getAttributeList();
        if (!JSPsiImplUtils.hasModifier(attributeList, JSAttributeList.ModifierType.STATIC)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "static");
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "constructor");
        }
        JSAttributeList.AccessType accessType2 = accessType = attributeList == null ? null : attributeList.getExplicitAccessType();
        if (accessType == null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "public", "private", "protected");
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)grandParentParent, JSAttributeList.ModifierType.ABSTRACT)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "abstract");
        }
    }

    public static boolean addPredefinedTypesInTypeContext(PsiElement parent, KeywordCompletionConsumer consumer, @NotNull String[] types, @NotNull String[] typesWithSpaces) {
        if (types == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(3);
        }
        if (typesWithSpaces == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(4);
        }
        if (parent instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)parent)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)parent, JSReferenceList.class) == null && ((JSReferenceExpression)parent).getQualifier() == null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, types);
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, typesWithSpaces);
            }
            return true;
        }
        return false;
    }

    public static boolean addPredefinedTypesInTypeContext(PsiElement parent, KeywordCompletionConsumer consumer, String ... types) {
        return TypeScriptCompletionKeywordsContributor.addPredefinedTypesInTypeContext(parent, consumer, types, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Override
    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer) {
        if (consumer == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(5);
        }
    }

    @Override
    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        super.appendKeywordsAfterExport(consumer);
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "namespace", "module", "enum", "type", "interface");
    }

    @Override
    @Nullable
    public InsertHandler<LookupElement> createInsertHandlerForKeyword(String keyword) {
        switch (keyword) {
            case "require": {
                return JSKeywordInsertHandlers.TS_REQUIRE_INSERT_HANDLER;
            }
            case "interface": {
                return JSKeywordInsertHandlers.INTERFACE_KEYWORD_INSERT_HANDLER;
            }
            case "enum": {
                return JSKeywordInsertHandlers.ENUM_KEYWORD_INSERT_HANDLER;
            }
        }
        return super.createInsertHandlerForKeyword(keyword);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParentParent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesWithSpaces";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptCompletionKeywordsContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendKeywordsForClassMember";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addPredefinedTypesInTypeContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpecificKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

