/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.inspection.SuspiciousTypeOfGuardInspection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SuspiciousInstanceOfGuardInspection
extends JSInspection {
    public static final String SHORT_NAME = SuspiciousInstanceOfGuardInspection.calcShortNameFromClass(SuspiciousInstanceOfGuardInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        if (!DialectDetector.isTypeScript((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SuspiciousInstanceOfGuardInspection.$$$reportNull$$$0(0);
            }
            return psiElementVisitor;
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression expression) {
                PsiElement instanceOf2;
                ProcessingContext context;
                IElementType sign = expression.getOperationSign();
                if (sign != JSTokenTypes.INSTANCEOF_KEYWORD) {
                    return;
                }
                JSExpression lOperand = expression.getLOperand();
                JSExpression rOperand = expression.getROperand();
                if (!(lOperand instanceof JSReferenceExpression) || rOperand == null) {
                    return;
                }
                JSType lType = JSResolveUtil.getExpressionJSType(lOperand);
                if (lType == null || lType instanceof JSAnyType) {
                    return;
                }
                lType = lType.transformTypeHierarchy(t -> SuspiciousTypeOfGuardInspection.getGenericConstraintSelfOrAny(t));
                JSType rType = JSResolveUtil.getExpressionJSType(rOperand);
                if (!(rType instanceof JSTypeImpl)) {
                    return;
                }
                if ((rType = TypeScriptUtil.getConstructedType(rType, rOperand)).isDirectlyAssignableType(lType, context = JSTypeComparingCacheService.getSubtypingProcessingContext((PsiElement)expression))) {
                    PsiElement instanceOf2 = JSRefactoringUtil.skipWhitespaces(lOperand.getNextSibling(), true);
                    if (instanceOf2 == null) {
                        return;
                    }
                    holder.registerProblem(instanceOf2, JSBundle.message((String)"typescript.redundant.instanceof.guard", (Object[])new Object[]{((JSReferenceExpression)lOperand).getReferenceName(), rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                if (lType.isDirectlyAssignableType(rType, context)) {
                    return;
                }
                if (lType instanceof JSCompositeTypeImpl) {
                    instanceOf2 = ((JSCompositeTypeImpl)lType).getTypes().iterator();
                    while (instanceOf2.hasNext()) {
                        JSType part = (JSType)instanceOf2.next();
                        if (!part.isDirectlyAssignableType(rType, context) && !rType.isDirectlyAssignableType(part, context)) continue;
                        return;
                    }
                }
                if ((instanceOf2 = JSRefactoringUtil.skipWhitespaces(lOperand.getNextSibling(), true)) == null) {
                    return;
                }
                holder.registerProblem(instanceOf2, JSBundle.message((String)"typescript.suspicious.instanceof.guard", (Object[])new Object[]{((JSReferenceExpression)lOperand).getReferenceName(), rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        };
        if (jSElementVisitor == null) {
            SuspiciousInstanceOfGuardInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/inspection/SuspiciousInstanceOfGuardInspection", "createVisitor"));
    }
}

