/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptComparingUtil;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptExcludeSourcesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptDeclarationMappingsImpl
implements TypeScriptDeclarationMappings {
    private static final String[] JS_GENERATED_EXTENSIONS = new String[]{".js", ".jsx"};
    private static final Logger LOGGER = Logger.getInstance(TypeScriptDeclarationMappingsImpl.class);
    @NotNull
    private final Project myProject;
    private static final Class<?>[] ACCEPTABLE_CLASSES = new Class[]{JSFunction.class, JSField.class, JSVariable.class, JSClass.class, TypeScriptModule.class};

    public TypeScriptDeclarationMappingsImpl(@NotNull Project project) {
        if (project == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public Collection<JSQualifiedNamedElement> getDeclarationElements(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        String name = file2.getName();
        if (!DialectDetector.isTypeScript((PsiElement)element)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null || TypeScriptLibraryProvider.getAllLibraries(this.myProject).contains(virtualFile)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        String fileNameWithoutExtension = JSFileReference.getFileNameWithoutExtension(name, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS);
        if (StringUtil.isEmpty((String)fileNameWithoutExtension)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        Collection<VirtualFile> candidates = this.getDeclarationFileCandidatesByName(element, fileNameWithoutExtension);
        Collection<JSQualifiedNamedElement> collection = this.getEqualElementsInFiles(element, candidates, false);
        if (collection == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JSQualifiedNamedElement> getTSSourceElements(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        String fileNameWithoutExtension = this.getDeclarationFileNameWithoutExtension(file2);
        if (StringUtil.isEmpty((String)fileNameWithoutExtension) || DumbService.isDumb((Project)this.myProject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        Collection<VirtualFile> candidates = this.getTypeScriptSourceFileCandidatesByName(element, fileNameWithoutExtension);
        Collection<JSQualifiedNamedElement> tsSourceElements = this.getEqualElementsInFiles(element, candidates, false);
        tsSourceElements.forEach(el -> el.putUserData(SOURCE_FILE_MARKER, (Object)true));
        Collection<JSQualifiedNamedElement> collection = tsSourceElements;
        if (collection == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Nullable
    private String getDeclarationFileNameWithoutExtension(@NotNull PsiFile file2) {
        if (file2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(12);
        }
        if (!TypeScriptUtil.isDefinitionFile(file2.getName())) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null || TypeScriptLibraryProvider.getAllLibraries(this.myProject).contains(virtualFile)) {
            return null;
        }
        return JSFileReference.getFileNameWithoutExtension(file2.getName(), TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
    }

    @Override
    @NotNull
    public Collection<? extends PsiElement> getJSSourceElementsOrSearchableStub(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (element instanceof TypeScriptCompileTimeType) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        String fileNameWithoutExtension = this.getDeclarationFileNameWithoutExtension(psiFile);
        if (StringUtil.isEmpty((String)fileNameWithoutExtension) || DumbService.isDumb((Project)this.myProject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(16);
            }
            return list;
        }
        if (TypeScriptExcludeSourcesUtil.areSourcesExcluded((PsiElement)element)) {
            List<PsiElement> list = Collections.singletonList(TypeScriptExcludeSourcesUtil.createIncludeSourcesElement((PsiElement)element));
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        final Collection<VirtualFile> candidates = this.getJavaScriptFileCandidatesByName(element, fileNameWithoutExtension);
        Collection<JSQualifiedNamedElement> elements = this.getEqualElementsInFiles(element, candidates, true);
        if (!elements.isEmpty()) {
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(18);
            }
            return collection;
        }
        final VirtualFile currentVirtualFile = psiFile.getVirtualFile();
        GlobalSearchScope project = GlobalSearchScope.allScope((Project)this.myProject);
        GlobalSearchScope projectWithFileTypeFilter = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)project, (FileType[])new FileType[]{JavaScriptFileType.INSTANCE});
        DelegatingGlobalSearchScope resultScope = new DelegatingGlobalSearchScope(projectWithFileTypeFilter){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !currentVirtualFile.equals(file2) && !candidates.contains(file2) && super.contains(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl$1", "contains"));
            }
        };
        Collection<JSQualifiedNamedElement> collection = this.getEqualElementsInScope(element, (GlobalSearchScope)resultScope, true);
        if (collection == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> getJavaScriptFileCandidatesByName(@NotNull JSQualifiedNamedElement context, @NotNull String fileNameWithoutExtension) {
        if (context == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(20);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(21);
        }
        Collection<VirtualFile> collection = this.getFilesByName(context, fileNameWithoutExtension, JS_GENERATED_EXTENSIONS);
        if (collection == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> getTypeScriptSourceFileCandidatesByName(@NotNull JSQualifiedNamedElement context, @NotNull String fileNameWithoutExtension) {
        if (context == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(23);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(24);
        }
        Collection<VirtualFile> collection = this.getFilesByName(context, fileNameWithoutExtension, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS);
        if (collection == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(25);
        }
        return collection;
    }

    private Collection<VirtualFile> getDeclarationFileCandidatesByName(@NotNull JSQualifiedNamedElement context, @NotNull String fileNameWithoutExtension) {
        if (context == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(26);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(27);
        }
        return this.getFilesByName(context, fileNameWithoutExtension, TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
    }

    private Collection<VirtualFile> getFilesByName(@NotNull JSQualifiedNamedElement context, @NotNull String fileNameWithoutExtension, String[] extensions) {
        if (context == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(28);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList result2 = ContainerUtil.newArrayList();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        for (String extension : extensions) {
            ContainerUtil.addAll((Collection)result2, (Iterable)FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)(fileNameWithoutExtension + extension), (GlobalSearchScope)scope));
        }
        return result2;
    }

    @NotNull
    private Collection<JSQualifiedNamedElement> getEqualElementsInFiles(@NotNull JSQualifiedNamedElement element, @NotNull Collection<VirtualFile> files, boolean processWeakElements) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(30);
        }
        if (files == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(31);
        }
        GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)this.myProject, files);
        Collection<JSQualifiedNamedElement> collection = this.getEqualElementsInScope(element, scope, processWeakElements);
        if (collection == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @NotNull
    private Collection<JSQualifiedNamedElement> getEqualElementsInScope(@NotNull JSQualifiedNamedElement element, @NotNull GlobalSearchScope scope, boolean processWeakElements) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(34);
        }
        scope = TypeScriptUtil.createFilterByNodeModuleScope(scope, (PsiElement)element);
        String qualifiedName = element.getQualifiedName();
        if (StringUtil.isEmpty((String)qualifiedName)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(35);
            }
            return list;
        }
        List result2 = ContainerUtil.newSmartList();
        Processor processor = candidate -> {
            if (element == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(68);
            }
            try {
                if (candidate instanceof JSQualifiedNamedElement && TypeScriptDeclarationMappingsImpl.areElementsEqual(element, (JSQualifiedNamedElement)candidate)) {
                    result2.add((JSQualifiedNamedElement)candidate);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return true;
        };
        this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, qualifiedName);
        if (!processWeakElements || result2.size() > 0) {
            List list = result2;
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(36);
            }
            return list;
        }
        String name = element.getName();
        if (!StringUtil.isEmpty((String)name) && !StringUtil.equals((CharSequence)qualifiedName, (CharSequence)name)) {
            PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
            if (parent instanceof TypeScriptModule) {
                qualifiedName = name;
                this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, qualifiedName);
            } else {
                JSClass container = JSUtils.getMemberContainingClass((PsiElement)element);
                if (container != null && !StringUtil.isEmpty((String)container.getName())) {
                    this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, container.getName() + "." + name);
                }
            }
        }
        if (StringUtil.equals((CharSequence)qualifiedName, (CharSequence)name)) {
            this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, "exports." + qualifiedName);
            this.processSymbolsWithQualifier(scope, (Processor<JSElement>)processor, "module.exports." + qualifiedName);
        }
        List list = result2;
        if (list == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    private void processSymbolsWithQualifier(@NotNull GlobalSearchScope scope, @NotNull Processor<JSElement> processor, @NotNull String name) {
        if (scope == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(38);
        }
        if (processor == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(39);
        }
        if (name == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(40);
        }
        StubIndex.getInstance().processElements(JSSymbolQualifiedNamesIndex.KEY, (Object)name.hashCode(), this.myProject, scope, JSElement.class, processor);
    }

    public static boolean areElementsEqual(@NotNull JSQualifiedNamedElement original, @NotNull JSQualifiedNamedElement candidate) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(41);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(42);
        }
        if (!TypeScriptDeclarationMappingsImpl.areNamesEqual(original, candidate) || !TypeScriptDeclarationMappingsImpl.areContextSimilar(original, candidate)) {
            return false;
        }
        if (TypeScriptDeclarationMappingsImpl.areKindsEqual(original, candidate)) {
            if (original instanceof JSFunction) {
                return TypeScriptComparingUtil.areFunctionsSimilar((JSFunction)original, (JSFunction)candidate);
            }
            if (original instanceof JSClass) {
                return TypeScriptDeclarationMappingsImpl.areJSClassesSimilar((JSClass)original, (JSClass)candidate);
            }
            if (original instanceof JSField) {
                return TypeScriptDeclarationMappingsImpl.areFieldsSimilar((JSField)original, (JSField)candidate);
            }
            if (original instanceof JSVariable) {
                return TypeScriptComparingUtil.areVariablesSimilar((JSFieldVariable)((JSVariable)original), (JSFieldVariable)((JSVariable)candidate));
            }
            if (original instanceof TypeScriptModule) {
                return TypeScriptDeclarationMappingsImpl.areModulesSimilar((TypeScriptModule)original, (TypeScriptModule)candidate);
            }
            return false;
        }
        if (original instanceof JSFunction && candidate instanceof JSClass) {
            return TypeScriptDeclarationMappingsImpl.areFunctionAndJSClassSimilar((JSFunction)original, (JSClass)candidate);
        }
        if (candidate instanceof JSFunction && original instanceof JSClass) {
            return TypeScriptDeclarationMappingsImpl.areFunctionAndJSClassSimilar((JSFunction)candidate, (JSClass)original);
        }
        if (candidate instanceof JSDefinitionExpression && original instanceof JSFunction) {
            return TypeScriptDeclarationMappingsImpl.areDefinitionAndFunctionSimilar((JSDefinitionExpression)candidate, (JSFunction)original);
        }
        if (candidate instanceof JSDefinitionExpression && original instanceof JSVariable) {
            return TypeScriptDeclarationMappingsImpl.areDefinitionAndVariableSimilar((JSDefinitionExpression)candidate, (JSVariable)original);
        }
        return false;
    }

    private static boolean areModulesSimilar(@NotNull TypeScriptModule original, @NotNull TypeScriptModule candidate) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(43);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(44);
        }
        if (original.isInternal() != candidate.isInternal()) {
            return false;
        }
        Collection<String> originalMembers = TypeScriptDeclarationMappingsImpl.getPublicModuleMembers(original);
        Collection<String> candidateMembers = TypeScriptDeclarationMappingsImpl.getPublicModuleMembers(candidate);
        return originalMembers.equals(candidateMembers);
    }

    private static Collection<String> getPublicModuleMembers(@NotNull TypeScriptModule original) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(45);
        }
        return Arrays.stream(original.getChildren()).filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).filter(el -> el.getAccessType() == JSAttributeList.AccessType.PUBLIC).map(el -> el.getName()).filter(el -> el != null).collect(Collectors.toSet());
    }

    public static boolean areFunctionAndJSClassSimilar(@NotNull JSFunction function, @NotNull JSClass jsClass) {
        JSFunction constructor;
        if (function == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(46);
        }
        if (jsClass == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(47);
        }
        if ((constructor = jsClass.getConstructor()) == null) {
            return function.getParameters().length == 0;
        }
        return TypeScriptComparingUtil.areFunctionsSimilar(constructor, function);
    }

    public static boolean areNamesEqual(@NotNull JSQualifiedNamedElement original, @NotNull JSQualifiedNamedElement candidate) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(48);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(49);
        }
        return StringUtil.equals((CharSequence)original.getName(), (CharSequence)candidate.getName());
    }

    public static boolean areKindsEqual(@NotNull JSQualifiedNamedElement original, @NotNull JSQualifiedNamedElement candidate) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(50);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(51);
        }
        for (Class<?> currentClass : ACCEPTABLE_CLASSES) {
            if (!currentClass.isInstance(original) || !currentClass.isInstance(candidate)) continue;
            return true;
        }
        return false;
    }

    private static boolean areDefinitionAndFunctionSimilar(@NotNull JSDefinitionExpression definition, @NotNull JSFunction candidate) {
        JSFunctionExpression expression;
        if (definition == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(52);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(53);
        }
        if ((expression = definition.tryGetFunctionExpressionInitializer()) != null) {
            return TypeScriptComparingUtil.areFunctionsSimilar((JSFunction)expression, candidate);
        }
        return false;
    }

    private static boolean areDefinitionAndVariableSimilar(@NotNull JSDefinitionExpression definition, @NotNull JSVariable variable) {
        JSClass fieldOwner;
        if (definition == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(54);
        }
        if (variable == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(55);
        }
        if ((fieldOwner = JSUtils.getMemberContainingClass((PsiElement)variable)) != null && variable.getJSContext() == JSContext.INSTANCE) {
            JSClass constructorOwner;
            JSFunction constructorFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)definition, JSFunction.class);
            if (constructorFunction == null) {
                return false;
            }
            JSFunction container = constructorFunction;
            if ("constructor".equals(constructorFunction.getName()) && (constructorOwner = JSUtils.getMemberContainingClass((PsiElement)constructorFunction)) != null) {
                container = constructorOwner;
            }
            return StringUtil.equals((CharSequence)container.getName(), (CharSequence)fieldOwner.getName());
        }
        return true;
    }

    private static boolean areContextSimilar(@NotNull JSQualifiedNamedElement element, @NotNull JSQualifiedNamedElement candidate) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(56);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(57);
        }
        JSContext originalContext = element.getJSContext();
        JSContext candidateContext = candidate.getJSContext();
        return originalContext == JSContext.UNKNOWN && candidateContext == JSContext.STATIC || originalContext == JSContext.STATIC && candidateContext == JSContext.UNKNOWN || element.getJSContext() == candidateContext;
    }

    private static boolean areJSClassesSimilar(@NotNull JSClass<?> originalClass, @NotNull JSClass<?> candidateClass) {
        boolean isTypeScriptOnly;
        if (originalClass == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(58);
        }
        if (candidateClass == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(59);
        }
        if (!TypeScriptDeclarationMappingsImpl.areReferenceListsEqual(originalClass.getExtendsList(), candidateClass.getExtendsList())) {
            return false;
        }
        ArrayList originalMembers = ContainerUtil.newArrayList((Iterable)originalClass.getMembers());
        ArrayList candidateMembers = ContainerUtil.newArrayList((Iterable)candidateClass.getMembers());
        Set<String> originalNames = TypeScriptDeclarationMappingsImpl.getMethodNames(originalMembers);
        Set<String> candidateNames = TypeScriptDeclarationMappingsImpl.getMethodNames(candidateMembers);
        boolean bl = isTypeScriptOnly = originalClass instanceof TypeScriptClass && candidateClass instanceof TypeScriptClass;
        if (!originalNames.equals(candidateNames)) {
            if (isTypeScriptOnly) {
                return false;
            }
            if (originalClass instanceof TypeScriptClass && !TypeScriptDeclarationMappingsImpl.areTypeScriptAndJSClassMembersSimilar(originalClass, candidateClass, originalNames, candidateNames)) {
                return false;
            }
            if (candidateClass instanceof TypeScriptClass && !TypeScriptDeclarationMappingsImpl.areTypeScriptAndJSClassMembersSimilar(candidateClass, originalClass, candidateNames, originalNames)) {
                return false;
            }
        }
        return !isTypeScriptOnly || TypeScriptDeclarationMappingsImpl.areReferenceListsEqual(originalClass.getImplementsList(), candidateClass.getImplementsList());
    }

    private static boolean areTypeScriptAndJSClassMembersSimilar(@NotNull JSClass tsClass, @NotNull JSClass jsClass, @NotNull Set<String> tsMembers, @NotNull Set<String> jsMembers) {
        if (tsClass == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(60);
        }
        if (jsClass == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(61);
        }
        if (tsMembers == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(62);
        }
        if (jsMembers == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(63);
        }
        return tsMembers.containsAll(jsMembers);
    }

    private static boolean areReferenceListsEqual(@Nullable JSReferenceList list, @Nullable JSReferenceList candidateExtendsList) {
        if ((list == null || candidateExtendsList == null) && list != candidateExtendsList) {
            return false;
        }
        if (list != null) {
            Object[] texts = list.getReferenceTexts();
            Object[] candidatesTexts = candidateExtendsList.getReferenceTexts();
            return Arrays.equals(texts, candidatesTexts);
        }
        return true;
    }

    @NotNull
    private static Set<String> getMethodNames(@NotNull List<JSElement> candidateMembers) {
        if (candidateMembers == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(64);
        }
        Set<String> set = candidateMembers.stream().map(el -> el.getName()).filter(el -> el != null && !"constructor".equals(el)).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(65);
        }
        return set;
    }

    private static boolean areFieldsSimilar(@NotNull JSField original, @NotNull JSField candidate) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(66);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(67);
        }
        JSClass originalClass = JSUtils.getMemberContainingClass((PsiElement)original);
        JSClass candidateClass = JSUtils.getMemberContainingClass((PsiElement)candidate);
        if (originalClass == null || candidateClass == null || !TypeScriptDeclarationMappingsImpl.areJSClassesSimilar(originalClass, candidateClass)) {
            return false;
        }
        JSType type = original.getType();
        JSType candidateType = candidate.getType();
        if (TypeScriptComparingUtil.skipType(type) || TypeScriptComparingUtil.skipType(candidateType)) {
            return true;
        }
        return TypeScriptComparingUtil.areTypeTextEqual(type, candidateType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 30: 
            case 33: 
            case 56: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExtension";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 42: 
            case 44: 
            case 49: 
            case 51: 
            case 53: 
            case 57: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 47: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateClass";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsClass";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsMembers";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsMembers";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElements";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTSSourceElements";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSSourceElementsOrSearchableStub";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptFileCandidatesByName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptSourceFileCandidatesByName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualElementsInFiles";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualElementsInScope";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 65: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTSSourceElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationFileNameWithoutExtension";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getJSSourceElementsOrSearchableStub";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getJavaScriptFileCandidatesByName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptSourceFileCandidatesByName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationFileCandidatesByName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getEqualElementsInFiles";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getEqualElementsInScope";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processSymbolsWithQualifier";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "areElementsEqual";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "areModulesSimilar";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPublicModuleMembers";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "areFunctionAndJSClassSimilar";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "areNamesEqual";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "areKindsEqual";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "areDefinitionAndFunctionSimilar";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "areDefinitionAndVariableSimilar";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "areContextSimilar";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "areJSClassesSimilar";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "areTypeScriptAndJSClassMembersSimilar";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNames";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "areFieldsSimilar";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEqualElementsInScope$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

