/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptConfigGraphCache;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigServiceImpl
implements TypeScriptConfigService {
    public static final Logger LOGGER = Logger.getInstance(TypeScriptConfigService.class);
    private static final Function<PsiFile, TypeScriptConfig> MAP_TO_CONFIG = file2 -> {
        if (JSLibraryUtil.isProbableLibraryFile(file2.getVirtualFile())) {
            return null;
        }
        return TypeScriptConfigBase.getConfig(file2);
    };
    private static final Predicate<VirtualFile> ALWAYS_TRUE = el -> true;
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<List<TypeScriptConfig>> myConfigs;
    private final CachedValue<ConcurrentMap<VirtualFile, Map<VirtualFile, Boolean>>> myFilesMappings;
    private final SimpleModificationTracker myTracker;
    @Nullable
    private final TypeScriptConfigLibraryUpdater myUpdater;
    private final TypeScriptConfigGraphCache myConfigGraphCache;
    private final Collection<TypeScriptConfigsChangedListener> myListeners;

    public TypeScriptConfigServiceImpl(@NotNull Project project, @Nullable TypeScriptConfigLibraryUpdater updater, @NotNull TypeScriptConfigGraphCache configGraphCache) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(0);
        }
        if (configGraphCache == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(1);
        }
        this.myTracker = new SimpleModificationTracker();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myUpdater = updater;
        this.myConfigGraphCache = configGraphCache;
        CachedValueProvider configsProvider = () -> (CachedValueProvider.Result)ReadAction.compute(() -> {
            this.beforeUpdate();
            Collection virtualFiles = FileTypeIndex.getFiles((FileType)TypeScriptConfigFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
            PsiManager manager = PsiManager.getInstance((Project)this.myProject);
            List files = virtualFiles.stream().sorted(Comparator.comparing(el -> el.getName())).map(el -> manager.findFile(el)).filter(el -> el != null).collect(Collectors.toList());
            List configs = ContainerUtil.mapNotNull(files, MAP_TO_CONFIG);
            HashSet depends = ContainerUtil.newHashSet((int)(configs.size() + 1));
            depends.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            ContainerUtil.addAll((Collection)depends, files);
            this.addAdditionalDeps(configs, depends);
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)configs, (Collection)depends);
            this.afterUpdate(configs);
            return result2;
        });
        this.myConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(configsProvider, false);
        this.myFilesMappings = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
    }

    private void addAdditionalDeps(@NotNull Collection<TypeScriptConfig> configs, @NotNull Collection<Object> depends) {
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(2);
        }
        if (depends == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(3);
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        for (TypeScriptConfig config2 : configs) {
            VirtualFile virtualFile = config2.getConfigFile();
            for (VirtualFile file2 : config2.getDependencies()) {
                if (file2.equals(virtualFile)) continue;
                PsiFile psiFile = manager.findFile(file2);
                depends.add(psiFile != null ? psiFile : file2);
            }
        }
    }

    private void beforeUpdate() {
        this.myTracker.incModificationCount();
        if (this.myUpdater != null) {
            this.myUpdater.queueToUpdate();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isAccessible(@NotNull VirtualFile scope, @NotNull VirtualFile referenced) {
        Boolean value;
        Map prevValue;
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(4);
        }
        if (referenced == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(5);
        }
        if (scope.equals(referenced)) {
            return true;
        }
        if (!this.isEnabled() || DumbService.isDumb((Project)this.myProject)) {
            return true;
        }
        ConcurrentMap filesRefsMap = (ConcurrentMap)this.myFilesMappings.getValue();
        Map scopeFileMap = (Map)filesRefsMap.get(scope);
        if (scopeFileMap == null && (prevValue = filesRefsMap.putIfAbsent(scope, scopeFileMap = ContainerUtil.newConcurrentMap())) != null) {
            scopeFileMap = prevValue;
        }
        if ((value = (Boolean)scopeFileMap.get(referenced)) == null) {
            value = this.isAccessibleImpl(scope, referenced);
            scopeFileMap.put(referenced, value);
        }
        return value;
    }

    @Override
    @NotNull
    public Predicate<VirtualFile> getAccessScope(@NotNull VirtualFile scope) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            Predicate<VirtualFile> predicate = ALWAYS_TRUE;
            if (predicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(7);
            }
            return predicate;
        }
        List<TypeScriptConfig> files = this.getConfigFiles();
        if (files.isEmpty()) {
            Predicate<VirtualFile> predicate = ALWAYS_TRUE;
            if (predicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(8);
            }
            return predicate;
        }
        Collection<TypeScriptImportGraph> graphs = this.getConfigGraphInclude(scope);
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(this.myProject);
        Predicate predicate = file2 -> {
            String fileName;
            boolean isStandardLib;
            if (scope == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(32);
            }
            if (file2 == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(33);
            }
            if ((isStandardLib = service.isLibraryFileName(fileName = file2.getName())) && service.isLibraryFile((VirtualFile)file2)) {
                return true;
            }
            boolean firstInclude = false;
            boolean bothIncludes = false;
            for (TypeScriptImportGraph graph : graphs) {
                firstInclude = true;
                if (!this.isGraphIncludeFile(graph, (VirtualFile)file2)) continue;
                bothIncludes = true;
                break;
            }
            if (bothIncludes) {
                return true;
            }
            if (TypeScriptUtil.isUnderNodeModules(file2, this.myProject) && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file2.getFileType())) {
                if (!isStandardLib && TypeScriptUtil.isDefinitionFile(fileName)) {
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
                    if (psiFile instanceof JSFile && ((JSFile)psiFile).isCommonJSModule()) {
                        return true;
                    }
                    if (!firstInclude && !TypeScriptUtil.isUnderNodeModules(scope, this.myProject)) {
                        return true;
                    }
                }
            } else if (!firstInclude) {
                return true;
            }
            return false;
        };
        if (predicate == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(9);
        }
        return predicate;
    }

    private boolean isAccessibleImpl(@NotNull VirtualFile scope, @NotNull VirtualFile file2) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(11);
        }
        return this.getAccessScope(scope).apply((Object)file2);
    }

    @Override
    @NotNull
    public List<TypeScriptConfig> getConfigInclude(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(12);
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<TypeScriptConfig> configs = this.getConfigFiles();
        if (configs.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<TypeScriptConfig> list = configs.stream().filter(el -> {
            if (scopeFile == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(31);
            }
            return this.myConfigGraphCache.isConfigInclude(scopeFile, (TypeScriptConfig)el);
        }).collect(Collectors.toList());
        if (list == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private Collection<TypeScriptImportGraph> getConfigGraphInclude(@NotNull VirtualFile scopeFile) {
        List<TypeScriptConfig> configs;
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(16);
        }
        if ((configs = this.getConfigFiles()).isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        Collection collection = configs.stream().map(config2 -> this.myConfigGraphCache.getGraph((TypeScriptConfig)config2)).filter(el -> {
            if (scopeFile == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(30);
            }
            return this.isGraphIncludeFile((TypeScriptImportGraph)el, scopeFile);
        }).collect(Collectors.toList());
        if (collection == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(18);
        }
        return collection;
    }

    protected boolean isGraphIncludeFile(@NotNull TypeScriptImportGraph el, @NotNull VirtualFile scopeFile) {
        if (el == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(19);
        }
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(20);
        }
        return el.containsFile(scopeFile);
    }

    @Override
    public boolean isConfigInclude(@NotNull VirtualFile scopeFile, @NotNull TypeScriptConfig config2) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(21);
        }
        if (config2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(22);
        }
        return this.myConfigGraphCache.isConfigInclude(scopeFile, config2);
    }

    @Override
    public void addChangeListener(@NotNull TypeScriptConfigsChangedListener listener2) {
        if (listener2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(23);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public boolean hasConfigs() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection configs = (Collection)this.myConfigs.getValue();
        return !configs.isEmpty();
    }

    @Override
    @Nullable
    public TypeScriptConfig parseConfigFile(@NotNull VirtualFile file2) {
        PsiFile psiFile;
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myConfigs.hasUpToDateValue()) {
            for (TypeScriptConfig config2 : (List)this.myConfigs.getValue()) {
                if (!file2.equals(config2.getConfigFile())) continue;
                return config2;
            }
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2)) != null) {
            return TypeScriptConfigBase.getConfig(psiFile);
        }
        return null;
    }

    private void afterUpdate(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(25);
        }
        for (TypeScriptConfigsChangedListener listener2 : this.myListeners) {
            listener2.afterUpdate(configs);
        }
    }

    @Override
    @NotNull
    public ModificationTracker getTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myTracker;
        if (simpleModificationTracker == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(26);
        }
        return simpleModificationTracker;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(27);
        }
        TypeScriptFileImportsImpl imports = new TypeScriptFileImportsImpl(this.myProject, file2);
        Collection collection = new TypeScriptImportGraph(imports).getNodes();
        if (collection == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<TypeScriptConfig> getConfigFiles() {
        List value = (List)this.myConfigs.getValue();
        List list = value == null ? ContainerUtil.emptyList() : value;
        if (list == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configGraphCache";
                break;
            }
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depends";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 11: 
            case 24: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessScope";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigInclude";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigGraphInclude";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalDeps";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAccessScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConfigInclude";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getConfigGraphInclude";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isGraphIncludeFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isConfigInclude";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "afterUpdate";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigGraphInclude$11";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigInclude$9";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAccessScope$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

