/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.codeInsight.ChangeAnnotationFix;
import com.intellij.execution.junit.codeInsight.JUnit5MalformedParameterizedInspection;
import com.intellij.execution.junit.codeInsight.references.MethodSourceReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.junit.JUnitCommonClassNames;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedParameterizedInspection;", "Lcom/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getDisplayName", "", "hasMultipleParameters", "method", "Lcom/intellij/psi/PsiMethod;", "Annotations", "intellij.junit"})
public final class JUnit5MalformedParameterizedInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message((String)"junit5.valid.parameterized.configuration.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiFile file = holder.getFile();
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)file, JavaSdkVersion.JDK_1_8)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiFile psiFile = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
        if (JavaPsiFacade.getInstance((Project)psiFile.getProject()).findClass("org.junit.jupiter.params.ParameterizedTest", file.getResolveScope()) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new JavaElementVisitor(this, holder){
            final /* synthetic */ JUnit5MalformedParameterizedInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitMethod(@NotNull PsiMethod method) {
                Ref.BooleanRef booleanRef;
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                PsiAnnotation[] parameterizedAnnotation = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)Collections.singletonList("org.junit.jupiter.params.ParameterizedTest"));
                PsiAnnotation[] testAnnotation = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_JUPITER_ANNOTATIONS);
                Intrinsics.checkExpressionValueIsNotNull((Object)parameterizedAnnotation, (String)"parameterizedAnnotation");
                Ref.BooleanRef booleanRef2 = booleanRef = (Ref.BooleanRef)parameterizedAnnotation;
                if (!(((Object[])booleanRef2).length == 0)) {
                    void source;
                    void noMultiArgsProvider;
                    Intrinsics.checkExpressionValueIsNotNull((Object)testAnnotation, (String)"testAnnotation");
                    booleanRef2 = booleanRef = (Object[])testAnnotation;
                    if (!(((Object[])booleanRef2).length == 0)) {
                        PsiParameterList psiParameterList = method.getParameterList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
                        if (psiParameterList.getParametersCount() > 0) {
                            this.$holder.registerProblem((PsiElement)testAnnotation[0], "Suspicious combination @Test and @ParameterizedTest", new LocalQuickFix[]{(LocalQuickFix)new DeleteElementFix((PsiElement)testAnnotation[0])});
                        }
                    }
                    booleanRef = new Ref.BooleanRef();
                    booleanRef.element = true;
                    booleanRef2 = new Ref.ObjectRef();
                    booleanRef2.element = null;
                    MetaAnnotationUtil.findMetaAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitCommonClassNames.SOURCE_ANNOTATIONS).forEach((Consumer)new Consumer<PsiAnnotation>(this, method, (Ref.BooleanRef)noMultiArgsProvider, (Ref.ObjectRef)source){
                        final /* synthetic */ buildVisitor.1 this$0;
                        final /* synthetic */ PsiMethod $method;
                        final /* synthetic */ Ref.BooleanRef $noMultiArgsProvider;
                        final /* synthetic */ Ref.ObjectRef $source;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final void accept(PsiAnnotation it) {
                            block11: {
                                block8: {
                                    block9: {
                                        block10: {
                                            String string;
                                            PsiAnnotation psiAnnotation = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"it");
                                            String string2 = string = psiAnnotation.getQualifiedName();
                                            if (string2 == null) return;
                                            switch (string2.hashCode()) {
                                                case -2084799780: {
                                                    if (!string.equals("org.junit.jupiter.params.provider.ValueSource")) return;
                                                    break;
                                                }
                                                case 124822449: {
                                                    if (!string.equals("org.junit.jupiter.params.provider.CsvSource")) return;
                                                    break block8;
                                                }
                                                case 2141896013: {
                                                    if (!string.equals("org.junit.jupiter.params.provider.CsvFileSource")) return;
                                                    break block9;
                                                }
                                                case -1320765300: {
                                                    if (!string.equals("org.junit.jupiter.params.provider.EnumSource")) return;
                                                    break block10;
                                                }
                                                case -205673727: {
                                                    if (!string.equals("org.junit.jupiter.params.provider.ArgumentsSource")) return;
                                                    break block11;
                                                }
                                                case 2129905772: {
                                                    if (!string.equals("org.junit.jupiter.params.provider.MethodSource")) return;
                                                    buildVisitor.1.access$checkMethodSource(this.this$0, this.$method, it);
                                                    this.$noMultiArgsProvider.element = false;
                                                    return;
                                                }
                                            }
                                            buildVisitor.1.access$checkValuesSource(this.this$0, this.$method, it);
                                            this.$source.element = it;
                                            return;
                                        }
                                        buildVisitor.1.access$checkEnumSource(this.this$0, this.$method, it);
                                        this.$source.element = it;
                                        return;
                                    }
                                    buildVisitor.1.access$checkFileSource(this.this$0, it);
                                    this.$noMultiArgsProvider.element = false;
                                    return;
                                }
                                this.$noMultiArgsProvider.element = false;
                                return;
                            }
                            if ((PsiAnnotation)this.$source.element != null) return;
                            this.$noMultiArgsProvider.element = false;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$method = psiMethod;
                            this.$noMultiArgsProvider = booleanRef;
                            this.$source = objectRef;
                        }
                    });
                    if (noMultiArgsProvider.element) {
                        if ((PsiAnnotation)source.element == null) {
                            this.$holder.registerProblem((PsiElement)parameterizedAnnotation[0], "No sources are provided, the suite would be empty", new LocalQuickFix[0]);
                        } else if (JUnit5MalformedParameterizedInspection.access$hasMultipleParameters(this.this$0, method)) {
                            PsiAnnotation psiAnnotation = (PsiAnnotation)source.element;
                            if (psiAnnotation == null) {
                                Intrinsics.throwNpe();
                            }
                            this.$holder.registerProblem((PsiElement)psiAnnotation, "Multiple parameters are not supported by this source", new LocalQuickFix[0]);
                        }
                    }
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)testAnnotation, (String)"testAnnotation");
                    booleanRef2 = booleanRef = (Object[])testAnnotation;
                    if (!(((Object[])booleanRef2).length == 0) && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitCommonClassNames.SOURCE_ANNOTATIONS)) {
                        PsiElement psiElement = (PsiElement)testAnnotation[0];
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                        PsiAnnotation psiAnnotation = testAnnotation[0];
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"testAnnotation[0]");
                        localQuickFixArray[0] = (LocalQuickFix)new ChangeAnnotationFix(psiAnnotation, "org.junit.jupiter.params.ParameterizedTest");
                        this.$holder.registerProblem(psiElement, "Suspicious combination @Test and parameterized source", localQuickFixArray);
                    }
                }
            }

            private final void checkEnumSource(PsiMethod method, PsiAnnotation enumSource) {
                this.processArrayInAnnotationParameter(enumSource.findAttributeValue("value"), (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, method){
                    final /* synthetic */ buildVisitor.1 this$0;
                    final /* synthetic */ PsiMethod $method;

                    public final void invoke(@NotNull PsiAnnotationMemberValue value) {
                        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                        if (value instanceof PsiClassObjectAccessExpression) {
                            PsiTypeElement psiTypeElement = ((PsiClassObjectAccessExpression)value).getOperand();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeElement, (String)"value.operand");
                            PsiType psiType = psiTypeElement.getType();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"value.operand.type");
                            buildVisitor.1.access$checkSourceTypeAndParameterTypeAgree(this.this$0, this.$method, value, psiType);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$method = psiMethod;
                        super(1);
                    }
                }));
            }

            private final void checkValuesSource(PsiMethod method, PsiAnnotation valuesSource) {
                Map possibleValues = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"strings", (Object)PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope())), TuplesKt.to((Object)"ints", (Object)PsiType.INT), TuplesKt.to((Object)"longs", (Object)PsiType.LONG), TuplesKt.to((Object)"doubles", (Object)PsiType.DOUBLE)});
                for (String valueKey : possibleValues.keySet()) {
                    this.processArrayInAnnotationParameter(valuesSource.findDeclaredAttributeValue(valueKey), (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, method, possibleValues, valueKey){
                        final /* synthetic */ buildVisitor.1 this$0;
                        final /* synthetic */ PsiMethod $method;
                        final /* synthetic */ Map $possibleValues;
                        final /* synthetic */ String $valueKey;

                        public final void invoke(@NotNull PsiAnnotationMemberValue value) {
                            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                            V v = this.$possibleValues.get(this.$valueKey);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            buildVisitor.1.access$checkSourceTypeAndParameterTypeAgree(this.this$0, this.$method, value, (PsiType)v);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$method = psiMethod;
                            this.$possibleValues = map;
                            this.$valueKey = string;
                            super(1);
                        }
                    }));
                }
                PsiAnnotationParameterList psiAnnotationParameterList = valuesSource.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationParameterList, (String)"valuesSource.parameterList");
                int attributesNumber = ((Object[])psiAnnotationParameterList.getAttributes()).length;
                if (attributesNumber > 1) {
                    this.$holder.registerProblem((PsiElement)valuesSource, "Exactly one type of input must be provided", new LocalQuickFix[0]);
                } else if (attributesNumber == 0) {
                    this.$holder.registerProblem((PsiElement)valuesSource, "No value source is defined", new LocalQuickFix[0]);
                }
            }

            private final void checkFileSource(PsiAnnotation methodSource) {
                PsiAnnotationMemberValue annotationMemberValue = methodSource.findDeclaredAttributeValue("resources");
                this.processArrayInAnnotationParameter(annotationMemberValue, (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this){
                    final /* synthetic */ buildVisitor.1 this$0;

                    public final void invoke(@NotNull PsiAnnotationMemberValue attributeValue) {
                        Object v1;
                        List refs;
                        block7: {
                            Object $receiver$iv$iv;
                            Intrinsics.checkParameterIsNotNull((Object)attributeValue, (String)"attributeValue");
                            PsiReference[] psiReferenceArray = attributeValue.getReferences();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"attributeValue.references");
                            Object $receiver$iv = psiReferenceArray;
                            Object[] objectArray = $receiver$iv;
                            Object destination$iv$iv = new ArrayList<E>();
                            for (void element$iv$iv : $receiver$iv$iv) {
                                PsiReference it = (PsiReference)element$iv$iv;
                                if (!(it instanceof FileReference)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            refs = (List)destination$iv$iv;
                            $receiver$iv$iv = $receiver$iv = (Iterable)refs;
                            destination$iv$iv = $receiver$iv$iv.iterator();
                            while (destination$iv$iv.hasNext()) {
                                E e = destination$iv$iv.next();
                                PsiReference reference = (PsiReference)e;
                                if (!(reference.resolve() != null)) continue;
                                v1 = e;
                                break block7;
                            }
                            v1 = null;
                        }
                        if (v1 == null) {
                            LocalQuickFix[] localQuickFixArray;
                            PsiReference reference = (PsiReference)CollectionsKt.first((List)refs);
                            if (reference != null) {
                                Collection $receiver$iv;
                                List list = FileReferenceQuickFixProvider.registerQuickFix((FileReference)((FileReference)reference));
                                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"FileReferenceQuickFixPro\u2026ference as FileReference)");
                                Collection collection = $receiver$iv = (Collection)list;
                                if (collection == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                                }
                                Collection thisCollection$iv = collection;
                                LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                                if (localQuickFixArray2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                localQuickFixArray = localQuickFixArray2;
                            } else {
                                localQuickFixArray = new LocalQuickFix[]{};
                            }
                            LocalQuickFix[] fixes = localQuickFixArray;
                            this.this$0.$holder.registerProblem((PsiElement)attributeValue, "Cannot resolve file source: '" + attributeValue.getText() + '\'', Arrays.copyOf(fixes, fixes.length));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }

            private final void checkMethodSource(PsiMethod method, PsiAnnotation methodSource) {
                PsiClass psiClass = method.getContainingClass();
                if (psiClass == null) {
                    Intrinsics.throwNpe();
                }
                PsiClass containingClass = psiClass;
                PsiAnnotationMemberValue annotationMemberValue = methodSource.findDeclaredAttributeValue("value");
                if (annotationMemberValue == null) {
                    if (methodSource.findAttributeValue("value") == null) {
                        return;
                    }
                    String providerName = method.getName();
                    PsiMethod[] methods = containingClass.findMethodsBySignature(JavaPsiFacade.getElementFactory((Project)method.getProject()).createMethodFromText("void " + providerName + "()", (PsiElement)method), false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)methods, (String)"methods");
                    Object[] objectArray = methods;
                    if (!(objectArray.length == 0)) {
                        PsiMethod psiMethod = methods[0];
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"methods[0]");
                        this.doCheckSourceProvider(psiMethod, containingClass, (PsiElement)methodSource, method);
                    } else {
                        PsiClass psiClass2 = containingClass;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"containingClass");
                        PsiElement psiElement = (PsiElement)methodSource;
                        String string = providerName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"providerName");
                        this.highlightAbsentSourceProvider(psiClass2, psiElement, string);
                    }
                } else {
                    this.processArrayInAnnotationParameter(annotationMemberValue, (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, containingClass, method){
                        final /* synthetic */ buildVisitor.1 this$0;
                        final /* synthetic */ PsiClass $containingClass;
                        final /* synthetic */ PsiMethod $method;

                        public final void invoke(@NotNull PsiAnnotationMemberValue attributeValue) {
                            Intrinsics.checkParameterIsNotNull((Object)attributeValue, (String)"attributeValue");
                            for (PsiReference reference : attributeValue.getReferences()) {
                                if (!(reference instanceof MethodSourceReference)) continue;
                                PsiElement resolve = reference.resolve();
                                if (!(resolve instanceof PsiMethod)) {
                                    PsiClass psiClass = this.$containingClass;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"containingClass");
                                    PsiElement psiElement = (PsiElement)attributeValue;
                                    String string = ((MethodSourceReference)reference).getValue();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reference.value");
                                    buildVisitor.1.access$highlightAbsentSourceProvider(this.this$0, psiClass, psiElement, string);
                                    continue;
                                }
                                PsiMethod sourceProvider = (PsiMethod)resolve;
                                buildVisitor.1.access$doCheckSourceProvider(this.this$0, sourceProvider, this.$containingClass, (PsiElement)attributeValue, this.$method);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$containingClass = psiClass;
                            this.$method = psiMethod;
                            super(1);
                        }
                    }));
                }
            }

            private final void highlightAbsentSourceProvider(PsiClass containingClass, PsiElement attributeValue, String sourceProviderName) {
                CreateMethodQuickFix createFix = null;
                if (this.$holder.isOnTheFly()) {
                    String staticModifier = !TestUtils.testInstancePerClass((PsiClass)containingClass) ? " static" : "";
                    createFix = CreateMethodQuickFix.createFix((PsiClass)containingClass, (String)("private" + staticModifier + " Object[][] " + sourceProviderName + "()"), (String)"return new Object[][] {};");
                }
                this.$holder.registerProblem(attributeValue, "Cannot resolve target method source: '" + sourceProviderName + '\'', new LocalQuickFix[]{(LocalQuickFix)createFix});
            }

            private final void doCheckSourceProvider(PsiMethod sourceProvider, PsiClass containingClass, PsiElement attributeValue, PsiMethod method) {
                String providerName = sourceProvider.getName();
                if (!sourceProvider.hasModifierProperty("static") && containingClass != null && !TestUtils.testInstancePerClass((PsiClass)containingClass)) {
                    this.$holder.registerProblem(attributeValue, "Method source '" + providerName + "' must be static", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)sourceProvider, "static", true, false)});
                } else {
                    PsiParameterList psiParameterList = sourceProvider.getParameterList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"sourceProvider.parameterList");
                    if (psiParameterList.getParametersCount() != 0) {
                        this.$holder.registerProblem(attributeValue, "Method source '" + providerName + "' should have no parameters", new LocalQuickFix[0]);
                    } else {
                        PsiType componentType = this.getComponentType(sourceProvider.getReturnType(), method);
                        if (componentType == null) {
                            this.$holder.registerProblem(attributeValue, "Method source '" + providerName + "' must have one of the following return type: Stream<?>, Iterator<?>, Iterable<?> or Object[]", new LocalQuickFix[0]);
                        } else if (JUnit5MalformedParameterizedInspection.access$hasMultipleParameters(this.this$0, method) && !this.isArgumentsInheritor(componentType) && !componentType.equalsToText("java.lang.Object") && !componentType.getDeepComponentType().equalsToText("java.lang.Object")) {
                            this.$holder.registerProblem(attributeValue, "Multiple parameters have to be wrapped in Arguments", new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private final void processArrayInAnnotationParameter(PsiAnnotationMemberValue attributeValue, Function1<? super PsiAnnotationMemberValue, Unit> checker) {
                if (attributeValue instanceof PsiLiteral || attributeValue instanceof PsiClassObjectAccessExpression) {
                    checker.invoke((Object)attributeValue);
                } else if (attributeValue instanceof PsiArrayInitializerMemberValue) {
                    for (PsiAnnotationMemberValue memberValue : ((PsiArrayInitializerMemberValue)attributeValue).getInitializers()) {
                        this.processArrayInAnnotationParameter(memberValue, checker);
                    }
                }
            }

            private final void checkSourceTypeAndParameterTypeAgree(PsiMethod method, PsiAnnotationMemberValue attributeValue, PsiType componentType) {
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
                PsiParameter[] parameters = psiParameterList.getParameters();
                if (((Object[])parameters).length == 1) {
                    PsiParameter psiParameter = parameters[0];
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[0]");
                    PsiType paramType = psiParameter.getType();
                    if (!paramType.isAssignableFrom(componentType) && !this.isArgumentsInheritor(componentType)) {
                        if (componentType.equalsToText("java.lang.String")) {
                            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)paramType)) {
                                return;
                            }
                            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType);
                            if (psiClass != null) {
                                String qualifiedName;
                                if (psiClass.isEnum()) {
                                    PsiAnnotationMemberValue psiAnnotationMemberValue = attributeValue;
                                    if (psiAnnotationMemberValue == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiLiteral");
                                    }
                                    if (psiClass.findFieldByName((String)((PsiLiteral)psiAnnotationMemberValue).getValue(), false) != null) {
                                        return;
                                    }
                                }
                                if ((qualifiedName = psiClass.getQualifiedName()) != null && StringsKt.startsWith$default((String)qualifiedName, (String)"java.time.", (boolean)false, (int)2, null)) {
                                    return;
                                }
                            }
                        }
                        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)parameters[0]), (String)"org.junit.jupiter.params.converter.ConvertWith", (int)0)) {
                            return;
                        }
                        PsiElement psiElement = (PsiElement)attributeValue;
                        StringBuilder stringBuilder = new StringBuilder().append("No implicit conversion found to convert object of type ").append(componentType.getPresentableText()).append(" to ");
                        PsiType psiType = paramType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"paramType");
                        this.$holder.registerProblem(psiElement, stringBuilder.append(psiType.getPresentableText()).toString(), new LocalQuickFix[0]);
                    }
                }
            }

            private final boolean isArgumentsInheritor(PsiType componentType) {
                return InheritanceUtil.isInheritor((PsiType)componentType, (String)"org.junit.jupiter.params.provider.Arguments");
            }

            private final PsiType getComponentType(PsiType returnType, PsiMethod method) {
                PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)returnType, (GlobalSearchScope)method.getResolveScope());
                if (collectionItemType != null) {
                    return collectionItemType;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.IntStream")) {
                    return (PsiType)PsiType.INT;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.LongStream")) {
                    return (PsiType)PsiType.LONG;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.DoubleStream")) {
                    return (PsiType)PsiType.DOUBLE;
                }
                PsiType streamItemType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.stream.Stream", (int)0, (boolean)true);
                if (streamItemType != null) {
                    return streamItemType;
                }
                return PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.Iterator", (int)0, (boolean)true);
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }

            public static final /* synthetic */ void access$checkMethodSource(buildVisitor.1 $this, @NotNull PsiMethod method, @NotNull PsiAnnotation methodSource) {
                $this.checkMethodSource(method, methodSource);
            }

            public static final /* synthetic */ void access$checkValuesSource(buildVisitor.1 $this, @NotNull PsiMethod method, @NotNull PsiAnnotation valuesSource) {
                $this.checkValuesSource(method, valuesSource);
            }

            public static final /* synthetic */ void access$checkEnumSource(buildVisitor.1 $this, @NotNull PsiMethod method, @NotNull PsiAnnotation enumSource) {
                $this.checkEnumSource(method, enumSource);
            }

            public static final /* synthetic */ void access$checkFileSource(buildVisitor.1 $this, @NotNull PsiAnnotation methodSource) {
                $this.checkFileSource(methodSource);
            }

            public static final /* synthetic */ void access$checkSourceTypeAndParameterTypeAgree(buildVisitor.1 $this, @NotNull PsiMethod method, @NotNull PsiAnnotationMemberValue attributeValue, @NotNull PsiType componentType) {
                $this.checkSourceTypeAndParameterTypeAgree(method, attributeValue, componentType);
            }

            public static final /* synthetic */ void access$highlightAbsentSourceProvider(buildVisitor.1 $this, @NotNull PsiClass containingClass, @NotNull PsiElement attributeValue, @NotNull String sourceProviderName) {
                $this.highlightAbsentSourceProvider(containingClass, attributeValue, sourceProviderName);
            }

            public static final /* synthetic */ void access$doCheckSourceProvider(buildVisitor.1 $this, @NotNull PsiMethod sourceProvider, @Nullable PsiClass containingClass, @NotNull PsiElement attributeValue, @NotNull PsiMethod method) {
                $this.doCheckSourceProvider(sourceProvider, containingClass, attributeValue, method);
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasMultipleParameters(PsiMethod method) {
        void $receiver$iv$iv;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) return false;
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"method.parameterList.parameters");
        Object[] $receiver$iv = psiParameterArray;
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            PsiParameter it;
            PsiParameter psiParameter = it = (PsiParameter)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"it");
            if (!(!InheritanceUtil.isInheritor((PsiType)psiParameter.getType(), (String)"org.junit.jupiter.api.TestInfo") && !InheritanceUtil.isInheritor((PsiType)it.getType(), (String)"org.junit.jupiter.api.TestReporter"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        if (collection.size() <= 1) return false;
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)Annotations.INSTANCE.getEXTENDS_WITH())) return false;
        if (MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (Collection)Annotations.INSTANCE.getEXTENDS_WITH())) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$hasMultipleParameters(JUnit5MalformedParameterizedInspection $this, @NotNull PsiMethod method) {
        return $this.hasMultipleParameters(method);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedParameterizedInspection$Annotations;", "", "()V", "EXTENDS_WITH", "", "", "getEXTENDS_WITH", "()Ljava/util/List;", "intellij.junit"})
    private static final class Annotations {
        @NotNull
        private static final List<String> EXTENDS_WITH;
        public static final Annotations INSTANCE;

        @NotNull
        public final List<String> getEXTENDS_WITH() {
            return EXTENDS_WITH;
        }

        private Annotations() {
        }

        static {
            Annotations annotations;
            INSTANCE = annotations = new Annotations();
            EXTENDS_WITH = CollectionsKt.listOf((Object)"org.junit.jupiter.api.extension.ExtendWith");
        }
    }
}

