/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.MultipleBuildsView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class AbstractViewManager
implements ViewManager,
BuildProgressListener,
Disposable {
    private static final Key<Boolean> b = new Key("PINNED_EXTRACTED_CONTENT");
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicClearableLazyValue<MultipleBuildsView> d;
    private final Set<MultipleBuildsView> a;
    private final AtomicBoolean c = new AtomicBoolean(false);

    public AbstractViewManager(Project project2, BuildContentManager buildContentManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.d = new AtomicClearableLazyValue<MultipleBuildsView>(){

            @NotNull
            protected MultipleBuildsView compute() {
                MultipleBuildsView multipleBuildsView = new MultipleBuildsView(AbstractViewManager.this.myProject, AbstractViewManager.this.myBuildContentManager, AbstractViewManager.this);
                Disposer.register((Disposable)AbstractViewManager.this, (Disposable)multipleBuildsView);
                MultipleBuildsView multipleBuildsView2 = multipleBuildsView;
                if (multipleBuildsView2 == null) {
                    1.a(0);
                }
                return multipleBuildsView2;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/AbstractViewManager$1", "compute"));
            }
        };
        this.a = ContainerUtil.newConcurrentSet();
    }

    @Override
    public boolean isConsoleEnabledByDefault() {
        return false;
    }

    @Override
    public boolean isBuildContentView() {
        return true;
    }

    protected abstract String getViewName();

    protected Map<BuildInfo, BuildView> getBuildsMap() {
        return ((MultipleBuildsView)this.d.getValue()).getBuildsMap();
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        MultipleBuildsView multipleBuildsView2;
        if (this.c.get()) {
            return;
        }
        if (buildEvent instanceof StartBuildEvent) {
            this.a();
            multipleBuildsView2 = (MultipleBuildsView)this.d.getValue();
        } else {
            multipleBuildsView2 = (MultipleBuildsView)this.d.getValue();
            if (!multipleBuildsView2.shouldConsume(buildEvent)) {
                multipleBuildsView2 = this.a.stream().filter(multipleBuildsView -> multipleBuildsView.shouldConsume(buildEvent)).findFirst().orElse(null);
            }
        }
        if (multipleBuildsView2 != null) {
            multipleBuildsView2.onEvent(buildEvent);
        }
    }

    void configureToolbar(DefaultActionGroup defaultActionGroup, MultipleBuildsView multipleBuildsView, BuildView buildView) {
        defaultActionGroup.removeAll();
        defaultActionGroup.addAll(buildView.createConsoleActions());
        defaultActionGroup.add((AnAction)new PinBuildViewAction(multipleBuildsView));
        defaultActionGroup.add((AnAction)new CloseBuildContentAction(multipleBuildsView));
    }

    @Nullable
    protected Icon getContentIcon() {
        return null;
    }

    protected void onBuildStart(BuildDescriptor buildDescriptor) {
    }

    protected void onBuildFinish(BuildDescriptor buildDescriptor) {
        BuildInfo buildInfo = (BuildInfo)buildDescriptor;
        if (buildInfo.result instanceof FailureResult) {
            boolean bl2 = buildInfo.activateToolWindowWhenFailed;
            this.myBuildContentManager.setSelectedContent(buildInfo.content, bl2, bl2, bl2, null);
            List<? extends Failure> list2 = ((FailureResult)buildInfo.result).getFailures();
            if (list2.isEmpty()) {
                return;
            }
            Failure failure = list2.get(0);
            Notification notification = failure.getNotification();
            if (notification != null) {
                String string = notification.getTitle();
                String string2 = notification.getContent();
                SystemNotifications.getInstance().notify(ToolWindowId.BUILD, string, string2);
            }
        }
    }

    public void dispose() {
        this.c.set(true);
        this.a.clear();
        this.d.drop();
    }

    private void a() {
        MultipleBuildsView multipleBuildsView = (MultipleBuildsView)this.d.getValue();
        Content content = multipleBuildsView.getContent();
        if (content != null && content.isPinned()) {
            String string = this.a(multipleBuildsView);
            UIUtil.invokeLaterIfNeeded(() -> {
                content.setPinnable(false);
                if (content.getIcon() == null) {
                    content.setIcon(EmptyIcon.ICON_8);
                }
                content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                ((BuildContentManagerImpl)this.myBuildContentManager).updateTabDisplayName(content, string);
            });
            this.a.add(multipleBuildsView);
            this.d.drop();
            content.putUserData(b, (Object)Boolean.TRUE);
        }
    }

    private String a(MultipleBuildsView multipleBuildsView) {
        Map<BuildInfo, BuildView> map = multipleBuildsView.getBuildsMap();
        BuildInfo buildInfo3 = map.keySet().stream().reduce((buildInfo, buildInfo2) -> buildInfo.getStartTime() <= buildInfo2.getStartTime() ? buildInfo : buildInfo2).orElse(null);
        if (buildInfo3 != null) {
            String string = buildInfo3.getTitle();
            String string2 = this.getViewName();
            String string3 = string2 + ": " + StringUtil.trimStart((String)string, (String)string2);
            if (map.size() > 1) {
                string3 = string3 + String.format(" and %d more", map.size() - 1);
            }
            return string3;
        }
        return this.getViewName();
    }

    private class CloseBuildContentAction
    extends AnAction
    implements DumbAware {
        private MultipleBuildsView a;

        public CloseBuildContentAction(MultipleBuildsView multipleBuildsView) {
            this.a = multipleBuildsView;
            AnAction anAction = ActionManager.getInstance().getAction("CloseContent");
            this.copyFrom(anAction);
            this.registerCustomShortcutSet(anAction.getShortcutSet(), multipleBuildsView.getContent().getPreferredFocusableComponent());
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.Cancel);
            presentation.setText(ExecutionBundle.message((String)"close.tab.action.name", (Object[])new Object[0]));
            presentation.setDescription(null);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            if (this.a == null) {
                return;
            }
            Content content = this.a.getContent();
            if (!content.isValid()) {
                return;
            }
            content.getManager().removeContent(content, true, true, true);
            if (AbstractViewManager.this.d.getValue() == this.a) {
                AbstractViewManager.this.d.drop();
            } else {
                AbstractViewManager.this.a.remove(this.a);
            }
            this.a = null;
        }

        public void update(AnActionEvent anActionEvent) {
            if (this.a != null && this.a.hasRunningBuilds()) {
                anActionEvent.getPresentation().setEnabled(false);
            } else {
                anActionEvent.getPresentation().setEnabled(this.a != null);
            }
        }
    }

    private static class PinBuildViewAction
    extends DumbAwareAction
    implements Toggleable {
        private final Content a;

        public PinBuildViewAction(MultipleBuildsView multipleBuildsView) {
            this.a = multipleBuildsView.getContent();
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            boolean bl2;
            boolean bl3 = bl2 = !this.a.isPinned();
            if (bl2) {
                this.a.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            }
            this.a.setPinned(bl2);
            anActionEvent.getPresentation().putClientProperty("selected", (Object)bl2);
        }

        public void update(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                PinBuildViewAction.a(0);
            }
            if (!this.a.isValid()) {
                return;
            }
            Boolean bl2 = (Boolean)this.a.getUserData(b);
            if (bl2 == Boolean.TRUE) {
                anActionEvent.getPresentation().setEnabledAndVisible(false);
                return;
            }
            boolean bl3 = this.a.getManager().getSelectedContent() == this.a;
            boolean bl4 = this.a.isPinned();
            anActionEvent.getPresentation().setIcon(AllIcons.General.Pin_tab);
            anActionEvent.getPresentation().putClientProperty("selected", (Object)bl4);
            String string = !bl3 ? (bl4 ? IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0])) : (bl4 ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
            anActionEvent.getPresentation().setText(string);
            anActionEvent.getPresentation().setEnabledAndVisible(true);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/AbstractViewManager$PinBuildViewAction", "update"));
        }
    }

    static class BuildInfo
    extends DefaultBuildDescriptor {
        String message;
        String statusMessage;
        long endTime;
        EventResult result;
        Content content;
        boolean activateToolWindowWhenAdded;
        boolean activateToolWindowWhenFailed;

        public BuildInfo(@NotNull Object object, @NotNull String string, @NotNull String string2, long l2) {
            if (object == null) {
                BuildInfo.b(0);
            }
            if (string == null) {
                BuildInfo.b(1);
            }
            if (string2 == null) {
                BuildInfo.b(2);
            }
            super(object, string, string2, l2);
            this.endTime = -1L;
            this.activateToolWindowWhenFailed = true;
        }

        public Icon getIcon() {
            return BuildInfo.a(this.result);
        }

        private static Icon a(EventResult eventResult) {
            if (eventResult == null) {
                return ExecutionNodeProgressAnimator.getCurrentFrame();
            }
            if (eventResult instanceof FailureResult) {
                return AllIcons.Process.State.RedExcl;
            }
            if (eventResult instanceof SkippedResult) {
                return AllIcons.Process.State.YellowStr;
            }
            return AllIcons.Process.State.GreenOK;
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
            }
            objectArray[1] = "com/intellij/build/AbstractViewManager$BuildInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

