/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.events.Failure;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class BuildConsoleUtils {
    private static final Pattern d = Pattern.compile("<[^>]*>");
    private static final Pattern a = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    private static final String b = "</a>";
    private static final Set<String> c = ContainerUtil.set((Object[])new String[]{"<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>", "<pre>", "</pre>"});

    public static boolean printDetails(ConsoleView consoleView, Failure failure) {
        return BuildConsoleUtils.printDetails(consoleView, failure, null);
    }

    public static boolean printDetails(final ConsoleView consoleView, final @Nullable Failure failure, @Nullable String string) {
        String string2;
        String string3 = string2 = failure == null ? string : (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage());
        if (string2 == null && failure != null && failure.getError() != null) {
            string2 = failure.getError().getMessage();
        }
        if (string2 == null) {
            return false;
        }
        String string4 = StringUtil.convertLineSeparators((String)string2);
        while (true) {
            Matcher matcher;
            if (!(matcher = d.matcher(string4)).find()) break;
            String string5 = matcher.group();
            consoleView.print(string4.substring(0, matcher.start()), ConsoleViewContentType.ERROR_OUTPUT);
            Matcher matcher2 = a.matcher(string5);
            if (matcher2.matches()) {
                final String string6 = matcher2.group(2);
                int n2 = string4.indexOf(b, matcher.end());
                if (n2 > 0) {
                    String string7 = string4.substring(matcher.end(), n2).replaceAll(d.pattern(), "");
                    consoleView.printHyperlink(string7, new HyperlinkInfo(){

                        public void navigate(Project project2) {
                            if (failure == null) {
                                return;
                            }
                            Notification notification = failure.getNotification();
                            if (notification != null && notification.getListener() != null) {
                                notification.getListener().hyperlinkUpdate(notification, IJSwingUtilities.createHyperlinkEvent((String)string6, (Object)consoleView.getComponent()));
                            }
                        }
                    });
                    string4 = string4.substring(n2 + b.length());
                    continue;
                }
            }
            if (c.contains(string5)) {
                consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                consoleView.print(string4.substring(matcher.start(), matcher.end()), ConsoleViewContentType.ERROR_OUTPUT);
            }
            string4 = string4.substring(matcher.end());
        }
        consoleView.print(string4, ConsoleViewContentType.ERROR_OUTPUT);
        consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        return true;
    }
}

