/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class BuildContentManagerImpl
implements BuildContentManager {
    public static final String Build = "Build";
    public static final String Sync = "Sync";
    public static final String Run = "Run";
    public static final String Debug = "Debug";
    private static final String[] c = new String[]{"Build", "Sync", "Run", "Debug"};
    private static final Key<Map<Object, CloseListener>> f = Key.create((String)"CONTENT_CLOSE_LISTENERS");
    private Project b;
    private ToolWindow a;
    private final List<Runnable> d = new ArrayList<Runnable>();
    private final Map<Content, Pair<Icon, AtomicInteger>> e = ContainerUtil.newConcurrentMap();

    public BuildContentManagerImpl(Project project2) {
        this.a(project2);
    }

    private void a(Project project2) {
        this.b = project2;
        if (project2.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).registerToolWindow(ToolWindowId.BUILD, true, ToolWindowAnchor.BOTTOM, (Disposable)project2, true);
            JComponent jComponent = toolWindow.getComponent();
            if (jComponent != null) {
                jComponent.putClientProperty("HideIdLabel", "true");
            }
            toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowBuild);
            toolWindow.setAvailable(true, null);
            toolWindow.hide(null);
            this.a = toolWindow;
            final ContentManager contentManager = this.a.getContentManager();
            contentManager.addDataProvider(new DataProvider(){
                private int a = 0;

                public Object getData(String string) {
                    ++this.a;
                    try {
                        Object object = this.a == 1 ? DataManager.getInstance().getDataContext((Component)contentManager.getComponent()).getData(string) : null;
                        return object;
                    }
                    finally {
                        --this.a;
                    }
                }
            });
            new ContentManagerWatcher(toolWindow, contentManager);
            for (Runnable runnable : this.d) {
                runnable.run();
            }
            this.d.clear();
        });
    }

    public Promise<Void> runWhenInitialized(Runnable runnable) {
        if (this.a != null) {
            runnable.run();
            return Promises.resolvedPromise(null);
        }
        AsyncPromise asyncPromise = new AsyncPromise();
        this.d.add(() -> {
            if (!this.b.isDisposed()) {
                runnable.run();
                asyncPromise.setResult(null);
            }
        });
        return asyncPromise;
    }

    @Override
    public void addContent(Content content) {
        this.runWhenInitialized(() -> {
            if (!this.a.isAvailable()) {
                this.a.setAvailable(true, null);
            }
            ContentManager contentManager = this.a.getContentManager();
            String string = content.getTabName();
            String string2 = StringUtil.trimEnd((String)((String)StringUtil.split((String)string, (String)" ").get(0)), (char)':');
            int n2 = -1;
            for (int i2 = 0; i2 < c.length; ++i2) {
                String object = c[i2];
                if (!object.equals(string2)) continue;
                n2 = i2;
                break;
            }
            Content[] contentArray = contentManager.getContents();
            if (n2 != -1) {
                Object object;
                MultiMap multiMap = MultiMap.createSmart();
                Content[] contentArray2 = contentArray;
                int n3 = contentArray2.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    object = contentArray2[i2];
                    String string3 = object.getTabName();
                    multiMap.putValue((Object)StringUtil.trimEnd((String)((String)StringUtil.split((String)string3, (String)" ").get(0)), (char)':'), (Object)string3);
                }
                int n4 = 0;
                for (n3 = 0; n3 < n2; ++n3) {
                    String string4 = c[n3];
                    object = multiMap.get((Object)string4);
                    if (string4.equals(string2)) continue;
                    n4 += object.size();
                }
                contentManager.addContent(content, n4);
            } else {
                contentManager.addContent(content);
            }
            for (Content content2 : contentArray) {
                content2.setDisplayName(content2.getTabName());
            }
            String string5 = content.getTabName();
            this.updateTabDisplayName(content, string5);
        });
    }

    public void updateTabDisplayName(Content content, String string) {
        this.runWhenInitialized(() -> {
            String string2;
            ContentManager contentManager = this.a.getContentManager();
            Content content2 = contentManager.getContent(0);
            assert (content2 != null);
            if (!Build.equals(content2.getTabName())) {
                if (contentManager.getContentCount() > 1) {
                    this.a(false);
                    string2 = string;
                } else {
                    string2 = "Build: " + string;
                }
            } else {
                string2 = string;
                this.a(true);
            }
            if (!string2.equals(content.getDisplayName())) {
                content.setTabName(string);
                content.setDisplayName(string2);
            }
        });
    }

    @Override
    public void removeContent(Content content) {
        this.runWhenInitialized(() -> {
            ContentManager contentManager = this.a.getContentManager();
            if (contentManager != null && !contentManager.isDisposed()) {
                contentManager.removeContent(content, true);
            }
        });
    }

    @Override
    public ActionCallback setSelectedContent(@NotNull Content content, boolean bl2, boolean bl3, boolean bl4, @Nullable Runnable runnable) {
        if (content == null) {
            BuildContentManagerImpl.a(0);
        }
        ActionCallback actionCallback = new ActionCallback();
        Disposer.register((Disposable)content, (Disposable)actionCallback);
        this.runWhenInitialized(() -> {
            if (content == null) {
                BuildContentManagerImpl.a(10);
            }
            if (!this.a.isAvailable()) {
                actionCallback.setRejected();
                return;
            }
            if (bl4) {
                this.a.show(runnable);
            }
            ActionCallback actionCallback2 = this.a.getContentManager().setSelectedContent(content, bl2, bl3, false);
            actionCallback2.notify(actionCallback);
        });
        return actionCallback;
    }

    @Override
    public Content addTabbedContent(@NotNull JComponent jComponent, @NotNull String string, @NotNull String string2, @Nullable Icon icon, @Nullable Disposable disposable) {
        TabbedContent tabbedContent;
        if (jComponent == null) {
            BuildContentManagerImpl.a(1);
        }
        if (string == null) {
            BuildContentManagerImpl.a(2);
        }
        if (string2 == null) {
            BuildContentManagerImpl.a(3);
        }
        ContentManager contentManager = this.a.getContentManager();
        ContentUtilEx.addTabbedContent((ContentManager)contentManager, (JComponent)jComponent, (String)string, (String)string2, (boolean)false, (Disposable)disposable);
        Content content = contentManager.findContent(ContentUtilEx.getFullName((String)string, (String)string2));
        if (icon != null && (tabbedContent = ContentUtilEx.findTabbedContent((ContentManager)contentManager, (String)string)) != null) {
            tabbedContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            tabbedContent.setIcon(icon);
        }
        return content;
    }

    public void startBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content, @Nullable BuildProcessHandler buildProcessHandler) {
        if (buildDescriptor == null) {
            BuildContentManagerImpl.a(4);
        }
        if (content == null) {
            BuildContentManagerImpl.a(5);
        }
        if (buildProcessHandler != null) {
            Map map = (Map)content.getUserData(f);
            if (map == null) {
                map = ContainerUtil.newHashMap();
                content.putUserData(f, (Object)map);
            }
            map.put(buildDescriptor.getId(), new CloseListener(content, buildProcessHandler));
        }
        this.runWhenInitialized(() -> {
            if (content == null) {
                BuildContentManagerImpl.a(9);
            }
            Pair pair2 = this.e.computeIfAbsent(content, content -> Pair.pair((Object)content.getIcon(), (Object)new AtomicInteger(0)));
            ((AtomicInteger)pair2.second).incrementAndGet();
            content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            if (pair2.first == null) {
                content.putUserData(Content.TAB_LABEL_ORIENTATION_KEY, (Object)ComponentOrientation.RIGHT_TO_LEFT);
            }
            content.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)pair2.first), (int)0, (int)13));
            JComponent jComponent = content.getComponent();
            if (jComponent != null) {
                jComponent.invalidate();
            }
            this.a.setIcon(ExecutionUtil.getLiveIndicator((Icon)AllIcons.Toolwindows.ToolWindowBuild));
        });
    }

    public void finishBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content) {
        CloseListener closeListener;
        Map map;
        if (buildDescriptor == null) {
            BuildContentManagerImpl.a(6);
        }
        if (content == null) {
            BuildContentManagerImpl.a(7);
        }
        if ((map = (Map)content.getUserData(f)) != null && (closeListener = (CloseListener)((Object)map.remove(buildDescriptor.getId()))) != null) {
            Disposer.dispose((Disposable)closeListener);
            if (map.isEmpty()) {
                content.putUserData(f, null);
            }
        }
        this.runWhenInitialized(() -> {
            Pair<Icon, AtomicInteger> pair2;
            if (content == null) {
                BuildContentManagerImpl.a(8);
            }
            if ((pair2 = this.e.get(content)) != null && ((AtomicInteger)pair2.second).decrementAndGet() == 0) {
                content.setIcon((Icon)pair2.first);
                if (pair2.first == null) {
                    content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.FALSE);
                }
                this.e.remove(content);
                if (this.e.isEmpty()) {
                    this.a.setIcon(AllIcons.Toolwindows.ToolWindowBuild);
                }
            }
        });
    }

    private void a(boolean bl2) {
        JComponent jComponent = this.a.getComponent();
        Object object = jComponent.getClientProperty("HideIdLabel");
        String string = bl2 ? "true" : null;
        jComponent.putClientProperty("HideIdLabel", string);
        if (this.a instanceof ToolWindowImpl) {
            ((ToolWindowImpl)this.a).getContentUI().propertyChange(new PropertyChangeEvent(this, "HideIdLabel", object, string));
        }
    }

    private void a(final boolean bl2, final BuildProcessHandler buildProcessHandler) {
        String string = ExecutionBundle.message((String)"terminating.process.progress.title", (Object[])new Object[]{buildProcessHandler.getExecutionName()});
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.b, string, true){

            public boolean isConditionalModal() {
                return bl2;
            }

            public boolean shouldStartInBackground() {
                return !bl2;
            }

            public void run(final @NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    2.a(0);
                }
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        buildProcessHandler.waitFor();
                    }
                    finally {
                        semaphore.up();
                    }
                });
                progressIndicator.setText(ExecutionBundle.message((String)"waiting.for.vm.detach.progress.text", (Object[])new Object[0]));
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            if (progressIndicator.isCanceled() || !progressIndicator.isRunning()) break;
                            try {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    this.wait(2000L);
                                    continue;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                        semaphore.up();
                    }
                });
                semaphore.waitFor();
            }

            public void onCancel() {
                buildProcessHandler.forceProcessDetach();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/build/BuildContentManagerImpl$2", "run"));
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/build/BuildContentManagerImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedContent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTabbedContent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startBuildNotified";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "finishBuildNotified";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$finishBuildNotified$8";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$startBuildNotified$7";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setSelectedContent$5";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements VetoableProjectManagerListener,
    Disposable {
        @Nullable
        private Content a;
        @Nullable
        private BuildProcessHandler b;

        private CloseListener(@NotNull Content content, BuildProcessHandler buildProcessHandler) {
            if (content == null) {
                CloseListener.a(0);
            }
            if (buildProcessHandler == null) {
                CloseListener.a(1);
            }
            this.a = content;
            ContentManager contentManager = content.getManager();
            if (contentManager != null) {
                contentManager.addContentManagerListener((ContentManagerListener)this);
            }
            ProjectManager.getInstance().addProjectManagerListener(BuildContentManagerImpl.this.b, (ProjectManagerListener)this);
            this.b = buildProcessHandler;
        }

        public void contentRemoved(ContentManagerEvent contentManagerEvent) {
            Content content = contentManagerEvent.getContent();
            if (content == this.a) {
                Disposer.dispose((Disposable)this);
            }
        }

        public void dispose() {
            if (this.a == null) {
                return;
            }
            Content content = this.a;
            ContentManager contentManager = content.getManager();
            if (contentManager != null) {
                contentManager.removeContentManagerListener((ContentManagerListener)this);
            }
            ProjectManager.getInstance().removeProjectManagerListener(BuildContentManagerImpl.this.b, (ProjectManagerListener)this);
            this.a = null;
            if (this.b instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)this.b));
            }
            this.b = null;
        }

        public void contentRemoveQuery(ContentManagerEvent contentManagerEvent) {
            boolean bl2;
            if (contentManagerEvent.getContent() == this.a && !(bl2 = this.a(false))) {
                contentManagerEvent.consume();
            }
        }

        public void projectClosed(Project project2) {
            if (this.a != null && project2 == BuildContentManagerImpl.this.b) {
                ContentManager contentManager = this.a.getManager();
                if (contentManager != null) {
                    contentManager.removeContent(this.a, true);
                }
                Disposer.dispose((Disposable)this);
            }
        }

        public boolean canClose(@NotNull Project project2) {
            if (project2 == null) {
                CloseListener.a(2);
            }
            if (project2 != BuildContentManagerImpl.this.b) {
                return true;
            }
            if (this.a == null) {
                return true;
            }
            boolean bl2 = this.a(true);
            if (bl2 && this.a != null) {
                ContentManager contentManager = this.a.getManager();
                if (contentManager != null) {
                    contentManager.removeContent(this.a, true);
                }
                this.a = null;
            }
            return bl2;
        }

        private boolean a(boolean bl2) {
            boolean bl3;
            if (this.b == null || this.b.isProcessTerminated() || this.b.isProcessTerminating()) {
                return true;
            }
            this.b.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, Boolean.TRUE);
            GeneralSettings.ProcessCloseConfirmation processCloseConfirmation = TerminateRemoteProcessDialog.show((Project)BuildContentManagerImpl.this.b, (String)this.b.getExecutionName(), (ProcessHandler)this.b);
            if (processCloseConfirmation == null) {
                return false;
            }
            boolean bl4 = bl3 = processCloseConfirmation == GeneralSettings.ProcessCloseConfirmation.TERMINATE;
            if (bl3) {
                this.b.destroyProcess();
            } else {
                this.b.detachProcess();
            }
            BuildContentManagerImpl.this.a(bl2, this.b);
            return true;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/BuildContentManagerImpl$CloseListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

