/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.CompositeView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.PinActiveTabAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class BuildView
extends CompositeView<ExecutionConsole>
implements BuildProgressListener,
ConsoleView,
DataProvider {
    public static final String CONSOLE_VIEW_NAME = "consoleView";
    private final AtomicReference<StartBuildEvent> f = new AtomicReference();
    private final BuildDescriptor h;
    private final Project j;
    private final AtomicBoolean k = new AtomicBoolean();
    private final List<BuildEvent> e = ContainerUtil.createConcurrentList();
    private final ViewManager g;
    private final TransferToEDTQueue<Runnable> i = TransferToEDTQueue.createRunnableMerger((String)"BuildView later invocator");

    public BuildView(Project project2, BuildDescriptor buildDescriptor, String string, ViewManager viewManager) {
        this(project2, null, buildDescriptor, string, viewManager);
    }

    public BuildView(Project project2, @Nullable ExecutionConsole executionConsole, BuildDescriptor buildDescriptor, String string, ViewManager viewManager) {
        super(string);
        this.j = project2;
        this.h = buildDescriptor;
        this.g = viewManager;
        if (executionConsole != null) {
            this.addView(executionConsole, CONSOLE_VIEW_NAME, viewManager.isConsoleEnabledByDefault());
        }
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        if (buildEvent instanceof StartBuildEvent) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                this.a((StartBuildEvent)buildEvent);
                for (BuildEvent buildEvent2 : this.e) {
                    this.a(buildEvent2);
                }
                this.e.clear();
                this.k.set(true);
            });
            return;
        }
        if (!this.k.get()) {
            this.e.add(buildEvent);
        } else {
            this.a(buildEvent);
        }
    }

    private void a(BuildEvent buildEvent) {
        if (buildEvent instanceof OutputBuildEvent) {
            ExecutionConsole executionConsole = this.a();
            if (executionConsole instanceof BuildProgressListener) {
                ((BuildProgressListener)executionConsole).onEvent(buildEvent);
            }
        } else {
            String string = BuildTreeConsoleView.class.getName();
            BuildTreeConsoleView buildTreeConsoleView = this.getView(string, BuildTreeConsoleView.class);
            if (buildTreeConsoleView != null) {
                this.i.offer(() -> buildTreeConsoleView.onEvent(buildEvent));
            }
        }
    }

    private void a(StartBuildEvent startBuildEvent) {
        Consumer<ConsoleView> consumer;
        Object object;
        Object object2;
        this.f.set(startBuildEvent);
        String string = BuildTreeConsoleView.class.getName();
        BuildTreeConsoleView buildTreeConsoleView = this.getView(string, BuildTreeConsoleView.class);
        if (buildTreeConsoleView == null) {
            buildTreeConsoleView = new BuildTreeConsoleView(this.j, this.h);
            this.addView(buildTreeConsoleView, string, !this.g.isConsoleEnabledByDefault());
        }
        if ((object2 = this.a()) == null) {
            object = startBuildEvent.getContentDescriptorSupplier();
            consumer = object != null ? (Consumer<ConsoleView>)object.get() : null;
            object2 = consumer != null && consumer.getExecutionConsole() != null && consumer.getExecutionConsole() != this ? consumer.getExecutionConsole() : new BuildTextConsoleView(this.j);
            this.addView(object2, CONSOLE_VIEW_NAME, this.g.isConsoleEnabledByDefault());
            if (consumer != null && Disposer.findRegisteredObject(consumer, (Disposable)this) == null) {
                Disposer.register((Disposable)this, consumer);
            }
        }
        object = startBuildEvent.getProcessHandler();
        if (object2 instanceof ConsoleView) {
            for (Filter filter : startBuildEvent.getExecutionFilters()) {
                ((ConsoleView)object2).addMessageFilter(filter);
            }
            if (object != null) {
                ((ConsoleView)object2).attachToProcess((ProcessHandler)object);
                consumer = startBuildEvent.getAttachedConsoleConsumer();
                if (consumer != null) {
                    consumer.consume((Object)((ConsoleView)object2));
                }
                if (!object.isStartNotified()) {
                    object.startNotify();
                }
            }
        }
        if (object != null && !object.isStartNotified()) {
            object.startNotify();
        }
        buildTreeConsoleView.onEvent(startBuildEvent);
    }

    private ExecutionConsole a() {
        return this.getView(CONSOLE_VIEW_NAME, ExecutionConsole.class);
    }

    public void print(@NotNull String string, @NotNull ConsoleViewContentType consoleViewContentType) {
        if (string == null) {
            BuildView.b(0);
        }
        if (consoleViewContentType == null) {
            BuildView.b(1);
        }
        this.a((Consumer<ConsoleView>)((Consumer)consoleView -> {
            if (string == null) {
                BuildView.b(11);
            }
            if (consoleViewContentType == null) {
                BuildView.b(12);
            }
            consoleView.print(string, consoleViewContentType);
        }));
    }

    private void a(Consumer<ConsoleView> consumer) {
        ExecutionConsole executionConsole = this.a();
        if (executionConsole instanceof ConsoleView) {
            consumer.consume((Object)((ConsoleView)executionConsole));
        }
    }

    @Nullable
    private <R> R a(Function<ConsoleView, R> function) {
        ExecutionConsole executionConsole = this.a();
        if (executionConsole instanceof ConsoleView) {
            return function.apply((ConsoleView)executionConsole);
        }
        return null;
    }

    public void clear() {
        this.a((Consumer<ConsoleView>)((Consumer)ConsoleView::clear));
    }

    public void scrollTo(int n2) {
        this.a((Consumer<ConsoleView>)((Consumer)consoleView -> consoleView.scrollTo(n2)));
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.a((Consumer<ConsoleView>)((Consumer)consoleView -> consoleView.attachToProcess(processHandler)));
    }

    public void setOutputPaused(boolean bl2) {
        this.a((Consumer<ConsoleView>)((Consumer)consoleView -> consoleView.setOutputPaused(bl2)));
    }

    public boolean isOutputPaused() {
        Boolean bl2 = this.a(ConsoleView::isOutputPaused);
        return bl2 != null && bl2 != false;
    }

    public boolean hasDeferredOutput() {
        Boolean bl2 = this.a(ConsoleView::hasDeferredOutput);
        return bl2 != null && bl2 != false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            BuildView.b(2);
        }
        this.a((Consumer<ConsoleView>)((Consumer)consoleView -> {
            if (runnable == null) {
                BuildView.b(10);
            }
            consoleView.performWhenNoDeferredOutput(runnable);
        }));
    }

    public void setHelpId(@NotNull String string) {
        if (string == null) {
            BuildView.b(3);
        }
        this.a((Consumer<ConsoleView>)((Consumer)consoleView -> {
            if (string == null) {
                BuildView.b(9);
            }
            consoleView.setHelpId(string);
        }));
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            BuildView.b(4);
        }
        this.a((Consumer<ConsoleView>)((Consumer)consoleView -> {
            if (filter == null) {
                BuildView.b(8);
            }
            consoleView.addMessageFilter(filter);
        }));
    }

    public void printHyperlink(@NotNull String string, @Nullable HyperlinkInfo hyperlinkInfo) {
        if (string == null) {
            BuildView.b(5);
        }
        this.a((Consumer<ConsoleView>)((Consumer)consoleView -> {
            if (string == null) {
                BuildView.b(7);
            }
            consoleView.printHyperlink(string, hyperlinkInfo);
        }));
    }

    public int getContentSize() {
        Integer n2 = this.a(ConsoleView::getContentSize);
        return n2 == null ? 0 : n2;
    }

    public boolean canPause() {
        Boolean bl2 = this.a(ConsoleView::canPause);
        return bl2 != null && bl2 != false;
    }

    @Override
    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] anActionArray;
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup();
        StopProcessAction stopProcessAction = null;
        StartBuildEvent startBuildEvent = this.f.get();
        if (startBuildEvent != null && startBuildEvent.getProcessHandler() != null) {
            stopProcessAction = new StopProcessAction("Stop", "Stop", (ProcessHandler)startBuildEvent.getProcessHandler());
            defaultActionGroup = ActionManager.getInstance().getAction("Stop");
            if (defaultActionGroup != null) {
                stopProcessAction.copyFrom((AnAction)defaultActionGroup);
                stopProcessAction.registerCustomShortcutSet(defaultActionGroup.getShortcutSet(), (JComponent)this);
            }
        }
        defaultActionGroup = new DefaultActionGroup(){

            public void update(AnActionEvent anActionEvent) {
                super.update(anActionEvent);
                String string = BuildTreeConsoleView.class.getName();
                anActionEvent.getPresentation().setVisible(!BuildView.this.isViewEnabled(string));
            }
        };
        ExecutionConsole executionConsole = this.a();
        if (executionConsole instanceof ConsoleView) {
            for (AnAction anAction : anActionArray = ((ConsoleView)executionConsole).createConsoleActions()) {
                if (anAction instanceof StopAction) {
                    if (stopProcessAction != null) continue;
                    stopProcessAction = anAction;
                    continue;
                }
                if (anAction instanceof FakeRerunAction || anAction instanceof PinActiveTabAction || anAction instanceof CloseAction) continue;
                defaultActionGroup.add(anAction);
            }
        }
        anActionArray = new DefaultActionGroup();
        if (startBuildEvent != null) {
            for (AnAction anAction : startBuildEvent.getRestartActions()) {
                defaultActionGroup2.add(anAction);
            }
        }
        if (stopProcessAction != null) {
            defaultActionGroup2.add((AnAction)stopProcessAction);
        }
        anActionArray.add((AnAction)defaultActionGroup2);
        if (this.g.isBuildContentView()) {
            anActionArray.addAll(this.getSwitchActions());
            anActionArray.addSeparator();
        }
        AnAction[] anActionArray2 = new AnAction[]{anActionArray, defaultActionGroup};
        if (anActionArray2 == null) {
            BuildView.b(6);
        }
        return anActionArray2;
    }

    public void allowHeavyFilters() {
        this.a((Consumer<ConsoleView>)((Consumer)ConsoleView::allowHeavyFilters));
    }

    @Override
    @Nullable
    public Object getData(String string) {
        Object object = super.getData(string);
        if (object != null) {
            return object;
        }
        StartBuildEvent startBuildEvent = this.f.get();
        if (startBuildEvent != null && LangDataKeys.RUN_PROFILE.is(string)) {
            ExecutionEnvironment executionEnvironment = startBuildEvent.getExecutionEnvironment();
            return executionEnvironment == null ? null : executionEnvironment.getRunProfile();
        }
        if (startBuildEvent != null && LangDataKeys.EXECUTION_ENVIRONMENT.is(string)) {
            return startBuildEvent.getExecutionEnvironment();
        }
        return null;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildView";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$printHyperlink$9";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMessageFilter$8";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setHelpId$7";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performWhenNoDeferredOutput$6";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$print$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

