/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionNode
extends CachingSimpleNode {
    private final List<ExecutionNode> d = ContainerUtil.newSmartList();
    private long k;
    private long c;
    @Nullable
    private String h;
    @Nullable
    private String f;
    @Nullable
    private String l;
    @Nullable
    private EventResult e;
    private boolean g;
    @Nullable
    private Navigatable i;
    @Nullable
    private NullableLazyValue<Icon> j;
    private final AtomicInteger b = new AtomicInteger();
    private final AtomicInteger a = new AtomicInteger();

    public ExecutionNode(Project project2, ExecutionNode executionNode) {
        super(project2, (NodeDescriptor)executionNode);
    }

    protected SimpleNode[] buildChildren() {
        return this.d.size() == 0 ? NO_CHILDREN : (SimpleNode[])ContainerUtil.toArray(this.d, (Object[])new ExecutionNode[this.d.size()]);
    }

    protected void update(PresentationData presentationData) {
        this.setIcon(this.a());
        presentationData.setPresentableText(this.myName);
        presentationData.setIcon(this.getIcon());
        if (this.h != null) {
            presentationData.addText(this.h + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        String string = this.b();
        if (this.h != null || string != null) {
            presentationData.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (string != null) {
            presentationData.addText("  " + string, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.f != null) {
            presentationData.setTooltip(this.f);
        }
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        this.myName = string;
    }

    @Nullable
    public String getTitle() {
        return this.h;
    }

    public void setTitle(@Nullable String string) {
        this.h = string;
    }

    @Nullable
    public String getTooltip() {
        return this.f;
    }

    public void setTooltip(@Nullable String string) {
        this.f = string;
    }

    @Nullable
    public String getHint() {
        return this.l;
    }

    public void setHint(@Nullable String string) {
        this.l = string;
    }

    public void add(ExecutionNode executionNode) {
        this.d.add(executionNode);
        this.cleanUpCache();
    }

    public void add(int n2, ExecutionNode executionNode) {
        this.d.add(n2, executionNode);
        this.cleanUpCache();
    }

    void removeChildren() {
        this.d.clear();
        this.cleanUpCache();
    }

    @Nullable
    public String getDuration() {
        if (this.k == this.c) {
            return null;
        }
        if (this.isRunning()) {
            long l2 = this.k == 0L ? 0L : System.currentTimeMillis() - this.k;
            String string = StringUtil.formatDuration((long)l2);
            int n2 = string.indexOf("s ");
            if (n2 != -1) {
                string = string.substring(0, n2 + 1);
            }
            return "Running for " + string;
        }
        return this.isSkipped() ? null : StringUtil.formatDuration((long)(this.c - this.k));
    }

    public long getStartTime() {
        return this.k;
    }

    public void setStartTime(long l2) {
        this.k = l2;
    }

    public long getEndTime() {
        return this.c;
    }

    public void setEndTime(long l2) {
        this.c = l2;
    }

    public boolean isFailed() {
        return this.e instanceof FailureResult;
    }

    public boolean isSkipped() {
        return this.e instanceof SkippedResult;
    }

    public boolean isRunning() {
        return this.c <= 0L && !this.isSkipped() && !this.isFailed();
    }

    public void setResult(@Nullable EventResult eventResult) {
        this.e = eventResult;
    }

    @Nullable
    public EventResult getResult() {
        return this.e;
    }

    public boolean isAutoExpandNode() {
        return this.g;
    }

    public void setAutoExpandNode(boolean bl2) {
        this.g = bl2;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        this.i = navigatable;
    }

    @NotNull
    public List<Navigatable> getNavigatables() {
        if (this.i != null) {
            List<Navigatable> list2 = Collections.singletonList(this.i);
            if (list2 == null) {
                ExecutionNode.a(0);
            }
            return list2;
        }
        if (this.e == null) {
            List<Navigatable> list3 = Collections.emptyList();
            if (list3 == null) {
                ExecutionNode.a(1);
            }
            return list3;
        }
        if (this.e instanceof FailureResult) {
            SmartList smartList = new SmartList();
            for (Failure failure : ((FailureResult)this.e).getFailures()) {
                ContainerUtil.addIfNotNull((Collection)smartList, (Object)failure.getNavigatable());
            }
            SmartList smartList2 = smartList;
            if (smartList2 == null) {
                ExecutionNode.a(2);
            }
            return smartList2;
        }
        List<Navigatable> list4 = Collections.emptyList();
        if (list4 == null) {
            ExecutionNode.a(3);
        }
        return list4;
    }

    public void setIconProvider(final Supplier<Icon> supplier) {
        this.j = new NullableLazyValue<Icon>(){

            @Nullable
            protected Icon compute() {
                return (Icon)supplier.get();
            }
        };
    }

    public void reportChildMessageKind(MessageEvent.Kind kind) {
        if (kind == MessageEvent.Kind.ERROR) {
            this.b.incrementAndGet();
        } else if (kind == MessageEvent.Kind.WARNING) {
            this.a.incrementAndGet();
        }
    }

    private String b() {
        String string = this.l;
        int n2 = this.a.get();
        int n3 = this.b.get();
        if (n2 > 0 || n3 > 0) {
            if (string == null) {
                string = "";
            }
            string = string + (this.getParent() == null ? (this.isRunning() ? "   " : "   with ") : " (");
            if (n3 > 0) {
                string = string + n3 + " " + StringUtil.pluralize((String)"error", (int)n3);
                if (n2 > 0) {
                    string = string + ", ";
                }
            }
            if (n2 > 0) {
                string = string + n2 + " " + StringUtil.pluralize((String)"warning", (int)n2);
            }
            if (this.getParent() != null) {
                string = string + ")";
            }
        }
        return string;
    }

    private Icon a() {
        if (this.j != null) {
            return (Icon)this.j.getValue();
        }
        if (this.e instanceof MessageEventResult) {
            return ExecutionNode.a(((MessageEventResult)this.e).getKind());
        }
        return this.isRunning() ? ExecutionNodeProgressAnimator.getCurrentFrame() : (this.isFailed() ? AllIcons.Process.State.RedExcl : (this.isSkipped() ? AllIcons.Process.State.YellowStr : AllIcons.Process.State.GreenOK));
    }

    private static Icon a(MessageEvent.Kind kind) {
        switch (kind) {
            case ERROR: {
                return AllIcons.General.Error;
            }
            case WARNING: {
                return AllIcons.General.Warning;
            }
            case INFO: {
                return AllIcons.General.Information;
            }
            case STATISTICS: {
                return AllIcons.General.Mdot_empty;
            }
            case SIMPLE: {
                return AllIcons.General.Mdot_empty;
            }
        }
        return AllIcons.General.Mdot_empty;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/ExecutionNode", "getNavigatables"));
    }
}

