/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.ExecutionNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ExecutionNodeProgressAnimator
implements Runnable,
Disposable {
    private static final int f = 8;
    private static final int e = 1200;
    private static final int b = 150;
    public static final Icon[] FRAMES = new Icon[8];
    private long d = -1L;
    private Alarm c;
    private final List<ExecutionNode> a = new SmartList();
    private BuildTreeConsoleView g;

    public ExecutionNodeProgressAnimator(BuildTreeConsoleView buildTreeConsoleView) {
        Disposer.register((Disposable)buildTreeConsoleView, (Disposable)this);
        this.c = new Alarm();
        this.g = buildTreeConsoleView;
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 1200L / 150L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[ExecutionNodeProgressAnimator.getCurrentFrameIndex()];
    }

    @Override
    public void run() {
        long l2;
        if (!this.a.isEmpty() && (l2 = System.currentTimeMillis()) - this.d >= 150L) {
            this.d();
            this.d = l2;
        }
        this.b();
    }

    public void addNode(@Nullable ExecutionNode executionNode) {
        this.a.add(executionNode);
    }

    public void startMovie() {
        this.b();
    }

    public void stopMovie() {
        this.d();
        for (ExecutionNode executionNode : this.a) {
            executionNode.setIconProvider(() -> AllIcons.Process.State.YellowStr);
            executionNode.setEndTime(System.currentTimeMillis());
        }
        this.a.clear();
        this.a();
    }

    public void dispose() {
        this.g = null;
        this.a.clear();
        this.a();
    }

    private void a() {
        if (this.c != null) {
            this.c.cancelAllRequests();
            this.c = null;
        }
    }

    private void d() {
        if (this.g == null || this.g.isDisposed()) {
            return;
        }
        Iterator<ExecutionNode> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            ExecutionNode executionNode = iterator.next();
            this.g.scheduleUpdate(executionNode);
            if (executionNode.isRunning()) continue;
            iterator.remove();
        }
    }

    private void b() {
        if (this.c == null) {
            return;
        }
        this.c.cancelAllRequests();
        this.c.addRequest((Runnable)this, 150);
    }

    static {
        ExecutionNodeProgressAnimator.FRAMES[0] = AllIcons.Process.State.GreyProgr_1;
        ExecutionNodeProgressAnimator.FRAMES[1] = AllIcons.Process.State.GreyProgr_2;
        ExecutionNodeProgressAnimator.FRAMES[2] = AllIcons.Process.State.GreyProgr_3;
        ExecutionNodeProgressAnimator.FRAMES[3] = AllIcons.Process.State.GreyProgr_4;
        ExecutionNodeProgressAnimator.FRAMES[4] = AllIcons.Process.State.GreyProgr_5;
        ExecutionNodeProgressAnimator.FRAMES[5] = AllIcons.Process.State.GreyProgr_6;
        ExecutionNodeProgressAnimator.FRAMES[6] = AllIcons.Process.State.GreyProgr_7;
        ExecutionNodeProgressAnimator.FRAMES[7] = AllIcons.Process.State.GreyProgr_8;
    }
}

