/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MultipleBuildsView
implements BuildProgressListener,
Disposable {
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicBoolean l;
    private final List<Runnable> d;
    private final ProgressWatcher b;
    private final ThreeComponentsSplitter e;
    private final JBList<AbstractViewManager.BuildInfo> k;
    private final Map<Object, AbstractViewManager.BuildInfo> a;
    private final Map<AbstractViewManager.BuildInfo, BuildView> i;
    private final AbstractViewManager h;
    private volatile Content j;
    private volatile DefaultActionGroup c;
    private volatile boolean f;
    private final TransferToEDTQueue<Runnable> g;

    public MultipleBuildsView(Project project2, BuildContentManager buildContentManager, AbstractViewManager abstractViewManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.h = abstractViewManager;
        this.l = new AtomicBoolean();
        this.d = ContainerUtil.createConcurrentList();
        this.e = new ThreeComponentsSplitter();
        Disposer.register((Disposable)this, (Disposable)this.e);
        this.k = new JBList();
        this.k.setModel(new DefaultListModel());
        this.k.setFixedCellHeight(40);
        this.k.installCellRenderer(object -> {
            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)object;
            JPanel jPanel = new JPanel(new BorderLayout());
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setIcon(buildInfo.getIcon());
            simpleColoredComponent.append(buildInfo.getTitle() + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            simpleColoredComponent.append(buildInfo.message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            jPanel.add((Component)simpleColoredComponent, "North");
            if (buildInfo.statusMessage != null) {
                SimpleColoredComponent simpleColoredComponent2 = new SimpleColoredComponent();
                simpleColoredComponent2.setIcon(EmptyIcon.ICON_16);
                simpleColoredComponent2.append(buildInfo.statusMessage, SimpleTextAttributes.GRAY_ATTRIBUTES);
                jPanel.add((Component)simpleColoredComponent2, "South");
            }
            return jPanel;
        });
        this.i = ContainerUtil.newConcurrentMap();
        this.a = ContainerUtil.newConcurrentMap();
        this.b = new ProgressWatcher();
        this.g = new TransferToEDTQueue("Multiple builds view queue", runnable -> {
            runnable.run();
            return true;
        }, object -> this.f);
    }

    public void dispose() {
        this.f = true;
    }

    public Content getContent() {
        return this.j;
    }

    public Map<AbstractViewManager.BuildInfo, BuildView> getBuildsMap() {
        return Collections.unmodifiableMap(this.i);
    }

    public boolean shouldConsume(BuildEvent buildEvent) {
        return buildEvent.getParentId() != null && this.a.containsKey(buildEvent.getParentId()) || this.a.containsKey(buildEvent.getId());
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        SmartList smartList = new SmartList();
        if (buildEvent instanceof StartBuildEvent) {
            StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
            if (this.l.get()) {
                this.a((List<Runnable>)smartList, startBuildEvent);
            }
            AbstractViewManager.BuildInfo buildInfo = new AbstractViewManager.BuildInfo(buildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), buildEvent.getEventTime());
            this.a.put(buildEvent.getId(), buildInfo);
        } else if (buildEvent.getParentId() != null) {
            AbstractViewManager.BuildInfo buildInfo = this.a.get(buildEvent.getParentId());
            assert (buildInfo != null);
            this.a.put(buildEvent.getId(), buildInfo);
        }
        smartList.add(() -> {
            AbstractViewManager.BuildInfo buildInfo2 = this.a.get(buildEvent.getId());
            assert (buildInfo2 != null);
            if (buildEvent instanceof StartBuildEvent) {
                RunContentDescriptor runContentDescriptor;
                StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
                buildInfo2.message = startBuildEvent.getMessage();
                DefaultListModel defaultListModel = (DefaultListModel)this.k.getModel();
                defaultListModel.addElement(buildInfo2);
                BuildView buildView = this.i.computeIfAbsent(buildInfo2, buildInfo -> {
                    DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(startBuildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), startBuildEvent.getEventTime());
                    String string = "build.toolwindow." + this.h.getViewName() + ".selection.state";
                    BuildView buildView = new BuildView(this.myProject, defaultBuildDescriptor, string, this.h);
                    Disposer.register((Disposable)this.e, (Disposable)buildView);
                    return buildView;
                });
                buildView.onEvent(startBuildEvent);
                this.j.setPreferredFocusedComponent(buildView::getPreferredFocusableComponent);
                Supplier<RunContentDescriptor> supplier = startBuildEvent.getContentDescriptorSupplier();
                RunContentDescriptor runContentDescriptor2 = runContentDescriptor = supplier != null ? supplier.get() : null;
                if (runContentDescriptor != null) {
                    boolean bl2;
                    buildInfo2.activateToolWindowWhenAdded = bl2 = runContentDescriptor.isActivateToolWindowWhenAdded();
                    if (runContentDescriptor instanceof BuildContentDescriptor) {
                        buildInfo2.activateToolWindowWhenFailed = ((BuildContentDescriptor)runContentDescriptor).isActivateToolWindowWhenFailed();
                    }
                    boolean bl3 = runContentDescriptor.isAutoFocusContent();
                    this.myBuildContentManager.setSelectedContent(this.j, bl3, bl3, bl2, runContentDescriptor.getActivationCallback());
                    Disposer.register((Disposable)buildView, (Disposable)runContentDescriptor);
                } else {
                    this.myBuildContentManager.setSelectedContent(this.j, true, true, false, null);
                }
                buildInfo2.content = this.j;
                if (this.e.getLastComponent() == null) {
                    this.e.setLastComponent((JComponent)buildView);
                    this.h.configureToolbar(this.c, this, buildView);
                }
                if (this.k.getModel().getSize() > 1) {
                    JBScrollPane jBScrollPane = new JBScrollPane();
                    jBScrollPane.setBorder((Border)JBUI.Borders.empty());
                    jBScrollPane.setViewportView(this.k);
                    this.e.setFirstComponent((JComponent)jBScrollPane);
                    this.k.setVisible(true);
                    this.k.setSelectedIndex(0);
                    this.e.repaint();
                    for (BuildView buildView2 : this.i.values()) {
                        BuildTreeConsoleView buildTreeConsoleView = buildView2.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
                        if (buildTreeConsoleView == null) continue;
                        buildTreeConsoleView.hideRootNode();
                    }
                } else {
                    this.e.setFirstComponent(null);
                }
                this.h.onBuildStart(buildInfo2);
                this.b.addBuild(buildInfo2);
                ((BuildContentManagerImpl)this.myBuildContentManager).startBuildNotified(buildInfo2, buildInfo2.content, startBuildEvent.getProcessHandler());
            } else {
                if (buildEvent instanceof FinishBuildEvent) {
                    buildInfo2.endTime = buildEvent.getEventTime();
                    buildInfo2.message = buildEvent.getMessage();
                    buildInfo2.result = ((FinishBuildEvent)buildEvent).getResult();
                    this.b.stopBuild(buildInfo2);
                    ((BuildContentManagerImpl)this.myBuildContentManager).finishBuildNotified(buildInfo2, buildInfo2.content);
                    this.h.onBuildFinish(buildInfo2);
                } else {
                    buildInfo2.statusMessage = buildEvent.getMessage();
                }
                this.i.get(buildInfo2).onEvent(buildEvent);
            }
        });
        if (this.j == null) {
            this.d.addAll((Collection<Runnable>)smartList);
            if (this.l.compareAndSet(false, true)) {
                this.g.offer(() -> {
                    this.k.setSelectionMode(0);
                    this.k.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent listSelectionEvent) {
                            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)MultipleBuildsView.this.k.getSelectedValue();
                            if (buildInfo == null) {
                                return;
                            }
                            BuildView buildView = (BuildView)MultipleBuildsView.this.i.get(buildInfo);
                            JComponent jComponent = MultipleBuildsView.this.e.getLastComponent();
                            if (buildView != null && jComponent != buildView.getComponent()) {
                                MultipleBuildsView.this.e.setLastComponent(buildView.getComponent());
                                buildView.getComponent().setVisible(true);
                                if (jComponent != null) {
                                    jComponent.setVisible(false);
                                }
                                MultipleBuildsView.this.h.configureToolbar(MultipleBuildsView.this.c, MultipleBuildsView.this, buildView);
                                buildView.getComponent().repaint();
                            }
                            int n2 = MultipleBuildsView.this.e.getFirstSize();
                            int n3 = MultipleBuildsView.this.e.getLastSize();
                            if (n2 == 0 && n3 == 0) {
                                EdtInvocationManager.getInstance().invokeLater(() -> {
                                    int n2 = 0;
                                    for (Object object = MultipleBuildsView.this.e; object != null && (n2 = object.getWidth()) == 0; object = object.getParent()) {
                                    }
                                    int n3 = Math.round((float)n2 / 4.0f);
                                    MultipleBuildsView.this.e.setFirstSize(n3);
                                });
                            }
                        }
                    });
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)this.e, "Center");
                    this.c = new DefaultActionGroup();
                    jPanel.add((Component)ActionManager.getInstance().createActionToolbar("BuildView", (ActionGroup)this.c, false).getComponent(), "West");
                    this.j = new ContentImpl((JComponent)jPanel, this.h.getViewName(), true);
                    Disposer.register((Disposable)this.j, (Disposable)this);
                    this.j.setCloseable(false);
                    Icon icon = this.h.getContentIcon();
                    if (icon != null) {
                        this.j.setIcon(icon);
                        this.j.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                    }
                    this.myBuildContentManager.addContent(this.j);
                    ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.d);
                    this.d.clear();
                    for (Runnable runnable : arrayList) {
                        runnable.run();
                    }
                });
            }
        } else {
            this.g.offer(() -> MultipleBuildsView.a((List)smartList));
        }
    }

    private void a(List<Runnable> list2, StartBuildEvent startBuildEvent) {
        long l2 = System.currentTimeMillis();
        DefaultListModel defaultListModel = (DefaultListModel)this.k.getModel();
        boolean bl2 = !defaultListModel.isEmpty();
        SmartList smartList = new SmartList();
        for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)defaultListModel.getElementAt(i2);
            boolean bl3 = buildInfo.getWorkingDir().equals(startBuildEvent.getWorkingDir());
            if (buildInfo.endTime != -1L && bl3) {
                smartList.add(buildInfo);
            }
            if ((!bl2 || buildInfo.endTime != -1L) && (bl3 || l2 - buildInfo.endTime >= TimeUnit.SECONDS.toMillis(1L))) continue;
            bl2 = false;
        }
        if (bl2) {
            this.a.clear();
            SmartList smartList2 = new SmartList(this.i.values());
            list2.add(() -> smartList2.forEach(Disposer::dispose));
            this.i.clear();
            defaultListModel.clear();
            this.k.setVisible(false);
            list2.add(() -> {
                this.e.setFirstComponent(null);
                this.e.setLastComponent(null);
            });
            this.c.removeAll();
        } else {
            for (AbstractViewManager.BuildInfo buildInfo : smartList) {
                list2.add(() -> {
                    BuildView buildView = this.i.remove(buildInfo);
                    if (buildView != null) {
                        Disposer.dispose((Disposable)buildView);
                    }
                });
                defaultListModel.removeElement(buildInfo);
            }
        }
    }

    public boolean hasRunningBuilds() {
        return !this.b.a.isEmpty();
    }

    private static /* synthetic */ void a(List list2) {
        for (Runnable runnable : list2) {
            runnable.run();
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private final Alarm b = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final Set<AbstractViewManager.BuildInfo> a = ContainerUtil.newConcurrentSet();

        private ProgressWatcher() {
        }

        @Override
        public void run() {
            this.b.cancelAllRequests();
            JComponent jComponent = MultipleBuildsView.this.e.getFirstComponent();
            if (jComponent != null) {
                jComponent.revalidate();
                jComponent.repaint();
            }
            if (!this.a.isEmpty()) {
                this.b.addRequest((Runnable)this, 300);
            }
        }

        void addBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.a.add(buildInfo);
            if (this.a.size() > 1) {
                this.b.cancelAllRequests();
                this.b.addRequest((Runnable)this, 300);
            }
        }

        void stopBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.a.remove(buildInfo);
        }
    }
}

