/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NavigationGutterIconRenderer
extends GutterIconRenderer
implements GutterIconNavigationHandler<PsiElement>,
DumbAware {
    private final String a;
    private final String b;
    private final Computable<PsiElementListCellRenderer> d;
    private final NotNullLazyValue<List<SmartPsiElementPointer>> c;

    protected NavigationGutterIconRenderer(String string, String string2, @NotNull Computable<PsiElementListCellRenderer> computable, @NotNull NotNullLazyValue<List<SmartPsiElementPointer>> notNullLazyValue) {
        if (computable == null) {
            NavigationGutterIconRenderer.a(0);
        }
        if (notNullLazyValue == null) {
            NavigationGutterIconRenderer.a(1);
        }
        this.a = string;
        this.b = string2;
        this.d = computable;
        this.c = notNullLazyValue;
    }

    public boolean isNavigateAction() {
        return true;
    }

    public List<PsiElement> getTargetElements() {
        return ContainerUtil.mapNotNull((Collection)((Collection)this.c.getValue()), (Function)((NullableFunction)smartPsiElementPointer -> smartPsiElementPointer.getElement()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        NavigationGutterIconRenderer navigationGutterIconRenderer = (NavigationGutterIconRenderer)((Object)object);
        if (this.b != null ? !this.b.equals(navigationGutterIconRenderer.b) : navigationGutterIconRenderer.b != null) {
            return false;
        }
        if (!((List)this.c.getValue()).equals(navigationGutterIconRenderer.c.getValue())) {
            return false;
        }
        return !(this.a != null ? !this.a.equals(navigationGutterIconRenderer.a) : navigationGutterIconRenderer.a != null);
    }

    public int hashCode() {
        int n2 = this.a != null ? this.a.hashCode() : 0;
        n2 = 31 * n2 + (this.b != null ? this.b.hashCode() : 0);
        n2 = 31 * n2 + ((List)this.c.getValue()).hashCode();
        return n2;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent anActionEvent) {
                NavigationGutterIconRenderer.this.navigate(anActionEvent == null ? null : (MouseEvent)anActionEvent.getInputEvent(), null);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(@Nullable MouseEvent mouseEvent, @Nullable PsiElement psiElement) {
        List<PsiElement> list2;
        DumbService dumbService;
        DumbService dumbService2 = dumbService = psiElement != null ? DumbService.getInstance((Project)psiElement.getProject()) : null;
        if (dumbService != null) {
            dumbService.setAlternativeResolveEnabled(true);
        }
        try {
            list2 = this.getTargetElements();
        }
        finally {
            if (dumbService != null) {
                dumbService.setAlternativeResolveEnabled(false);
            }
        }
        if (list2.isEmpty()) {
            if (this.b != null && mouseEvent != null) {
                JComponent jComponent = HintUtil.createErrorLabel((String)this.b);
                jComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)7, (int)2, (int)7));
                JBPopupFactory.getInstance().createBalloonBuilder(jComponent).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint(mouseEvent), Balloon.Position.above);
            }
            return;
        }
        if (list2.size() == 1) {
            PsiNavigateUtil.navigate((PsiElement)list2.iterator().next());
        } else if (mouseEvent != null) {
            JBPopup jBPopup = NavigationUtil.getPsiElementPopup((PsiElement[])PsiUtilCore.toPsiElementArray(list2), (PsiElementListCellRenderer)((PsiElementListCellRenderer)this.d.compute()), (String)this.a);
            jBPopup.show(new RelativePoint(mouseEvent));
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "cellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pointers";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

