/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.UnwrapHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class UnwrapTestCase
extends LightPlatformCodeInsightTestCase {
    protected void assertUnwrapped(String string, String string2) throws Exception {
        this.assertUnwrapped(string, string2, 0);
    }

    protected void assertUnwrapped(String string, String string2, final int n2) throws Exception {
        this.configureCode(string);
        UnwrapHandler unwrapHandler = new UnwrapHandler(){

            protected void selectOption(List<AnAction> list2, Editor editor, PsiFile psiFile) {
                if (list2.isEmpty()) {
                    return;
                }
                list2.get(n2).actionPerformed(null);
            }
        };
        unwrapHandler.invoke(UnwrapTestCase.getProject(), UnwrapTestCase.getEditor(), UnwrapTestCase.getFile());
        this.checkResultByText(this.createCode(string2));
    }

    protected void assertOptions(String string, String ... stringArray) throws IOException {
        this.configureCode(string);
        final ArrayList arrayList = new ArrayList();
        UnwrapHandler unwrapHandler = new UnwrapHandler(){

            protected void selectOption(List<AnAction> list2, Editor editor, PsiFile psiFile) {
                for (AnAction anAction : list2) {
                    arrayList.add(anAction.getTemplatePresentation().getText());
                }
            }
        };
        unwrapHandler.invoke(UnwrapTestCase.getProject(), UnwrapTestCase.getEditor(), UnwrapTestCase.getFile());
        UnwrapTestCase.assertEquals(Arrays.asList(stringArray), arrayList);
    }

    protected void configureCode(String string) throws IOException {
        UnwrapTestCase.configureFromFileText(this.getFileNameToCreate(), this.createCode(string));
    }

    protected String getFileNameToCreate() {
        return "A.java";
    }

    protected String createCode(String string) {
        return "public class A {\n    void foo() {\n" + this.indentTwice(string) + "    }\n}";
    }

    protected String indentTwice(String string) {
        return this.indent(this.indent(string));
    }

    protected String indent(String string) {
        String string2 = "";
        for (String string3 : StringUtil.tokenize((String)string, (String)"\n")) {
            string2 = string2 + "    " + string3 + "\n";
        }
        return string2;
    }
}

