/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.compiler.CompileTaskBean;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.FileProcessingCompilerAdapterTask;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.OneProjectItemCompileScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFactory;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;

public class CompilerManagerImpl
extends CompilerManager {
    private static final Logger j = Logger.getInstance((String)"#com.intellij.compiler.CompilerManagerImpl");
    private final Project i;
    private final List<Compiler> g = new ArrayList<Compiler>();
    private final List<CompileTask> d = new ArrayList<CompileTask>();
    private final List<CompileTask> a = new ArrayList<CompileTask>();
    private final Set<FileType> l = new HashSet<FileType>();
    private final CompilationStatusListener b;
    private final Semaphore c = new Semaphore(1, true);
    private final Set<ModuleType> h = new HashSet<ModuleType>();
    private final Set<LocalFileSystem.WatchRequest> e;
    private volatile ExternalJavacManager f;
    private final Map<CompilationStatusListener, MessageBusConnection> k = new HashMap<CompilationStatusListener, MessageBusConnection>();

    public CompilerManagerImpl(Project project2, MessageBus messageBus) {
        this.i = project2;
        this.b = (CompilationStatusListener)messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS);
        for (Compiler compiler : (Compiler[])Extensions.getExtensions((ExtensionPointName)Compiler.EP_NAME, (AreaInstance)this.i)) {
            this.addCompiler(compiler);
        }
        for (Compiler compiler : (CompilerFactory[])Extensions.getExtensions((ExtensionPointName)CompilerFactory.EP_NAME, (AreaInstance)this.i)) {
            Compiler[] compilerArray;
            for (Compiler compiler2 : compilerArray = compiler.createCompilers((CompilerManager)this)) {
                this.addCompiler(compiler2);
            }
        }
        for (Compiler compiler : (InspectionValidator[])Extensions.getExtensions((ExtensionPointName)InspectionValidator.EP_NAME, (AreaInstance)this.i)) {
            this.addCompiler((Compiler)new InspectionValidatorWrapper(this, InspectionManager.getInstance((Project)project2), InspectionProjectProfileManager.getInstance((Project)project2), PsiDocumentManager.getInstance((Project)project2), PsiManager.getInstance((Project)project2), (InspectionValidator)compiler));
        }
        this.addCompilableFileType((FileType)StdFileTypes.JAVA);
        File file = CompilerPaths.getGeneratedDataDirectory((Project)project2);
        file.mkdirs();
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        this.e = localFileSystem.addRootsToWatch(Collections.singletonList(FileUtil.toCanonicalPath((String)file.getPath())), true);
        Disposer.register((Disposable)project2, () -> {
            ExternalJavacManager externalJavacManager = this.f;
            this.f = null;
            if (externalJavacManager != null) {
                externalJavacManager.stop();
            }
            localFileSystem.removeWatchedRoots(this.e);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                FileUtil.delete((File)CompilerPaths.getCompilerSystemDirectory((Project)project2));
            }
        });
    }

    public boolean waitForExternalJavacToTerminate(long l2, @NotNull TimeUnit timeUnit) {
        ExternalJavacManager externalJavacManager;
        if (timeUnit == null) {
            CompilerManagerImpl.a(0);
        }
        return (externalJavacManager = this.f) == null || externalJavacManager.waitForAllProcessHandlers(l2, timeUnit);
    }

    public boolean awaitNettyThreadPoolTermination(long l2, @NotNull TimeUnit timeUnit) {
        ExternalJavacManager externalJavacManager;
        if (timeUnit == null) {
            CompilerManagerImpl.a(1);
        }
        return (externalJavacManager = this.f) == null || externalJavacManager.awaitNettyThreadPoolTermination(l2, timeUnit);
    }

    public Semaphore getCompilationSemaphore() {
        return this.c;
    }

    public boolean isCompilationActive() {
        return this.c.availablePermits() == 0;
    }

    public final void addCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            CompilerManagerImpl.a(2);
        }
        this.g.add(compiler);
        if (compiler instanceof SourceInstrumentingCompiler) {
            this.addBeforeTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        } else if (compiler instanceof Validator) {
            this.addAfterTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        }
    }

    @Deprecated
    public void addTranslatingCompiler(@NotNull TranslatingCompiler translatingCompiler, Set<FileType> set, Set<FileType> set2) {
        if (translatingCompiler == null) {
            CompilerManagerImpl.a(3);
        }
    }

    public final void removeCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            CompilerManagerImpl.a(4);
        }
        for (List list2 : Arrays.asList(this.d, this.a)) {
            list2.removeIf(compileTask -> {
                if (compiler == null) {
                    CompilerManagerImpl.a(46);
                }
                return compileTask instanceof FileProcessingCompilerAdapterTask && ((FileProcessingCompilerAdapterTask)compileTask).getCompiler() == compiler;
            });
        }
    }

    @NotNull
    public <T extends Compiler> T[] getCompilers(@NotNull Class<T> clazz) {
        if (clazz == null) {
            CompilerManagerImpl.a(5);
        }
        Compiler[] compilerArray = this.getCompilers(clazz, CompilerFilter.ALL);
        if (compilerArray == null) {
            CompilerManagerImpl.a(6);
        }
        return compilerArray;
    }

    @NotNull
    public <T extends Compiler> T[] getCompilers(@NotNull Class<T> clazz, CompilerFilter compilerFilter) {
        if (clazz == null) {
            CompilerManagerImpl.a(7);
        }
        ArrayList<Compiler> arrayList = new ArrayList<Compiler>(this.g.size());
        for (Compiler compiler : this.g) {
            if (!clazz.isAssignableFrom(compiler.getClass()) || !compilerFilter.acceptCompiler(compiler)) continue;
            arrayList.add(compiler);
        }
        Compiler[] compilerArray = (Compiler[])Array.newInstance(clazz, arrayList.size());
        Compiler[] compilerArray2 = arrayList.toArray(compilerArray);
        if (compilerArray2 == null) {
            CompilerManagerImpl.a(8);
        }
        return compilerArray2;
    }

    public void addCompilableFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            CompilerManagerImpl.a(9);
        }
        this.l.add(fileType);
    }

    public void removeCompilableFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            CompilerManagerImpl.a(10);
        }
        this.l.remove(fileType);
    }

    public boolean isCompilableFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            CompilerManagerImpl.a(11);
        }
        return this.l.contains(fileType);
    }

    public final void addBeforeTask(@NotNull CompileTask compileTask) {
        if (compileTask == null) {
            CompilerManagerImpl.a(12);
        }
        this.d.add(compileTask);
    }

    public final void addAfterTask(@NotNull CompileTask compileTask) {
        if (compileTask == null) {
            CompilerManagerImpl.a(13);
        }
        this.a.add(compileTask);
    }

    @NotNull
    public CompileTask[] getBeforeTasks() {
        CompileTask[] compileTaskArray = this.a(this.d, CompileTaskBean.CompileTaskExecutionPhase.BEFORE);
        if (compileTaskArray == null) {
            CompilerManagerImpl.a(14);
        }
        return compileTaskArray;
    }

    private CompileTask[] a(List<CompileTask> list2, CompileTaskBean.CompileTaskExecutionPhase compileTaskExecutionPhase) {
        ArrayList<CompileTask> arrayList = new ArrayList<CompileTask>(list2);
        for (CompileTaskBean compileTaskBean : (CompileTaskBean[])CompileTaskBean.EP_NAME.getExtensions((AreaInstance)this.i)) {
            if (compileTaskBean.myExecutionPhase != compileTaskExecutionPhase) continue;
            arrayList.add(compileTaskBean.getTaskInstance());
        }
        return arrayList.toArray(new CompileTask[0]);
    }

    @NotNull
    public CompileTask[] getAfterTasks() {
        CompileTask[] compileTaskArray = this.a(this.a, CompileTaskBean.CompileTaskExecutionPhase.AFTER);
        if (compileTaskArray == null) {
            CompilerManagerImpl.a(15);
        }
        return compileTaskArray;
    }

    public void compile(@NotNull VirtualFile[] virtualFileArray, CompileStatusNotification compileStatusNotification) {
        if (virtualFileArray == null) {
            CompilerManagerImpl.a(16);
        }
        this.compile(this.createFilesCompileScope(virtualFileArray), compileStatusNotification);
    }

    public void compile(@NotNull Module module2, CompileStatusNotification compileStatusNotification) {
        if (module2 == null) {
            CompilerManagerImpl.a(17);
        }
        new CompileDriver(this.i).compile(this.createModuleCompileScope(module2, false), new ListenerNotificator(compileStatusNotification));
    }

    public void compile(@NotNull CompileScope compileScope, CompileStatusNotification compileStatusNotification) {
        if (compileScope == null) {
            CompilerManagerImpl.a(18);
        }
        new CompileDriver(this.i).compile(compileScope, new ListenerNotificator(compileStatusNotification));
    }

    public void make(CompileStatusNotification compileStatusNotification) {
        new CompileDriver(this.i).make(this.createProjectCompileScope(this.i), new ListenerNotificator(compileStatusNotification));
    }

    public void make(@NotNull Module module2, CompileStatusNotification compileStatusNotification) {
        if (module2 == null) {
            CompilerManagerImpl.a(19);
        }
        new CompileDriver(this.i).make(this.createModuleCompileScope(module2, true), new ListenerNotificator(compileStatusNotification));
    }

    public void make(@NotNull Project project2, @NotNull Module[] moduleArray, CompileStatusNotification compileStatusNotification) {
        if (project2 == null) {
            CompilerManagerImpl.a(20);
        }
        if (moduleArray == null) {
            CompilerManagerImpl.a(21);
        }
        new CompileDriver(this.i).make(this.createModuleGroupCompileScope(project2, moduleArray, true), new ListenerNotificator(compileStatusNotification));
    }

    public void make(@NotNull CompileScope compileScope, CompileStatusNotification compileStatusNotification) {
        if (compileScope == null) {
            CompilerManagerImpl.a(22);
        }
        new CompileDriver(this.i).make(compileScope, new ListenerNotificator(compileStatusNotification));
    }

    public void makeWithModalProgress(@NotNull CompileScope compileScope, @Nullable CompileStatusNotification compileStatusNotification) {
        if (compileScope == null) {
            CompilerManagerImpl.a(23);
        }
        new CompileDriver(this.i).make(compileScope, true, new ListenerNotificator(compileStatusNotification));
    }

    public void make(@NotNull CompileScope compileScope, CompilerFilter compilerFilter, @Nullable CompileStatusNotification compileStatusNotification) {
        if (compileScope == null) {
            CompilerManagerImpl.a(24);
        }
        CompileDriver compileDriver = new CompileDriver(this.i);
        compileDriver.setCompilerFilter(compilerFilter);
        compileDriver.make(compileScope, new ListenerNotificator(compileStatusNotification));
    }

    public boolean isUpToDate(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            CompilerManagerImpl.a(25);
        }
        return new CompileDriver(this.i).isUpToDate(compileScope);
    }

    public void rebuild(CompileStatusNotification compileStatusNotification) {
        new CompileDriver(this.i).rebuild(new ListenerNotificator(compileStatusNotification));
    }

    public void executeTask(@NotNull CompileTask compileTask, @NotNull CompileScope compileScope, String string, Runnable runnable) {
        if (compileTask == null) {
            CompilerManagerImpl.a(26);
        }
        if (compileScope == null) {
            CompilerManagerImpl.a(27);
        }
        CompileDriver compileDriver = new CompileDriver(this.i);
        compileDriver.executeCompileTask(compileTask, compileScope, string, runnable);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener compilationStatusListener) {
        if (compilationStatusListener == null) {
            CompilerManagerImpl.a(28);
        }
        MessageBusConnection messageBusConnection = this.i.getMessageBus().connect();
        this.k.put(compilationStatusListener, messageBusConnection);
        messageBusConnection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)compilationStatusListener);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener compilationStatusListener, @NotNull Disposable disposable) {
        if (compilationStatusListener == null) {
            CompilerManagerImpl.a(29);
        }
        if (disposable == null) {
            CompilerManagerImpl.a(30);
        }
        MessageBusConnection messageBusConnection = this.i.getMessageBus().connect(disposable);
        messageBusConnection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)compilationStatusListener);
    }

    public void removeCompilationStatusListener(@NotNull CompilationStatusListener compilationStatusListener) {
        MessageBusConnection messageBusConnection;
        if (compilationStatusListener == null) {
            CompilerManagerImpl.a(31);
        }
        if ((messageBusConnection = this.k.remove(compilationStatusListener)) != null) {
            messageBusConnection.disconnect();
        }
    }

    public boolean isExcludedFromCompilation(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CompilerManagerImpl.a(32);
        }
        return CompilerConfiguration.getInstance((Project)this.i).isExcludedFromCompilation(virtualFile);
    }

    @NotNull
    public CompileScope createFilesCompileScope(@NotNull VirtualFile[] virtualFileArray) {
        if (virtualFileArray == null) {
            CompilerManagerImpl.a(33);
        }
        CompileScope[] compileScopeArray = new CompileScope[virtualFileArray.length];
        for (int i2 = 0; i2 < virtualFileArray.length; ++i2) {
            compileScopeArray[i2] = new OneProjectItemCompileScope(this.i, virtualFileArray[i2]);
        }
        CompositeScope compositeScope = new CompositeScope(compileScopeArray);
        if (compositeScope == null) {
            CompilerManagerImpl.a(34);
        }
        return compositeScope;
    }

    @NotNull
    public CompileScope createModuleCompileScope(@NotNull Module module2, boolean bl2) {
        if (module2 == null) {
            CompilerManagerImpl.a(35);
        }
        CompileScope compileScope = this.createModulesCompileScope(new Module[]{module2}, bl2);
        if (compileScope == null) {
            CompilerManagerImpl.a(36);
        }
        return compileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] moduleArray, boolean bl2) {
        if (moduleArray == null) {
            CompilerManagerImpl.a(37);
        }
        CompileScope compileScope = this.createModulesCompileScope(moduleArray, bl2, false);
        if (compileScope == null) {
            CompilerManagerImpl.a(38);
        }
        return compileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] moduleArray, boolean bl2, boolean bl3) {
        if (moduleArray == null) {
            CompilerManagerImpl.a(39);
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(this.i, moduleArray, bl2, bl3);
        if (moduleCompileScope == null) {
            CompilerManagerImpl.a(40);
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createModuleGroupCompileScope(@NotNull Project project2, @NotNull Module[] moduleArray, boolean bl2) {
        if (project2 == null) {
            CompilerManagerImpl.a(41);
        }
        if (moduleArray == null) {
            CompilerManagerImpl.a(42);
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(project2, moduleArray, bl2);
        if (moduleCompileScope == null) {
            CompilerManagerImpl.a(43);
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createProjectCompileScope(@NotNull Project project2) {
        if (project2 == null) {
            CompilerManagerImpl.a(44);
        }
        ProjectCompileScope projectCompileScope = new ProjectCompileScope(project2);
        if (projectCompileScope == null) {
            CompilerManagerImpl.a(45);
        }
        return projectCompileScope;
    }

    public void setValidationEnabled(ModuleType moduleType, boolean bl2) {
        if (bl2) {
            this.h.remove(moduleType);
        } else {
            this.h.add(moduleType);
        }
    }

    public boolean isValidationEnabled(Module module2) {
        if (this.h.isEmpty()) {
            return true;
        }
        return !this.h.contains(ModuleType.get((Module)module2));
    }

    public Collection<ClassObject> compileJavaCode(List<String> list2, Collection<File> collection, Collection<File> collection2, Collection<File> collection3, Collection<File> collection4, Collection<File> collection5, File file) throws IOException, CompilationException {
        boolean bl2;
        File file22;
        Object object;
        Pair<Sdk, JavaSdkVersion> pair2 = BuildManager.getJavacRuntimeSdk(this.i);
        Sdk sdk = (Sdk)pair2.getFirst();
        SdkTypeId sdkTypeId = sdk.getSdkType();
        String string = null;
        if (sdkTypeId instanceof JavaSdkType && !CompilerManagerImpl.a(string = sdk.getHomePath())) {
            object = ((JavaSdkType)sdkTypeId).getBinPath(sdk);
            String string2 = string = object != null ? new File((String)object).getParent() : null;
            if (!CompilerManagerImpl.a(string)) {
                string = null;
            }
        }
        if (string == null) {
            throw new IOException("Was not able to determine JDK for project " + this.i.getName());
        }
        object = new OutputCollector();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        THashSet tHashSet = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        if (!collection4.isEmpty()) {
            tHashSet.addAll(collection4);
        } else {
            for (File file22 : collection5) {
                File file3 = file22.getParentFile();
                if (file3 == null) continue;
                tHashSet.add(file3);
            }
        }
        Map<File, THashSet> map = Collections.singletonMap(file, tHashSet);
        file22 = this.a();
        boolean bl3 = bl2 = file22 != null && file22.forkJavac(string, -1, Collections.emptyList(), list2, collection, collection2, collection3, collection4, collection5, map, diagnosticCollector, (OutputFileConsumer)object, (JavaCompilingTool)new JavacCompilerTool(), CanceledStatus.NULL);
        if (!bl2) {
            SmartList smartList = new SmartList();
            for (Diagnostic<? extends JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
                JavaFileObject javaFileObject = diagnostic.getSource();
                URI uRI = javaFileObject != null ? javaFileObject.toUri() : null;
                smartList.add(new CompilationException.Message(CompilerManagerImpl.a(diagnostic.getKind()), diagnostic.getMessage(Locale.US), uRI != null ? uRI.toURL().toString() : null, (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber()));
            }
            throw new CompilationException("Compilation failed", (Collection)smartList);
        }
        ArrayList<ClassObject> arrayList = new ArrayList<ClassObject>();
        for (OutputFileObject outputFileObject : ((OutputCollector)object).getCompiledClasses()) {
            BinaryContent binaryContent = outputFileObject.getContent();
            arrayList.add(new CompiledClass(outputFileObject.getName(), outputFileObject.getClassName(), binaryContent != null ? binaryContent.toByteArray() : null));
        }
        return arrayList;
    }

    private static boolean a(@Nullable String string) {
        return string != null && (JdkUtil.checkForJre((String)string) || JdkUtil.checkForJdk((String)string));
    }

    private static CompilerMessageCategory a(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return CompilerMessageCategory.ERROR;
            }
            case MANDATORY_WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case NOTE: {
                return CompilerMessageCategory.INFORMATION;
            }
        }
        return CompilerMessageCategory.INFORMATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ExternalJavacManager a() throws IOException {
        ExternalJavacManager externalJavacManager = this.f;
        if (externalJavacManager == null) {
            CompilerManagerImpl compilerManagerImpl = this;
            synchronized (compilerManagerImpl) {
                externalJavacManager = this.f;
                if (externalJavacManager == null) {
                    File file = this.getJavacCompilerWorkingDir();
                    if (file == null) {
                        return null;
                    }
                    int n2 = NetUtils.findAvailableSocketPort();
                    externalJavacManager = new ExternalJavacManager(file);
                    externalJavacManager.start(n2);
                    this.f = externalJavacManager;
                }
            }
        }
        return externalJavacManager;
    }

    @Nullable
    public File getJavacCompilerWorkingDir() {
        File file = BuildManager.getInstance().getProjectSystemDirectory(this.i);
        if (file == null) {
            return null;
        }
        file.mkdirs();
        return file;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerClass";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerManagerImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: 
            case 19: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: 
            case 37: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerManagerImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTasks";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterTasks";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilesCompileScope";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleCompileScope";
                break;
            }
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createModulesCompileScope";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleGroupCompileScope";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectCompileScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "waitForExternalJavacToTerminate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "awaitNettyThreadPoolTermination";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCompiler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTranslatingCompiler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeCompiler";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCompilers";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCompilableFileType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeCompilableFileType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCompilableFileType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeTask";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAfterTask";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "make";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "makeWithModalProgress";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addCompilationStatusListener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeCompilationStatusListener";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFromCompilation";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createFilesCompileScope";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createModuleCompileScope";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createModulesCompileScope";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroupCompileScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createProjectCompileScope";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeCompiler$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OutputCollector
    implements OutputFileConsumer {
        private final List<OutputFileObject> a = new ArrayList<OutputFileObject>();

        private OutputCollector() {
        }

        public void save(@NotNull OutputFileObject outputFileObject) {
            if (outputFileObject == null) {
                OutputCollector.a(0);
            }
            this.a.add(outputFileObject);
        }

        List<OutputFileObject> getCompiledClasses() {
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/intellij/compiler/CompilerManagerImpl$OutputCollector", "save"));
        }
    }

    private static class DiagnosticCollector
    implements DiagnosticOutputConsumer {
        private final List<Diagnostic<? extends JavaFileObject>> a = new ArrayList<Diagnostic<? extends JavaFileObject>>();

        private DiagnosticCollector() {
        }

        public void outputLineAvailable(String string) {
            if (string != null && string.startsWith("JAVAC_PROCESS[STDERR]")) {
                j.info(string.trim());
            }
        }

        public void registerImports(String string, Collection<String> collection, Collection<String> collection2) {
        }

        public void javaFileLoaded(File file) {
        }

        public void customOutputData(String string, String string2, byte[] byArray) {
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.a.add(diagnostic);
        }

        public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
            return this.a;
        }
    }

    private class ListenerNotificator
    implements CompileStatusNotification {
        @Nullable
        private final CompileStatusNotification a;

        private ListenerNotificator(CompileStatusNotification compileStatusNotification) {
            this.a = compileStatusNotification;
        }

        public void finished(boolean bl2, int n2, int n3, CompileContext compileContext) {
            if (!CompilerManagerImpl.this.i.isDisposed()) {
                CompilerManagerImpl.this.b.compilationFinished(bl2, n2, n3, compileContext);
            }
            if (this.a != null) {
                this.a.finished(bl2, n2, n3, compileContext);
            }
        }
    }

    private static class CompiledClass
    implements ClassObject {
        private final String c;
        private final String a;
        private final byte[] b;

        CompiledClass(String string, String string2, byte[] byArray) {
            this.c = string;
            this.a = string2;
            this.b = byArray;
        }

        public String getPath() {
            return this.c;
        }

        public String getClassName() {
            return this.a;
        }

        @Nullable
        public byte[] getContent() {
            return this.b;
        }

        public String toString() {
            return this.getClassName();
        }
    }
}

