/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.compiler.actions.GenerateAntBuildDialog;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationOptionsImpl;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.ModuleChunkAntProject;
import com.intellij.compiler.ant.MultipleFileProjectBuild;
import com.intellij.compiler.ant.ProjectBuild;
import com.intellij.compiler.ant.PropertyFileGeneratorImpl;
import com.intellij.compiler.ant.SingleFileProjectBuild;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GenerateAntBuildAction
extends CompileActionBase {
    @NonNls
    private static final String a = ".xml";

    @Override
    protected void doAction(DataContext dataContext, Project project2) {
        ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2)).convertPatterns();
        GenerateAntBuildDialog generateAntBuildDialog = new GenerateAntBuildDialog(project2);
        if (generateAntBuildDialog.showAndGet()) {
            String[] stringArray = generateAntBuildDialog.getRepresentativeModuleNames();
            GenerationOptionsImpl[] generationOptionsImplArray = new GenerationOptionsImpl[1];
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                generationOptionsImplArray[0] = (GenerationOptionsImpl)((Object)((Object)ReadAction.compute(() -> new GenerationOptionsImpl(project2, generateAntBuildDialog.isGenerateSingleFileBuild(), generateAntBuildDialog.isFormsCompilationEnabled(), generateAntBuildDialog.isBackupFiles(), generateAntBuildDialog.isForceTargetJdk(), generateAntBuildDialog.isRuntimeClasspathInlined(), generateAntBuildDialog.isIdeaHomeGenerated(), stringArray, generateAntBuildDialog.getOutputFileName()))));
            }, "Analyzing project structure...", true, project2)) {
                return;
            }
            if (!GenerateAntBuildAction.a(project2, generationOptionsImplArray[0])) {
                return;
            }
            this.a(project2, generationOptionsImplArray[0]);
        }
    }

    private static boolean a(Project project2, GenerationOptionsImpl generationOptionsImpl) {
        List<String> list2;
        List<String> list3 = list2 = Collections.emptyList();
        for (ModuleChunk moduleChunk : generationOptionsImpl.getModuleChunks()) {
            ChunkCustomCompilerExtension[] chunkCustomCompilerExtensionArray = moduleChunk.getCustomCompilers();
            if (chunkCustomCompilerExtensionArray.length <= 1) continue;
            if (list3 == list2) {
                list3 = new LinkedList<String>();
            }
            list3.add(moduleChunk.getName());
        }
        if (!list3.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : list3) {
                stringBuilder.append(CompilerBundle.message((String)"generate.ant.build.custom.compiler.conflict.message.row", (Object[])new Object[]{string}));
            }
            int n2 = Messages.showOkCancelDialog((Project)project2, (String)CompilerBundle.message((String)"generate.ant.build.custom.compiler.conflict.message", (Object[])new Object[]{stringBuilder.toString()}), (String)CompilerBundle.message((String)"generate.ant.build.custom.compiler.conflict.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            if (n2 != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void update(AnActionEvent anActionEvent) {
        Presentation presentation = anActionEvent.getPresentation();
        presentation.setEnabled(anActionEvent.getProject() != null);
    }

    private void a(final Project project2, final GenerationOptions generationOptions) {
        ModuleChunk[] moduleChunkArray;
        Serializable serializable;
        ApplicationManager.getApplication().saveAll();
        final ArrayList<File> arrayList = new ArrayList<File>();
        final IOException[] iOExceptionArray = new IOException[]{null};
        final ArrayList arrayList2 = new ArrayList();
        try {
            File file;
            if (generationOptions.generateSingleFile) {
                serializable = VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir());
                file = new File((File)serializable, generationOptions.getBuildFileName());
                moduleChunkArray = new File((File)serializable, generationOptions.getPropertiesFileName());
                this.a(project2, new File[]{file, moduleChunkArray});
            } else {
                serializable = new ArrayList();
                file = VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir());
                serializable.add(new File(file, generationOptions.getBuildFileName()));
                serializable.add(new File(file, generationOptions.getPropertiesFileName()));
                for (ModuleChunk moduleChunk : moduleChunkArray = generationOptions.getModuleChunks()) {
                    File file2 = BuildProperties.getModuleChunkBaseDir((ModuleChunk)moduleChunk);
                    serializable.add(new File(file2, BuildProperties.getModuleChunkBuildFileName((ModuleChunk)moduleChunk) + a));
                }
                this.a(project2, serializable.toArray(new File[0]));
            }
            new Task.Modal(project2, CompilerBundle.message((String)"generate.ant.build.title", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator progressIndicator) {
                    if (progressIndicator == null) {
                        1.a(0);
                    }
                    progressIndicator.setIndeterminate(true);
                    progressIndicator.setText(CompilerBundle.message((String)"generate.ant.build.progress.message", (Object[])new Object[0]));
                    try {
                        Object[] objectArray = generationOptions.generateSingleFile ? GenerateAntBuildAction.this.a(project2, generationOptions, arrayList) : GenerateAntBuildAction.this.generateMultipleFileBuild(project2, generationOptions, arrayList);
                        if (objectArray != null) {
                            ContainerUtil.addAll((Collection)arrayList2, (Object[])objectArray);
                        }
                    }
                    catch (IOException iOException) {
                        iOExceptionArray[0] = iOException;
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/compiler/actions/GenerateAntBuildAction$1", "run"));
                }
            }.queue();
        }
        catch (IOException iOException) {
            iOExceptionArray[0] = iOException;
        }
        if (iOExceptionArray[0] != null) {
            Messages.showErrorDialog((Project)project2, (String)CompilerBundle.message((String)"error.ant.files.generate.failed", (Object[])new Object[]{iOExceptionArray[0].getMessage()}), (String)CompilerBundle.message((String)"generate.ant.build.title", (Object[])new Object[0]));
        } else {
            serializable = new StringBuffer();
            for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                moduleChunkArray = (File)arrayList2.get(i2);
                if (i2 > 0) {
                    ((StringBuffer)serializable).append(",\n");
                }
                ((StringBuffer)serializable).append(moduleChunkArray.getPath());
            }
            Messages.showInfoMessage((Project)project2, (String)CompilerBundle.message((String)"message.ant.files.generated.ok", (Object[])new Object[]{((StringBuffer)serializable).toString()}), (String)CompilerBundle.message((String)"generate.ant.build.title", (Object[])new Object[0]));
        }
        if (arrayList.size() > 0) {
            CompilerUtil.refreshIOFiles(arrayList);
        }
    }

    private boolean a(File file, Project project2, GenerationOptions generationOptions, List<File> list2) {
        boolean bl2;
        if (!generationOptions.backupPreviouslyGeneratedFiles || !file.exists()) {
            return true;
        }
        String string = file.getPath();
        int n2 = string.lastIndexOf(".");
        String string2 = string.substring(n2, string.length());
        String string3 = string.substring(0, n2) + "_" + new Date(file.lastModified()).toString().replaceAll("\\s+", "_").replaceAll(":", "-") + string2;
        File file2 = new File(string3);
        try {
            FileUtil.rename((File)file, (File)file2);
            bl2 = true;
        }
        catch (IOException iOException) {
            Messages.showErrorDialog((Project)project2, (String)CompilerBundle.message((String)"error.ant.files.backup.failed", (Object[])new Object[]{string}), (String)CompilerBundle.message((String)"generate.ant.build.title", (Object[])new Object[0]));
            bl2 = false;
        }
        list2.add(file2);
        return bl2;
    }

    private File[] a(Project project2, GenerationOptions generationOptions, List<File> list2) throws IOException {
        File file = VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir());
        file.mkdirs();
        File file2 = new File(file, generationOptions.getBuildFileName());
        File file3 = new File(file, generationOptions.getPropertiesFileName());
        if (!this.a(file2, project2, generationOptions, list2)) {
            return null;
        }
        if (!this.a(file3, project2, generationOptions, list2)) {
            return null;
        }
        GenerateAntBuildAction.generateSingleFileBuild(project2, generationOptions, file2, file3);
        list2.add(file2);
        list2.add(file3);
        return new File[]{file2, file3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSingleFileBuild(Project project2, GenerationOptions generationOptions, File file, File file2) throws IOException {
        FileUtil.createIfDoesntExist((File)file);
        FileUtil.createIfDoesntExist((File)file2);
        try (PrintWriter printWriter = GenerateAntBuildAction.a(file);){
            new SingleFileProjectBuild(project2, generationOptions).generate(printWriter);
        }
        try (PrintWriter printWriter = GenerateAntBuildAction.a(file2);){
            new PropertyFileGeneratorImpl(project2, generationOptions).generate(printWriter);
        }
    }

    private static PrintWriter a(File file) throws UnsupportedEncodingException, FileNotFoundException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), CharsetToolkit.UTF8_CHARSET));
    }

    private void a(Project project2, File[] operationStatus) throws IOException {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(((File[])operationStatus).length);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        for (File file : operationStatus) {
            VirtualFile virtualFile = localFileSystem.findFileByIoFile(file);
            if (virtualFile == null) continue;
            arrayList.add(virtualFile);
        }
        ReadonlyStatusHandler.OperationStatus operationStatus2 = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(VfsUtil.toVirtualFileArray(arrayList));
        if (operationStatus2.hasReadonlyFiles()) {
            throw new IOException(operationStatus2.getReadonlyFilesMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] generateMultipleFileBuild(Project project2, GenerationOptions generationOptions, List<File> list2) throws IOException {
        Object object;
        File file = VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir());
        file.mkdirs();
        ArrayList<File> arrayList = new ArrayList<File>();
        File file2 = new File(file, generationOptions.getBuildFileName());
        File file3 = new File(file, generationOptions.getPropertiesFileName());
        ModuleChunk[] moduleChunkArray = generationOptions.getModuleChunks();
        File[] fileArray = new File[moduleChunkArray.length];
        for (int i2 = 0; i2 < moduleChunkArray.length; ++i2) {
            object = moduleChunkArray[i2];
            File file4 = BuildProperties.getModuleChunkBaseDir((ModuleChunk)object);
            fileArray[i2] = new File(file4, BuildProperties.getModuleChunkBuildFileName((ModuleChunk)object) + a);
        }
        if (!this.a(file2, project2, generationOptions, list2)) {
            return null;
        }
        if (!this.a(file3, project2, generationOptions, list2)) {
            return null;
        }
        FileUtil.createIfDoesntExist((File)file2);
        try (PrintWriter printWriter = GenerateAntBuildAction.a(file2);){
            object = new MultipleFileProjectBuild(project2, generationOptions);
            ((ProjectBuild)((Object)object)).generate(printWriter);
            arrayList.add(file2);
            for (int i3 = 0; i3 < moduleChunkArray.length; ++i3) {
                PrintWriter printWriter2;
                boolean bl2;
                ModuleChunk moduleChunk = moduleChunkArray[i3];
                File file5 = fileArray[i3];
                File file6 = file5.getParentFile();
                if (file6 != null) {
                    file6.mkdirs();
                }
                if (!(bl2 = this.a(file5, project2, generationOptions, list2))) {
                    printWriter2 = null;
                    return printWriter2;
                }
                FileUtil.createIfDoesntExist((File)file5);
                printWriter2 = GenerateAntBuildAction.a(file5);
                try {
                    new ModuleChunkAntProject(project2, moduleChunk, generationOptions).generate(printWriter2);
                    arrayList.add(file5);
                    continue;
                }
                finally {
                    printWriter2.close();
                }
            }
        }
        object = GenerateAntBuildAction.a(file3);
        try {
            new PropertyFileGeneratorImpl(project2, generationOptions).generate((PrintWriter)object);
            arrayList.add(file3);
        }
        finally {
            ((PrintWriter)object).close();
        }
        list2.addAll(arrayList);
        return arrayList.toArray(new File[0]);
    }
}

