/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.BuildPropertiesImpl;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.CleanProject;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.artifacts.ArtifactsGenerator;
import com.intellij.compiler.ant.taskdefs.AntProject;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public abstract class ProjectBuild
extends Generator {
    protected final Project myProject;
    private final AntProject a;

    public ProjectBuild(Project project2, GenerationOptions generationOptions) {
        this.myProject = project2;
        this.a = new AntProject(BuildProperties.getProjectBuildFileName((Project)this.myProject), "all");
        this.a.add((Generator)new BuildPropertiesImpl(this.myProject, generationOptions), 1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("init");
        stringBuilder.append(", ");
        stringBuilder.append("clean");
        ModuleChunk[] moduleChunkArray = generationOptions.getModuleChunks();
        if (moduleChunkArray.length > 0) {
            this.a.add((Generator)new Comment(CompilerBundle.message((String)"generated.ant.build.modules.section.title", (Object[])new Object[0])), 1);
            for (Target object2 : moduleChunkArray) {
                this.a.add(this.createModuleBuildGenerator((ModuleChunk)object2, generationOptions), 1);
                Generator generator = ChunkBuildExtension.getAllTargets((ModuleChunk)object2);
                for (String string : generator) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string);
                }
            }
        }
        for (ChunkBuildExtension chunkBuildExtension : (Target)ChunkBuildExtension.EP_NAME.getExtensions()) {
            chunkBuildExtension.generateProjectTargets(project2, generationOptions, (CompositeGenerator)this.a);
        }
        Target target = new Target("init", null, CompilerBundle.message((String)"generated.ant.build.initialization.section.title", (Object[])new Object[0]), null);
        target.add((Generator)new Comment(CompilerBundle.message((String)"generated.ant.build.initialization.section.comment", (Object[])new Object[0])));
        this.a.add((Generator)target, 1);
        ArtifactsGenerator artifactsGenerator = new ArtifactsGenerator(project2, generationOptions);
        this.a.add((Generator)new CleanProject(project2, generationOptions, artifactsGenerator), 1);
        this.a.add((Generator)new Target("build.modules", stringBuilder.toString(), CompilerBundle.message((String)"generated.ant.build.build.all.modules.target.name", (Object[])new Object[0]), null), 1);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("build.modules");
        if (artifactsGenerator.hasArtifacts()) {
            List<Generator> list2 = artifactsGenerator.generate();
            for (Generator generator : list2) {
                this.a.add(generator, 1);
            }
            stringBuilder2.append(", ").append("build.all.artifacts");
        }
        this.a.add((Generator)new Target("all", stringBuilder2.toString(), CompilerBundle.message((String)"generated.ant.build.build.all.target.name", (Object[])new Object[0]), null), 1);
    }

    public void generate(PrintWriter printWriter) throws IOException {
        ProjectBuild.writeXmlHeader((PrintWriter)printWriter);
        this.a.generate(printWriter);
    }

    protected abstract Generator createModuleBuildGenerator(ModuleChunk var1, GenerationOptions var2);
}

