/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import java.util.Collection;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

enum CompilerHierarchySearchType {
    DIRECT_INHERITOR{

        @Override
        PsiElement[] performSearchInFile(SearchId[] searchIdArray, PsiNamedElement psiNamedElement, PsiFileWithStubSupport psiFileWithStubSupport, LanguageLightRefAdapter languageLightRefAdapter) {
            return languageLightRefAdapter.findDirectInheritorCandidatesInFile(searchIdArray, psiFileWithStubSupport);
        }

        @Override
        Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter languageLightRefAdapter) {
            return languageLightRefAdapter.getHierarchyObjectClass();
        }

        @Override
        SearchId[] convertToIds(Collection<LightRef> collection, NameEnumerator nameEnumerator) {
            return (SearchId[])collection.stream().map(lightRef -> lightRef instanceof LightRef.JavaLightAnonymousClassRef ? new SearchId(((LightRef.JavaLightAnonymousClassRef)lightRef).getName()) : new SearchId(nameEnumerator.getName(((LightRef.LightClassHierarchyElementDef)lightRef).getName()))).toArray(SearchId[]::new);
        }
    }
    ,
    FUNCTIONAL_EXPRESSION{

        @Override
        PsiElement[] performSearchInFile(SearchId[] searchIdArray, PsiNamedElement psiNamedElement, PsiFileWithStubSupport psiFileWithStubSupport, LanguageLightRefAdapter languageLightRefAdapter) {
            return languageLightRefAdapter.findFunExpressionsInFile(searchIdArray, psiFileWithStubSupport);
        }

        @Override
        Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter languageLightRefAdapter) {
            return languageLightRefAdapter.getFunExprClass();
        }

        @Override
        SearchId[] convertToIds(Collection<LightRef> collection, NameEnumerator nameEnumerator) {
            return (SearchId[])collection.stream().map(lightRef -> ((LightRef.LightFunExprDef)lightRef).getId()).map(SearchId::new).toArray(SearchId[]::new);
        }
    };


    abstract PsiElement[] performSearchInFile(SearchId[] var1, PsiNamedElement var2, PsiFileWithStubSupport var3, LanguageLightRefAdapter var4);

    abstract Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter var1);

    abstract SearchId[] convertToIds(Collection<LightRef> var1, NameEnumerator var2);
}

