/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.backwardRefs.CompilerHierarchyInfoImpl;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.DirtyScopeHolder;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.OccurrenceCounter;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.chainsSearch.ChainOpAndOccurrences;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.TypeCast;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.SignatureData;

public class CompilerReferenceServiceImpl
extends CompilerReferenceServiceEx
implements ModificationTracker {
    private static final Logger a = Logger.getInstance(CompilerReferenceServiceImpl.class);
    private final Set<FileType> j;
    private final DirtyScopeHolder h;
    private final ProjectFileIndex d;
    private final LongAdder e = new LongAdder();
    private final ReentrantReadWriteLock f = new ReentrantReadWriteLock();
    private final Lock g = this.f.readLock();
    private final Lock b = this.f.writeLock();
    private int c = 0;
    private volatile CompilerReferenceReader i;

    public CompilerReferenceServiceImpl(Project project2, FileDocumentManager fileDocumentManager, PsiDocumentManager psiDocumentManager) {
        super(project2);
        this.d = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.j = Stream.of(LanguageLightRefAdapter.INSTANCES).flatMap(languageLightRefAdapter -> languageLightRefAdapter.getFileTypes().stream()).collect(Collectors.toSet());
        this.h = new DirtyScopeHolder(this, fileDocumentManager, psiDocumentManager);
    }

    public void projectOpened() {
        if (CompilerReferenceServiceImpl.isEnabled()) {
            MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
            messageBusConnection.subscribe(BuildManagerListener.TOPIC, (Object)new BuildManagerListener(){

                @Override
                public void buildStarted(Project project2, UUID uUID, boolean bl2) {
                    if (project2 == CompilerReferenceServiceImpl.this.myProject) {
                        CompilerReferenceServiceImpl.this.a(IndexCloseReason.COMPILATION_STARTED);
                    }
                }
            });
            messageBusConnection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

                public void compilationFinished(boolean bl2, int n2, int n3, CompileContext compileContext) {
                    this.a(compileContext);
                }

                public void automakeCompilationFinished(int n2, int n3, CompileContext compileContext) {
                    this.a(compileContext);
                }

                private void a(CompileContext compileContext) {
                    if (compileContext.getProject() == CompilerReferenceServiceImpl.this.myProject) {
                        Runnable runnable = () -> {
                            Module[] moduleArray = (Module[])ReadAction.compute(() -> {
                                if (CompilerReferenceServiceImpl.this.myProject.isDisposed()) {
                                    return null;
                                }
                                return compileContext.getCompileScope().getAffectedModules();
                            });
                            if (moduleArray == null) {
                                return;
                            }
                            CompilerReferenceServiceImpl.this.a(IndexOpenReason.COMPILATION_FINISHED);
                        };
                        CompilerReferenceServiceImpl.a(runnable);
                    }
                }
            });
            this.h.installVFSListener();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    boolean bl2;
                    boolean bl3 = CompilerReferenceReader.exists(this.myProject);
                    if (bl3) {
                        CompileScope compileScope = compilerManager.createProjectCompileScope(this.myProject);
                        bl2 = compilerManager.isUpToDate(compileScope);
                    } else {
                        bl2 = false;
                    }
                    CompilerReferenceServiceImpl.a(() -> {
                        if (bl2) {
                            this.a(IndexOpenReason.UP_TO_DATE_CACHE);
                        } else {
                            this.a(bl3);
                        }
                    });
                });
            }
            Disposer.register((Disposable)this.myProject, () -> this.a(IndexCloseReason.PROJECT_CLOSED));
        }
    }

    @Nullable
    public GlobalSearchScope getScopeWithoutCodeReferences(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CompilerReferenceServiceImpl.a(0);
        }
        if (!this.a(psiElement)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)psiElement, () -> {
                if (psiElement == null) {
                    CompilerReferenceServiceImpl.a(61);
                }
                return CachedValueProvider.Result.create((Object)this.g(psiElement), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            });
        }
        catch (RuntimeException runtimeException) {
            return (GlobalSearchScope)this.a(runtimeException, "scope without code references");
        }
    }

    @Nullable
    public CompilerDirectHierarchyInfo getDirectInheritors(@NotNull PsiNamedElement psiNamedElement, @NotNull GlobalSearchScope globalSearchScope, @NotNull FileType fileType) {
        if (psiNamedElement == null) {
            CompilerReferenceServiceImpl.a(1);
        }
        if (globalSearchScope == null) {
            CompilerReferenceServiceImpl.a(2);
        }
        if (fileType == null) {
            CompilerReferenceServiceImpl.a(3);
        }
        return this.a(psiNamedElement, globalSearchScope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
    }

    @Nullable
    public CompilerDirectHierarchyInfo getFunExpressions(@NotNull PsiNamedElement psiNamedElement, @NotNull GlobalSearchScope globalSearchScope, @NotNull FileType fileType) {
        if (psiNamedElement == null) {
            CompilerReferenceServiceImpl.a(4);
        }
        if (globalSearchScope == null) {
            CompilerReferenceServiceImpl.a(5);
        }
        if (fileType == null) {
            CompilerReferenceServiceImpl.a(6);
        }
        return this.a(psiNamedElement, globalSearchScope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
    }

    @Nullable
    public Integer getCompileTimeOccurrenceCount(@NotNull PsiElement psiElement, boolean bl2) {
        if (psiElement == null) {
            CompilerReferenceServiceImpl.a(7);
        }
        if (!this.a(psiElement)) {
            return null;
        }
        try {
            return (Integer)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)psiElement, () -> {
                if (psiElement == null) {
                    CompilerReferenceServiceImpl.a(59);
                }
                return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(bl2 -> {
                    if (psiElement == null) {
                        CompilerReferenceServiceImpl.a(60);
                    }
                    return this.a(psiElement, (boolean)bl2);
                }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            })).get(bl2);
        }
        catch (RuntimeException runtimeException) {
            return (Integer)this.a(runtimeException, "weighting for completion");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public SortedSet<ChainOpAndOccurrences<MethodCall>> findMethodReferenceOccurrences(@NotNull String var1_1, @SignatureData.IteratorKind byte var2_2, @NotNull ChainCompletionContext var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ChainOpAndOccurrences<TypeCast> getMostUsedTypeCast(@NotNull String string) throws ReferenceIndexUnavailableException {
        if (string == null) {
            CompilerReferenceServiceImpl.a(13);
        }
        try {
            this.g.lock();
            try {
                if (this.i == null) {
                    throw new ReferenceIndexUnavailableException();
                }
                int n2 = this.getNameId(string);
                if (n2 == 0) {
                    ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = null;
                    return chainOpAndOccurrences;
                }
                LightRef.JavaLightClassRef javaLightClassRef = new LightRef.JavaLightClassRef(n2);
                OccurrenceCounter<LightRef> occurrenceCounter = this.i.getTypeCastOperands((LightRef.LightClassHierarchyElementDef)javaLightClassRef, null);
                LightRef lightRef = occurrenceCounter.getBest();
                if (lightRef == null) {
                    ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = null;
                    return chainOpAndOccurrences;
                }
                ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = new ChainOpAndOccurrences<TypeCast>(new TypeCast((LightRef.LightClassHierarchyElementDef)lightRef, (LightRef.LightClassHierarchyElementDef)javaLightClassRef, this), occurrenceCounter.getBestOccurrences());
                return chainOpAndOccurrences;
            }
            finally {
                this.g.unlock();
            }
        }
        catch (Exception exception) {
            this.a(exception, "best type cast search");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LightRef.LightClassHierarchyElementDef mayCallOfTypeCast(@NotNull LightRef.JavaLightMethodRef javaLightMethodRef, int n2) throws ReferenceIndexUnavailableException {
        if (javaLightMethodRef == null) {
            CompilerReferenceServiceImpl.a(14);
        }
        this.g.lock();
        try {
            if (this.i == null) {
                throw new ReferenceIndexUnavailableException();
            }
            TIntHashSet tIntHashSet = this.i.getAllContainingFileIds((LightRef)javaLightMethodRef);
            LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef = javaLightMethodRef.getOwner();
            OccurrenceCounter<LightRef> occurrenceCounter = this.i.getTypeCastOperands(lightClassHierarchyElementDef, tIntHashSet);
            LightRef lightRef = occurrenceCounter.getBest();
            LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef2 = lightRef != null && tIntHashSet.size() > n2 * (tIntHashSet.size() - occurrenceCounter.getBestOccurrences()) ? (LightRef.LightClassHierarchyElementDef)lightRef : null;
            this.g.unlock();
            return lightClassHierarchyElementDef2;
        }
        catch (Throwable throwable) {
            try {
                this.g.unlock();
                throw throwable;
            }
            catch (Exception exception) {
                this.a(exception, "conditional probability");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mayHappen(@NotNull LightRef lightRef, @NotNull LightRef lightRef2, int n2) {
        if (lightRef == null) {
            CompilerReferenceServiceImpl.a(15);
        }
        if (lightRef2 == null) {
            CompilerReferenceServiceImpl.a(16);
        }
        try {
            this.g.lock();
            try {
                if (this.i == null) {
                    throw new ReferenceIndexUnavailableException();
                }
                TIntHashSet tIntHashSet = this.i.getAllContainingFileIds(lightRef);
                TIntHashSet tIntHashSet2 = this.i.getAllContainingFileIds(lightRef2);
                TIntHashSet tIntHashSet3 = CompilerReferenceServiceImpl.a(tIntHashSet, tIntHashSet2);
                if ((tIntHashSet2.size() - tIntHashSet3.size()) * n2 < tIntHashSet2.size()) {
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.g.unlock();
            }
        }
        catch (Exception exception) {
            this.a(exception, "conditional probability");
            return false;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public String getName(int n2) throws ReferenceIndexUnavailableException {
        this.g.lock();
        if (this.i == null) {
            throw new ReferenceIndexUnavailableException();
        }
        String string = this.i.getNameEnumerator().getName(n2);
        this.g.unlock();
        String string2 = string;
        if (string2 == null) {
            CompilerReferenceServiceImpl.a(17);
        }
        return string2;
        {
            catch (Throwable throwable) {
                try {
                    this.g.unlock();
                    throw throwable;
                }
                catch (Exception exception) {
                    this.a(exception, "find methods");
                    throw new ReferenceIndexUnavailableException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNameId(@NotNull String string) throws ReferenceIndexUnavailableException {
        if (string == null) {
            CompilerReferenceServiceImpl.a(18);
        }
        this.g.lock();
        try {
            int n2;
            if (this.i == null) {
                throw new ReferenceIndexUnavailableException();
            }
            int n3 = n2 = this.i.getNameEnumerator().tryEnumerate((Object)string);
            this.g.unlock();
            return n3;
        }
        catch (Throwable throwable) {
            try {
                this.g.unlock();
                throw throwable;
            }
            catch (Exception exception) {
                this.a(exception, "get name-id");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public LightRef.LightClassHierarchyElementDef[] getDirectInheritors(@NotNull LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef) throws ReferenceIndexUnavailableException {
        LightRef.LightClassHierarchyElementDef[] lightClassHierarchyElementDefArray;
        block7: {
            if (lightClassHierarchyElementDef == null) {
                CompilerReferenceServiceImpl.a(19);
            }
            this.g.lock();
            if (this.i == null) {
                throw new ReferenceIndexUnavailableException();
            }
            lightClassHierarchyElementDefArray = this.i.getDirectInheritors(lightClassHierarchyElementDef);
            this.g.unlock();
            if (lightClassHierarchyElementDefArray != null) break block7;
            CompilerReferenceServiceImpl.a(20);
        }
        return lightClassHierarchyElementDefArray;
        {
            catch (Throwable throwable) {
                try {
                    this.g.unlock();
                    throw throwable;
                }
                catch (Exception exception) {
                    this.a(exception, "find methods");
                    throw new ReferenceIndexUnavailableException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInheritorCount(@NotNull LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef) throws ReferenceIndexUnavailableException {
        if (lightClassHierarchyElementDef == null) {
            CompilerReferenceServiceImpl.a(21);
        }
        this.g.lock();
        try {
            if (this.i == null) {
                throw new ReferenceIndexUnavailableException();
            }
            LightRef.LightClassHierarchyElementDef[] lightClassHierarchyElementDefArray = this.i.getHierarchy(lightClassHierarchyElementDef, false, true, -1);
            int n2 = lightClassHierarchyElementDefArray == null ? -1 : lightClassHierarchyElementDefArray.length;
            this.g.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            try {
                this.g.unlock();
                throw throwable;
            }
            catch (Exception exception) {
                this.a(exception, "inheritor count");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    private Integer a(@NotNull PsiElement psiElement, boolean bl2) {
        if (psiElement == null) {
            CompilerReferenceServiceImpl.a(22);
        }
        LanguageLightRefAdapter languageLightRefAdapter = null;
        if (bl2 && ((languageLightRefAdapter = (LanguageLightRefAdapter)ReadAction.compute(() -> {
            if (psiElement == null) {
                CompilerReferenceServiceImpl.a(56);
            }
            return LanguageLightRefAdapter.findAdapter(psiElement);
        })) == null || !languageLightRefAdapter.isClass(psiElement))) {
            return null;
        }
        CompilerElementInfo compilerElementInfo = this.a(psiElement, false, false);
        if (compilerElementInfo == null) {
            return null;
        }
        this.g.lock();
        try {
            if (this.i == null) {
                Integer n2 = null;
                return n2;
            }
            if (bl2) {
                int n3 = 0;
                for (PsiElement psiElement2 : languageLightRefAdapter.getInstantiableConstructors(psiElement)) {
                    LightRef lightRef = languageLightRefAdapter.asLightUsage(psiElement2, this.i.getNameEnumerator());
                    if (lightRef == null) continue;
                    n3 += this.i.getOccurrenceCount(lightRef);
                }
                Integer n4 = this.i.getAnonymousCount((LightRef.LightClassHierarchyElementDef)compilerElementInfo.searchElements[0], compilerElementInfo.place == ElementPlace.SRC);
                Integer n5 = n4 == null ? n3 : n3 + n4;
                return n5;
            }
            Integer n6 = this.i.getOccurrenceCount(compilerElementInfo.searchElements[0]);
            return n6;
        }
        finally {
            this.g.unlock();
        }
    }

    @Nullable
    private CompilerHierarchyInfoImpl a(@NotNull PsiNamedElement psiNamedElement, @NotNull GlobalSearchScope globalSearchScope, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType compilerHierarchySearchType) {
        if (psiNamedElement == null) {
            CompilerReferenceServiceImpl.a(23);
        }
        if (globalSearchScope == null) {
            CompilerReferenceServiceImpl.a(24);
        }
        if (fileType == null) {
            CompilerReferenceServiceImpl.a(25);
        }
        if (compilerHierarchySearchType == null) {
            CompilerReferenceServiceImpl.a(26);
        }
        if (!this.a((PsiElement)psiNamedElement) || globalSearchScope == LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope()) {
            return null;
        }
        try {
            Map map = (Map)ReadAction.compute(() -> {
                if (psiNamedElement == null) {
                    CompilerReferenceServiceImpl.a(51);
                }
                if (compilerHierarchySearchType == null) {
                    CompilerReferenceServiceImpl.a(52);
                }
                if (fileType == null) {
                    CompilerReferenceServiceImpl.a(53);
                }
                if (this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (Map)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)psiNamedElement, () -> {
                    if (psiNamedElement == null) {
                        CompilerReferenceServiceImpl.a(54);
                    }
                    return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(hierarchySearchKey -> {
                        if (psiNamedElement == null) {
                            CompilerReferenceServiceImpl.a(55);
                        }
                        return this.a(psiNamedElement, ((HierarchySearchKey)hierarchySearchKey).a, ((HierarchySearchKey)hierarchySearchKey).b);
                    }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
                })).get(new HierarchySearchKey(compilerHierarchySearchType, fileType));
            });
            if (map == null) {
                return null;
            }
            GlobalSearchScope globalSearchScope2 = this.h.getDirtyScope();
            if (ElementPlace.LIB == ReadAction.compute(() -> {
                if (psiNamedElement == null) {
                    CompilerReferenceServiceImpl.a(50);
                }
                return ElementPlace.a(psiNamedElement.getContainingFile().getVirtualFile(), this.d);
            })) {
                globalSearchScope2 = globalSearchScope2.union((SearchScope)LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope());
            }
            return new CompilerHierarchyInfoImpl(map, psiNamedElement, globalSearchScope2, globalSearchScope, this.myProject, fileType, compilerHierarchySearchType);
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (RuntimeException runtimeException) {
            return (CompilerHierarchyInfoImpl)this.a(runtimeException, "hierarchy");
        }
    }

    private boolean a(PsiElement psiElement) {
        if (!this.isActive()) {
            return false;
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> psiElement.getContainingFile());
        return psiFile != null && !InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(psiFile);
    }

    public boolean isActive() {
        return this.i != null && CompilerReferenceServiceImpl.isEnabled();
    }

    private Map<VirtualFile, SearchId[]> a(@NotNull PsiNamedElement psiNamedElement, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType compilerHierarchySearchType) {
        SearchScope searchScope;
        if (psiNamedElement == null) {
            CompilerReferenceServiceImpl.a(27);
        }
        if (fileType == null) {
            CompilerReferenceServiceImpl.a(28);
        }
        if (compilerHierarchySearchType == null) {
            CompilerReferenceServiceImpl.a(29);
        }
        if (!((searchScope = psiNamedElement.getUseScope()) instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerElementInfo compilerElementInfo = this.a((PsiElement)psiNamedElement, false, true);
        if (compilerElementInfo == null) {
            return null;
        }
        LightRef lightRef = compilerElementInfo.searchElements[0];
        this.g.lock();
        try {
            if (this.i == null) {
                Map<VirtualFile, SearchId[]> map = null;
                return map;
            }
            Map<VirtualFile, SearchId[]> map = this.i.getDirectInheritors(lightRef, (GlobalSearchScope)searchScope, this.h.getDirtyScope(), fileType, compilerHierarchySearchType);
            return map;
        }
        finally {
            this.g.unlock();
        }
    }

    @Nullable
    private GlobalSearchScope g(@NotNull PsiElement psiElement) {
        TIntHashSet tIntHashSet;
        if (psiElement == null) {
            CompilerReferenceServiceImpl.a(30);
        }
        if ((tIntHashSet = this.c(psiElement)) == null) {
            return null;
        }
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)new ScopeWithoutReferencesOnCompilation(tIntHashSet, this.d).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.h.getDirtyScope())), (FileType[])this.j.toArray(FileType.EMPTY_ARRAY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TIntHashSet c(@NotNull PsiElement psiElement) {
        CompilerElementInfo compilerElementInfo;
        if (psiElement == null) {
            CompilerReferenceServiceImpl.a(31);
        }
        if ((compilerElementInfo = this.a(psiElement, true, true)) == null) {
            return null;
        }
        this.g.lock();
        try {
            if (this.i == null) {
                TIntHashSet tIntHashSet = null;
                return tIntHashSet;
            }
            TIntHashSet tIntHashSet = new TIntHashSet();
            for (TIntHashSet tIntHashSet2 : compilerElementInfo.searchElements) {
                TIntHashSet tIntHashSet3;
                block12: {
                    try {
                        tIntHashSet3 = this.i.findReferentFileIds((LightRef)tIntHashSet2, compilerElementInfo.place == ElementPlace.SRC);
                        if (tIntHashSet3 != null) break block12;
                        TIntHashSet tIntHashSet4 = null;
                        return tIntHashSet4;
                    }
                    catch (StorageException storageException) {
                        throw new RuntimeException(storageException);
                    }
                }
                tIntHashSet.addAll(tIntHashSet3.toArray());
            }
            TIntHashSet tIntHashSet5 = tIntHashSet;
            return tIntHashSet5;
        }
        finally {
            this.g.unlock();
        }
    }

    @Nullable
    private CompilerElementInfo a(@NotNull PsiElement psiElement, boolean bl2, boolean bl3) {
        if (psiElement == null) {
            CompilerReferenceServiceImpl.a(32);
        }
        this.g.lock();
        try {
            if (this.i == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (virtualFile == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            ElementPlace elementPlace = ElementPlace.a(virtualFile, this.d);
            if (bl3 && (elementPlace == null || elementPlace == ElementPlace.SRC && this.h.contains(virtualFile))) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LanguageLightRefAdapter languageLightRefAdapter = LanguageLightRefAdapter.findAdapter(virtualFile);
            if (languageLightRefAdapter == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LightRef lightRef = languageLightRefAdapter.asLightUsage(psiElement, this.i.getNameEnumerator());
            if (lightRef == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            if (elementPlace == ElementPlace.LIB && bl2) {
                List<LightRef> list2 = languageLightRefAdapter.getHierarchyRestrictedToLibraryScope(lightRef, psiElement, this.i.getNameEnumerator(), LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope());
                LightRef[] lightRefArray = new LightRef[list2.size() + 1];
                lightRefArray[0] = lightRef;
                int n2 = 1;
                for (LightRef lightRef2 : list2) {
                    lightRefArray[n2++] = lightRef2;
                }
                CompilerElementInfo compilerElementInfo = new CompilerElementInfo(elementPlace, lightRefArray);
                return compilerElementInfo;
            }
            CompilerElementInfo compilerElementInfo = new CompilerElementInfo(elementPlace, new LightRef[]{lightRef});
            return compilerElementInfo;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            this.g.unlock();
        }
    }

    private void a(IndexCloseReason indexCloseReason) {
        this.b.lock();
        try {
            if (indexCloseReason == IndexCloseReason.COMPILATION_STARTED) {
                ++this.c;
                this.h.compilerActivityStarted();
            }
            if (this.i != null) {
                this.i.close(indexCloseReason == IndexCloseReason.AN_EXCEPTION);
                this.i = null;
            }
        }
        finally {
            this.b.unlock();
        }
    }

    private void a(IndexOpenReason indexOpenReason) {
        this.e.increment();
        this.b.lock();
        try {
            try {
                switch (indexOpenReason) {
                    case UP_TO_DATE_CACHE: {
                        this.h.upToDateChecked(true);
                        break;
                    }
                    case COMPILATION_FINISHED: {
                        this.h.compilerActivityFinished();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                --this.c;
                throw runtimeException;
            }
            if (--this.c == 0 && this.myProject.isOpen()) {
                this.i = CompilerReferenceReader.create(this.myProject);
                a.info("backward reference index reader " + (this.i == null ? "doesn't exist" : "is opened"));
            }
        }
        finally {
            this.b.unlock();
        }
    }

    private void a(boolean bl2) {
        this.b.lock();
        try {
            if (bl2) {
                --this.c;
            }
            this.h.upToDateChecked(false);
        }
        finally {
            this.b.unlock();
        }
    }

    ProjectFileIndex getFileIndex() {
        return this.d;
    }

    Set<FileType> getFileTypes() {
        return this.j;
    }

    Project getProject() {
        return this.myProject;
    }

    private static void a(Runnable runnable) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            BuildManager.getInstance().runCommand(runnable);
        }
    }

    public long getModificationCount() {
        return this.e.longValue();
    }

    @Nullable
    public Set<VirtualFile> getReferentFiles(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CompilerReferenceServiceImpl.a(33);
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        TIntHashSet tIntHashSet = this.c(psiElement);
        if (tIntHashSet == null) {
            return null;
        }
        THashSet tHashSet = new THashSet();
        tIntHashSet.forEach(arg_0 -> this.a(fileBasedIndex, (Set)tHashSet, arg_0));
        return tHashSet;
    }

    @NotNull
    public DirtyScopeHolder getDirtyScopeHolder() {
        DirtyScopeHolder dirtyScopeHolder = this.h;
        if (dirtyScopeHolder == null) {
            CompilerReferenceServiceImpl.a(34);
        }
        return dirtyScopeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceFindUsagesTestInfo getTestFindUsages(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CompilerReferenceServiceImpl.a(35);
        }
        this.g.lock();
        TIntHashSet tIntHashSet = this.c(psiElement);
        DirtyScopeTestInfo dirtyScopeTestInfo = this.h.getState();
        CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo = new CompilerReferenceFindUsagesTestInfo(tIntHashSet, dirtyScopeTestInfo, this.myProject);
        CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo2 = compilerReferenceFindUsagesTestInfo;
        if (compilerReferenceFindUsagesTestInfo2 == null) {
            CompilerReferenceServiceImpl.a(36);
        }
        return compilerReferenceFindUsagesTestInfo2;
        finally {
            this.g.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceHierarchyTestInfo getTestHierarchy(@NotNull PsiNamedElement psiNamedElement, @NotNull GlobalSearchScope globalSearchScope, @NotNull FileType fileType) {
        if (psiNamedElement == null) {
            CompilerReferenceServiceImpl.a(37);
        }
        if (globalSearchScope == null) {
            CompilerReferenceServiceImpl.a(38);
        }
        if (fileType == null) {
            CompilerReferenceServiceImpl.a(39);
        }
        this.g.lock();
        CompilerHierarchyInfoImpl compilerHierarchyInfoImpl = this.a(psiNamedElement, globalSearchScope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
        DirtyScopeTestInfo dirtyScopeTestInfo = this.h.getState();
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(compilerHierarchyInfoImpl, dirtyScopeTestInfo);
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo2 = compilerReferenceHierarchyTestInfo;
        if (compilerReferenceHierarchyTestInfo2 == null) {
            CompilerReferenceServiceImpl.a(40);
        }
        return compilerReferenceHierarchyTestInfo2;
        finally {
            this.g.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceHierarchyTestInfo getTestFunExpressions(@NotNull PsiNamedElement psiNamedElement, @NotNull GlobalSearchScope globalSearchScope, @NotNull FileType fileType) {
        if (psiNamedElement == null) {
            CompilerReferenceServiceImpl.a(41);
        }
        if (globalSearchScope == null) {
            CompilerReferenceServiceImpl.a(42);
        }
        if (fileType == null) {
            CompilerReferenceServiceImpl.a(43);
        }
        this.g.lock();
        CompilerHierarchyInfoImpl compilerHierarchyInfoImpl = this.a(psiNamedElement, globalSearchScope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
        DirtyScopeTestInfo dirtyScopeTestInfo = this.h.getState();
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(compilerHierarchyInfoImpl, dirtyScopeTestInfo);
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo2 = compilerReferenceHierarchyTestInfo;
        if (compilerReferenceHierarchyTestInfo2 == null) {
            CompilerReferenceServiceImpl.a(44);
        }
        return compilerReferenceHierarchyTestInfo2;
        finally {
            this.g.unlock();
        }
    }

    @Nullable
    private <T> T a(@NotNull Exception exception, @NotNull String string) {
        Throwable throwable;
        if (exception == null) {
            CompilerReferenceServiceImpl.a(45);
        }
        if (string == null) {
            CompilerReferenceServiceImpl.a(46);
        }
        if (exception instanceof ControlFlowException) {
            throw (RuntimeException)exception;
        }
        a.error("an exception during " + string + " calculation", (Throwable)exception);
        Throwable throwable2 = throwable = exception instanceof RuntimeException ? exception.getCause() : exception;
        if (CompilerReferenceServiceImpl.a(throwable)) {
            this.a(IndexCloseReason.AN_EXCEPTION);
        }
        return null;
    }

    @NotNull
    private static TIntHashSet a(@NotNull TIntHashSet tIntHashSet, @NotNull TIntHashSet tIntHashSet2) {
        if (tIntHashSet == null) {
            CompilerReferenceServiceImpl.a(47);
        }
        if (tIntHashSet2 == null) {
            CompilerReferenceServiceImpl.a(48);
        }
        TIntHashSet tIntHashSet3 = (TIntHashSet)tIntHashSet.clone();
        tIntHashSet3.retainAll(tIntHashSet2.toArray());
        TIntHashSet tIntHashSet4 = tIntHashSet3;
        if (tIntHashSet4 == null) {
            CompilerReferenceServiceImpl.a(49);
        }
        return tIntHashSet4;
    }

    private static boolean a(@Nullable Throwable throwable) {
        return throwable instanceof PersistentEnumeratorBase.CorruptedException || throwable instanceof StorageException || throwable instanceof IOException;
    }

    private /* synthetic */ boolean a(FileBasedIndex fileBasedIndex, Set set, int n2) {
        VirtualFile virtualFile = fileBasedIndex.findFileById(this.myProject, n2);
        assert (virtualFile != null);
        set.add(virtualFile);
        return true;
    }

    private static /* synthetic */ ChainOpAndOccurrences a(Map.Entry entry) {
        return new ChainOpAndOccurrences<RefChainOperation>((RefChainOperation)entry.getKey(), (int)((IntSummaryStatistics)entry.getValue()).getSum());
    }

    private static /* synthetic */ int a(ChainOpAndOccurrences chainOpAndOccurrences) {
        return chainOpAndOccurrences.getOccurrenceCount();
    }

    private static /* synthetic */ MethodCall b(ChainOpAndOccurrences chainOpAndOccurrences) {
        return (MethodCall)chainOpAndOccurrences.getOperation();
    }

    private /* synthetic */ Stream a(@NotNull ChainCompletionContext chainCompletionContext, SignatureData signatureData) {
        if (chainCompletionContext == null) {
            CompilerReferenceServiceImpl.a(57);
        }
        return ((StreamEx)((StreamEx)StreamEx.of(this.i.getMembersFor(signatureData)).peek(lightRef -> ProgressManager.checkCanceled())).select(LightRef.JavaLightMethodRef.class).flatMap(javaLightMethodRef -> {
            LightRef.LightClassHierarchyElementDef[] lightClassHierarchyElementDefArray = this.i.getHierarchy(javaLightMethodRef.getOwner(), false, false, 20);
            return lightClassHierarchyElementDefArray == null ? Stream.empty() : Arrays.stream(lightClassHierarchyElementDefArray).map(namedLightRef -> javaLightMethodRef.override(namedLightRef.getName()));
        }).distinct()).map(lightRef -> {
            int n2;
            if (chainCompletionContext == null) {
                CompilerReferenceServiceImpl.a(58);
            }
            return (n2 = this.i.getOccurrenceCount((LightRef)lightRef)) <= 1 ? null : new ChainOpAndOccurrences<MethodCall>(new MethodCall((LightRef.JavaLightMethodRef)lightRef, signatureData, chainCompletionContext), n2);
        });
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 34: 
            case 36: 
            case 40: 
            case 44: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 34: 
            case 36: 
            case 40: 
            case 44: 
            case 49: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 23: 
            case 27: 
            case 50: 
            case 51: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 6: 
            case 25: 
            case 28: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFileType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionalInterface";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawReturnType";
                break;
            }
            case 9: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 34: 
            case 36: 
            case 40: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandQName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 26: 
            case 29: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set1";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodReferenceOccurrences";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectInheritors";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeHolder";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFindUsages";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestHierarchy";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFunExpressions";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScopeWithoutCodeReferences";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDirectInheritors";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunExpressions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeOccurrenceCount";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findMethodReferenceOccurrences";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 34: 
            case 36: 
            case 40: 
            case 44: 
            case 49: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMostUsedTypeCast";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mayCallOfTypeCast";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mayHappen";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNameId";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInheritorCount";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calculateOccurrenceCount";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyInfo";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calculateDirectInheritors";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "calculateScopeWithoutReferences";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFileIds";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "asCompilerElements";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFiles";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTestFindUsages";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTestHierarchy";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getTestFunExpressions";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "onException";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHierarchyInfo$19";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHierarchyInfo$18";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$17";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$16";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateOccurrenceCount$15";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findMethodReferenceOccurrences$11";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$10";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCompileTimeOccurrenceCount$6";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getScopeWithoutCodeReferences$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 34: 
            case 36: 
            case 40: 
            case 44: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum IndexOpenReason {
        COMPILATION_FINISHED,
        UP_TO_DATE_CACHE;

    }

    private static enum IndexCloseReason {
        AN_EXCEPTION,
        COMPILATION_STARTED,
        PROJECT_CLOSED;

    }

    private static class HierarchySearchKey {
        private final CompilerHierarchySearchType b;
        private final FileType a;

        HierarchySearchKey(CompilerHierarchySearchType compilerHierarchySearchType, FileType fileType) {
            this.b = compilerHierarchySearchType;
            this.a = fileType;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            HierarchySearchKey hierarchySearchKey = (HierarchySearchKey)object;
            return this.b == hierarchySearchKey.b && this.a == hierarchySearchKey.a;
        }

        public int hashCode() {
            return 31 * this.b.hashCode() + this.a.hashCode();
        }
    }

    static class CompilerElementInfo {
        final ElementPlace place;
        final LightRef[] searchElements;

        private CompilerElementInfo(ElementPlace elementPlace, LightRef ... lightRefArray) {
            this.place = elementPlace;
            this.searchElements = lightRefArray;
        }
    }

    private static class ScopeWithoutReferencesOnCompilation
    extends GlobalSearchScope {
        private final TIntHashSet b;
        private final ProjectFileIndex a;

        private ScopeWithoutReferencesOnCompilation(TIntHashSet tIntHashSet, ProjectFileIndex projectFileIndex) {
            this.b = tIntHashSet;
            this.a = projectFileIndex;
        }

        public boolean contains(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                ScopeWithoutReferencesOnCompilation.a(0);
            }
            return virtualFile instanceof VirtualFileWithId && this.a.isInSourceContent(virtualFile) && !this.b.contains(((VirtualFileWithId)virtualFile).getId());
        }

        public int compare(@NotNull VirtualFile virtualFile, @NotNull VirtualFile virtualFile2) {
            if (virtualFile == null) {
                ScopeWithoutReferencesOnCompilation.a(1);
            }
            if (virtualFile2 == null) {
                ScopeWithoutReferencesOnCompilation.a(2);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module module2) {
            if (module2 == null) {
                ScopeWithoutReferencesOnCompilation.a(3);
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ElementPlace {
        SRC,
        LIB;


        private static ElementPlace a(VirtualFile virtualFile, ProjectFileIndex projectFileIndex) {
            if (virtualFile == null) {
                return null;
            }
            return projectFileIndex.isInSourceContent(virtualFile) ? SRC : (projectFileIndex.isInLibrarySource(virtualFile) || projectFileIndex.isInLibraryClasses(virtualFile) ? LIB : null);
        }
    }
}

