/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceImpl;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompilerElementRetriever {
    private static final Logger a = Logger.getInstance(JavaCompilerElementRetriever.class);
    private static final TokenSet b = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LAMBDA_EXPRESSION, JavaElementType.METHOD_REF_EXPRESSION});

    @NotNull
    static PsiFunctionalExpression[] retrieveFunExpressionsByIndices(@NotNull TIntHashSet tIntHashSet, @NotNull PsiFileWithStubSupport psiFileWithStubSupport) {
        if (tIntHashSet == null) {
            JavaCompilerElementRetriever.a(0);
        }
        if (psiFileWithStubSupport == null) {
            JavaCompilerElementRetriever.a(1);
        }
        StubbedSpine stubbedSpine = psiFileWithStubSupport.getStubbedSpine();
        Object[] objectArray = new PsiFunctionalExpression[tIntHashSet.size()];
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < stubbedSpine.getStubCount(); ++i2) {
            if (!b.contains(stubbedSpine.getStubType(i2)) || !tIntHashSet.contains(n3++)) continue;
            objectArray[n2++] = (PsiFunctionalExpression)stubbedSpine.getStubPsi(i2);
        }
        if (objectArray.length != n2) {
            CompilerReferenceServiceImpl compilerReferenceServiceImpl = (CompilerReferenceServiceImpl)CompilerReferenceService.getInstance((Project)psiFileWithStubSupport.getProject());
            Set<Module> set = compilerReferenceServiceImpl.getDirtyScopeHolder().getAllDirtyModules();
            VirtualFile virtualFile = psiFileWithStubSupport.getVirtualFile();
            Module module2 = ProjectFileIndex.getInstance((Project)psiFileWithStubSupport.getProject()).getModuleForFile(virtualFile);
            a.error("Compiler functional expression index doesn't match to stub index.\nFunctional expression indices: " + tIntHashSet + "\nDoes the file belong to dirty scope?: " + set.contains(module2), new Attachment[]{new Attachment(psiFileWithStubSupport.getName(), psiFileWithStubSupport.getText())});
            PsiFunctionalExpression[] psiFunctionalExpressionArray = ContainerUtil.filter((Object[])objectArray, Objects::nonNull).toArray(PsiFunctionalExpression.EMPTY_ARRAY);
            if (psiFunctionalExpressionArray == null) {
                JavaCompilerElementRetriever.a(2);
            }
            return psiFunctionalExpressionArray;
        }
        if (objectArray == null) {
            JavaCompilerElementRetriever.a(3);
        }
        return objectArray;
    }

    @NotNull
    static PsiClass[] retrieveClassesByInternalIds(@NotNull SearchId[] searchIdArray, @NotNull PsiFileWithStubSupport psiFileWithStubSupport) {
        if (searchIdArray == null) {
            JavaCompilerElementRetriever.a(4);
        }
        if (psiFileWithStubSupport == null) {
            JavaCompilerElementRetriever.a(5);
        }
        ClassMatcher classMatcher = ClassMatcher.a(searchIdArray);
        PsiClass[] psiClassArray = (PsiClass[])ReadAction.compute(() -> {
            if (psiFileWithStubSupport == null) {
                JavaCompilerElementRetriever.a(7);
            }
            return classMatcher.a(psiFileWithStubSupport);
        });
        if (psiClassArray == null) {
            JavaCompilerElementRetriever.a(6);
        }
        return psiClassArray;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalIds";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveFunExpressionsByIndices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveClassesByInternalIds";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "retrieveFunExpressionsByIndices";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "retrieveClassesByInternalIds";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$retrieveClassesByInternalIds$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassMatcher {
        @Nullable
        private final TIntHashSet a;
        @NotNull
        private final Collection<InternalNameMatcher> b;

        private ClassMatcher(@Nullable TIntHashSet tIntHashSet, @NotNull Collection<InternalNameMatcher> collection) {
            if (collection == null) {
                ClassMatcher.a(0);
            }
            this.a = tIntHashSet;
            this.b = collection;
        }

        private PsiClass[] a(PsiFileWithStubSupport psiFileWithStubSupport) {
            StubbedSpine stubbedSpine = psiFileWithStubSupport.getStubbedSpine();
            ArrayList<PsiClass> arrayList = new ArrayList<PsiClass>(this.b.size() + (this.a == null ? 0 : this.a.size()));
            int n2 = 0;
            for (int i2 = 0; i2 < stubbedSpine.getStubCount(); ++i2) {
                if (!Constants.CLASS_BIT_SET.contains(stubbedSpine.getStubType(i2))) continue;
                PsiClass psiClass = (PsiClass)stubbedSpine.getStubPsi(i2);
                if (psiClass instanceof PsiAnonymousClass) {
                    if (this.a == null || this.a.isEmpty()) continue;
                    if (this.a.contains(n2)) {
                        arrayList.add(psiClass);
                    }
                    ++n2;
                    continue;
                }
                if (!ClassMatcher.a(psiClass, this.b)) continue;
                arrayList.add(psiClass);
            }
            return arrayList.toArray(PsiClass.EMPTY_ARRAY);
        }

        private static boolean a(PsiClass psiClass, Collection<InternalNameMatcher> collection) {
            for (InternalNameMatcher internalNameMatcher : collection) {
                if (!internalNameMatcher.matches(psiClass)) continue;
                if (internalNameMatcher instanceof InternalNameMatcher.ByQualifiedName) {
                    collection.remove(internalNameMatcher);
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static ClassMatcher a(@NotNull SearchId[] searchIdArray) {
            if (searchIdArray == null) {
                ClassMatcher.a(1);
            }
            SmartList smartList = new SmartList();
            TIntHashSet tIntHashSet = null;
            SearchId[] searchIdArray2 = searchIdArray;
            int n2 = searchIdArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                SearchId searchId = searchIdArray2[n3];
                if (searchId.getId() != -1) {
                    if (tIntHashSet == null) {
                        tIntHashSet = new TIntHashSet();
                    }
                    tIntHashSet.add(searchId.getId());
                } else {
                    String string = searchId.getDeserializedName();
                    int n4 = string.length() - 1;
                    while (true) {
                        int n5;
                        if ((n5 = string.lastIndexOf(36, n4)) > -1 && n5 < string.length() - 1) {
                            int n6 = n5 + 1;
                            boolean bl2 = Character.isDigit(string.charAt(n6));
                            if (bl2) {
                                if (n4 == string.length() - 1) {
                                    int n7 = ClassMatcher.a(string, n6);
                                    if (n7 == -1) {
                                        throw new IllegalStateException();
                                    }
                                    smartList.add(new InternalNameMatcher.ByName(string.substring(n7)));
                                } else {
                                    smartList.add(new InternalNameMatcher.ByName(StringUtil.getShortName((String)string, (char)'$')));
                                    break;
                                }
                            }
                        } else {
                            smartList.add(new InternalNameMatcher.ByQualifiedName(StringUtil.replace((String)string, (String)"$", (String)".")));
                            break;
                        }
                        n4 = n5 - 1;
                    }
                }
                ++n3;
            }
            return new ClassMatcher(tIntHashSet, (Collection<InternalNameMatcher>)smartList);
        }

        private static int a(String string, int n2) {
            for (int i2 = n2 + 1; i2 < string.length(); ++i2) {
                if (Character.isDigit(string.charAt(i2))) continue;
                return i2;
            }
            return -1;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameMatchers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "internalIds";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever$ClassMatcher";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface InternalNameMatcher {
        public boolean matches(PsiClass var1);

        public static class ByQualifiedName
        implements InternalNameMatcher {
            private final String a;

            public ByQualifiedName(String string) {
                this.a = string;
            }

            @Override
            public boolean matches(PsiClass psiClass) {
                return this.a.equals(psiClass.getQualifiedName());
            }
        }

        public static class ByName
        implements InternalNameMatcher {
            private final String a;

            public ByName(String string) {
                this.a = string;
            }

            @Override
            public boolean matches(PsiClass psiClass) {
                return this.a.equals(psiClass.getName());
            }
        }
    }
}

